/*
 * Decompiled with CFR 0.152.
 */
package genj.search;

import genj.gedcom.Entity;
import genj.gedcom.Gedcom;
import genj.gedcom.Property;
import genj.search.Hit;
import genj.search.Matcher;
import genj.search.RegExMatcher;
import genj.search.SimpleMatcher;
import genj.search.WorkerListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;

abstract class Worker {
    public WorkerListener listener;
    public int max_hits;
    public boolean case_sensitive;
    public Gedcom gedcom;
    public Set<Entity> entities = new HashSet<Entity>();
    public List<Hit> hits = new ArrayList<Hit>();
    public int hitCount = 0;
    public Matcher matcher;
    public Thread thread;
    public AtomicBoolean lock = new AtomicBoolean(false);
    public long lastFlush;

    Worker(WorkerListener listener) {
        this.listener = listener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void stop() {
        AtomicBoolean atomicBoolean = this.lock;
        synchronized (atomicBoolean) {
            try {
                this.lock.set(false);
                if (this.thread != null) {
                    this.thread.interrupt();
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public abstract void start(Gedcom var1, int var2, boolean var3, Object ... var4);

    public void flush() {
        if (!this.hits.isEmpty()) {
            this.listener.more(Collections.unmodifiableList(this.hits));
            this.hits.clear();
        }
    }

    public void search(Gedcom gedcom) {
        Comparator<Property> comparator = new Comparator<Property>(){

            @Override
            public int compare(Property p1, Property p2) {
                return p1.toString().compareTo(p2.toString());
            }
        };
        for (int t = 0; t < Gedcom.ENTITIES.length && this.hitCount < this.max_hits; ++t) {
            for (Entity entity : gedcom.getEntities(Gedcom.ENTITIES[t], (Comparator)comparator)) {
                this.search(entity, (Property)entity);
                if (this.lock.get()) continue;
                return;
            }
        }
    }

    public abstract void search(Entity var1, Property var2);

    public Matcher getMatcher(String pattern, boolean regex) {
        Matcher result = regex ? new RegExMatcher() : new SimpleMatcher();
        result.init(pattern);
        return result;
    }
}

