/*
 * Decompiled with CFR 0.152.
 */
package ancestris.welcome.content;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import javax.swing.border.Border;
import org.openide.util.ImageUtilities;

public class ButtonBorder
implements Border {
    private final Image imgTopLeft;
    private final Image imgBottomLeft;
    private final Image imgLeft;
    private final Image imgTopRight;
    private final Image imgBottomRight;
    private final Image imgRight;
    private final Image imgCenter;
    private final Image imgTop;
    private final Image imgBottom;
    private static Border regularBorder;
    private static Border mouseoverBorder;

    private ButtonBorder(boolean mouseOver) {
        if (mouseOver) {
            this.imgTopLeft = ImageUtilities.loadImage((String)"ancestris/welcome/resources/butt-sel-top-lef.png");
            this.imgTopRight = ImageUtilities.loadImage((String)"ancestris/welcome/resources/butt-sel-top-right.png");
            this.imgBottomLeft = ImageUtilities.loadImage((String)"ancestris/welcome/resources/butt-sel-bott-left.png");
            this.imgBottomRight = ImageUtilities.loadImage((String)"ancestris/welcome/resources/butt-sel-bott-right.png");
            this.imgLeft = ImageUtilities.loadImage((String)"ancestris/welcome/resources/butt-sel-side-left.png");
            this.imgRight = ImageUtilities.loadImage((String)"ancestris/welcome/resources/butt-sel-side-right.png");
            this.imgTop = ImageUtilities.loadImage((String)"ancestris/welcome/resources/butt-sel-top.png");
            this.imgBottom = ImageUtilities.loadImage((String)"ancestris/welcome/resources/butt-sel-bottom.png");
            this.imgCenter = ImageUtilities.loadImage((String)"ancestris/welcome/resources/butt-sel-center.png");
        } else {
            this.imgTopLeft = ImageUtilities.loadImage((String)"ancestris/welcome/resources/butt-top-lef.png");
            this.imgTopRight = ImageUtilities.loadImage((String)"ancestris/welcome/resources/butt-top-right.png");
            this.imgBottomLeft = ImageUtilities.loadImage((String)"ancestris/welcome/resources/butt-bott-left.png");
            this.imgBottomRight = ImageUtilities.loadImage((String)"ancestris/welcome/resources/butt-bott-right.png");
            this.imgLeft = ImageUtilities.loadImage((String)"ancestris/welcome/resources/butt-side-left.png");
            this.imgRight = ImageUtilities.loadImage((String)"ancestris/welcome/resources/butt-side-right.png");
            this.imgTop = ImageUtilities.loadImage((String)"ancestris/welcome/resources/butt-top.png");
            this.imgBottom = ImageUtilities.loadImage((String)"ancestris/welcome/resources/butt-bottom.png");
            this.imgCenter = ImageUtilities.loadImage((String)"ancestris/welcome/resources/butt-center.png");
        }
    }

    public static Border createRegular() {
        if (null == regularBorder) {
            regularBorder = new ButtonBorder(false);
        }
        return regularBorder;
    }

    public static Border createMouseOver() {
        if (null == mouseoverBorder) {
            mouseoverBorder = new ButtonBorder(true);
        }
        return mouseoverBorder;
    }

    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        g.drawImage(this.imgTopLeft, x, y, c);
        g.drawImage(this.imgBottomLeft, x, y + height - this.imgBottomLeft.getHeight(c), c);
        g.drawImage(this.imgLeft, x, y + this.imgTopLeft.getHeight(c), this.imgLeft.getWidth(c), height - this.imgTopLeft.getHeight(c) - this.imgBottomLeft.getHeight(c), c);
        g.drawImage(this.imgTopRight, x + width - this.imgTopRight.getWidth(c), y, c);
        g.drawImage(this.imgBottomRight, x + width - this.imgBottomRight.getWidth(c), y + height - this.imgBottomRight.getHeight(c), c);
        g.drawImage(this.imgRight, x + width - this.imgRight.getWidth(c), y + this.imgTopRight.getHeight(c), this.imgRight.getWidth(c), height - this.imgTopRight.getHeight(c) - this.imgBottomRight.getHeight(c), c);
        g.drawImage(this.imgTop, x + this.imgTopLeft.getWidth(c), y, x + width - this.imgTopLeft.getWidth(c) - this.imgTopRight.getWidth(c), this.imgTop.getHeight(c), c);
        g.drawImage(this.imgBottom, x + this.imgBottomLeft.getWidth(c), y + height - this.imgBottom.getHeight(c), x + width - this.imgBottomLeft.getWidth(c) - this.imgBottomRight.getWidth(c), this.imgBottom.getHeight(c), c);
        g.drawImage(this.imgCenter, x + this.imgTopLeft.getWidth(c), y + this.imgTopLeft.getHeight(c), x + width - this.imgTopLeft.getWidth(c) - this.imgTopRight.getWidth(c), y + height - this.imgTopLeft.getHeight(c) - this.imgBottomLeft.getHeight(c), c);
    }

    public Insets getBorderInsets(Component c) {
        return new Insets(11, 11, 11, 11);
    }

    public boolean isBorderOpaque() {
        return false;
    }
}

