/*
 * Decompiled with CFR 0.152.
 */
package ancestris.reports.geneanet;

import ancestris.reports.geneanet.GeneanetLocationElement;
import java.io.InputStream;
import java.util.ArrayList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.NodeList;

public class LocationParser {
    private static final String xmlFileName = "geneanet_location.xml";
    private static LocationParser locationParser;
    private static final String COUNTRY_TAG = "country";
    private static final String REGION_TAG = "region";
    private static final String SUBREGION_TAG = "subregion";
    private static final String NAME_ATTRIBUTE = "name";
    private static final String CODE_ATTRIBUTE = "code";
    private static GeneanetLocationElement tree;

    private LocationParser() {
    }

    public static GeneanetLocationElement getTree() {
        if (tree == null) {
            tree = new GeneanetLocationElement("PLANET", "planet");
            LocationParser.parse();
        }
        return tree;
    }

    private static void parse() {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            InputStream fis = LocationParser.class.getResourceAsStream(xmlFileName);
            Document doc = builder.parse(fis);
            ArrayList<GeneanetLocationElement> countries = new ArrayList<GeneanetLocationElement>();
            ArrayList<GeneanetLocationElement> regions = null;
            ArrayList<GeneanetLocationElement> subRegions = null;
            GeneanetLocationElement geneanetCountry = null;
            GeneanetLocationElement geneanetRegion = null;
            GeneanetLocationElement geneanetSubRegion = null;
            Element planet = doc.getDocumentElement();
            NodeList countriesNodeList = planet.getElementsByTagName(COUNTRY_TAG);
            for (int i = 0; i < countriesNodeList.getLength(); ++i) {
                Element countryNode = (Element)countriesNodeList.item(i);
                geneanetCountry = new GeneanetLocationElement(countryNode.getAttribute(NAME_ATTRIBUTE), countryNode.getAttribute(CODE_ATTRIBUTE));
                NodeList regionsNodeList = countryNode.getElementsByTagName(REGION_TAG);
                regions = new ArrayList<GeneanetLocationElement>();
                for (int j = 0; j < regionsNodeList.getLength(); ++j) {
                    Element regionNode = (Element)regionsNodeList.item(j);
                    NamedNodeMap regionAttributes = regionNode.getAttributes();
                    geneanetRegion = new GeneanetLocationElement(regionNode.getAttribute(NAME_ATTRIBUTE), regionNode.getAttribute(CODE_ATTRIBUTE));
                    NodeList subRegionNodeList = regionNode.getElementsByTagName(SUBREGION_TAG);
                    subRegions = new ArrayList<GeneanetLocationElement>();
                    for (int k = 0; k < subRegionNodeList.getLength(); ++k) {
                        Element subRegionNode = (Element)subRegionNodeList.item(k);
                        if (!subRegionNode.hasAttribute(NAME_ATTRIBUTE) || !subRegionNode.hasAttribute(CODE_ATTRIBUTE)) continue;
                        geneanetSubRegion = new GeneanetLocationElement(subRegionNode.getAttribute(NAME_ATTRIBUTE), subRegionNode.getAttribute(CODE_ATTRIBUTE));
                        subRegions.add(geneanetSubRegion);
                    }
                    geneanetRegion.setSubElementList(subRegions);
                    regions.add(geneanetRegion);
                }
                geneanetCountry.setSubElementList(regions);
                countries.add(geneanetCountry);
            }
            tree.setSubElementList(countries);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

