/*
 * Decompiled with CFR 0.152.
 */
package ancestris.reports.geneanet;

import ancestris.reports.geneanet.GeneanetLocationElement;
import ancestris.reports.geneanet.LocationParser;
import genj.gedcom.PropertyPlace;
import java.util.Map;

public class Location {
    public static final String GENEANET_FORMAT = "geneanet";
    public static final String GEDCOM_FORMAT = "gedcom";
    public static final String TOWN = "TOWN";
    public static final String TOWN_ID = "TOWN_ID";
    public static final String COUNTRY = "COUNTRY";
    public static final String REGION = "REGION";
    public static final String SUBREGION = "SUBREGION";
    public static final String TOWN_CODE = "P";
    public static final String TOWN_ID_CODE = "Z";
    public static final String SUBREGION_CODE = "S";
    public static final String REGION_CODE = "R";
    public static final String COUNTRY_CODE = "C";
    public static final String UNDETERMINED_COUNTRY = "UND";
    private static final String SEPARATOR = ";";
    private static final String SEPARATOR_IN_PLACE = ",";
    private static int townIndexInLocationFormat;
    private static int townIdIndexInLocationFormat;
    private static int subRegionIndexInLocationFormat;
    private static int regionIndexInLocationFormat;
    private static int countryIndexInLocationFormat;
    public static boolean existPLACTag;
    private String place = "";
    private String town = "";
    private String townId = "";
    private String subRegion = "";
    private String region = "";
    private String country = "";
    private String subRegionCode = "";
    private String regionCode = "";
    private String countryCode = "";

    public Location() {
    }

    public Location(PropertyPlace place) {
        if (existPLACTag) {
            this.town = place.getJurisdiction(townIndexInLocationFormat);
            this.townId = place.getJurisdiction(townIdIndexInLocationFormat);
            if (this.townId == null) {
                this.townId = "";
            }
            this.subRegion = place.getJurisdiction(subRegionIndexInLocationFormat);
            this.region = place.getJurisdiction(regionIndexInLocationFormat);
            this.country = place.getJurisdiction(countryIndexInLocationFormat);
        } else {
            this.place = place.toString();
            this.country = UNDETERMINED_COUNTRY;
            this.countryCode = UNDETERMINED_COUNTRY;
        }
    }

    public static void initializeLocationElementIndex(Map locationInformationOrder) {
        townIndexInLocationFormat = (Integer)locationInformationOrder.get(TOWN_CODE);
        townIdIndexInLocationFormat = (Integer)locationInformationOrder.get(TOWN_ID_CODE);
        subRegionIndexInLocationFormat = (Integer)locationInformationOrder.get(SUBREGION_CODE);
        regionIndexInLocationFormat = (Integer)locationInformationOrder.get(REGION_CODE);
        countryIndexInLocationFormat = (Integer)locationInformationOrder.get(COUNTRY_CODE);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.town).append(SEPARATOR_IN_PLACE).append(this.townId).append(SEPARATOR_IN_PLACE).append(this.subRegion).append(SEPARATOR_IN_PLACE).append(this.region).append(SEPARATOR).append(this.subRegionCode).append(SEPARATOR).append(this.regionCode).append(SEPARATOR).append(this.countryCode);
        return sb.toString();
    }

    public Location fromGedcom2Geneanet() {
        Location geneanetLocation = new Location();
        geneanetLocation.setTown(this.town);
        geneanetLocation.setTownId(this.townId);
        geneanetLocation.setSubRegion(this.subRegion);
        geneanetLocation.setRegion(this.region);
        geneanetLocation.setPlace(this.place);
        if (!existPLACTag) {
            geneanetLocation.setCountryCode(UNDETERMINED_COUNTRY);
            geneanetLocation.setRegionCode("");
            geneanetLocation.setSubRegionCode("");
        } else {
            this.findCountryCode(geneanetLocation);
            this.findRegionCode(geneanetLocation);
            this.findSubRegionCode(geneanetLocation);
        }
        return geneanetLocation;
    }

    private void findSubRegionCode(Location geneanetLocation) {
        GeneanetLocationElement subRegionElement = null;
        if (!geneanetLocation.getCountryCode().equals(UNDETERMINED_COUNTRY) && this.subRegion != null && this.subRegion.length() > 0 && (subRegionElement = this.findSubRegionGeneanetLocationPart(geneanetLocation, this.subRegion)) != null) {
            geneanetLocation.setSubRegionCode(subRegionElement.getCode());
        }
    }

    private void findRegionCode(Location geneanetLocation) {
        GeneanetLocationElement regionElement = null;
        if (!geneanetLocation.getCountryCode().equals(UNDETERMINED_COUNTRY) && this.region != null && this.region.length() > 0 && (regionElement = this.findRegionGeneanetLocationPart(geneanetLocation, this.region)) != null) {
            geneanetLocation.setRegionCode(regionElement.getCode());
        }
    }

    private void findCountryCode(Location geneanetLocation) {
        GeneanetLocationElement countryElement = null;
        if (this.country != null && this.country.length() > 0) {
            countryElement = this.findCountryGeneanetLocationPart(this.country);
            if (countryElement != null) {
                geneanetLocation.setCountryCode(countryElement.getCode());
            } else {
                geneanetLocation.setCountryCode(UNDETERMINED_COUNTRY);
            }
        } else {
            geneanetLocation.setCountryCode(UNDETERMINED_COUNTRY);
        }
    }

    public GeneanetLocationElement findCountryGeneanetLocationPart(String countryLocationName) {
        GeneanetLocationElement tree = LocationParser.getTree();
        return tree.getSubElementByName(countryLocationName);
    }

    public GeneanetLocationElement findRegionGeneanetLocationPart(Location location, String regionLocationName) {
        GeneanetLocationElement tree = LocationParser.getTree();
        GeneanetLocationElement region = tree.getSubElementByCode(location.getCountryCode()).getSubElementByName(regionLocationName);
        if (region != null) {
            return region;
        }
        region = tree.getSubElementByCode(location.getCountryCode()).getSubElementByNameOfSubSubElement(location.getRegion());
        if (region != null) {
            return region;
        }
        return null;
    }

    public GeneanetLocationElement findSubRegionGeneanetLocationPart(Location geneaNetLocation, String subRegionLocationName) {
        GeneanetLocationElement tree = LocationParser.getTree();
        return tree.getSubElementByCode(geneaNetLocation.getCountryCode()).getSubElementByCode(geneaNetLocation.getRegionCode()).getSubElementByName(subRegionLocationName);
    }

    public static String buildLocationKey(PropertyPlace location) {
        String key = null;
        if (existPLACTag) {
            StringBuffer sb = new StringBuffer().append(location.getJurisdiction(townIndexInLocationFormat)).append("__").append(location.getJurisdiction(subRegionIndexInLocationFormat));
            key = sb.toString();
        } else {
            key = location.toString();
        }
        return key;
    }

    public String getPlace() {
        if (this.place.equals("")) {
            StringBuffer placeSB = new StringBuffer(this.town).append(SEPARATOR_IN_PLACE).append(this.townId).append(SEPARATOR_IN_PLACE).append(this.subRegion).append(SEPARATOR_IN_PLACE).append(this.region);
            this.place = placeSB.toString();
        }
        return this.place.toString();
    }

    public void setPlace(String place) {
        this.place = place;
    }

    public String getCountry() {
        return this.country;
    }

    public void setCountry(String country) {
        this.country = country;
    }

    public String getTown() {
        return this.town;
    }

    public void setTown(String town) {
        this.town = town;
    }

    public String getRegion() {
        return this.region;
    }

    public void setRegion(String region) {
        this.region = region;
    }

    public String getSubRegion() {
        return this.subRegion;
    }

    public void setSubRegion(String subRegion) {
        this.subRegion = subRegion;
    }

    public String getCountryCode() {
        return this.countryCode;
    }

    public void setCountryCode(String countryCode) {
        this.countryCode = countryCode;
    }

    public String getTownId() {
        return this.townId;
    }

    public void setTownId(String townId) {
        this.townId = townId;
    }

    public String getRegionCode() {
        return this.regionCode;
    }

    public void setRegionCode(String regionCode) {
        this.regionCode = regionCode;
    }

    public String getSubRegionCode() {
        return this.subRegionCode;
    }

    public void setSubRegionCode(String subRegionCode) {
        this.subRegionCode = subRegionCode;
    }

    static {
        existPLACTag = false;
    }
}

