/*
 * Decompiled with CFR 0.152.
 */
package ancestris.reports.geneanet;

import ancestris.reports.geneanet.Location;

public class GeneanetIndexLine
implements Comparable {
    private String name = "";
    private String info = "";
    private int beginningDate = Integer.MAX_VALUE;
    private int endDate = Integer.MIN_VALUE;
    private int nbIndi = 0;
    private String place = "";
    private String subRegionCode = "";
    private String regionCode = "";
    private String countryCode = "";
    private String type = "";

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb = new StringBuffer();
        sb.append(this.name);
        sb.append(";");
        sb.append(this.info);
        sb.append(";");
        sb.append(this.beginningDate == Integer.MAX_VALUE ? "" : String.valueOf(this.beginningDate));
        sb.append(";");
        sb.append(this.endDate == Integer.MIN_VALUE ? "" : String.valueOf(this.endDate));
        sb.append(";");
        sb.append(this.nbIndi);
        sb.append(";");
        sb.append(this.place);
        sb.append(";");
        sb.append(this.subRegionCode);
        sb.append(";");
        sb.append(this.regionCode);
        sb.append(";");
        sb.append(this.countryCode);
        sb.append(";");
        sb.append(this.type);
        return sb.toString();
    }

    public int compareTo(Object otherGeneanetIndexLine) {
        if (!otherGeneanetIndexLine.getClass().equals(GeneanetIndexLine.class)) {
            return 0;
        }
        GeneanetIndexLine otherGeneanetIndex = (GeneanetIndexLine)otherGeneanetIndexLine;
        int res = this.name.compareTo(otherGeneanetIndex.name);
        if (res == 0) {
            res = this.place.compareTo(otherGeneanetIndex.place);
        }
        return res;
    }

    public void add(String name, String info, int start, int end, Location location, String type) {
        if (this.name.length() == 0) {
            this.name = name;
        }
        if (start != Integer.MAX_VALUE) {
            this.beginningDate = Math.min(this.beginningDate, start);
        }
        if (end != Integer.MAX_VALUE) {
            this.endDate = Math.max(this.endDate, end);
        }
        ++this.nbIndi;
        if (this.place.length() == 0) {
            Location geneanetLocation = location.fromGedcom2Geneanet();
            this.place = geneanetLocation.getPlace();
            this.subRegionCode = geneanetLocation.getSubRegionCode();
            this.regionCode = geneanetLocation.getRegionCode();
            this.countryCode = geneanetLocation.getCountryCode();
        }
        if (this.info.length() == 0) {
            this.info = info;
        } else if (info.length() != 0) {
            this.info = "";
        }
        if (this.type.length() == 0) {
            this.type = type;
        }
    }

    public int getBeginningDate() {
        return this.beginningDate;
    }

    public void setBeginningDate(int beginningDate) {
        this.beginningDate = beginningDate;
    }

    public String getCountryCode() {
        return this.countryCode;
    }

    public void setCountryCode(String country) {
        this.countryCode = country;
    }

    public int getEndDate() {
        return this.endDate;
    }

    public void setEndDate(int endDate) {
        this.endDate = endDate;
    }

    public String getInfo() {
        return this.info;
    }

    public void setInfo(String info) {
        this.info = info;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public int getNbIndi() {
        return this.nbIndi;
    }

    public void setNbIndi(int nbIndi) {
        this.nbIndi = nbIndi;
    }

    public String getPlace() {
        return this.place;
    }

    public void setPlace(String place) {
        this.place = place;
    }

    public String getRegionCode() {
        return this.regionCode;
    }

    public void setRegionCode(String region) {
        this.regionCode = region;
    }

    public String getSubRegionCode() {
        return this.subRegionCode;
    }

    public void setSubRegionCode(String subRegion) {
        this.subRegionCode = subRegion;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }
}

