/*
 * Decompiled with CFR 0.152.
 */
package ancestris.reports.gedart;

import ancestris.reports.gedart.GedartTemplate;
import genj.util.EnvironmentChecker;
import genj.util.PackageUtils;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.TreeMap;
import java.util.regex.Pattern;
import org.apache.commons.io.FileUtils;
import org.openide.util.Exceptions;

class GedartTemplates
extends TreeMap<String, GedartTemplate> {
    public GedartTemplates() {
        File dirDefault;
        File dir = new File(EnvironmentChecker.getProperty((String)"user.home.ancestris/gedart/contrib-templates", (String)"?", (String)"Looking for gedart/contrib-templates"));
        if (!dir.exists()) {
            dir.mkdirs();
        }
        if (!(dirDefault = new File(dir + File.separator + "default")).exists()) {
            dirDefault.mkdirs();
        }
        File dest = null;
        String PCKNAME = "ancestris.reports.gedart.templates.resources";
        try {
            URL inputUrl;
            String name;
            for (String res : PackageUtils.findInPackage((String)"ancestris.reports.gedart.templates.resources", (Pattern)Pattern.compile(".*/[^/]*\\.vm"))) {
                name = res.substring("ancestris.reports.gedart.templates.resources".length() + 1);
                inputUrl = GedartTemplates.class.getResource("/" + "ancestris.reports.gedart.templates.resources".replace('.', '/') + "/" + name);
                dest = new File(dirDefault + File.separator + name);
                FileUtils.copyURLToFile((URL)inputUrl, (File)dest);
            }
            for (String res : PackageUtils.findInPackage((String)"ancestris.reports.gedart.templates.resources", (Pattern)Pattern.compile(".*/[^/]*\\.properties"))) {
                name = res.substring("ancestris.reports.gedart.templates.resources".length() + 1);
                inputUrl = GedartTemplates.class.getResource("/" + "ancestris.reports.gedart.templates.resources".replace('.', '/') + "/" + name);
                dest = new File(dirDefault + File.separator + name);
                FileUtils.copyURLToFile((URL)inputUrl, (File)dest);
            }
        }
        catch (Exception ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        this.putAll(new GedartTemplates(dir));
        dir = new File(EnvironmentChecker.getProperty((String)"user.home.ancestris/gedart/templates", (String)"?", (String)"Looking for gedart/templates"));
        if (!dir.exists()) {
            dir.mkdirs();
        }
        this.putAll(new GedartTemplates(dir));
    }

    public GedartTemplates(File dir) {
        if (dir.isDirectory()) {
            File[] files = dir.listFiles();
            for (int b = 0; b < files.length; ++b) {
                GedartTemplate t = GedartTemplate.create(files[b]);
                if (t == null) continue;
                this.put(t.getName(), t);
            }
        }
    }

    public GedartTemplate[] toArray() {
        return this.values().toArray(new GedartTemplate[0]);
    }

    public GedartTemplate[] toArray(Object context) {
        ArrayList<GedartTemplate> result = new ArrayList<GedartTemplate>(5);
        String ctx = context.getClass().getSimpleName();
        for (GedartTemplate ga : this.values()) {
            if (ga.getDescription(ctx) == null) continue;
            try {
                GedartTemplate _ga = ga.clone();
                _ga.setDescription(ga.getDescription(ctx));
                result.add(_ga);
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {}
        }
        return result.toArray(new GedartTemplate[0]);
    }
}

