/*
 * Decompiled with CFR 0.152.
 */
package ancestris.reports;

import ancestris.gedcom.privacy.PrivacyPolicy;
import genj.fo.Document;
import genj.gedcom.Entity;
import genj.gedcom.Fam;
import genj.gedcom.Gedcom;
import genj.gedcom.Indi;
import genj.gedcom.Property;
import genj.gedcom.PropertySource;
import genj.gedcom.Source;
import genj.gedcom.TagPath;
import genj.report.Report;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;

public class ReportSosa
extends Report {
    private static final int SOSA_REPORT = 0;
    private static final int TABLE_REPORT = 1;
    private static final int LINEAGE_REPORT = 2;
    private static final int AGNATIC_REPORT = 3;
    public int reportType = 0;
    public String[] reportTypes = new String[]{this.translate("SosaReport"), this.translate("TableReport"), this.translate("LineageReport"), this.translate("AgnaticReport")};
    private static final int ONE_LINE = 0;
    private static final int ONE_EVT_PER_LINE = 1;
    public int reportFormat = 0;
    public String[] reportFormats = new String[]{this.translate("IndiPerLine"), this.translate("EventPerLine")};
    public boolean displayBullet = true;
    public int startSosa = 1;
    public String sosaTag = "_SOSA";
    public int privateGen = 0;
    public int reportMinGenerations = 1;
    public int reportMaxGenerations = 999;
    public boolean reportPlaceOfBirth = true;
    public boolean reportDateOfBirth = true;
    public boolean reportPlaceOfBaptism = true;
    public boolean reportDateOfBaptism = true;
    public boolean reportPlaceOfMarriage = true;
    public boolean reportDateOfMarriage = true;
    public boolean reportPlaceOfDeath = true;
    public boolean reportDateOfDeath = true;
    public boolean reportPlaceOfBurial = true;
    public boolean reportDateOfBurial = true;
    public boolean reportOccu = true;
    public boolean reportPlaceOfOccu = true;
    public boolean reportDateOfOccu = true;
    public boolean reportResi = true;
    public boolean reportPlaceOfResi = true;
    public boolean reportDateOfResi = true;
    public boolean reportIndiNumber = true;
    public boolean showAllPlaceJurisdictions = false;
    private static final int SRC_NO = 0;
    private static final int SRC_TITLE_NO_TEXT = 1;
    private static final int SRC_TITLE_GEN_NO_TEXT = 2;
    private static final int SRC_TITLE_END_NO_TEXT = 3;
    private static final int SRC_TITLE_TEXT_GEN = 4;
    private static final int SRC_TITLE_TEXT_END = 5;
    private static final int SRC_TITLE_GEN_TEXT_GEN = 6;
    private static final int SRC_TITLE_END_TEXT_END = 7;
    public int displaySource = 1;
    public String[] displaySources = new String[]{this.translate("src_no"), this.translate("src_title_no_text"), this.translate("src_title_gen_no_text"), this.translate("src_title_end_no_text"), this.translate("src_title_text_gen"), this.translate("src_title_text_end"), this.translate("src_title_gen_text_gen"), this.translate("src_title_end_text_end")};
    public boolean displayEmpty = true;
    public boolean prefixEvent = false;
    public String prefixSource = "Src: ";
    private static String format_one_line = "";
    private static String format_multi_lines = "";
    private static final int COLOR_BLACK = 0;
    private static final int COLOR_GREY = 1;
    private static final int COLOR_PURPLE = 2;
    private static final int COLOR_INDIGO = 3;
    private static final int COLOR_BLUE = 4;
    private static final int COLOR_GREEN = 5;
    private static final int COLOR_YELLOW = 6;
    private static final int COLOR_ORANGE = 7;
    private static final int COLOR_RED = 8;
    public int srcColor = 4;
    public String[] srcColors = new String[]{this.translate("Black"), this.translate("Grey"), this.translate("Purple"), this.translate("Indigo"), this.translate("Blue"), this.translate("Green"), this.translate("Yellow"), this.translate("Orange"), this.translate("Red")};
    private static SortedSet globalSrcList = new TreeSet();
    private static Map globalSrcNotes = new TreeMap();
    String[] events = new String[]{"BIRT", "BAPM", "MARR", "DEAT", "BURI", "OCCU", "RESI"};
    boolean[] dispEv = new boolean[]{true, true, true, true, false, false, false};
    String[] symbols = new String[7];
    private boolean srcLinkSrc = false;
    private boolean srcLinkGenSrc = false;
    private boolean srcTitle = false;
    private boolean srcAtGen = false;
    private boolean srcAtEnd = false;
    private boolean srcTextAtGen = false;
    private boolean srcTextAtEnd = false;
    private boolean srcDisplay = false;
    private static String NOTE = ".:NOTE";
    private static String DATA = ".:DATA:TEXT";

    public Document start(Indi indi) {
        Recursion recursion;
        Property sosaProp;
        PrivacyPolicy policy = PrivacyPolicy.getDefault();
        this.InitVariables();
        this.assignColor(this.srcColor);
        if (this.startSosa == 0 && (sosaProp = indi.getProperty(this.sosaTag)) != null) {
            try {
                this.startSosa = Integer.parseInt(sosaProp.getValue(), 10);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (this.startSosa == 0) {
            this.startSosa = 1;
        }
        switch (this.reportType) {
            case 3: {
                recursion = new Agnatic();
                break;
            }
            case 0: {
                recursion = new Sosa();
                break;
            }
            case 2: {
                recursion = new Lineage();
                break;
            }
            case 1: {
                recursion = new Table();
                break;
            }
            default: {
                throw new IllegalArgumentException("no such report type");
            }
        }
        String title = recursion.getTitle(indi);
        Document doc = new Document(title);
        doc.startSection(title);
        recursion.start(indi, policy, doc);
        return doc;
    }

    void InitVariables() {
        this.symbols[0] = this.OPTIONS.getBirthSymbol();
        this.symbols[1] = this.OPTIONS.getBaptismSymbol();
        this.symbols[2] = this.OPTIONS.getMarriageSymbol();
        this.symbols[3] = this.OPTIONS.getDeathSymbol();
        this.symbols[4] = this.OPTIONS.getBurialSymbol();
        this.symbols[5] = this.OPTIONS.getOccuSymbol();
        this.symbols[6] = this.OPTIONS.getResiSymbol();
        this.dispEv[0] = this.reportDateOfBirth || this.reportPlaceOfBirth;
        this.dispEv[1] = this.reportDateOfBaptism || this.reportPlaceOfBaptism;
        this.dispEv[2] = this.reportDateOfMarriage || this.reportPlaceOfMarriage;
        this.dispEv[3] = this.reportDateOfDeath || this.reportPlaceOfDeath;
        boolean bl = this.dispEv[4] = this.reportDateOfBurial || this.reportPlaceOfBurial;
        if (this.reportType == 1) {
            this.displayBullet = true;
            if (this.displaySource == 2) {
                this.displaySource = 3;
            }
            if (this.displaySource == 4) {
                this.displaySource = 5;
            }
            if (this.displaySource == 6) {
                this.displaySource = 7;
            }
        }
        this.srcLinkSrc = false;
        this.srcLinkGenSrc = false;
        this.srcTitle = false;
        this.srcAtGen = false;
        this.srcAtEnd = false;
        this.srcTextAtGen = false;
        this.srcTextAtEnd = false;
        this.srcDisplay = false;
        switch (this.displaySource) {
            case 0: {
                break;
            }
            case 1: {
                this.srcTitle = true;
                this.srcDisplay = true;
                break;
            }
            case 2: {
                this.srcLinkGenSrc = true;
                this.srcAtGen = true;
                this.srcDisplay = true;
                break;
            }
            case 4: {
                this.srcLinkGenSrc = true;
                this.srcTitle = true;
                this.srcTextAtGen = true;
                this.srcDisplay = true;
                break;
            }
            case 6: {
                this.srcLinkGenSrc = true;
                this.srcAtGen = true;
                this.srcTextAtGen = true;
                this.srcDisplay = true;
                break;
            }
            case 3: {
                this.srcLinkSrc = true;
                this.srcAtEnd = true;
                this.srcDisplay = true;
                break;
            }
            case 5: {
                this.srcLinkSrc = true;
                this.srcTitle = true;
                this.srcTextAtEnd = true;
                this.srcDisplay = true;
                break;
            }
            case 7: {
                this.srcLinkSrc = true;
                this.srcAtEnd = true;
                this.srcTextAtEnd = true;
                this.srcDisplay = true;
                break;
            }
        }
    }

    void assignColor(int srcColor) {
        String cs = "#000000";
        switch (srcColor) {
            case 0: {
                cs = "#000000";
                break;
            }
            case 1: {
                cs = "#a0a0a0";
                break;
            }
            case 2: {
                cs = "#ff60ff";
                break;
            }
            case 3: {
                cs = "#8560ff";
                break;
            }
            case 4: {
                cs = "#6060ff";
                break;
            }
            case 5: {
                cs = "#00a71c";
                break;
            }
            case 6: {
                cs = "#d1de00";
                break;
            }
            case 7: {
                cs = "#ffb260";
                break;
            }
            case 8: {
                cs = "#ff6060";
                break;
            }
            default: {
                cs = "#000000";
            }
        }
        format_one_line = "font-style=italic,color=" + cs;
        format_multi_lines = "margin-left=0px,font-style=italic,color=" + cs;
    }

    void writeEvents(Document doc, int gen, Map eventDesc, Map eventSources, boolean isIndented) {
        String indent = "";
        if (isIndented) {
            indent = "start-indent=" + (gen * 20 + 10) + "pt";
        }
        if (this.reportFormat == 1 && this.displayBullet && this.reportType != 1) {
            doc.startList(indent);
        }
        for (int ev = 0; ev < this.events.length; ++ev) {
            String evStr = this.events[ev];
            String description = (String)eventDesc.get(evStr);
            if (description == null) {
                description = "";
            }
            List sources = (List)eventSources.get(evStr);
            boolean noSrc = false;
            if (sources == null || sources.size() == 0) {
                noSrc = true;
            }
            String preSrc = " ";
            if (this.prefixEvent && this.symbols[ev].trim().length() > 0) {
                preSrc = " (" + this.symbols[ev] + ") ";
            }
            if (ev != 0) {
                this.writeStartNextItem(doc, this.reportFormat, this.displayBullet, description.length() != 0, indent);
            }
            this.writeDescription(doc, description);
            if (!noSrc && this.srcDisplay) {
                for (Source source : sources) {
                    String sId = source.getId();
                    if (this.srcTitle) {
                        if (!this.isValidText(source)) {
                            sId = "none";
                        }
                        this.writeStartNextParagraph(doc, this.reportFormat, indent);
                        this.writeSourceWithEvent(doc, this.reportFormat, noSrc, this.prefixSource, preSrc + source.getTitle() + " (" + source.getId() + ")", gen, sId);
                        continue;
                    }
                    this.writeSourceWithEvent(doc, this.reportFormat, noSrc, " ( " + this.prefixSource + preSrc + " " + source.getId() + " )", "", gen, sId);
                }
            }
            if (!noSrc || !this.srcDisplay || !this.displayEmpty || !this.dispEv[ev]) continue;
            if (this.displayBullet && description.length() == 0 && this.reportType != 1) {
                this.writeStartNextItem(doc, this.reportFormat, this.displayBullet, true, indent);
            } else if (this.displayBullet) {
                this.writeStartNextParagraph(doc, this.reportFormat, "");
            } else {
                this.writeStartNextParagraph(doc, this.reportFormat, indent);
            }
            this.writeSourceWithEvent(doc, this.reportFormat, noSrc, this.prefixSource, preSrc + this.translate("noSource"), 0, "");
        }
        if (this.reportFormat == 1 && this.displayBullet && this.reportType != 1) {
            doc.endList();
        }
    }

    void writeStartNextItem(Document doc, int format, boolean bullet, boolean isDescription, String style) {
        if (this.reportType == 1) {
            doc.nextTableCell();
            return;
        }
        if (!isDescription) {
            return;
        }
        if (format == 1) {
            if (bullet) {
                doc.nextListItem();
            } else {
                doc.nextParagraph(style);
            }
        } else {
            doc.addText(", ");
        }
    }

    void writeStartNextParagraph(Document doc, int format, String style) {
        if (format == 1) {
            doc.nextParagraph(style);
        } else {
            doc.addText(", ");
        }
    }

    void writeDescription(Document doc, String text) {
        if (text.length() != 0) {
            doc.addText(text);
        }
    }

    void writeSourceWithEvent(Document doc, int format, boolean noSrcFound, String link, String source, int gen, String id) {
        String formatText = "";
        formatText = format == 1 ? format_multi_lines : format_one_line;
        if (noSrcFound) {
            doc.addText(link + source, formatText);
            return;
        }
        if (this.srcLinkSrc) {
            doc.addLink(link, "0-" + id);
        } else if (this.srcLinkGenSrc) {
            doc.addLink(link, gen + 1 + "-" + id);
        } else {
            doc.addText(link, formatText);
        }
        if (this.srcTitle) {
            doc.addText(source, formatText);
        }
    }

    boolean isValidText(Source source) {
        List listOfNotes = (List)globalSrcNotes.get(source);
        return !listOfNotes.isEmpty();
    }

    boolean isAlreadyIn(List listOfStr, String strNote) {
        for (String str : listOfStr) {
            if (str.indexOf(strNote) == -1) continue;
            return true;
        }
        return false;
    }

    void writeSourceNotes(Document doc, Source source, String format) {
        List listOfNotes = (List)globalSrcNotes.get(source);
        format = format + ",margin-left=8px,font-style=italic,color=#707070";
        for (String strNote : listOfNotes) {
            doc.nextParagraph(format);
            int i = strNote.indexOf("$#@");
            if (i != -1) {
                String beg = strNote.substring(0, i);
                String end = strNote.substring(i + 3);
                doc.addText(beg, "font-style=normal");
                doc.addText(end, "font-style=italic");
                continue;
            }
            doc.addText(strNote);
        }
    }

    void writeSourceList(Document doc, int gen, boolean isTitle, boolean isText) {
        if (globalSrcList.size() == 0) {
            return;
        }
        ArrayList<String> noTextSources = new ArrayList<String>();
        String format = "space-after=8pt";
        if (this.reportType == 0) {
            if (gen == -1) {
                doc.nextPage();
            }
            doc.nextTableRow();
            doc.nextTableCell("margin-left=0px,number-columns-spanned=2,text-decoration=underline");
            doc.nextParagraph("space-before=20pt");
            if (gen == -1) {
                doc.addText("________________________________________________");
                doc.nextParagraph();
            }
            doc.addText(this.translate("sourceList"));
            doc.nextTableRow();
            doc.nextTableCell("margin-left=10px,number-columns-spanned=2");
        }
        if (this.reportType == 2 || this.reportType == 3 || this.reportType == 1) {
            doc.nextPage();
            doc.nextParagraph("space-before=10pt");
            doc.addText("________________________________________________");
            doc.nextParagraph("space-after=10pt,space-before=10pt,text-decoration=underline");
            doc.addText(this.translate("sourceList"));
            doc.nextParagraph(format);
        }
        for (Source source : globalSrcList) {
            String sId = source.getId();
            String sTitle = source.getTitle();
            if (isTitle) {
                doc.nextParagraph(format);
                doc.addAnchor(gen + 1 + "-" + sId);
                doc.addText("(" + sId + ") " + sTitle, "color=#303030");
                if (!isText || !this.isValidText(source)) continue;
                this.writeSourceNotes(doc, source, format);
                continue;
            }
            if (!isText) continue;
            if (this.isValidText(source)) {
                doc.nextParagraph(format);
                doc.addAnchor(gen + 1 + "-" + sId);
                doc.addText("(" + sId + ") ");
                this.writeSourceNotes(doc, source, format);
                continue;
            }
            noTextSources.add(sId);
        }
        if (noTextSources.size() > 0) {
            doc.nextParagraph("space-after=0pt");
            doc.addAnchor(gen + 1 + "-none");
            Iterator n = noTextSources.iterator();
            while (n.hasNext()) {
                doc.addText("(" + (String)n.next() + ") ");
            }
            doc.nextParagraph(format);
            doc.addText(this.translate("noText"));
            doc.nextParagraph(format);
        }
        globalSrcList.clear();
        globalSrcNotes.clear();
    }

    class Table
    extends BreadthFirst {
        String[] header;
        int[] widths;

        Table() {
            this.header = new String[]{"#", Gedcom.getName((String)"NAME"), Gedcom.getName((String)"BIRT"), Gedcom.getName((String)"BAPM"), Gedcom.getName((String)"MARR"), Gedcom.getName((String)"DEAT"), Gedcom.getName((String)"BURI"), Gedcom.getName((String)"OCCU"), Gedcom.getName((String)"RESI")};
            this.widths = new int[]{3, 22, 12, 10, 10, 10, 10, 10, 10};
        }

        @Override
        String getTitle(Indi root) {
            return ReportSosa.this.translate("title.sosa", new Object[]{root.getName()});
        }

        @Override
        void formatStart(Indi root, Document doc) {
            int i;
            doc.startTable("genj:csv=true,width=100%");
            for (i = 0; i < this.header.length; ++i) {
                doc.addTableColumn("column-width=" + this.widths[i] + "%");
            }
            doc.nextTableRow("background-color=#f0f0f0");
            for (i = 0; i < this.header.length; ++i) {
                if (i > 0) {
                    doc.nextTableCell("background-color=#f0f0f0");
                }
                doc.addText(this.header[i], "font-weight=bold");
            }
        }

        @Override
        void formatGeneration(int gen, Document doc) {
        }

        @Override
        void formatIndi(Indi indi, Fam fam, int gen, int sosa, PrivacyPolicy policy, Document doc) {
            if (gen < ReportSosa.this.reportMinGenerations - 1) {
                return;
            }
            TreeMap eventDesc = new TreeMap();
            TreeMap eventSources = new TreeMap();
            String[] props = new String[]{""};
            this.getProperties(indi, fam, policy, false, true, eventDesc, eventSources);
            doc.nextTableRow();
            doc.addText("" + sosa);
            doc.nextTableCell();
            doc.addText(this.getName(indi, 0, policy));
            if (eventDesc.size() > 0) {
                doc.nextTableCell();
                ReportSosa.this.writeEvents(doc, gen, eventDesc, eventSources, false);
            }
        }

        @Override
        void formatEnd(Document doc) {
            doc.endTable();
            if (ReportSosa.this.srcDisplay && (ReportSosa.this.srcAtEnd || ReportSosa.this.srcTextAtEnd)) {
                ReportSosa.this.writeSourceList(doc, -1, ReportSosa.this.srcAtEnd, ReportSosa.this.srcTextAtEnd);
            }
        }
    }

    class Agnatic
    extends DepthFirst {
        Agnatic() {
        }

        @Override
        void recursion(Indi indi, Fam fam, int gen, int sosa, PrivacyPolicy policy, Document doc) {
            if (gen > ReportSosa.this.reportMaxGenerations) {
                return;
            }
            this.formatIndi(indi, fam, gen, sosa, gen < ReportSosa.this.privateGen ? PrivacyPolicy.getDefault().getAllPrivate() : policy, doc);
            Fam famc = indi.getFamilyWhereBiologicalChild();
            if (famc == null) {
                return;
            }
            Indi father = famc.getHusband();
            if (father != null) {
                this.recursion(father, famc, gen + 1, sosa * 2, policy, doc);
            }
        }

        @Override
        String getTitle(Indi root) {
            return ReportSosa.this.translate("title.agnatic", new Object[]{root.getName()});
        }

        @Override
        void formatStart(Indi indi, Document doc) {
        }

        @Override
        void formatIndi(Indi indi, Fam fam, int gen, int sosa, PrivacyPolicy policy, Document doc) {
            if (gen < ReportSosa.this.reportMinGenerations - 1) {
                return;
            }
            if (gen > 1 && fam != null && fam.getHusband() != indi) {
                return;
            }
            doc.nextParagraph("space-after=10pt,space-before=10pt,start-indent=" + gen * 20 + "pt");
            doc.addText(this.getName(indi, sosa, policy) + " ", "font-weight=bold");
            doc.nextParagraph("start-indent=" + (gen * 20 + 10) + "pt");
            TreeMap eventDesc = new TreeMap();
            TreeMap eventSources = new TreeMap();
            this.getProperties(indi, fam, policy, true, false, eventDesc, eventSources);
            if (eventDesc.size() > 0) {
                ReportSosa.this.writeEvents(doc, gen, eventDesc, eventSources, true);
            }
        }

        @Override
        void formatEnd(Document doc) {
            if (ReportSosa.this.srcDisplay && (ReportSosa.this.srcAtEnd || ReportSosa.this.srcTextAtEnd)) {
                ReportSosa.this.writeSourceList(doc, -1, ReportSosa.this.srcAtEnd, ReportSosa.this.srcTextAtEnd);
            }
        }
    }

    class Lineage
    extends DepthFirst {
        Lineage() {
        }

        @Override
        String getTitle(Indi root) {
            return ReportSosa.this.translate("title.lineage", new Object[]{root.getName()});
        }

        @Override
        void formatStart(Indi indi, Document doc) {
        }

        @Override
        void formatIndi(Indi indi, Fam fam, int gen, int sosa, PrivacyPolicy policy, Document doc) {
            if (gen < ReportSosa.this.reportMinGenerations - 1) {
                return;
            }
            doc.nextParagraph("space-after=10pt,space-before=10pt,start-indent=" + gen * 20 + "pt");
            doc.addText(this.getName(indi, sosa, policy) + " ", "font-weight=bold");
            doc.nextParagraph("start-indent=" + (gen * 20 + 10) + "pt");
            TreeMap eventDesc = new TreeMap();
            TreeMap eventSources = new TreeMap();
            this.getProperties(indi, fam, policy, true, false, eventDesc, eventSources);
            if (eventDesc.size() > 0) {
                ReportSosa.this.writeEvents(doc, gen, eventDesc, eventSources, true);
            }
        }

        @Override
        void formatEnd(Document doc) {
            if (ReportSosa.this.srcDisplay && (ReportSosa.this.srcAtEnd || ReportSosa.this.srcTextAtEnd)) {
                ReportSosa.this.writeSourceList(doc, -1, ReportSosa.this.srcAtEnd, ReportSosa.this.srcTextAtEnd);
            }
        }
    }

    class Sosa
    extends BreadthFirst {
        Sosa() {
        }

        @Override
        String getTitle(Indi root) {
            return ReportSosa.this.translate("title.sosa", new Object[]{root.getName()});
        }

        @Override
        void formatStart(Indi root, Document doc) {
            doc.startTable("width=100%");
            doc.addTableColumn("");
            doc.addTableColumn("");
        }

        @Override
        void formatGeneration(int gen, Document doc) {
            if (gen < ReportSosa.this.reportMinGenerations - 1) {
                return;
            }
            doc.nextTableRow();
            doc.nextTableCell("color=#ffffff");
            doc.addText(".");
            doc.nextTableRow();
            doc.nextTableCell("number-columns-spanned=2,font-size=18pt,background-color=#f0f0f0,border-after-width=0.5pt");
            doc.addText(ReportSosa.this.translate("Generation") + " " + (gen + 1));
        }

        @Override
        void formatIndi(Indi indi, Fam fam, int gen, int sosa, PrivacyPolicy policy, Document doc) {
            if (gen < ReportSosa.this.reportMinGenerations - 1) {
                return;
            }
            TreeMap eventDesc = new TreeMap();
            TreeMap eventSources = new TreeMap();
            doc.nextTableRow();
            doc.addText(this.getName(indi, sosa, policy));
            this.getProperties(indi, fam, policy, true, false, eventDesc, eventSources);
            if (eventDesc.size() > 0) {
                doc.nextTableCell();
                ReportSosa.this.writeEvents(doc, gen, eventDesc, eventSources, false);
            }
        }

        @Override
        void formatEnd(Document doc) {
            if (ReportSosa.this.srcDisplay && (ReportSosa.this.srcAtEnd || ReportSosa.this.srcTextAtEnd)) {
                ReportSosa.this.writeSourceList(doc, -1, ReportSosa.this.srcAtEnd, ReportSosa.this.srcTextAtEnd);
            }
            doc.endTable();
        }
    }

    abstract class BreadthFirst
    extends Recursion {
        BreadthFirst() {
        }

        @Override
        void start(Indi indi, PrivacyPolicy policy, Document doc) {
            this.formatStart(indi, doc);
            ArrayList<Integer> list = new ArrayList<Integer>(3);
            list.add(new Integer(ReportSosa.this.startSosa));
            list.add((Integer)indi);
            Fam[] fams = indi.getFamiliesWhereSpouse();
            if (fams != null && fams.length > 0) {
                list.add((Integer)fams[0]);
            } else {
                list.add(null);
            }
            this.recursion(list, 0, policy, doc);
            this.formatEnd(doc);
        }

        void recursion(List generation, int gen, PrivacyPolicy policy, Document doc) {
            if (gen > ReportSosa.this.reportMaxGenerations) {
                return;
            }
            this.formatGeneration(gen, doc);
            ArrayList<Integer> nextGeneration = new ArrayList<Integer>();
            int i = 0;
            while (i < generation.size()) {
                int sosa = (Integer)generation.get(i++);
                Indi indi = (Indi)generation.get(i++);
                Fam fam = (Fam)generation.get(i++);
                Fam famc = indi.getFamilyWhereBiologicalChild();
                if (famc != null) {
                    Indi mother;
                    Indi father = famc.getHusband();
                    if (father != null) {
                        nextGeneration.add(new Integer(sosa * 2));
                        nextGeneration.add((Integer)father);
                        nextGeneration.add((Integer)famc);
                    }
                    if ((mother = famc.getWife()) != null) {
                        nextGeneration.add(new Integer(sosa * 2 + 1));
                        nextGeneration.add((Integer)mother);
                        nextGeneration.add((Integer)famc);
                    }
                }
                this.formatIndi(indi, fam, gen, sosa, gen < ReportSosa.this.privateGen ? PrivacyPolicy.getDefault().getAllPrivate() : policy, doc);
            }
            if (ReportSosa.this.srcDisplay && (ReportSosa.this.srcAtGen || ReportSosa.this.srcTextAtGen)) {
                if (gen >= ReportSosa.this.reportMinGenerations - 1) {
                    ReportSosa.this.writeSourceList(doc, gen, ReportSosa.this.srcAtGen, ReportSosa.this.srcTextAtGen);
                } else {
                    globalSrcList.clear();
                }
            }
            if (!nextGeneration.isEmpty()) {
                this.recursion(nextGeneration, gen + 1, policy, doc);
            }
        }

        abstract void formatGeneration(int var1, Document var2);
    }

    abstract class DepthFirst
    extends Recursion {
        DepthFirst() {
        }

        @Override
        void start(Indi indi, PrivacyPolicy policy, Document doc) {
            this.formatStart(indi, doc);
            Fam[] fams = indi.getFamiliesWhereSpouse();
            Fam fam = null;
            fam = fams != null && fams.length > 0 ? fams[0] : null;
            this.recursion(indi, fam, 0, ReportSosa.this.startSosa, policy, doc);
            this.formatEnd(doc);
        }

        void recursion(Indi indi, Fam fam, int gen, int sosa, PrivacyPolicy policy, Document doc) {
            if (gen > ReportSosa.this.reportMaxGenerations) {
                return;
            }
            this.formatIndi(indi, fam, gen, sosa, gen < ReportSosa.this.privateGen ? PrivacyPolicy.getDefault().getAllPrivate() : policy, doc);
            Fam famc = indi.getFamilyWhereBiologicalChild();
            if (famc == null) {
                return;
            }
            Indi father = famc.getHusband();
            Indi mother = famc.getWife();
            if (father == null && mother == null) {
                return;
            }
            if (father != null) {
                this.recursion(father, famc, gen + 1, sosa * 2, policy, doc);
            }
            if (mother != null) {
                this.recursion(mother, famc, gen + 1, sosa * 2 + 1, policy, doc);
            }
        }
    }

    abstract class Recursion {
        Recursion() {
        }

        abstract void start(Indi var1, PrivacyPolicy var2, Document var3);

        abstract String getTitle(Indi var1);

        abstract void formatStart(Indi var1, Document var2);

        abstract void formatIndi(Indi var1, Fam var2, int var3, int var4, PrivacyPolicy var5, Document var6);

        abstract void formatEnd(Document var1);

        String getProperty(Entity entity, String tag, String prefix, boolean date, boolean place, PrivacyPolicy policy) {
            Property prop = entity.getProperty(tag);
            if (prop == null) {
                return "";
            }
            String format = prefix + (date ? "{ $D}" : "") + (place && ReportSosa.this.showAllPlaceJurisdictions ? "{ $P}" : "") + (place && !ReportSosa.this.showAllPlaceJurisdictions ? "{ $p}" : "");
            return prop.format(format, policy).trim();
        }

        List getSources(Entity entity, String tagPath, String description) {
            String descStr = entity.toString();
            ArrayList<Source> src = new ArrayList<Source>();
            if (description.length() != 0) {
                descStr = descStr + " " + description + " :$#@ ";
            }
            Property[] prop = entity.getProperties(new TagPath(tagPath));
            for (int p = 0; p < prop.length; ++p) {
                if (prop[p] == null || prop[p].toString().trim().length() == 0 || !(prop[p] instanceof PropertySource)) continue;
                PropertySource propSrc = (PropertySource)prop[p];
                Source source = (Source)propSrc.getTargetEntity();
                src.add(source);
                globalSrcList.add(source);
                ArrayList<String> listOfNotes = (ArrayList<String>)globalSrcNotes.get(source);
                if (listOfNotes == null) {
                    listOfNotes = new ArrayList<String>();
                    String sText = source.getText();
                    if (sText != null && sText.trim().length() > 0) {
                        listOfNotes.add(sText);
                    }
                    String sNote = "";
                    Property sProp = source.getPropertyByPath(NOTE);
                    if (sProp != null) {
                        sNote = sProp.getValue();
                    }
                    if (sNote != null && sNote.trim().length() > 0) {
                        listOfNotes.add(sNote);
                    }
                    globalSrcNotes.put(source, listOfNotes);
                }
                String strNote = "";
                Property sProp2 = propSrc.getPropertyByPath(NOTE);
                if (sProp2 != null) {
                    strNote = sProp2.getValue();
                }
                if (strNote != null && strNote.trim().length() > 0 && !ReportSosa.this.isAlreadyIn(listOfNotes, strNote)) {
                    listOfNotes.add(descStr + strNote);
                }
                strNote = "";
                sProp2 = propSrc.getPropertyByPath(DATA);
                if (sProp2 != null) {
                    strNote = sProp2.getValue();
                }
                if (strNote == null || strNote.trim().length() <= 0 || ReportSosa.this.isAlreadyIn(listOfNotes, strNote)) continue;
                listOfNotes.add(descStr + strNote);
            }
            return src;
        }

        String getName(Indi indi, int sosa, PrivacyPolicy privacy) {
            if (ReportSosa.this.reportIndiNumber) {
                return (sosa > 0 ? sosa + " " : "") + privacy.getDisplayValue((Property)indi, "NAME") + " (" + indi.getId() + ")";
            }
            return (sosa > 0 ? sosa + " " : "") + privacy.getDisplayValue((Property)indi, "NAME");
        }

        void getProperties(Indi indi, Fam fam, PrivacyPolicy privacy, boolean usePrefixes, boolean returnEmpties, Map eDesc, Map eSrc) {
            String event = "";
            String description = "";
            List sources = new ArrayList();
            int ev = 0;
            ev = 0;
            event = "BIRT";
            if (ReportSosa.this.dispEv[ev]) {
                description = this.getProperty((Entity)indi, event, usePrefixes ? ReportSosa.this.symbols[ev] : "", ReportSosa.this.reportDateOfBirth, ReportSosa.this.reportPlaceOfBirth, privacy);
                if (returnEmpties || description.length() > 0) {
                    eDesc.put(event, description);
                }
                if (ReportSosa.this.srcDisplay) {
                    sources = this.getSources((Entity)indi, "INDI:" + event + ":SOUR", description);
                    if (ReportSosa.this.displayEmpty || sources.size() > 0) {
                        eSrc.put(event, sources);
                    }
                }
            }
            ev = 1;
            event = "BAPM";
            if (ReportSosa.this.dispEv[ev]) {
                description = this.getProperty((Entity)indi, event, usePrefixes ? ReportSosa.this.symbols[ev] : "", ReportSosa.this.reportDateOfBaptism, ReportSosa.this.reportPlaceOfBaptism, privacy);
                if (returnEmpties || description.length() > 0) {
                    eDesc.put(event, description);
                }
                if (ReportSosa.this.srcDisplay) {
                    sources = this.getSources((Entity)indi, "INDI:" + event + ":SOUR", description);
                    if (ReportSosa.this.displayEmpty || sources.size() > 0) {
                        eSrc.put(event, sources);
                    }
                }
            }
            ev = 2;
            event = "MARR";
            if (ReportSosa.this.dispEv[ev] && fam != null) {
                String prefix = "";
                description = this.getProperty((Entity)fam, event, prefix, ReportSosa.this.reportDateOfMarriage, ReportSosa.this.reportPlaceOfMarriage, privacy);
                if (usePrefixes) {
                    prefix = ReportSosa.this.symbols[ev] + (fam.getOtherSpouse(indi) != null ? " " + fam.getOtherSpouse(indi).getName() : "");
                }
                if (returnEmpties || description.length() > 0) {
                    eDesc.put(event, prefix + " " + description);
                }
                if (ReportSosa.this.srcDisplay && (sources = this.getSources((Entity)fam, "FAM:" + event + ":SOUR", (usePrefixes ? ReportSosa.this.symbols[ev] : "") + " " + description)).size() > 0) {
                    eSrc.put(event, sources);
                }
            }
            ev = 3;
            event = "DEAT";
            if (ReportSosa.this.dispEv[ev]) {
                description = this.getProperty((Entity)indi, event, usePrefixes ? ReportSosa.this.symbols[ev] : "", ReportSosa.this.reportDateOfDeath, ReportSosa.this.reportPlaceOfDeath, privacy);
                if (returnEmpties || description.length() > 0) {
                    eDesc.put(event, description);
                }
                if (ReportSosa.this.srcDisplay && (ReportSosa.this.reportDateOfDeath || ReportSosa.this.reportPlaceOfDeath) && (sources = this.getSources((Entity)indi, "INDI:" + event + ":SOUR", description)).size() > 0) {
                    eSrc.put(event, sources);
                }
            }
            ev = 4;
            event = "BURI";
            if (ReportSosa.this.dispEv[ev]) {
                description = this.getProperty((Entity)indi, event, usePrefixes ? ReportSosa.this.symbols[ev] : "", ReportSosa.this.reportDateOfBurial, ReportSosa.this.reportPlaceOfBurial, privacy);
                if (returnEmpties || description.length() > 0) {
                    eDesc.put(event, description);
                }
                if (ReportSosa.this.srcDisplay && (ReportSosa.this.reportDateOfBurial || ReportSosa.this.reportPlaceOfBurial) && (sources = this.getSources((Entity)indi, "INDI:" + event + ":SOUR", description)).size() > 0) {
                    eSrc.put(event, sources);
                }
            }
            ev = 5;
            event = "OCCU";
            if (ReportSosa.this.reportOccu) {
                description = this.getProperty((Entity)indi, event, (usePrefixes ? ReportSosa.this.symbols[ev] : "") + "{ $V} ", ReportSosa.this.reportDateOfOccu, ReportSosa.this.reportPlaceOfOccu, privacy);
                if (returnEmpties || description.length() > 0) {
                    eDesc.put(event, description);
                }
                if (ReportSosa.this.srcDisplay && (sources = this.getSources((Entity)indi, "INDI:" + event + ":SOUR", description)).size() > 0) {
                    eSrc.put(event, sources);
                }
            }
            ev = 6;
            event = "RESI";
            if (ReportSosa.this.reportResi) {
                description = this.getProperty((Entity)indi, event, (usePrefixes ? ReportSosa.this.symbols[ev] : "") + "{ $V} ", ReportSosa.this.reportDateOfResi, ReportSosa.this.reportPlaceOfResi, privacy);
                if (returnEmpties || description.length() > 0) {
                    eDesc.put(event, description);
                }
                if (ReportSosa.this.srcDisplay && (sources = this.getSources((Entity)indi, "INDI:" + event + ":SOUR", description)).size() > 0) {
                    eSrc.put(event, sources);
                }
            }
        }
    }
}

