/*
 * Decompiled with CFR 0.152.
 */
package ancestris.reports;

import genj.gedcom.Entity;
import genj.gedcom.Gedcom;
import genj.gedcom.Indi;
import genj.gedcom.PropertyDate;
import genj.report.Report;
import java.util.ArrayList;

public class ReportPedigree
extends Report {
    private String textTitle = this.translate("title");
    private String textSelect = this.translate("select");
    private String textUnknown = this.translate("unknown");

    public void start(Indi indi) {
        this.doReport(indi);
    }

    public void start(Gedcom gedcom) {
        Entity ent = this.getEntityFromUser(this.textSelect + " ", gedcom, "INDI");
        if (ent == null) {
            return;
        }
        Indi person = (Indi)ent;
        this.doReport(person);
    }

    public void doReport(Indi indi) {
        ArrayList<Object> parseList = new ArrayList<Object>();
        ArrayList<Indi> tempList = new ArrayList<Indi>();
        Object[] aGens = new Object[]{2, 3, 4, 5, 6};
        Indi[] iDiagIndi = new Indi[31];
        int[][] iDiag = new int[][]{{-1, -1, -1, -2, 15}, {-1, -1, -2, 7, -4}, {-1, -1, -3, -2, 16}, {-1, -2, 3, -4, -4}, {-1, -3, -3, -2, 17}, {-1, -3, -2, 8, -4}, {-1, -3, -1, -2, 18}, {-2, 1, -4, -4, -4}, {-3, -3, -1, -2, 19}, {-3, -3, -2, 9, -4}, {-3, -3, -3, -2, 20}, {-3, -2, 4, -4, -4}, {-3, -1, -3, -2, 21}, {-3, -1, -2, 10, -4}, {-3, -1, -1, -2, 22}, {0, -4, -4, -4, -4}, {-3, -1, -1, -2, 23}, {-3, -1, -2, 11, -4}, {-3, -1, -3, -2, 24}, {-3, -2, 5, -4, -4}, {-3, -3, -3, -2, 25}, {-3, -3, -2, 12, -4}, {-3, -3, -1, -2, 26}, {-2, 2, -4, -4, -4}, {-1, -3, -1, -2, 27}, {-1, -3, -2, 13, -4}, {-1, -3, -3, -2, 28}, {-1, -2, 6, -4, -4}, {-1, -1, -3, -2, 29}, {-1, -1, -2, 14, -4}, {-1, -1, -1, -2, 30}};
        int iTextFieldLength = 80;
        parseList.add(indi);
        Indi dummyIndi = new Indi();
        int iGen = 1;
        int iGenerations = 5;
        int iPosition = 1;
        iDiagIndi[0] = indi;
        do {
            int iLoop;
            for (iLoop = 0; iLoop < parseList.size(); ++iLoop) {
                Indi tempIndi = ((Indi)parseList.get(iLoop)).getBiologicalFather() == null ? dummyIndi : ((Indi)parseList.get(iLoop)).getBiologicalFather();
                tempList.add(tempIndi);
                tempIndi = ((Indi)parseList.get(iLoop)).getBiologicalMother() == null ? dummyIndi : ((Indi)parseList.get(iLoop)).getBiologicalMother();
                tempList.add(tempIndi);
            }
            parseList.clear();
            for (iLoop = 0; iLoop < tempList.size(); ++iLoop) {
                parseList.add(tempList.get(iLoop));
                iDiagIndi[iPosition++] = (Indi)tempList.get(iLoop);
            }
            tempList.clear();
        } while (++iGen < iGenerations);
        this.println(ReportPedigree.align((String)(this.textTitle + ": " + indi), (int)125, (int)1));
        this.println();
        for (int iRow = 0; iRow < 31; ++iRow) {
            String strRow = "";
            for (int iCol = 0; iCol < 5; ++iCol) {
                int iTemp = iDiag[iRow][iCol];
                if (iTemp < 0) {
                    if (iTemp == -1) {
                        strRow = strRow + ReportPedigree.align((String)" ", (int)24, (int)0);
                    }
                    if (iTemp == -2) {
                        strRow = strRow + ReportPedigree.align((String)"|-------------", (int)24, (int)2);
                    }
                    if (iTemp != -3) continue;
                    strRow = strRow + ReportPedigree.align((String)"|             ", (int)24, (int)2);
                    continue;
                }
                if (iDiagIndi[iTemp].getName() == "") {
                    strRow = strRow + ReportPedigree.align((String)("(" + this.textUnknown + ")"), (int)iTextFieldLength, (int)0).trim();
                    continue;
                }
                String strDates = "";
                int iDOBYear = this.getYear(iDiagIndi[iTemp].getBirthDate());
                strDates = iDOBYear == -1 ? " (-" : " (" + iDOBYear + "-";
                int iDODYear = this.getYear(iDiagIndi[iTemp].getDeathDate());
                strDates = iDODYear == -1 ? strDates + ")" : strDates + iDODYear + ")";
                strRow = strRow + ReportPedigree.align((String)(iDiagIndi[iTemp].getName() + strDates), (int)iTextFieldLength, (int)0).trim();
            }
            this.println(strRow);
        }
    }

    public int getYear(PropertyDate someDate) {
        if (someDate == null || !someDate.isValid() || someDate.isRange()) {
            return -1;
        }
        String strYear = someDate.getDisplayValue().trim();
        strYear = strYear.substring(strYear.length() - 4);
        return Integer.parseInt(strYear);
    }
}

