/*
 * Decompiled with CFR 0.152.
 */
package ancestris.reports;

import ancestris.gedcom.privacy.PrivacyPolicy;
import genj.fo.Document;
import genj.gedcom.Entity;
import genj.gedcom.Fam;
import genj.gedcom.Gedcom;
import genj.gedcom.Indi;
import genj.gedcom.Property;
import genj.gedcom.PropertyMultilineValue;
import genj.report.Report;
import java.util.HashMap;

public class ReportMultDesc
extends Report {
    private static final String FORMAT_STRONG = "font-weight=bold";
    private static final String FORMAT_UNDERLINE = "text-decoration=underline";
    private int nbColumns;
    private int nbIndi = 0;
    private int nbFam = 0;
    private int nbLiving = 0;
    private static final int ONE_LINE = 0;
    private static final int ONE_EVT_PER_LINE = 1;
    private static final int TABLE = 2;
    public int reportFormat = 0;
    public String[] reportFormats = new String[]{this.translate("IndiPerLine"), this.translate("EventPerLine"), this.translate("Table")};
    private static final int NUM_NONE = 0;
    private static final int NUM_ABBO = 1;
    public int reportNumberScheme = 1;
    public String[] reportNumberSchemes = new String[]{this.translate("NumNone"), this.translate("NumAbbo")};
    public int reportMaxGenerations = 999;
    public boolean showAllPlaceJurisdictions = false;
    public boolean reportPlaceOfBirth = true;
    public boolean reportDateOfBirth = true;
    public boolean reportPlaceOfDeath = true;
    public boolean reportDateOfDeath = true;
    public boolean reportPlaceOfMarriage = true;
    public boolean reportDateOfMarriage = true;
    public boolean reportPlaceOfOccu = true;
    public boolean reportDateOfOccu = true;
    public boolean reportPlaceOfResi = true;
    public boolean reportDateOfResi = true;
    public boolean reportMailingAddress = true;
    public boolean reportIds = true;
    private Output output;
    public int publicGen = 0;

    public Object start(Indi indi) {
        return this.start(new Indi[]{indi}, this.translate("title.descendant", new Object[]{indi.getName()}));
    }

    public Object start(Indi[] indis) {
        return this.start(indis, this.getName() + " - " + indis[0].getGedcom().getName());
    }

    private Document start(Indi[] indis, String title) {
        switch (this.reportFormat) {
            case 2: {
                this.output = new OutputTable();
                break;
            }
            case 0: 
            case 1: {
                this.output = new OutputStandard();
                break;
            }
            default: {
                throw new IllegalArgumentException("no such report type");
            }
        }
        HashMap<Fam, String> done = new HashMap<Fam, String>();
        PrivacyPolicy policy = PrivacyPolicy.getDefault();
        this.nbColumns = 2;
        if (this.reportPlaceOfBirth || this.reportDateOfBirth) {
            ++this.nbColumns;
        }
        if (this.reportPlaceOfMarriage || this.reportDateOfMarriage) {
            ++this.nbColumns;
        }
        if (this.reportPlaceOfDeath || this.reportDateOfDeath) {
            ++this.nbColumns;
        }
        if (this.reportPlaceOfOccu || this.reportDateOfOccu) {
            ++this.nbColumns;
        }
        if (this.reportPlaceOfResi || this.reportDateOfResi) {
            ++this.nbColumns;
        }
        Document doc = new Document(title);
        for (int i = 0; i < indis.length; ++i) {
            Indi indi = indis[i];
            this.output.title(indi, doc);
            this.iterate(indi, 1, new Integer(i + 1).toString(), done, policy, doc);
        }
        this.output.statistiques(doc);
        return doc;
    }

    private void iterate(Indi indi, int level, String num, HashMap<Fam, String> done, PrivacyPolicy policy, Document doc) {
        ++this.nbIndi;
        if (indi != null && !indi.isDeceased()) {
            ++this.nbLiving;
        }
        if (level > this.reportMaxGenerations) {
            return;
        }
        PrivacyPolicy localPolicy = level < this.publicGen + 1 ? PrivacyPolicy.getDefault().getAllPublic() : policy;
        this.output.startIndi(doc);
        this.format(indi, null, num, localPolicy, doc);
        Fam[] fams = indi.getFamiliesWhereSpouse();
        for (int f = 0; f < fams.length; ++f) {
            Fam fam = fams[f];
            Indi spouse = fam.getOtherSpouse(indi);
            this.output.startSpouse(doc);
            if (fams.length == 1) {
                this.format(spouse, fam, num + "x", localPolicy, doc);
            } else {
                this.format(spouse, fam, num + "x" + (f + 1), localPolicy, doc);
            }
            if (done.containsKey(fam)) {
                this.output.link(fam, done.get(fam), doc);
                continue;
            }
            this.output.anchor(fam, doc);
            done.put(fam, num);
            ++this.nbIndi;
            ++this.nbFam;
            if (spouse != null && !spouse.isDeceased()) {
                ++this.nbLiving;
            }
            Indi[] children = fam.getChildren();
            for (int c = 0; c < children.length; ++c) {
                if (fams.length == 1) {
                    this.iterate(children[c], level + 1, num + '.' + (c + 1), done, policy, doc);
                    continue;
                }
                this.iterate(children[c], level + 1, num + 'x' + (f + 1) + '.' + (c + 1), done, policy, doc);
            }
        }
        this.output.endIndi(indi, doc);
    }

    private void format(Indi indi, Fam fam, String prefix, PrivacyPolicy policy, Document doc) {
        PropertyMultilineValue addr;
        if (indi == null) {
            return;
        }
        this.output.number(prefix, doc);
        this.output.name(policy.getDisplayValue((Property)indi, "NAME"), doc);
        if (this.reportIds) {
            this.output.id(indi.getId(), doc);
        }
        String birt = this.output.format((Entity)indi, "BIRT", this.OPTIONS.getBirthSymbol(), this.reportDateOfBirth, this.reportPlaceOfBirth, policy);
        String marr = fam != null ? this.output.format((Entity)fam, "MARR", this.OPTIONS.getMarriageSymbol(), this.reportDateOfMarriage, this.reportPlaceOfMarriage, policy) : "";
        String deat = this.output.format((Entity)indi, "DEAT", this.OPTIONS.getDeathSymbol(), this.reportDateOfDeath, this.reportPlaceOfDeath, policy);
        String occu = this.output.format((Entity)indi, "OCCU", "{$T}", this.reportDateOfOccu, this.reportPlaceOfOccu, policy);
        String resi = this.output.format((Entity)indi, "RESI", "{$T}", this.reportDateOfResi, this.reportPlaceOfResi, policy);
        PropertyMultilineValue propertyMultilineValue = addr = this.reportMailingAddress ? indi.getAddress() : null;
        if (addr != null && policy.isPrivate((Property)addr)) {
            addr = null;
        }
        this.output.startEvents(doc);
        String[] infos = new String[]{birt, marr, deat, occu, resi};
        boolean j = false;
        for (int i = 0; i < infos.length; ++i) {
            this.output.event(infos[i], doc);
        }
        if (addr != null) {
            this.output.addressPrefix(doc);
            String[] lines = addr.getLines();
            this.output.startEvents(doc);
            for (int i = 0; i < lines.length; ++i) {
                this.output.event(lines[i], doc);
            }
            this.output.endEvents(doc);
        }
        this.output.endEvents(doc);
    }

    class OutputTable
    extends Output {
        OutputTable() {
        }

        @Override
        String format(Entity e, String tag, String prefix, boolean date, boolean place, PrivacyPolicy policy) {
            return super.format(e, tag, "", date, place, policy);
        }

        @Override
        void title(Indi indi, Document doc) {
            doc.startTable("genj:csv=true");
            doc.nextTableRow();
            doc.nextTableCell("number-columns-spanned=7,font-weight=bold");
            doc.addText(ReportMultDesc.this.translate("title.descendant", new Object[]{indi.getName()}));
            doc.nextTableRow();
            doc.addText(ReportMultDesc.this.translate("num.col"), ReportMultDesc.FORMAT_STRONG);
            doc.nextTableCell();
            doc.addText(Gedcom.getName((String)"NAME"), ReportMultDesc.FORMAT_STRONG);
            doc.nextTableCell();
            doc.addText(Gedcom.getName((String)"BIRT"), ReportMultDesc.FORMAT_STRONG);
            doc.nextTableCell();
            doc.addText(Gedcom.getName((String)"MARR"), ReportMultDesc.FORMAT_STRONG);
            doc.nextTableCell();
            doc.addText(Gedcom.getName((String)"DEAT"), ReportMultDesc.FORMAT_STRONG);
            doc.nextTableCell();
            doc.addText(Gedcom.getName((String)"OCCU"), ReportMultDesc.FORMAT_STRONG);
            doc.nextTableCell();
            doc.addText(Gedcom.getName((String)"RESI"), ReportMultDesc.FORMAT_STRONG);
            doc.nextTableCell();
            doc.addText(ReportMultDesc.this.translate("addr1.col"), ReportMultDesc.FORMAT_STRONG);
            doc.nextTableCell();
            doc.addText(ReportMultDesc.this.translate("addr2.col"), ReportMultDesc.FORMAT_STRONG);
            doc.nextTableCell();
            doc.addText(ReportMultDesc.this.translate("addr3.col"), ReportMultDesc.FORMAT_STRONG);
            doc.nextTableCell();
            doc.addText(ReportMultDesc.this.translate("addr4.col"), ReportMultDesc.FORMAT_STRONG);
            doc.nextTableCell();
            doc.addText(ReportMultDesc.this.translate("addr5.col"), ReportMultDesc.FORMAT_STRONG);
        }

        @Override
        void statistiques(Document doc) {
            doc.startSection(ReportMultDesc.this.translate("title.stats"));
            doc.addText(ReportMultDesc.this.translate("nb.fam", new Object[]{ReportMultDesc.this.nbFam}));
            doc.nextParagraph();
            doc.addText(ReportMultDesc.this.translate("nb.indi", new Object[]{ReportMultDesc.this.nbIndi}));
            doc.nextParagraph();
            doc.addText(ReportMultDesc.this.translate("nb.living", new Object[]{ReportMultDesc.this.nbLiving}));
        }

        @Override
        void startIndi(Document doc) {
            doc.nextTableRow();
        }

        @Override
        void startSpouse(Document doc) {
            doc.nextTableRow();
        }

        @Override
        void link(Fam fam, String label, Document doc) {
            doc.nextTableRow();
            doc.nextTableCell();
            doc.nextTableCell();
            doc.addText("====> " + ReportMultDesc.this.translate("see") + " ");
            if (ReportMultDesc.this.reportNumberScheme != 0) {
                doc.addText(label);
            } else {
                doc.addText(fam.getDisplayValue());
            }
        }

        @Override
        void anchor(Fam fam, Document doc) {
        }

        @Override
        void endIndi(Indi indi, Document doc) {
        }

        @Override
        void name(String name, Document doc) {
            doc.nextTableCell();
            doc.addText(name, ReportMultDesc.FORMAT_STRONG);
        }

        @Override
        void id(String id, Document doc) {
            doc.addText(" (" + id + ")");
        }

        @Override
        void startEvents(Document doc) {
        }

        @Override
        void endEvents(Document doc) {
        }

        @Override
        void event(String event, Document doc) {
            doc.nextTableCell();
            doc.addText(event);
        }

        @Override
        void number(String num, Document doc) {
            doc.nextTableCell();
            doc.addText(num);
        }

        @Override
        void addressPrefix(Document doc) {
        }
    }

    class OutputStandard
    extends Output {
        private boolean isFirstEvent;

        OutputStandard() {
            this.isFirstEvent = true;
        }

        @Override
        void title(Indi indi, Document doc) {
            doc.startSection(ReportMultDesc.this.translate("title.descendant", new Object[]{indi.getName()}));
        }

        @Override
        void statistiques(Document doc) {
            doc.startSection(ReportMultDesc.this.translate("title.stats"));
            doc.addText(ReportMultDesc.this.translate("nb.fam", new Object[]{ReportMultDesc.this.nbFam}));
            doc.nextParagraph();
            doc.addText(ReportMultDesc.this.translate("nb.indi", new Object[]{ReportMultDesc.this.nbIndi}));
            doc.nextParagraph();
            doc.addText(ReportMultDesc.this.translate("nb.living", new Object[]{ReportMultDesc.this.nbLiving}));
        }

        @Override
        void startIndi(Document doc) {
            doc.startList();
        }

        @Override
        void startSpouse(Document doc) {
        }

        @Override
        void link(Fam fam, String label, Document doc) {
            doc.nextParagraph();
            doc.addText("====> " + ReportMultDesc.this.translate("see") + " ");
            if (ReportMultDesc.this.reportNumberScheme != 0) {
                doc.addLink(label, fam.getAnchor());
            } else {
                doc.addLink(fam.getDisplayValue(), fam.getAnchor());
            }
        }

        @Override
        void anchor(Fam fam, Document doc) {
            doc.addAnchor(fam.getAnchor());
        }

        @Override
        void endIndi(Indi indi, Document doc) {
            doc.endList();
        }

        @Override
        void number(String number, Document doc) {
            doc.nextParagraph();
            if (ReportMultDesc.this.reportNumberScheme != 0) {
                doc.nextListItem("genj:label=" + number);
            }
        }

        @Override
        void name(String name, Document doc) {
            doc.addText(name, ReportMultDesc.FORMAT_STRONG);
        }

        @Override
        void id(String id, Document doc) {
            doc.addText(" (" + id + ")");
        }

        @Override
        void startEvents(Document doc) {
            if (ReportMultDesc.this.reportFormat != 0) {
                doc.startList();
            }
            this.isFirstEvent = true;
        }

        @Override
        void endEvents(Document doc) {
            if (ReportMultDesc.this.reportFormat != 0) {
                doc.endList();
            }
        }

        @Override
        void event(String event, Document doc) {
            if (event.length() == 0) {
                return;
            }
            if (!this.isFirstEvent) {
                if (ReportMultDesc.this.reportFormat == 0) {
                    doc.addText(", ");
                } else {
                    doc.nextListItem();
                }
            }
            doc.addText(event);
            this.isFirstEvent = false;
        }

        @Override
        void addressPrefix(Document doc) {
            if (!this.isFirstEvent) {
                if (ReportMultDesc.this.reportFormat == 0) {
                    doc.addText(", ");
                } else {
                    doc.nextListItem();
                }
            }
        }
    }

    abstract class Output {
        Output() {
        }

        abstract void title(Indi var1, Document var2);

        abstract void statistiques(Document var1);

        abstract void startIndi(Document var1);

        abstract void startSpouse(Document var1);

        abstract void link(Fam var1, String var2, Document var3);

        abstract void anchor(Fam var1, Document var2);

        abstract void endIndi(Indi var1, Document var2);

        abstract void name(String var1, Document var2);

        abstract void id(String var1, Document var2);

        abstract void startEvents(Document var1);

        abstract void endEvents(Document var1);

        abstract void event(String var1, Document var2);

        abstract void number(String var1, Document var2);

        abstract void addressPrefix(Document var1);

        String format(Entity e, String tag, String prefix, boolean date, boolean place, PrivacyPolicy policy) {
            Property prop = e.getProperty(tag);
            if (prop == null) {
                return "";
            }
            String format = prefix + "{ $v}" + (date ? "{ $D}" : "") + (place && ReportMultDesc.this.showAllPlaceJurisdictions ? "{ $P}" : "") + (place && !ReportMultDesc.this.showAllPlaceJurisdictions ? "{ $p}" : "");
            return prop.format(format, policy);
        }
    }
}

