/*
 * Decompiled with CFR 0.152.
 */
package ancestris.reports;

import genj.gedcom.Entity;
import genj.gedcom.Fam;
import genj.gedcom.Gedcom;
import genj.gedcom.Indi;
import genj.gedcom.TagPath;
import genj.report.Report;

public class ReportFamilyTex
extends Report {
    public boolean reportParents = true;
    public boolean reportOtherSpouses = true;
    public boolean reportDetailedChildrenData = true;
    public boolean reportNumberFamilies = true;
    public boolean reportPages = false;
    public boolean reportNumberIndi = true;
    public boolean reportNoteFam = true;
    public boolean reportNoteIndi = false;
    public boolean reportNoteDeath = true;
    public boolean reportNoteBirth = true;
    public boolean reportDetailOccupation = true;
    public boolean reportFamiliyImage = false;
    public boolean reportTexHeader = false;
    public boolean reportsubsection_on_newpage = false;

    public void start(Gedcom gedcom) {
        String str = "";
        if (this.reportTexHeader) {
            this.println("\\documentclass[10pt,a4paper]{article}");
            this.println("\\usepackage[T1]{fontenc}");
            this.println("\\usepackage[latin1]{inputenc}");
            this.println("\\usepackage{float}");
            this.println("%\\usepackage{ngerman} % or use: \\usepackage[francais]{babel}");
            this.println("\\usepackage[pdftex]{graphicx}");
            this.println("\\DeclareGraphicsExtensions{.jpg,.pdf,.png} % for pdflatex");
            this.println("\\usepackage{subfig} % for subfloat");
            this.println("\\usepackage{fancybox}");
            this.println("\\usepackage[\tpdftex,");
            this.println("\t\tcolorlinks,");
            this.println("\t\tlinkcolor=black]");
            this.println("\t\t{hyperref}");
            this.println("\n\\newcommand{\\Bild}[3]{%");
            this.println("\\begin{figure}[H]%");
            this.println("\\includegraphics[width=120mm]{#2}%");
            this.println("\\caption{#3 \\\\ {\\tiny (#2)}}%");
            this.println("\\label{pic_#1}%\n\\end{figure}%\n}");
            this.println("\n\\newcommand{\\Bildh}[3]{%");
            this.println("\\begin{figure}[H]%");
            this.println("\\includegraphics[height=160mm]{#2}%");
            this.println("\\caption{#3 \\\\ {\\tiny (#2)}}%");
            this.println("\\label{pic_#1}%");
            this.println("\\end{figure}%");
            this.println("}");
            this.println("\n%Notes are from 4 sources: Birth, death, persons, families");
            this.println("%with the next options you can select how the notes are printed");
            this.println("%\\newcommand{ \\NoteBirth }[1]{ \\footnote{ #1 } }");
            this.println("\\newcommand{ \\NoteBirth }[1]{, Notiz: #1 }");
            this.println("%\\newcommand{ \\NoteBirth }[1]{ \\\\ \\leftskip=12mm Notiz: #1 }");
            this.println("\n%\\newcommand{ \\NoteDeath }[1]{ \\footnote{ #1 } }");
            this.println("\\newcommand{ \\NoteDeath }[1]{, Notiz: #1  }");
            this.println("\n%\\newcommand{ \\NoteIndi  }[1]{ \\footnote{ #1 } }");
            this.println("\\newcommand{ \\NoteIndi  }[1]{ \\\\ \\leftskip=12mm Notiz: #1 }");
            this.println("\n% \\newcommand{ \\NoteFam   }[1]{ \\\\ \\leftskip=0mm Notiz zur Familie: #1 } \\par");
            this.println("\\newcommand{ \\NoteFam   }[1]{ \\footnote{ #1 } }");
            this.println("\n%\\newcommand{\\zeile}[2]{\\hspace*{#1}\\begin{minipage}[t]{\\textwidth} #2 \\end{minipage}\\\\}");
            this.println("\n\\begin{document}");
            this.println("");
            this.println("\n\n\\title{Title}");
            this.println("\\author{your name \\and your helper}");
            this.println("% \\thanks{to all suporter}");
            this.println("\\date{ \\today }\n\n\\restylefloat{figure}");
            this.println("\n\\maketitle");
            this.println("\n\\section{Introduction}\nsome words ...");
            this.println("\n\\subsection{Used symbols}");
            this.println("The following symbols are used for the events:\\\\");
            this.println(this.TexEncode(this.OPTIONS.getBirthSymbol()) + " - Birth \\\\");
            this.println(this.TexEncode(this.OPTIONS.getDeathSymbol()) + " - Death \\\\");
            this.println(this.TexEncode(this.OPTIONS.getMarriageSymbol()) + " - Marriage \\\\");
            this.println(this.TexEncode(this.OPTIONS.getOccuSymbol()) + " - Occupation \\\\");
            this.println(this.TexEncode(this.OPTIONS.getChildOfSymbol()) + " - Child in Family\\\\");
            this.println(this.TexEncode(this.OPTIONS.getBaptismSymbol()) + " - Baptism \\\\");
            this.println("\n\\section{Families}");
            this.println("\n\n\\parindent0mm");
        }
        this.println("\n\n\\IfFileExists{head}{\\input{head}}\n\n");
        Entity[] fams = gedcom.getEntities("FAM", "");
        for (int i = 0; i < fams.length; ++i) {
            this.analyzeFam((Fam)fams[i]);
        }
        this.println("\n\n\\IfFileExists{foot}{\\input{foot}}\n");
        if (this.reportTexHeader) {
            this.println("\\tableofcontents");
            this.println("\\end{document}");
        }
    }

    public void start(Fam fam) {
        this.analyzeFam(fam);
    }

    private String trim(Object o) {
        if (o == null) {
            return "";
        }
        return o.toString();
    }

    private String TexEncode(String str) {
        String out = str.replaceAll("[\\\\]", "\\\\textbackslash");
        out = out.replaceAll("[%]", "\\\\%");
        out = out.replaceAll("[{]", "\\\\{");
        out = out.replaceAll("[}]", "\\\\}");
        out = out.replaceAll("\\[", "\\\\[");
        out = out.replaceAll("\\]", "\\\\]");
        out = out.replaceAll("[_]", "\\\\_");
        out = out.replaceAll("[#]", "\\\\#");
        out = out.replaceAll("[&]", "\\\\&");
        out = out.replaceAll("<", "\\\\textless{}");
        out = out.replaceAll(">", "\\\\textgreater{}");
        out = out.replaceAll("\u00a7", "\\\\S");
        out = out.replaceAll("(\\$)", "\\\\\\$");
        out = out.replaceAll("\u00df", "\\\\ss{}");
        out = out.replaceAll("\u00c4", "\\\\\"{A}");
        out = out.replaceAll("\u00d6", "\\\\\"{O}");
        out = out.replaceAll("\u00dc", "\\\\\"{U}");
        out = out.replaceAll("\u00e4", "\\\\\"{a}");
        out = out.replaceAll("\u00f6", "\\\\\"{o}");
        out = out.replaceAll("\u00fc", "\\\\\"{u}");
        out = out.replaceAll("\u00e8", "\\\\`{e}");
        out = out.replaceAll("\u00e9", "\\\\'{e}");
        out = out.replaceAll("\u00ea", "\\\\^{e}");
        out = out.replaceAll("\u00eb", "\\\\\"{e}");
        out = out.replaceAll("\u00c9", "\\\\'{E}");
        out = out.replaceAll("\u00c8", "\\\\`{E}");
        out = out.replaceAll("\u00ca", "\\\\^{E}");
        out = out.replaceAll("\u00e2", "\\\\^{a}");
        out = out.replaceAll("\u00e1", "\\\\'{a}");
        out = out.replaceAll("\u00e0", "\\\\`{a}");
        out = out.replaceAll("\u00c2", "\\\\^{A}");
        out = out.replaceAll("\u00e6", "\\\\ae");
        out = out.replaceAll("\u00c6", "\\\\AE");
        out = out.replaceAll("\u00e7", "\\\\c{c}");
        out = out.replaceAll("\u00c7", "\\\\c{C}");
        out = out.replaceAll("\u0153", "\\\\oe");
        out = out.replaceAll("\u0152", "\\\\OE");
        out = out.replaceAll("\u00ef", "\\\\\"{i}");
        out = out.replaceAll("\u00ed", "\\\\'{i}");
        out = out.replaceAll("\u00ec", "\\\\`{i}");
        out = out.replaceAll("\u00ee", "\\\\^{i}");
        out = out.replaceAll("\u00cf", "\\\\\"{I}");
        out = out.replaceAll("\u00ce", "\\\\^{I}");
        out = out.replaceAll("\u00f3", "\\\\'{o}");
        out = out.replaceAll("\u00f2", "\\\\`{o}");
        out = out.replaceAll("\u00f4", "\\\\^{o}");
        out = out.replaceAll("\u00fa", "\\\\'{u}");
        out = out.replaceAll("\u00f9", "\\\\`{u}");
        out = out.replaceAll("\u00fb", "\\\\^{u}");
        out = out.replaceAll("\u00f1", "\\\\~{n}");
        out = out.replaceAll("\u00d1", "\\\\~{N}");
        out = out.replaceAll("\u00e5", "\\\\r{a}");
        out = out.replaceAll("\u00c5", "\\\\r{A}");
        out = out.replaceAll("\u00b0", "\\\\degree");
        out = out.replaceAll("\\*", "\\\\textasteriskcentered");
        return out;
    }

    private String getIndentTex(int i) {
        String str = "\\leftskip=";
        str = str + 6 * (i - 1) + "mm ";
        return str;
    }

    private String familyNote(Fam f) {
        if (!this.reportNoteFam) {
            return "";
        }
        String str = "";
        for (int n = 0; n < f.getProperties("NOTE").length; ++n) {
            str = str + "\\NoteFam{";
            str = str + this.TexEncode(this.trim(f.getProperties("NOTE")[n]));
            str = str + "} ";
        }
        return str;
    }

    private String BirthNote(Indi i) {
        if (!this.reportNoteBirth) {
            return "";
        }
        String str = "";
        if ((str = str + this.trim(i.getProperty(new TagPath("INDI:BIRT:NOTE")))).length() < 1) {
            return "";
        }
        str = "\\NoteBirth{" + this.TexEncode(str) + "} ";
        return str;
    }

    private String DeathNote(Indi i) {
        if (!this.reportNoteDeath) {
            return "";
        }
        String str = "";
        if ((str = str + this.trim(i.getProperty(new TagPath("INDI:DEAT:NOTE")))).length() < 1) {
            return "";
        }
        str = "\\NoteDeath{" + this.TexEncode(str) + "} ";
        return str;
    }

    private String ID_of_Family(Fam f) {
        if (this.reportNumberFamilies) {
            return this.TexEncode(f.getId()) + " ";
        }
        return "";
    }

    private String Name_of_Husband(Fam f) {
        String str = "";
        str = f.getHusband().getName();
        if (this.reportNumberIndi) {
            str = str + " " + f.getHusband().getId();
        }
        return this.TexEncode(str);
    }

    private String Name_of_Wife(Fam f) {
        String str = "";
        str = f.getWife().getName();
        if (this.reportNumberIndi) {
            str = str + " " + f.getWife().getId();
        }
        return this.TexEncode(str);
    }

    private String Name_of_Indi(Indi Indi2) {
        String str = "";
        str = Indi2.getName();
        if (this.reportNumberIndi) {
            str = str + " " + Indi2.getId();
        }
        return this.TexEncode(str);
    }

    private String familyToString(Fam f) {
        Indi husband = f.getHusband();
        Indi wife = f.getWife();
        String str = "\\hyperlink{" + f.getId() + "}{" + this.ID_of_Family(f);
        if (husband != null) {
            str = str + this.Name_of_Husband(f);
        }
        if (husband != null & wife != null) {
            str = str + " " + this.TexEncode(this.translate("and")) + " ";
        }
        if (wife != null) {
            str = str + this.Name_of_Wife(f);
        }
        if (this.reportPages) {
            str = str + "(" + this.TexEncode(this.translate("Chap")) + ". \\ref*{" + f.getId() + "}, S. \\pageref*{" + f.getId() + "})";
        }
        str = str + "}";
        return str;
    }

    private String familyToStringSubsection(Fam f) {
        Indi husband = f.getHusband();
        Indi wife = f.getWife();
        String str = "\\leftskip=0mm ";
        if (this.reportsubsection_on_newpage) {
            str = str + "\\newpage ";
        }
        str = str + "\\subsection{" + this.ID_of_Family(f);
        if (husband != null) {
            str = str + this.Name_of_Husband(f);
        }
        if (husband != null & wife != null) {
            str = str + " " + this.TexEncode(this.translate("and")) + " ";
        }
        if (wife != null) {
            str = str + this.Name_of_Wife(f);
        }
        str = str + "} \n\\hypertarget{" + f.getId() + "}{}\n\\label{" + f.getId() + "}";
        return str;
    }

    private String familyImageCaption(Fam f) {
        String str = "\n";
        Indi husband = f.getHusband();
        Indi wife = f.getWife();
        str = str + "Stammbaum der Famile " + this.ID_of_Family(f);
        if (husband != null) {
            str = str + this.Name_of_Husband(f);
        }
        if (husband != null & wife != null) {
            str = str + " " + this.translate("and") + " ";
        }
        if (wife != null) {
            str = str + this.Name_of_Wife(f);
        }
        return str;
    }

    private String familyImage(Fam f) {
        Indi husband = f.getHusband();
        Indi wife = f.getWife();
        String str = "\n";
        if (husband != null) {
            str = str + "\\IfFileExists{" + husband.getId() + ".pdf}{";
            str = str + "\\Bild{Bild_" + husband.getId() + "}{" + husband.getId() + ".pdf}{" + this.familyImageCaption(f) + "}}\n";
        }
        return str;
    }

    private void analyzeFam(Fam f) {
        String str = "";
        this.println(this.familyToStringSubsection(f));
        if (this.reportFamiliyImage) {
            this.println(this.familyImage(f));
        }
        this.println(str + this.familyNote(f));
        if (this.trim(f.getMarriageDate()).length() > 0 || this.trim(f.getProperty(new TagPath("FAM:MARR:PLAC"))).length() > 0) {
            this.println(this.getIndentTex(1) + this.TexEncode(this.OPTIONS.getMarriageSymbol() + " " + this.trim(f.getMarriageDate()) + " " + this.trim(f.getProperty(new TagPath("FAM:MARR:PLAC")))) + "\\par");
        }
        this.analyzeIndi(f.getHusband(), f);
        this.analyzeIndi(f.getWife(), f);
        this.analyzeChildren(f);
    }

    private void analyzeIndi(Indi indi, Fam f) {
        Fam[] families;
        String str;
        Fam fam;
        if (indi == null) {
            return;
        }
        this.println(this.getIndentTex(2) + this.Name_of_Indi(indi) + "\\par");
        if (this.reportParents && (fam = indi.getFamilyWhereBiologicalChild()) != null) {
            this.println(this.getIndentTex(3) + this.TexEncode(this.OPTIONS.getChildOfSymbol()) + " " + this.familyToString(fam) + "\\par");
        }
        if (this.trim(indi.getBirthAsString()).length() > 0 || this.trim(indi.getProperty(new TagPath("INDI:BIRT:PLAC"))).length() > 0) {
            str = this.OPTIONS.getBirthSymbol() + " " + this.trim(indi.getBirthAsString()) + " " + this.trim(indi.getProperty(new TagPath("INDI:BIRT:PLAC")));
            str = this.TexEncode(str);
            this.println(this.getIndentTex(3) + str + this.BirthNote(indi) + "\\par");
        }
        if (indi.getProperty("DEAT") != null && (this.trim(indi.getDeathAsString()).length() > 0 || this.trim(indi.getProperty(new TagPath("INDI:DEAT:PLAC"))).length() > 0)) {
            str = this.OPTIONS.getDeathSymbol() + " " + this.trim(indi.getDeathAsString()) + " " + this.trim(indi.getProperty(new TagPath("INDI:DEAT:PLAC")));
            str = this.TexEncode(str);
            this.println(this.getIndentTex(3) + str + this.DeathNote(indi) + "\\par");
        }
        if (this.reportOtherSpouses && (families = indi.getFamiliesWhereSpouse()).length > 1) {
            this.println(this.getIndentTex(3) + this.translate("otherSpouses") + "\\par");
            for (int i = 0; i < families.length; ++i) {
                if (families[i] == f) continue;
                str = "";
                if (this.trim(families[i].getMarriageDate()).length() > 0 || this.trim(families[i].getProperty(new TagPath("FAM:MARR:PLAC"))).length() > 0) {
                    str = this.OPTIONS.getMarriageSymbol() + " " + this.trim(families[i].getMarriageDate()) + " " + this.trim(families[i].getProperty(new TagPath("FAM:MARR:PLAC"))) + " ";
                }
                str = this.TexEncode(str);
                this.println(this.getIndentTex(4) + str + " " + this.familyToString(families[i]) + "\\par");
            }
        }
        if (this.reportDetailOccupation & this.trim(indi.getProperty(new TagPath("INDI:OCCU"))).length() > 0) {
            str = this.translate("occupation") + ": " + this.trim(indi.getProperty(new TagPath("INDI:OCCU")));
            str = this.TexEncode(str);
            this.println(this.getIndentTex(3) + str + "\\par");
        }
    }

    private void analyzeChildren(Fam f) {
        Indi[] children = f.getChildren();
        String str = "";
        if (children.length > 0) {
            this.println(this.getIndentTex(2) + this.translate("children") + "\\par");
        }
        for (int i = 0; i < children.length; ++i) {
            Indi child = children[i];
            str = this.Name_of_Indi(child);
            this.println(this.getIndentTex(3) + str + "\\par");
            if (!this.reportDetailedChildrenData) continue;
            if (this.trim(child.getBirthAsString()).length() > 0 || this.trim(child.getProperty(new TagPath("INDI:BIRT:PLAC"))).length() > 0) {
                str = this.OPTIONS.getBirthSymbol() + " ";
                str = str + this.trim(child.getBirthAsString()) + " ";
                str = str + this.trim(child.getProperty(new TagPath("INDI:BIRT:PLAC")));
                str = this.TexEncode(str);
                this.println(this.getIndentTex(4) + str + this.BirthNote(child) + "\\par");
            }
            this.printBaptism(child, "BAPM");
            this.printBaptism(child, "BAPL");
            this.printBaptism(child, "CHR");
            this.printBaptism(child, "CHRA");
            Fam[] families = child.getFamiliesWhereSpouse();
            for (int j = 0; j < families.length; ++j) {
                Fam family = families[j];
                str = this.trim(family.getMarriageDate()) + " ";
                str = str + this.trim(family.getProperty(new TagPath("FAM:MARR:PLAC")));
                str = this.TexEncode(str);
                this.println(this.getIndentTex(4) + this.OPTIONS.getMarriageSymbol() + " " + this.familyToString(family) + " " + str + "\\par");
            }
            if (this.reportDetailOccupation & this.trim(child.getProperty(new TagPath("INDI:OCCU"))).length() > 0) {
                str = this.translate("occupation") + ": ";
                str = str + this.trim(child.getProperty(new TagPath("INDI:OCCU")));
                str = this.TexEncode(str);
                this.println(this.getIndentTex(4) + str + "\\par");
            }
            if (child.getProperty("DEAT") == null || this.trim(child.getDeathAsString()).length() <= 0 && this.trim(child.getProperty(new TagPath("INDI:DEAT:PLAC"))).length() <= 0) continue;
            str = this.OPTIONS.getDeathSymbol() + " ";
            str = str + this.trim(child.getDeathAsString()) + " ";
            str = str + this.trim(child.getProperty(new TagPath("INDI:DEAT:PLAC")));
            str = this.TexEncode(str);
            this.println(this.getIndentTex(4) + str + this.DeathNote(child) + "\\par");
        }
    }

    private void printBaptism(Indi indi, String tag) {
        String str = "";
        if (indi.getProperty(tag) != null && (this.trim(indi.getProperty(new TagPath("INDI:" + tag + ":DATE"))).length() > 0 || this.trim(indi.getProperty(new TagPath("INDI:" + tag + ":PLAC"))).length() > 0)) {
            str = this.OPTIONS.getBaptismSymbol() + " (" + tag;
            str = str + "): ";
            str = str + this.trim(indi.getProperty(new TagPath("INDI:" + tag + ":DATE"))) + " ";
            str = str + this.trim(indi.getProperty(new TagPath("INDI:" + tag + ":PLAC")));
            str = this.TexEncode(str);
            this.println(this.getIndentTex(4) + str + "\\par");
        }
    }
}

