/*
 * Decompiled with CFR 0.152.
 */
package ancestris.reports;

import genj.gedcom.Entity;
import genj.gedcom.Gedcom;
import genj.gedcom.Indi;
import genj.gedcom.PropertyDate;
import genj.gedcom.time.PointInTime;
import genj.report.Report;

public class ReportContemporaries
extends Report {
    public int optionLifeSpan = 70;
    private String textTitle = this.translate("title");
    private String textDate = this.translate("date");
    private String textSelect = this.translate("select");
    private String textNothing = this.translate("nothing");
    private String textNoDates = this.translate("nodates");
    private String textContemps = this.translate("contemps");

    public void start(Indi indi) {
        this.displayHeader();
        this.doReport(indi);
    }

    public void start(Gedcom gedcom) {
        Entity ent = this.getEntityFromUser(this.textSelect + " ", gedcom, "INDI");
        if (ent == null) {
            return;
        }
        Indi person = (Indi)ent;
        this.displayHeader();
        this.doReport(person);
    }

    public void doReport(Indi indi) {
        String strSpan = "";
        int subjectDOBYear = this.getYear(indi.getBirthDate());
        int subjectDODYear = this.getYear(indi.getDeathDate());
        if (subjectDOBYear == -1 && subjectDODYear == -1) {
            this.println(this.textNothing);
            this.println(this.textNoDates);
            return;
        }
        if (subjectDOBYear == -1) {
            subjectDOBYear = subjectDODYear - this.optionLifeSpan;
            strSpan = subjectDOBYear + "(est) - ";
        } else {
            strSpan = subjectDOBYear + " - ";
        }
        if (subjectDODYear == -1) {
            subjectDODYear = subjectDOBYear + this.optionLifeSpan;
            if (subjectDODYear < PointInTime.getNow().getYear()) {
                strSpan = strSpan + subjectDODYear + "(est)";
            }
        } else {
            strSpan = strSpan + subjectDODYear;
        }
        this.println(this.textContemps + " " + indi.getName() + " " + strSpan);
        this.println();
        Entity[] individuals = indi.getGedcom().getEntities("INDI", "");
        for (int loop = 0; loop < individuals.length; ++loop) {
            if ((Indi)individuals[loop] == indi) continue;
            int tempDOBYear = this.getYear(((Indi)individuals[loop]).getBirthDate());
            int tempDODYear = this.getYear(((Indi)individuals[loop]).getDeathDate());
            if (tempDOBYear == -1 && tempDODYear == -1) continue;
            if (tempDOBYear == -1) {
                tempDOBYear = tempDODYear - this.optionLifeSpan;
                strSpan = tempDOBYear + "(est) - ";
            } else {
                strSpan = tempDOBYear + " - ";
            }
            if (tempDODYear == -1) {
                tempDODYear = tempDOBYear + this.optionLifeSpan;
                if (tempDODYear < PointInTime.getNow().getYear()) {
                    strSpan = strSpan + tempDODYear + "(est)";
                }
            } else {
                strSpan = strSpan + tempDODYear;
            }
            if (tempDODYear < subjectDOBYear || tempDOBYear > subjectDODYear) continue;
            strSpan = ((Indi)individuals[loop]).getName() + " " + strSpan;
            this.println(strSpan);
        }
    }

    public int getYear(PropertyDate someDate) {
        if (someDate == null || !someDate.isValid() || someDate.isRange()) {
            return -1;
        }
        String strYear = someDate.getDisplayValue().trim();
        strYear = strYear.substring(strYear.length() - 4);
        return Integer.parseInt(strYear);
    }

    public void displayHeader() {
        this.println(ReportContemporaries.align((String)this.textTitle, (int)80, (int)1));
        this.println(this.textDate + ": " + PointInTime.getNow().toString());
        this.println();
    }
}

