/*
 * Decompiled with CFR 0.152.
 */
package ancestris.explorer;

import ancestris.core.pluginservice.AncestrisPlugin;
import ancestris.explorer.EntitiesNode;
import ancestris.explorer.EntityNode;
import ancestris.explorer.GedcomEntities;
import ancestris.explorer.GedcomExplorerTopComponent;
import genj.gedcom.Entity;
import genj.gedcom.Fam;
import genj.gedcom.Gedcom;
import genj.gedcom.GedcomListener;
import genj.gedcom.Indi;
import genj.gedcom.Property;
import genj.gedcom.TagPath;
import java.util.ArrayList;
import java.util.Collection;
import org.openide.nodes.Children;
import org.openide.nodes.Node;

class EntityChildren
extends Children.SortedArray
implements GedcomListener {
    private final GedcomEntities entities;

    public EntityChildren(GedcomEntities entities) {
        this.entities = entities;
        entities.getGedcom().addGedcomListener((GedcomListener)this);
    }

    public Collection<Node> initCollection() {
        ArrayList<Node> result = new ArrayList<Node>();
        for (Entity entity : this.entities.getEntities()) {
            result.add((Node)new EntityNode(entity));
        }
        return result;
    }

    protected void addNotify() {
        super.addNotify();
        AncestrisPlugin.register((Object)((Object)this));
    }

    protected void removeNotify() {
        super.removeNotify();
        AncestrisPlugin.unregister((Object)((Object)this));
    }

    public void gedcomEntityAdded(Gedcom gedcom, Entity entity) {
        if (!this.entities.getTag().equals(entity.getTag())) {
            return;
        }
        this.add((Node[])new EntityNode[]{new EntityNode(entity)});
        Node node = this.getNode();
        if (node instanceof EntitiesNode) {
            EntitiesNode esn = (EntitiesNode)node;
            esn.updateDisplay();
        }
        this.refresh();
    }

    public void gedcomEntityDeleted(Gedcom gedcom, Entity entity) {
        if (!this.entities.getTag().equals(entity.getTag())) {
            return;
        }
        for (Node n : this.getNodes()) {
            EntityNode en = (EntityNode)n;
            if (!en.getEntity().equals(entity)) continue;
            this.remove((Node[])new EntityNode[]{en});
        }
        Node node = this.getNode();
        if (node instanceof EntitiesNode) {
            EntitiesNode esn = (EntitiesNode)node;
            esn.updateDisplay();
        }
        this.refresh();
    }

    public void gedcomPropertyAdded(Gedcom gedcom, Property property, int pos, Property added) {
        this.invalidate(gedcom, property.getEntity(), added.getPath());
    }

    public void gedcomPropertyChanged(Gedcom gedcom, Property property) {
        this.invalidate(gedcom, property.getEntity(), property.getPath());
    }

    public void gedcomPropertyDeleted(Gedcom gedcom, Property property, int pos, Property deleted) {
        this.invalidate(gedcom, property.getEntity(), new TagPath(property.getPath(), deleted.getTag()));
    }

    private void invalidate(Gedcom gedcom, Entity entity, TagPath path) {
        EntityNode en;
        if (this.entities.getTag().equals("FAM") && entity instanceof Indi) {
            for (Node n : this.getNodes()) {
                en = (EntityNode)n;
                Indi i = (Indi)entity;
                Fam f = (Fam)en.getEntity();
                if (!f.getSpouses().contains(i)) continue;
                GedcomExplorerTopComponent.getDefault().addToList(en);
            }
        }
        if (!this.entities.getTag().equals(entity.getTag())) {
            return;
        }
        for (Node n : this.getNodes()) {
            en = (EntityNode)n;
            if (!en.getEntity().equals(entity)) continue;
            GedcomExplorerTopComponent.getDefault().addToList(en);
        }
    }
}

