/*
 * Decompiled with CFR 0.152.
 */
package ancestris.app;

import ancestris.app.App;
import ancestris.app.AppOptions;
import ancestris.app.OptionFilesOptionsPanelController;
import ancestris.core.CoreOptions;
import ancestris.util.URLUtil;
import ancestris.util.swing.FileChooserBuilder;
import genj.gedcom.GedcomOptions;
import genj.io.Options;
import genj.util.Registry;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Collection;
import javax.swing.AbstractButton;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.SpinnerNumberModel;
import javax.swing.filechooser.FileFilter;
import org.netbeans.api.actions.Openable;
import org.openide.awt.Mnemonics;
import org.openide.awt.StatusDisplayer;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

final class OptionFilesPanel
extends JPanel {
    private final OptionFilesOptionsPanelController controller;
    private JButton jButton2;
    private JButton jButton3;
    private JLabel jLabel1;
    private JLabel jLabel12;
    private JLabel jLabel13;
    private JLabel jLabel14;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JSpinner jSpinner1;
    private JTextField jTextField2;
    private JTextField jTextField3;
    private JCheckBox jcbAlwaysOpen;
    private JCheckBox jcbOpenNothing;
    private JComboBox logLevel;
    private JSpinner nbBackups;

    OptionFilesPanel(OptionFilesOptionsPanelController controller) {
        this.controller = controller;
        this.initComponents();
    }

    private void chooseFileDir(JTextField jTF, boolean dirOnly) {
        File file = new FileChooserBuilder(OptionFilesPanel.class.getCanonicalName() + dirOnly).setDirectoriesOnly(dirOnly).setDefaultBadgeProvider().setTitle(NbBundle.getMessage(this.getClass(), (String)(dirOnly ? "TITL_GetDefaultDir" : "TITL_GetDefaultGedcom"))).setApproveText(NbBundle.getMessage(this.getClass(), (String)"OK_Select")).setDefaultExtension(FileChooserBuilder.getGedcomFilter().getExtensions()[0]).setFileFilter((FileFilter)(dirOnly ? null : FileChooserBuilder.getGedcomFilter())).setAcceptAllFileFilterUsed(dirOnly).setFileHiding(true).setParent((Component)this).setSelectedFile(new File(jTF.getText())).setDefaultWorkingDirectory(new File(System.getProperty("user.home"))).showOpenDialog();
        if (file != null) {
            jTF.setText(file.getAbsolutePath());
        }
    }

    private void initComponents() {
        this.jTextField3 = new JTextField();
        this.jButton3 = new JButton();
        this.jLabel13 = new JLabel();
        this.jButton2 = new JButton();
        this.jSpinner1 = new JSpinner(new SpinnerNumberModel(2048, 128, 16384, 128));
        this.jLabel5 = new JLabel();
        this.jLabel3 = new JLabel();
        this.jTextField2 = new JTextField();
        this.jLabel1 = new JLabel();
        this.jLabel12 = new JLabel();
        this.jLabel14 = new JLabel();
        this.logLevel = new JComboBox();
        this.jcbOpenNothing = new JCheckBox();
        this.jcbAlwaysOpen = new JCheckBox();
        this.jLabel4 = new JLabel();
        this.nbBackups = new JSpinner();
        this.setPreferredSize(new Dimension(600, 297));
        this.jTextField3.setText(NbBundle.getMessage(OptionFilesPanel.class, (String)"OptionFilesPanel.jTextField3.text"));
        this.jTextField3.setToolTipText(NbBundle.getMessage(OptionFilesPanel.class, (String)"OptionFilesPanel.jTextField3.toolTipText"));
        Mnemonics.setLocalizedText((AbstractButton)this.jButton3, (String)NbBundle.getMessage(OptionFilesPanel.class, (String)"OptionFilesPanel.jButton3.text"));
        this.jButton3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OptionFilesPanel.this.jButton3ActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((JLabel)this.jLabel13, (String)NbBundle.getMessage(OptionFilesPanel.class, (String)"OptionFilesPanel.jLabel13.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.jButton2, (String)NbBundle.getMessage(OptionFilesPanel.class, (String)"OptionFilesPanel.jButton2.text"));
        this.jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OptionFilesPanel.this.jButton2ActionPerformed(evt);
            }
        });
        this.jSpinner1.setToolTipText(NbBundle.getMessage(OptionFilesPanel.class, (String)"OptionFilesPanel.jSpinner1.toolTipText"));
        Mnemonics.setLocalizedText((JLabel)this.jLabel5, (String)NbBundle.getMessage(OptionFilesPanel.class, (String)"OptionFilesPanel.jLabel5.text"));
        Mnemonics.setLocalizedText((JLabel)this.jLabel3, (String)NbBundle.getMessage(OptionFilesPanel.class, (String)"OptionFilesPanel.jLabel3.text"));
        this.jTextField2.setText(NbBundle.getMessage(OptionFilesPanel.class, (String)"OptionFilesPanel.jTextField2.text"));
        this.jTextField2.setToolTipText(NbBundle.getMessage(OptionFilesPanel.class, (String)"OptionFilesPanel.jTextField2.toolTipText"));
        this.jLabel1.setFont(new Font("DejaVu Sans", 1, 13));
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(OptionFilesPanel.class, (String)"OptionFilesPanel.jLabel1.text"));
        this.jLabel12.setFont(new Font("DejaVu Sans", 1, 13));
        Mnemonics.setLocalizedText((JLabel)this.jLabel12, (String)NbBundle.getMessage(OptionFilesPanel.class, (String)"OptionFilesPanel.jLabel12.text"));
        Mnemonics.setLocalizedText((JLabel)this.jLabel14, (String)NbBundle.getMessage(OptionFilesPanel.class, (String)"OptionFilesPanel.jLabel14.text"));
        this.logLevel.setModel(new DefaultComboBoxModel<String>(new String[]{"OFF", "SEVERE", "WARNING", "INFO", "CONFIG", "FINE", "FINER", "FINEST", "ALL"}));
        this.logLevel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OptionFilesPanel.this.logLevelActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.jcbOpenNothing, (String)NbBundle.getMessage(OptionFilesPanel.class, (String)"OptionFilesPanel.jcbOpenNothing.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.jcbAlwaysOpen, (String)NbBundle.getMessage(OptionFilesPanel.class, (String)"OptionFilesPanel.jcbAlwaysOpen.text"));
        this.jcbAlwaysOpen.setToolTipText(NbBundle.getMessage(OptionFilesPanel.class, (String)"OptionFilesPanel.jcbOpenOnlyEmpty.tooltip"));
        Mnemonics.setLocalizedText((JLabel)this.jLabel4, (String)NbBundle.getMessage(OptionFilesPanel.class, (String)"OptionFilesPanel.jLabel4.text"));
        this.nbBackups.setModel(new SpinnerNumberModel((Number)0, Integer.valueOf(0), null, (Number)1));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel1).addGroup(layout.createSequentialGroup().addGap(12, 12, 12).addComponent(this.jLabel3))).addGap(37, 37, 37)).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel5).addGroup(layout.createSequentialGroup().addComponent(this.jTextField3).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButton3)))).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel12).addGroup(layout.createSequentialGroup().addGap(12, 12, 12).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel13).addComponent(this.jLabel14).addComponent(this.jLabel4)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.nbBackups).addComponent(this.logLevel, 0, -1, Short.MAX_VALUE).addComponent(this.jSpinner1, -2, 105, -2)))).addGap(0, 0, Short.MAX_VALUE))).addContainerGap()).addGroup(layout.createSequentialGroup().addGap(24, 24, 24).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jTextField2, -1, 500, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButton2).addGap(30, 30, 30)).addGroup(layout.createSequentialGroup().addGap(6, 6, 6).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jcbOpenNothing).addComponent(this.jcbAlwaysOpen)).addContainerGap(-1, Short.MAX_VALUE)))));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel3).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButton2).addComponent(this.jTextField2, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jcbAlwaysOpen).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jcbOpenNothing).addGap(12, 12, 12).addComponent(this.jLabel5).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jTextField3, -2, -1, -2).addComponent(this.jButton3)).addGap(18, 18, 18).addComponent(this.jLabel12).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel13).addComponent(this.jSpinner1, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel14).addComponent(this.logLevel, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel4).addComponent(this.nbBackups, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
    }

    private void jButton3ActionPerformed(ActionEvent evt) {
        this.chooseFileDir(this.jTextField3, true);
    }

    private void jButton2ActionPerformed(ActionEvent evt) {
        this.chooseFileDir(this.jTextField2, false);
    }

    private void logLevelActionPerformed(ActionEvent evt) {
    }

    void load() {
        Registry gedcomPrefs = Registry.get(GedcomOptions.class);
        this.setGedcomFile(CoreOptions.getInstance().getDefaultGedcom());
        this.jcbOpenNothing.setSelected(CoreOptions.getInstance().getOpenNothingAtStartup());
        this.jcbAlwaysOpen.setSelected(CoreOptions.getInstance().getAlwaysOpenDefault());
        this.setReportDir(gedcomPrefs.get("reportDir", System.getProperty("user.home")));
        this.jSpinner1.setValue(AppOptions.getMaxLogSizeKB());
        this.setLogLevel(Registry.get(App.class).get("logLevel", "INFO"));
        this.nbBackups.setValue(Options.getNbBackups());
    }

    void store() {
        Registry gedcomPrefs = Registry.get(GedcomOptions.class);
        CoreOptions.getInstance().setDefaultGedcom(this.getGedcomFile());
        CoreOptions.getInstance().setOpenNothingAtStartup(this.jcbOpenNothing.isSelected());
        CoreOptions.getInstance().setAlwaysOpenDefault(this.jcbAlwaysOpen.isSelected());
        gedcomPrefs.put("reportDir", this.getReportDir());
        AppOptions.setMaxLogSizeKB(Integer.valueOf(this.jSpinner1.getValue().toString()));
        Registry.get(App.class).put("logLevel", this.getLogLevel());
        StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage(OptionFilesPanel.class, (String)"OptionPanel.saved.statustext"));
        Collection actions = Lookup.getDefault().lookupAll(Openable.class);
        for (Openable openable : actions) {
            openable.open();
        }
        Options.setNbBackups((int)Integer.valueOf(this.nbBackups.getValue().toString()));
    }

    boolean valid() {
        return true;
    }

    void setGedcomFile(URL file) {
        this.jTextField2.setText("");
        try {
            if (file != null && "file".equals(file.getProtocol())) {
                this.jTextField2.setText(new File(file.toURI()).getAbsolutePath());
            }
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
    }

    private URL getGedcomFile() {
        if (this.jTextField2.getText().trim().isEmpty()) {
            return null;
        }
        return URLUtil.toURL(this.jTextField2.getText());
    }

    void setReportDir(String str) {
        if (str.equals("")) {
            str = System.getProperty("user.home") + File.separator + "report";
        }
        this.jTextField3.setText(str);
    }

    String getReportDir() {
        return this.jTextField3.getText();
    }

    String getAssoCommand(String str) {
        String command = "";
        int i = str.lastIndexOf("*");
        command = i < 0 ? str : (i + 1 == str.length() || str.equals("") ? "" : str.substring(i + 1, str.length()));
        return command;
    }

    String getLogLevel() {
        return this.logLevel.getSelectedItem().toString();
    }

    void setLogLevel(String str) {
        this.logLevel.setSelectedItem(str);
    }
}

