/*
 * Decompiled with CFR 0.152.
 */
package ancestris.app;

import ancestris.core.CoreOptions;
import ancestris.gedcom.GedcomDirectory;
import java.net.URL;
import javax.swing.JMenuItem;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.actions.CookieAction;

public final class ActionOpenDefault
extends CookieAction {
    private FileObject fileToOpen = null;

    protected int mode() {
        return 7;
    }

    protected Class<?>[] cookieClasses() {
        return new Class[]{String.class};
    }

    protected void performAction(Node[] nodes) {
        if (this.fileToOpen != null) {
            try {
                GedcomDirectory.getDefault().openGedcom(this.fileToOpen);
            }
            catch (Exception e) {
                System.out.println("Error opening default gedcom:" + e);
            }
        }
    }

    protected boolean asynchronous() {
        return false;
    }

    public String getName() {
        String name = this.getDefaultFile(true);
        this.setEnabled(name != null && !name.isEmpty());
        String str = "";
        str = name == null || name.isEmpty() ? NbBundle.getMessage(ActionOpenDefault.class, (String)"ActionOpenDefault.NoFile") : name;
        return NbBundle.getMessage(ActionOpenDefault.class, (String)"CTL_ActionOpenDefault") + " " + str;
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    protected boolean enable(Node[] arg0) {
        super.enable(arg0);
        return this.calcState();
    }

    protected String iconResource() {
        return "ancestris/app/OpenDefault.png";
    }

    public JMenuItem getMenuPresenter() {
        JMenuItem item = super.getMenuPresenter();
        return item;
    }

    private String getDefaultFile(boolean nameOnly) {
        URL defaultFile = CoreOptions.getInstance().getDefaultGedcom();
        if (defaultFile == null) {
            return null;
        }
        try {
            this.fileToOpen = URLMapper.findFileObject((URL)defaultFile);
            if (!this.fileToOpen.isValid()) {
                return null;
            }
        }
        catch (Throwable t) {
            return null;
        }
        if (nameOnly) {
            return this.fileToOpen.getNameExt();
        }
        return FileUtil.getFileDisplayName((FileObject)this.fileToOpen);
    }

    public boolean calcState() {
        return CoreOptions.getInstance().getDefaultGedcom() != null;
    }
}

