/*
 * Decompiled with CFR 0.152.
 */
package genj.view;

import genj.gedcom.Context;
import genj.gedcom.Entity;
import genj.gedcom.Gedcom;
import genj.gedcom.Property;
import genj.gedcom.PropertyEvent;
import genj.util.swing.ImageIcon;
import java.util.List;

public class ViewContext
extends Context
implements Comparable<ViewContext> {
    private ImageIcon img = null;
    private String txt = null;

    public ViewContext(String text, Context context) {
        super(context);
        this.setText(text);
    }

    public ViewContext(String text, ImageIcon img, Context context) {
        super(context);
        this.setText(text);
        this.setImage(img);
    }

    public ViewContext(Context context) {
        super(context);
    }

    public ViewContext(Gedcom gedcom, List<Entity> entities, List<Property> properties) {
        super(gedcom, entities, properties);
    }

    public ViewContext(Gedcom ged) {
        super(ged);
    }

    public ViewContext(Property prop) {
        super(prop);
    }

    public ViewContext(Entity entity) {
        super(entity);
    }

    public String getText() {
        if (this.txt != null) {
            return this.txt;
        }
        List<? extends Property> ps = this.getProperties();
        List<? extends Entity> es = this.getEntities();
        if (ps.size() == 1) {
            StringBuffer buf = new StringBuffer();
            Property p = ps.get(0);
            buf.append(p.getPropertyName());
            while (!(p.getParent() instanceof Entity)) {
                if (!((p = p.getParent()) instanceof PropertyEvent)) continue;
                buf.append("|");
                buf.append(((PropertyEvent)p).getPropertyDisplayValue("DATE"));
                break;
            }
            buf.append("|");
            buf.append(p.getEntity());
            this.txt = buf.toString();
        } else {
            this.txt = !ps.isEmpty() ? Property.getPropertyNames(ps, 5) : (es.size() == 1 ? es.get(0).toString() : (!es.isEmpty() ? Entity.getPropertyNames(es, 5) : (this.getGedcom() == null ? null : this.getGedcom().getName())));
        }
        return this.txt == null ? "" : this.txt;
    }

    public ViewContext setText(String text) {
        this.txt = text;
        return this;
    }

    public ImageIcon getImage() {
        if (this.img != null) {
            return this.img;
        }
        this.img = this.getProperties().size() == 1 ? this.getProperties().get(0).getImage(false) : (this.getEntities().size() == 1 ? this.getEntities().get(0).getImage(false) : Gedcom.getImage());
        return this.img;
    }

    public ViewContext setImage(ImageIcon set) {
        this.img = set;
        return this;
    }

    @Override
    public int compareTo(ViewContext that) {
        if (this.txt == null) {
            return -1;
        }
        if (that.txt == null) {
            return 1;
        }
        return this.txt.compareTo(that.txt);
    }
}

