/*
 * Decompiled with CFR 0.152.
 */
package genj.util;

public class WordBuffer {
    private StringBuffer buffer = new StringBuffer(80);
    private String filler = " ";

    public WordBuffer(String filler) {
        this();
        this.setFiller(filler);
    }

    public WordBuffer() {
    }

    public WordBuffer setFiller(String set) {
        this.filler = set;
        return this;
    }

    public String toString() {
        return this.buffer.toString();
    }

    public WordBuffer append(int i) {
        if (this.buffer.length() > 0) {
            this.buffer.append(this.filler);
        }
        this.buffer.append(i);
        return this;
    }

    public WordBuffer append(Object object) {
        if (object != null) {
            this.append(object.toString());
        }
        return this;
    }

    public WordBuffer append(Object object, String nullSubst) {
        if (object == null) {
            return this.append(nullSubst);
        }
        return this.append(object.toString(), nullSubst);
    }

    public WordBuffer append(String word) {
        return word == null ? this : this.append(word, null);
    }

    public WordBuffer append(String word, String nullSubst) {
        if (word == null || word.length() == 0) {
            return this.append(nullSubst);
        }
        if (this.buffer.length() > 0 && !this.isStartingWithPunctuation(word)) {
            this.buffer.append(this.filler);
        }
        this.buffer.append(word.trim());
        return this;
    }

    private final boolean isStartingWithPunctuation(String word) {
        switch (word.charAt(0)) {
            default: {
                return false;
            }
            case '.': {
                return true;
            }
            case ',': {
                return true;
            }
            case ':': 
        }
        return true;
    }

    public int length() {
        return this.buffer.length();
    }
}

