/*
 * Decompiled with CFR 0.152.
 */
package genj.util;

import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.regex.Pattern;

public class PackageUtils {
    public static List<Class> getClassesForPackage(String pckgname) throws ClassNotFoundException {
        return PackageUtils.getClassesForPackage(pckgname, null);
    }

    public static List<Class> getClassesForPackage(String pckgname, String startWith) throws ClassNotFoundException {
        ArrayList<Class> classes = new ArrayList<Class>();
        List<String> resPaths = PackageUtils.findInPackage(pckgname, Pattern.compile((".*/" + (startWith == null ? "" : startWith) + "[^/]*").concat("\\.class")));
        for (String resPath : resPaths) {
            classes.add(Class.forName(resPath.substring(0, resPath.length() - 6)));
        }
        return classes;
    }

    public static List<String> findInPackage(String pckgname, Pattern pattern) throws ClassNotFoundException {
        ArrayList<String> resPath = new ArrayList<String>();
        ArrayList<File> directories = new ArrayList<File>();
        String packagePath = pckgname.replace('.', '/');
        try {
            ClassLoader cld = Thread.currentThread().getContextClassLoader();
            if (cld == null) {
                throw new ClassNotFoundException("Can't get class loader.");
            }
            Enumeration<URL> resources = cld.getResources(pckgname.replace('.', '/') + "/");
            while (resources.hasMoreElements()) {
                URL res = resources.nextElement();
                if (res.getProtocol().equalsIgnoreCase("jar")) {
                    JarURLConnection conn = (JarURLConnection)res.openConnection();
                    JarFile jar = conn.getJarFile();
                    for (JarEntry e : Collections.list(jar.entries())) {
                        if (!e.getName().startsWith(packagePath) || e.getName().contains("$") || !pattern.matcher(e.getName().substring(packagePath.length())).matches()) continue;
                        String className = e.getName().replace("/", ".");
                        resPath.add(className);
                    }
                    continue;
                }
                directories.add(new File(URLDecoder.decode(res.getPath(), "UTF-8")));
            }
        }
        catch (NullPointerException x) {
            throw new ClassNotFoundException(pckgname + " does not appear to be " + "a valid package (Null pointer exception)");
        }
        catch (UnsupportedEncodingException encex) {
            throw new ClassNotFoundException(pckgname + " does not appear to be " + "a valid package (Unsupported encoding)");
        }
        catch (IOException ioex) {
            throw new ClassNotFoundException("IOException was thrown when trying to get all resources for " + pckgname);
        }
        for (File directory : directories) {
            if (directory.exists()) {
                String[] files;
                for (String file : files = directory.list()) {
                    if (!pattern.matcher(file).matches()) continue;
                    resPath.add(pckgname + '.' + file);
                }
                continue;
            }
            throw new ClassNotFoundException(pckgname + " (" + directory.getPath() + ") does not appear to be a valid package");
        }
        return resPath;
    }
}

