/*
 * Decompiled with CFR 0.152.
 */
package genj.util;

import genj.util.ByteArray;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;

public abstract class Origin {
    private static Logger LOG = Logger.getLogger("genj.util");
    private static final char BSLASH = '\\';
    private static final char FSLASH = '/';
    private static final char COLON = ':';
    protected URL url;
    private static final Pattern ABSOLUTE = Pattern.compile("([a-z]:).*|([A-Z]:).*|\\/.*|\\\\.*");

    protected Origin(URL url) {
        this.url = url;
    }

    public static Origin create(String s) throws MalformedURLException {
        return Origin.create(new URL(s));
    }

    public static Origin create(URL url) {
        if (url.getFile().endsWith(".zip")) {
            return new ZipOrigin(url);
        }
        return new DefaultOrigin(url);
    }

    public static Origin create(FileObject file) {
        FOOrigin o;
        try {
            o = new FOOrigin(file.toURL());
        }
        catch (Throwable ex) {
            return null;
        }
        o.setFileObject(file);
        return o;
    }

    public abstract InputStream open() throws IOException;

    public final InputStream open(String name) throws IOException {
        if (ABSOLUTE.matcher(name = this.back2forwardslash(name)).matches()) {
            URLConnection uc;
            LOG.finer("Trying to open " + name + " as absolute path (origin is " + this + ")");
            try {
                uc = new URL(name).openConnection();
            }
            catch (MalformedURLException e1) {
                try {
                    uc = new URL("file:" + name).openConnection();
                }
                catch (MalformedURLException e2) {
                    return null;
                }
            }
            return new InputStreamImpl(uc.getInputStream(), uc.getContentLength());
        }
        LOG.finer("Trying to open " + name + " as relative path (origin is " + this + ")");
        return this.openImpl(name);
    }

    protected abstract InputStream openImpl(String var1) throws IOException;

    public String toString() {
        return this.url.toString();
    }

    public String calcRelativeLocation(String file) {
        String here = this.url.toString();
        if (here.startsWith("file://")) {
            here = here.substring("file:/".length());
        } else if (here.startsWith("file:")) {
            here = here.substring("file:".length());
        }
        if (!ABSOLUTE.matcher(file).matches()) {
            return null;
        }
        try {
            here = this.back2forwardslash(new File(here.substring(0, here.lastIndexOf(47))).getCanonicalPath()) + "/";
            file = this.back2forwardslash(new File(file).getCanonicalPath());
            boolean startsWith = file.startsWith(here);
            LOG.finer("File " + file + " is " + (startsWith ? "" : "not ") + "relative to " + here);
            if (startsWith) {
                return file.substring(here.length());
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }

    public abstract String[] list() throws IOException;

    public abstract File getFile();

    public abstract File getFile(String var1);

    public String getFileName() {
        return this.getName();
    }

    public String getName() {
        String path;
        try {
            path = this.back2forwardslash(URLDecoder.decode(this.url.toString()));
        }
        catch (Exception ex) {
            path = this.url.toString();
        }
        if (path.endsWith("/")) {
            path = path.substring(0, path.length() - 1);
        }
        return path.substring(path.lastIndexOf(47) + 1);
    }

    public boolean equals(Object other) {
        return other instanceof Origin && ((Origin)other).url.toString().equals(this.url.toString());
    }

    public int hashCode() {
        return this.url.toString().hashCode();
    }

    protected String back2forwardslash(String s) {
        return s.toString().replace('\\', '/');
    }

    private static class InputStreamImpl
    extends InputStream {
        private InputStream in;
        private int available;

        protected InputStreamImpl(InputStream in, int len) {
            this.in = in;
            this.available = len;
        }

        @Override
        public int read() throws IOException {
            if (this.available > 0) {
                --this.available;
            }
            return this.in.read();
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            this.available = Math.max(0, this.available - len);
            return this.in.read(b, off, len);
        }

        @Override
        public int available() throws IOException {
            return this.available;
        }

        @Override
        public void close() throws IOException {
            this.in.close();
        }
    }

    private static class ZipOrigin
    extends Origin {
        private byte[] cachedBits;

        protected ZipOrigin(URL url) {
            super(url);
        }

        @Override
        public String[] list() throws IOException {
            ZipEntry entry;
            ArrayList<String> result = new ArrayList<String>();
            ZipInputStream in = this.openImpl();
            while ((entry = in.getNextEntry()) != null) {
                result.add(entry.getName());
            }
            in.close();
            return result.toArray(new String[result.size()]);
        }

        @Override
        public InputStream open() throws IOException {
            String anchor = this.url.getRef();
            if (anchor == null || anchor.length() == 0) {
                throw new IOException("ZipOrigin needs anchor for open()");
            }
            return this.openImpl(anchor);
        }

        private ZipInputStream openImpl() throws IOException {
            if (this.cachedBits == null) {
                try {
                    this.cachedBits = new ByteArray(this.url.openConnection().getInputStream(), true).getBytes();
                }
                catch (InterruptedException e) {
                    throw new IOException("interrupted while opening " + this.getName());
                }
            }
            return new ZipInputStream(new ByteArrayInputStream(this.cachedBits));
        }

        @Override
        protected InputStream openImpl(String file) throws IOException {
            ZipInputStream zin = this.openImpl();
            ZipEntry zentry = zin.getNextEntry();
            while (zentry != null) {
                if (zentry.getName().equals(file)) {
                    return new InputStreamImpl(zin, (int)zentry.getSize());
                }
                zentry = zin.getNextEntry();
            }
            throw new IOException("Couldn't find resource " + file + " in ZIP-file");
        }

        @Override
        public File getFile() {
            return null;
        }

        @Override
        public String getFileName() {
            return this.url.getRef();
        }

        @Override
        public File getFile(String name) {
            return null;
        }
    }

    private static class FOOrigin
    extends Origin {
        private FileObject fileObject;

        public void setFileObject(FileObject fileObject) {
            this.fileObject = fileObject;
        }

        protected FOOrigin(URL url) {
            super(url);
        }

        @Override
        public InputStream open() throws IOException {
            return this.fileObject.getInputStream();
        }

        @Override
        protected InputStream openImpl(String name) throws IOException {
            FileObject fo = null;
            fo = this.fileObject.isFolder() ? this.fileObject.getFileObject(name) : this.fileObject.getFileObject("../" + name);
            return fo.getInputStream();
        }

        @Override
        public String[] list() {
            File dir = this.getFile();
            if (dir == null) {
                throw new IllegalArgumentException("list() not supported by url protocol");
            }
            if (!dir.isDirectory()) {
                dir = dir.getParentFile();
            }
            return dir.list();
        }

        @Override
        public File getFile() {
            return FileUtil.toFile((FileObject)this.fileObject);
        }

        @Override
        public File getFile(String file) {
            if (file.length() < 1) {
                return null;
            }
            if (ABSOLUTE.matcher(file).matches()) {
                return new File(file);
            }
            return new File(this.getFile().getParent(), file);
        }
    }

    private static class DefaultOrigin
    extends Origin {
        protected DefaultOrigin(URL url) {
            super(url);
        }

        @Override
        public InputStream open() throws IOException {
            URLConnection uc = this.url.openConnection();
            return new InputStreamImpl(uc.getInputStream(), uc.getContentLength());
        }

        @Override
        protected InputStream openImpl(String name) throws IOException {
            String path = this.back2forwardslash(this.url.toString());
            path = path.substring(0, path.lastIndexOf(47) + 1) + name;
            try {
                URLConnection uc = new URL(path).openConnection();
                return new InputStreamImpl(uc.getInputStream(), uc.getContentLength());
            }
            catch (MalformedURLException e) {
                throw new IOException(e.getMessage());
            }
        }

        @Override
        public String[] list() {
            File dir = this.getFile();
            if (dir == null) {
                throw new IllegalArgumentException("list() not supported by url protocol");
            }
            if (!dir.isDirectory()) {
                dir = dir.getParentFile();
            }
            return dir.list();
        }

        @Override
        public File getFile() {
            if (!"file".equals(this.url.getProtocol()) && !"jar".equals(this.url.getProtocol())) {
                return null;
            }
            try {
                return new File(this.url.toURI());
            }
            catch (URISyntaxException ex) {
                Exceptions.printStackTrace((Throwable)ex);
                return null;
            }
        }

        @Override
        public File getFile(String file) {
            if (file.length() < 1) {
                return null;
            }
            if (ABSOLUTE.matcher(file).matches()) {
                return new File(file);
            }
            return new File(this.getFile().getParent(), file);
        }
    }
}

