/*
 * Decompiled with CFR 0.152.
 */
package genj.util;

import java.util.ArrayList;

public class DirectAccessTokenizer {
    private String string;
    private String separator;
    private int from;
    private int to;
    private int index;
    private boolean skipEmpty;

    public DirectAccessTokenizer(String string, String separator) {
        this(string, separator, false);
    }

    public DirectAccessTokenizer(String string, String separator, boolean skipEmpty) {
        this.skipEmpty = skipEmpty;
        this.string = string;
        this.separator = separator;
        this.from = 0;
        this.to = this.from - separator.length();
        this.index = 0;
    }

    public String[] getTokens() {
        return this.getTokens(false);
    }

    public String[] getTokens(boolean trim) {
        String token;
        ArrayList<String> result = new ArrayList<String>();
        int i = 0;
        while ((token = this.get(i, trim)) != null) {
            result.add(token);
            ++i;
        }
        return result.toArray(new String[result.size()]);
    }

    public int count() {
        int result = 0;
        int i = 0;
        while (this.get(i) != null) {
            ++result;
            ++i;
        }
        return result;
    }

    public int getStart() {
        return this.from;
    }

    public int getEnd() {
        return this.to;
    }

    public String getSubstring(int pos) {
        if (this.get(pos) == null) {
            return "";
        }
        return this.string.substring(this.getStart());
    }

    public String get(int pos) {
        return this.get(pos, false);
    }

    public String get(int pos, boolean trim) {
        if (pos < 0) {
            return null;
        }
        if (pos < this.index) {
            this.from = 0;
            this.to = this.from - this.separator.length();
            this.index = 0;
        }
        while (this.index <= pos) {
            this.from = this.to + this.separator.length();
            if (this.from > this.string.length()) {
                return null;
            }
            this.to = this.string.indexOf(this.separator, this.from);
            if (this.to < 0) {
                this.to = this.string.length();
            }
            if (this.skipEmpty && this.to <= this.from) continue;
            ++this.index;
        }
        String result = this.string.substring(this.from, this.to);
        return trim ? result.trim() : result;
    }

    public String toString() {
        return this.string.replaceAll(this.separator, ", ");
    }
}

