/*
 * Decompiled with CFR 0.152.
 */
package genj.print;

import ancestris.core.actions.AbstractAncestrisAction;
import genj.option.Option;
import genj.option.OptionListener;
import genj.option.OptionsWidget;
import genj.print.PrintTask;
import genj.print.ScalingWidget;
import genj.renderer.DPI;
import genj.renderer.RenderOptions;
import genj.renderer.RenderPreviewHintKey;
import genj.util.Resources;
import genj.util.swing.ChoiceWidget;
import genj.util.swing.GraphicsHelper;
import genj.util.swing.NestedBlockLayout;
import genj.util.swing.ScrollPaneWidget;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.Dimension2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.util.List;
import java.util.logging.Logger;
import javax.print.PrintService;
import javax.print.ServiceUI;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.Scrollable;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class PrintWidget
extends JTabbedPane {
    static final Resources RESOURCES = Resources.get(PrintWidget.class);
    static final Logger LOG = Logger.getLogger("ancestris.print");
    private PrintTask task;
    private ChoiceWidget services;
    private ScalingWidget scaling;
    private Preview preview;
    private Apply apply = new Apply();
    private JCheckBox fit;
    private JCheckBox empties;

    public PrintWidget(PrintTask task) {
        this.task = task;
        this.add(RESOURCES.getString("printer"), this.createFirstPage());
        this.add(RESOURCES.getString("settings"), this.createSecondPage());
    }

    public void commit() {
        if (this.services.getSelectedItem() != null) {
            this.task.setService((PrintService)this.services.getSelectedItem());
        }
    }

    private JPanel createFirstPage() {
        String LAYOUT_TEMPLATE = "<col><row><lprinter/><printers wx=\"1\"/><settings/></row><row><zoom/><fit/></row><row><lpreview/></row><row><preview wx=\"1\" wy=\"1\"/></row></col>";
        JPanel page = new JPanel(new NestedBlockLayout(LAYOUT_TEMPLATE));
        page.add(new JLabel(RESOURCES.getString("printer")));
        this.services = new ChoiceWidget(this.task.getServices(), this.task.getService());
        this.services.setEditable(false);
        this.services.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() != 1) {
                    PrintWidget.this.task.setService((PrintService)PrintWidget.this.services.getSelectedItem());
                }
            }
        });
        page.add(this.services);
        page.add(new JButton(new Settings()));
        this.scaling = new ScalingWidget();
        this.scaling.addChangeListener(this.apply);
        page.add(this.scaling);
        this.fit = new JCheckBox(RESOURCES.getString("fit"), false);
        this.fit.setEnabled(false);
        this.fit.addChangeListener(this.apply);
        page.add(this.fit);
        page.add(new JLabel(RESOURCES.getString("preview")));
        this.preview = new Preview();
        page.add(new ScrollPaneWidget(this.preview));
        return page;
    }

    private JComponent createSecondPage() {
        List<? extends Option> options = this.task.getOptions();
        for (Option option : options) {
            option.addOptionListener(this.apply);
        }
        return new OptionsWidget(this.task.getTitle(), options);
    }

    private class Apply
    implements ChangeListener,
    OptionListener {
        private Apply() {
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            this.apply();
        }

        @Override
        public void optionChanged(Option option) {
            this.apply();
        }

        private void apply() {
            Object scale = PrintWidget.this.scaling.getValue();
            if (scale instanceof Dimension) {
                PrintWidget.this.task.setPages((Dimension)scale, PrintWidget.this.fit.isSelected());
                PrintWidget.this.fit.setEnabled(true);
            }
            if (scale instanceof Double) {
                PrintWidget.this.task.setZoom((Double)scale);
                PrintWidget.this.fit.setEnabled(false);
            }
            PrintWidget.this.preview.revalidate();
            PrintWidget.this.preview.repaint();
        }
    }

    private class Settings
    extends AbstractAncestrisAction {
        private Settings() {
            super.setText(RESOURCES.getString("settings"));
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            Point pos = PrintWidget.this.getLocationOnScreen();
            PrintService choice = ServiceUI.printDialog(null, pos.x, pos.y, PrintWidget.this.task.getServices(), PrintWidget.this.task.getService(), null, PrintWidget.this.task.getAttributes());
            if (choice != null) {
                PrintWidget.this.services.setSelectedItem(choice);
            }
            PrintWidget.this.preview.revalidate();
            PrintWidget.this.preview.repaint();
        }
    }

    private class Preview
    extends JComponent
    implements Scrollable {
        private double zoom = 0.2;
        private int gap = 5;
        private DPI dpi = new DPI((int)((double)RenderOptions.getInstance().getDPI().horizontal() * this.zoom), (int)((double)RenderOptions.getInstance().getDPI().vertical() * this.zoom));

        private Preview() {
        }

        @Override
        public Dimension getPreferredSize() {
            Dimension pages = PrintWidget.this.task.getPages();
            Dimension2D page = this.dpi.toPixel(PrintWidget.this.task.getPageSize());
            return new Dimension((int)Math.ceil((double)pages.width * page.getWidth() + (double)(pages.width * this.gap) + (double)this.gap), (int)Math.ceil((double)pages.height * page.getHeight() + (double)(pages.height * this.gap) + (double)this.gap));
        }

        @Override
        protected void paintComponent(Graphics g) {
            g.setColor(Color.gray);
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
            g.setColor(Color.white);
            Graphics2D g2d = (Graphics2D)g;
            g2d.setRenderingHint(RenderPreviewHintKey.KEY, true);
            g2d.setRenderingHint(DPI.KEY, this.dpi);
            Dimension pages = PrintWidget.this.task.getPages();
            Dimension2D pageSize = this.dpi.toPixel(PrintWidget.this.task.getPageSize());
            Rectangle clip = g2d.getClipBounds();
            AffineTransform at = g2d.getTransform();
            for (int y = 0; y < pages.height; ++y) {
                for (int x = 0; x < pages.width; ++x) {
                    Rectangle2D.Double page = new Rectangle2D.Double((double)this.gap + (double)x * (pageSize.getWidth() + (double)this.gap), (double)this.gap + (double)y * (pageSize.getHeight() + (double)this.gap), pageSize.getWidth(), pageSize.getHeight());
                    if (!clip.intersects(page)) continue;
                    g2d.setColor(Color.white);
                    g2d.fill(page);
                    g.setColor(Color.gray);
                    g.setFont(new Font("Arial", 1, 48));
                    GraphicsHelper.render(g2d, String.valueOf(x + y * pages.width + 1), page.getCenterX(), page.getCenterY(), 0.5, 0.5);
                    g2d.translate((double)this.gap + (double)x * (((RectangularShape)page).getWidth() + (double)this.gap), (double)this.gap + (double)y * (((RectangularShape)page).getHeight() + (double)this.gap));
                    PrintWidget.this.task.print(g2d, y, x);
                    g2d.setTransform(at);
                    g2d.setClip(clip);
                }
            }
        }

        @Override
        public boolean getScrollableTracksViewportHeight() {
            return false;
        }

        @Override
        public boolean getScrollableTracksViewportWidth() {
            return false;
        }

        @Override
        public Dimension getPreferredScrollableViewportSize() {
            return new Dimension(0, 0);
        }

        @Override
        public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction) {
            return orientation == 1 ? visibleRect.height : visibleRect.width;
        }

        @Override
        public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
            return 1;
        }
    }
}

