/*
 * Decompiled with CFR 0.152.
 */
package genj.gedcom.time;

import genj.gedcom.time.Calendar;
import genj.gedcom.time.PointInTime;
import genj.util.WordBuffer;
import java.util.StringTokenizer;

public class Delta
implements Comparable<Delta> {
    public static final String TXT_DAY = PointInTime.resources.getString("time.day");
    public static final String TXT_DAYS = PointInTime.resources.getString("time.days");
    public static final String TXT_DAYSS;
    public static final String TXT_MONTH;
    public static final String TXT_MONTHS;
    public static final String TXT_MONTHSS;
    public static final String TXT_YEAR;
    public static final String TXT_YEARS;
    public static final String TXT_YEARSS;
    private int years;
    private int months;
    private int days;
    private Calendar calendar;

    public Delta(int d, int m, int y) {
        this(d, m, y, PointInTime.GREGORIAN);
    }

    public Delta(int d, int m, int y, Calendar c) {
        this.years = y;
        this.months = m;
        this.days = d;
        this.calendar = c;
    }

    public int getYears() {
        return this.years;
    }

    public int getMonths() {
        return this.months;
    }

    public int getDays() {
        return this.days;
    }

    public Calendar getCalendar() {
        return this.calendar;
    }

    public static Delta get(PointInTime earlier, PointInTime later, Calendar calendar) {
        try {
            earlier = earlier.getPointInTime(calendar);
            later = later.getPointInTime(calendar);
        }
        catch (Throwable t) {
            return null;
        }
        if (earlier.compareTo(later) > 0) {
            PointInTime p = earlier;
            earlier = later;
            later = p;
        }
        int yearlier = earlier.getYear();
        int mearlier = earlier.getMonth();
        int dearlier = earlier.getDay();
        if (earlier.getCalendar() == PointInTime.GREGORIAN && yearlier < 0) {
            ++yearlier;
        }
        int ylater = later.getYear();
        int mlater = later.getMonth();
        int dlater = later.getDay();
        if (later.getCalendar() == PointInTime.GREGORIAN && ylater < 0) {
            ++ylater;
        }
        if (yearlier == Integer.MAX_VALUE || ylater == Integer.MAX_VALUE) {
            return null;
        }
        int years = ylater - yearlier;
        int months = 0;
        int days = 0;
        if (mearlier != Integer.MAX_VALUE && mlater != Integer.MAX_VALUE) {
            months = mlater - mearlier;
            if (dearlier != Integer.MAX_VALUE && dlater != Integer.MAX_VALUE && (days = dlater - dearlier) < 0) {
                --months;
                days = dlater + (calendar.getDays(mearlier, yearlier) - dearlier);
            }
            if (months < 0) {
                --years;
                months += calendar.getMonths();
            }
        }
        return new Delta(days, months, years, calendar);
    }

    public static Delta get(PointInTime earlier, PointInTime later) {
        return Delta.get(earlier, later, PointInTime.GREGORIAN);
    }

    @Override
    public int compareTo(Delta other) {
        int delta = this.years - other.years;
        if (delta != 0) {
            return delta;
        }
        delta = this.months - other.months;
        if (delta != 0) {
            return delta;
        }
        delta = this.days - other.days;
        return delta;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Delta)) {
            return false;
        }
        Delta d = (Delta)obj;
        return d.calendar == this.calendar && d.days == this.days && d.months == this.months && d.years == this.years;
    }

    public int hashCode() {
        return this.calendar.hashCode() + this.days + this.months + this.years;
    }

    public String toString() {
        int form;
        if (this.years == 0 && this.months == 0 && this.days == 0) {
            return "<1 " + TXT_DAY;
        }
        WordBuffer buffer = new WordBuffer();
        if (this.years > 0) {
            buffer.append(this.years);
            form = this.getPluralForm(this.years);
            if (form == 1) {
                buffer.append(TXT_YEAR);
            } else if (form == 2) {
                buffer.append(TXT_YEARS);
            } else {
                buffer.append(TXT_YEARSS);
            }
        }
        if (this.months > 0) {
            buffer.append(this.months);
            form = this.getPluralForm(this.months);
            if (form == 1) {
                buffer.append(TXT_MONTH);
            } else if (form == 2) {
                buffer.append(TXT_MONTHS);
            } else {
                buffer.append(TXT_MONTHSS);
            }
        }
        if (this.days > 0) {
            buffer.append(this.days);
            form = this.getPluralForm(this.days);
            if (form == 1) {
                buffer.append(TXT_DAY);
            } else if (form == 2) {
                buffer.append(TXT_DAYS);
            } else {
                buffer.append(TXT_DAYSS);
            }
        }
        return buffer.toString();
    }

    private int getPluralForm(int number) {
        if ((number = Math.abs(number)) == 1) {
            return 1;
        }
        if (number % 100 / 10 != 1 && number % 10 >= 2 && number % 10 <= 4) {
            return 2;
        }
        return 3;
    }

    public String getValue() {
        WordBuffer buffer = new WordBuffer();
        if (this.years > 0) {
            buffer.append(this.years + "y");
        }
        if (this.months > 0) {
            buffer.append(this.months + "m");
        }
        if (this.years == 0 && this.months == 0 || this.years > 0 && this.months > 0 || this.days > 0) {
            buffer.append(this.days + "d");
        }
        return buffer.toString();
    }

    public void setValue(Delta other) {
        this.years = other.years;
        this.months = other.months;
        this.days = other.days;
        this.calendar = other.calendar;
    }

    public boolean setValue(String value) {
        this.years = 0;
        this.months = 0;
        this.days = 0;
        StringTokenizer tokens = new StringTokenizer(value);
        block7: while (tokens.hasMoreTokens()) {
            int i;
            String token = tokens.nextToken();
            int len = token.length();
            if (len < 2) {
                return false;
            }
            for (i = 0; i < len - 1; ++i) {
                if (Character.isDigit(token.charAt(i))) continue;
                return false;
            }
            try {
                i = Integer.parseInt(token.substring(0, token.length() - 1));
            }
            catch (NumberFormatException e) {
                return false;
            }
            switch (token.charAt(len - 1)) {
                case 'y': {
                    this.years = i;
                    continue block7;
                }
                case 'm': {
                    this.months = i;
                    continue block7;
                }
                case 'd': {
                    this.days = i;
                    continue block7;
                }
            }
            return false;
        }
        return true;
    }

    static {
        TXT_MONTH = PointInTime.resources.getString("time.month");
        TXT_MONTHS = PointInTime.resources.getString("time.months");
        TXT_YEAR = PointInTime.resources.getString("time.year");
        TXT_YEARS = PointInTime.resources.getString("time.years");
        String ss = PointInTime.resources.getString("time.dayss");
        TXT_DAYSS = ss.equals("time.dayss") ? PointInTime.resources.getString("time.days") : ss;
        ss = PointInTime.resources.getString("time.monthss");
        TXT_MONTHSS = ss.equals("time.monthss") ? PointInTime.resources.getString("time.months") : ss;
        ss = PointInTime.resources.getString("time.yearss");
        TXT_YEARSS = ss.equals("time.yearss") ? PointInTime.resources.getString("time.years") : ss;
    }
}

