/*
 * Decompiled with CFR 0.152.
 */
package genj.gedcom;

import genj.gedcom.Gedcom;
import genj.gedcom.GedcomOptions;
import genj.gedcom.Grammar;
import genj.gedcom.Property;
import genj.gedcom.PropertyChoiceValue;
import genj.gedcom.PropertyComparator2;
import genj.gedcom.PropertyLatitude;
import genj.gedcom.PropertyLongitude;
import genj.gedcom.PropertyMap;
import genj.gedcom.TagPath;
import genj.util.DirectAccessTokenizer;
import genj.util.ReferenceSet;
import genj.util.swing.ImageIcon;
import java.text.Collator;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;

public class PropertyPlace
extends PropertyChoiceValue {
    private static final boolean USE_SPACES = GedcomOptions.getInstance().isUseSpacedPlaces();
    public static final ImageIcon IMAGE = Grammar.V55.getMeta(new TagPath("INDI:BIRT:PLAC")).getImage();
    public static final String JURISDICTION_SEPARATOR = ",";
    private static final String JURISDICTION_RESOURCE_PREFIX = "prop.plac.jurisdiction.";
    public static final String TAG = "PLAC";
    public static final String FORM = "FORM";

    public PropertyPlace(String tag) {
        super(tag);
    }

    @Override
    protected String trim(String value) {
        String jurisdiction;
        StringBuilder buf = new StringBuilder(value.length());
        DirectAccessTokenizer jurisdictions = new DirectAccessTokenizer(value, JURISDICTION_SEPARATOR);
        int i = 0;
        while ((jurisdiction = jurisdictions.get(i, true)) != null) {
            if (i > 0) {
                buf.append(JURISDICTION_SEPARATOR);
                if (USE_SPACES) {
                    buf.append(' ');
                }
            }
            buf.append(jurisdiction);
            ++i;
        }
        return buf.toString().intern();
    }

    @Override
    protected boolean remember(String theOld, String theNew) {
        String jurisdiction;
        if (!super.remember(theOld, theNew)) {
            return false;
        }
        Gedcom gedcom = this.getGedcom();
        DirectAccessTokenizer jurisdictions = new DirectAccessTokenizer(theOld, JURISDICTION_SEPARATOR);
        int i = 0;
        while ((jurisdiction = jurisdictions.get(i, true)) != null) {
            if (jurisdiction.length() > 0) {
                gedcom.getReferenceSet("PLAC." + i).remove(jurisdiction, this);
            }
            ++i;
        }
        jurisdictions = new DirectAccessTokenizer(theNew, JURISDICTION_SEPARATOR);
        i = 0;
        while ((jurisdiction = jurisdictions.get(i, true)) != null) {
            if (jurisdiction.length() > 0) {
                gedcom.getReferenceSet("PLAC." + i).add(jurisdiction.intern(), this);
            }
            ++i;
        }
        return true;
    }

    public String[] getFormat() {
        return PropertyPlace.toJurisdictions(this.getFormatAsString());
    }

    public static String[] getFormat(String str) {
        return PropertyPlace.toJurisdictions(str);
    }

    public static String[] getFormat(Gedcom gedcom) {
        return PropertyPlace.getFormat(gedcom, false);
    }

    public static String[] getFormat(Gedcom gedcom, boolean fallback) {
        String[] format = PropertyPlace.toJurisdictions(gedcom.getPlaceFormat());
        if (fallback && (format == null || format.length == 0)) {
            format = PropertyPlace.toJurisdictions(GedcomOptions.getInstance().getPlaceFormat());
        }
        return format;
    }

    private static String[] toJurisdictions(String value) {
        ArrayList<String> result = new ArrayList<String>(10);
        String lastToken = JURISDICTION_SEPARATOR;
        StringTokenizer tokens = new StringTokenizer(value, JURISDICTION_SEPARATOR, true);
        while (tokens.hasMoreTokens()) {
            String token = tokens.nextToken();
            if (!JURISDICTION_SEPARATOR.equals(token)) {
                result.add(token);
            } else if (JURISDICTION_SEPARATOR.equals(lastToken)) {
                result.add("");
            }
            lastToken = token;
        }
        if (JURISDICTION_SEPARATOR.equals(lastToken)) {
            result.add("");
        }
        return result.toArray(new String[result.size()]);
    }

    public String getFormatAsString() {
        String result = "";
        Property pformat = this.getProperty(FORM);
        if (pformat != null) {
            result = pformat.getValue();
        } else {
            Gedcom ged = this.getGedcom();
            if (ged != null) {
                result = ged.getPlaceFormat();
            }
        }
        return result;
    }

    public void setFormatAsString(boolean global, String format) {
        if (!global) {
            throw new IllegalArgumentException("non-global n/a");
        }
        this.getGedcom().setPlaceFormat(format);
        this.propagatePropertyChanged(this, this.getValue());
    }

    public PropertyPlace[] getSameChoices(int hierarchyLevel) {
        String jurisdiction = this.getJurisdiction(hierarchyLevel);
        if (jurisdiction == null) {
            return null;
        }
        Set<Property> places = this.getGedcom().getReferenceSet("PLAC." + hierarchyLevel).getReferences(jurisdiction);
        return places.toArray(new PropertyPlace[places.size()]);
    }

    public static PropertyPlace[] getSameChoices(Gedcom gedcom, int hierarchyLevel, String jurisdiction) {
        if (jurisdiction == null) {
            return null;
        }
        Set<Property> places = gedcom.getReferenceSet("PLAC." + hierarchyLevel).getReferences(jurisdiction);
        return places.toArray(new PropertyPlace[places.size()]);
    }

    public String[] getAllJurisdictions(int hierarchyLevel, boolean sort) {
        Gedcom gedcom = this.getGedcom();
        if (gedcom == null) {
            return new String[0];
        }
        return PropertyPlace.getAllJurisdictions(gedcom, hierarchyLevel, sort);
    }

    public static String[] getAllJurisdictions(Gedcom gedcom, int hierarchyLevel, boolean sort) {
        ReferenceSet<String, Property> refset = gedcom.getReferenceSet(hierarchyLevel < 0 ? TAG : "PLAC." + hierarchyLevel);
        List<String> jurisdictions = refset.getKeys(sort ? gedcom.getCollator() : null);
        return jurisdictions.toArray(new String[jurisdictions.size()]);
    }

    public String getFirstAvailableJurisdiction() {
        DirectAccessTokenizer jurisdictions = new DirectAccessTokenizer(this.getValue(), JURISDICTION_SEPARATOR);
        String result = "";
        int i = 0;
        while (result.length() == 0) {
            result = jurisdictions.get(i, true);
            if (result == null) {
                return "";
            }
            ++i;
        }
        return result;
    }

    public String getJurisdiction(int hierarchyLevel) {
        return new DirectAccessTokenizer(this.getValue(), JURISDICTION_SEPARATOR).get(hierarchyLevel, true);
    }

    public String[] getJurisdictions() {
        return PropertyPlace.toJurisdictions(this.getValue());
    }

    public String getCity() {
        int cityIndex = this.getCityIndex();
        if (cityIndex < 0) {
            return this.getFirstAvailableJurisdiction();
        }
        String city = new DirectAccessTokenizer(this.getValue(), JURISDICTION_SEPARATOR).get(cityIndex, true);
        return city != null ? city : "";
    }

    public String getValueStartingWithCity() {
        String result = this.getValue();
        int cityIndex = this.getCityIndex();
        if (cityIndex <= 0) {
            return result;
        }
        return new DirectAccessTokenizer(result, JURISDICTION_SEPARATOR).getSubstring(cityIndex);
    }

    public String getGeoValue() {
        PropertyLatitude latitude = this.getLatitude(false);
        PropertyLongitude longitude = this.getLongitude(false);
        String gedcomPlace = this.getDisplayValue() + JURISDICTION_SEPARATOR + (latitude != null ? ((Property)latitude).getValue() : "") + JURISDICTION_SEPARATOR + (longitude != null ? ((Property)longitude).getValue() : "");
        return gedcomPlace;
    }

    public String getNumericalJurisdictions() {
        String str = "";
        String[] juris = PropertyPlace.toJurisdictions(this.getValue());
        for (int i = 0; i < juris.length; ++i) {
            String juri = juris[i];
            if (!juri.matches("-?\\d+(\\.\\d+)?")) continue;
            str = str + juri + JURISDICTION_SEPARATOR;
        }
        return str;
    }

    public int getCityIndex() {
        if (this.getFormatAsString().length() == 0) {
            return -1;
        }
        Set<String> cityKeys = GedcomOptions.getInstance().getPlaceHierarchyCityKeys();
        String[] format = this.getFormat();
        for (int i = 0; i < format.length; ++i) {
            if (!cityKeys.contains(format[i].toLowerCase())) continue;
            return i;
        }
        return -1;
    }

    public PropertyMap getMap() {
        if (this.isVersion55()) {
            return (PropertyMap)this.getProperty("_MAP");
        }
        return (PropertyMap)this.getProperty("MAP");
    }

    public PropertyLatitude getLatitude(boolean strict) {
        PropertyMap map = this.getMap();
        if (map == null) {
            return null;
        }
        PropertyLatitude lat = map.getLatitude();
        if (lat == null) {
            return null;
        }
        if (strict && map.getLongitude() == null) {
            return null;
        }
        return lat;
    }

    public PropertyLongitude getLongitude(boolean strict) {
        PropertyMap map = this.getMap();
        if (map == null) {
            return null;
        }
        PropertyLongitude longitude = map.getLongitude();
        if (longitude == null) {
            return null;
        }
        if (strict && map.getLatitude() == null) {
            return null;
        }
        return longitude;
    }

    public void setCoordinates(String latitude, String longitude) {
        PropertyLatitude lat;
        PropertyMap map = this.getMap();
        boolean is55 = this.isVersion55();
        if (map == null) {
            map = new PropertyMap(is55);
            this.addProperty(map);
        }
        if ((lat = map.getLatitude()) == null) {
            lat = new PropertyLatitude(is55);
            map.addProperty(lat);
        }
        lat.setValue(latitude);
        PropertyLongitude lon = map.getLongitude();
        if (lon == null) {
            lon = new PropertyLongitude(is55);
            map.addProperty(lon);
        }
        lon.setValue(longitude);
    }

    @Override
    public String format(String format) {
        Gedcom localGedcom = this.getGedcom();
        if (format == null) {
            String string = format = localGedcom == null ? null : localGedcom.getPlaceDisplayFormat();
        }
        if (format == null) {
            return this.getFirstAvailableJurisdiction();
        }
        String f = format.trim();
        if (f.equals("")) {
            return this.getFirstAvailableJurisdiction();
        }
        if (f.equals("all")) {
            return this.getDisplayValue();
        }
        StringBuilder result = new StringBuilder();
        String[] jurisdictions = this.getJurisdictions();
        for (int i = 0; i < f.length(); ++i) {
            char c = f.charAt(i);
            if (Character.isDigit(c)) {
                int j = Character.digit(c, 10);
                if (j >= jurisdictions.length) continue;
                result.append(jurisdictions[j].trim());
                continue;
            }
            result.append(c);
        }
        return result.toString();
    }

    @Override
    public PropertyComparator2 getComparator() {
        return PLACComparator.getInstance();
    }

    private static class PLACComparator
    extends PropertyComparator2.Default<PropertyPlace> {
        private static final PLACComparator INSTANCE = new PLACComparator();

        private PLACComparator() {
        }

        public static PropertyComparator2 getInstance() {
            return INSTANCE;
        }

        @Override
        public int compare(PropertyPlace p1, PropertyPlace p2) {
            int r = this.compareNull(p1, p2);
            if (r != Integer.MAX_VALUE) {
                return r;
            }
            Collator c = p1.getGedcom().getCollator();
            String sortFormat = p1.getGedcom().getPlaceSortOrder();
            if (sortFormat == null) {
                return c.compare(p1.getValueStartingWithCity(), p2.getValueStartingWithCity());
            }
            return c.compare(p1.format(sortFormat), p2.format(sortFormat));
        }

        @Override
        public String getSortGroup(PropertyPlace p) {
            String sortFormat = p.getGedcom().getPlaceSortOrder();
            String value = sortFormat == null ? p.getValueStartingWithCity() : p.format(sortFormat);
            return this.shortcut(value, 1);
        }
    }
}

