/*
 * Decompiled with CFR 0.152.
 */
package genj.gedcom;

import genj.gedcom.Entity;
import genj.gedcom.Fam;
import genj.gedcom.Gedcom;
import genj.gedcom.Grammar;
import genj.gedcom.Indi;
import genj.gedcom.Property;
import genj.gedcom.PropertyDate;
import genj.gedcom.TagPath;
import genj.gedcom.time.Delta;
import genj.gedcom.time.PointInTime;
import java.text.Collator;
import javax.swing.ImageIcon;

public class PropertyAge
extends Property {
    public static final ImageIcon IMG = Grammar.V55.getMeta(new TagPath("INDI:BIRT:AGE")).getImage();
    private Delta age = new Delta(0, 0, 0);
    private int younger_exactly_older = 0;
    private String ageAsString;
    public static String[] PHRASES = new String[]{"CHILD", "INFANT", "STILLBORN"};

    public PropertyAge(String tag) {
        super(tag);
    }

    @Override
    public boolean isValid() {
        Collator c = this.getGedcom().getCollator();
        if (this.ageAsString == null) {
            return true;
        }
        for (int i = 0; i < PHRASES.length; ++i) {
            if (c.compare(PHRASES[i], this.ageAsString) != 0) continue;
            return true;
        }
        return false;
    }

    @Override
    void afterAddNotify() {
        super.afterAddNotify();
        this.updateAge();
    }

    public static String getLabelForAge() {
        return Gedcom.getName("AGE");
    }

    @Override
    public String getValue() {
        if (this.ageAsString != null) {
            return this.ageAsString;
        }
        if (this.younger_exactly_older > 0) {
            return ">" + this.age.getValue();
        }
        if (this.younger_exactly_older < 0) {
            return "<" + this.age.getValue();
        }
        return this.age.getValue();
    }

    @Override
    public String getDisplayValue() {
        if (this.ageAsString != null) {
            String result = resources.getString("prop.age." + this.ageAsString);
            if (result != null) {
                return result;
            }
            return this.ageAsString;
        }
        if (this.younger_exactly_older > 0) {
            return ">" + this.age.toString();
        }
        if (this.younger_exactly_older < 0) {
            return "<" + this.age.toString();
        }
        return this.age.toString();
    }

    @Override
    public void setValue(String newValue) {
        String old = this.getValue();
        if (newValue.startsWith(">")) {
            newValue = newValue.substring(1);
            this.younger_exactly_older = 1;
        } else if (newValue.startsWith("<")) {
            newValue = newValue.substring(1);
            this.younger_exactly_older = -1;
        }
        this.ageAsString = this.age.setValue(newValue) ? null : newValue;
        this.propagatePropertyChanged(this, old);
    }

    public void setValue(Delta age) {
        String old = this.getValue();
        this.age.setValue(age);
        this.propagatePropertyChanged(this, old);
    }

    public boolean updateAge() {
        return this.updateAge(Delta.get(this.getEarlier(), this.getLater()));
    }

    public boolean updateAge(Delta delta) {
        String old = this.getValue();
        if (delta == null) {
            return false;
        }
        this.age = delta;
        this.younger_exactly_older = 0;
        this.ageAsString = null;
        this.propagatePropertyChanged(this, old);
        return true;
    }

    @Override
    public int compareTo(Property other) {
        if (!this.isValid() || !other.isValid()) {
            return super.compareTo(other);
        }
        return this.age.compareTo(((PropertyAge)other).age);
    }

    public PointInTime getEarlier() {
        return this.getEarlier(this.getEntity(), this.getParent());
    }

    public PointInTime getEarlier(Entity e, Property parent) {
        if (e instanceof Fam) {
            if (parent.getTag().equals("HUSB")) {
                e = ((Fam)e).getHusband();
            }
            if (parent.getTag().equals("WIFE")) {
                e = ((Fam)e).getWife();
            }
        }
        if (!(e instanceof Indi)) {
            return null;
        }
        PropertyDate birth = ((Indi)e).getBirthDate();
        return birth != null ? birth.getStart() : null;
    }

    public PointInTime getLater() {
        return this.getLater(this.getParent());
    }

    public PointInTime getLater(Property parent) {
        Property prop;
        if (parent.getTag().equals("HUSB") || parent.getTag().equals("WIFE")) {
            parent = parent.getParent();
        }
        if ((prop = parent.getProperty("DATE", true)) == null) {
            return null;
        }
        if (!(prop instanceof PropertyDate)) {
            return null;
        }
        PropertyDate date = (PropertyDate)prop;
        return date != null ? date.getStart() : null;
    }
}

