/*
 * Decompiled with CFR 0.152.
 */
package genj.gedcom;

import genj.gedcom.Entity;
import genj.gedcom.Gedcom;
import genj.gedcom.GedcomException;
import genj.gedcom.Property;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class Context {
    private Gedcom gedcom;
    private List<Entity> entities = new ArrayList<Entity>();
    private List<Property> properties = new ArrayList<Property>();

    public boolean equals(Object obj) {
        if (!(obj instanceof Context)) {
            return false;
        }
        Context that = (Context)obj;
        return this.gedcom == that.gedcom && this.entities.equals(that.entities) && this.properties.equals(that.properties);
    }

    public boolean sameGedcom(Context that) {
        if (that == null) {
            return false;
        }
        if (this.gedcom == null) {
            return false;
        }
        return this.gedcom.equals(that.gedcom);
    }

    public Context() {
    }

    public Context(Context context) {
        this.gedcom = context.gedcom;
        this.entities.addAll(context.entities);
        this.properties.addAll(context.properties);
    }

    public Context(Gedcom gedcom, Collection<? extends Entity> entities) {
        this(gedcom, entities, null);
    }

    public Context(Gedcom gedcom, Collection<? extends Entity> entities, Collection<? extends Property> properties) {
        this.gedcom = gedcom;
        if (entities != null) {
            for (Entity entity : entities) {
                if (entity.getGedcom() != gedcom) {
                    throw new IllegalArgumentException("gedcom must be same");
                }
                if (this.entities.contains(entity)) continue;
                this.entities.add(entity);
            }
        }
        if (properties != null) {
            for (Property property : properties) {
                if (property instanceof Entity) {
                    if (this.entities.contains(property)) continue;
                    this.entities.add((Entity)property);
                    continue;
                }
                if (this.properties.contains(property)) continue;
                Entity e = property.getEntity();
                if (e.getGedcom() != gedcom) {
                    throw new IllegalArgumentException("gedcom must be same");
                }
                this.properties.add(property);
                if (this.entities.contains(e)) continue;
                this.entities.add(e);
            }
        }
    }

    public Context(Gedcom ged) {
        this.gedcom = ged;
    }

    public Context(Property prop) {
        this(prop.getGedcom());
        Entity entity;
        if (!(prop instanceof Entity)) {
            this.properties.add(prop);
            entity = prop.getEntity();
        } else {
            entity = (Entity)prop;
        }
        if (!this.entities.contains(entity)) {
            this.entities.add(entity);
        }
    }

    public Context(Entity entity) {
        this(entity.getGedcom());
        this.entities.add(entity);
    }

    public Context remove(Entity entity) {
        ArrayList<Entity> ents = new ArrayList<Entity>(this.entities);
        ents.remove(entity);
        ArrayList<Property> props = new ArrayList<Property>(this.properties.size());
        for (Property prop : this.properties) {
            Entity ent = prop.getEntity();
            if (ent == entity || ent == null) continue;
            props.add(prop);
        }
        return new Context(this.gedcom, ents, props);
    }

    public Context remove(Property property) {
        if (property instanceof Entity) {
            return this.remove((Entity)property);
        }
        ArrayList<Entity> ents = new ArrayList<Entity>(this.entities);
        ArrayList<Property> props = new ArrayList<Property>(this.properties);
        props.remove(property);
        return new Context(this.gedcom, ents, props);
    }

    public Gedcom getGedcom() {
        return this.gedcom;
    }

    public Entity getEntity() {
        return this.entities.isEmpty() ? null : this.entities.get(0);
    }

    public Property getProperty() {
        return this.properties.isEmpty() ? null : this.properties.get(0);
    }

    public List<? extends Entity> getEntities() {
        return this.entities;
    }

    public List<? extends Property> getProperties() {
        return this.properties;
    }

    public String toString() {
        if (this.gedcom == null) {
            return "";
        }
        StringBuffer result = new StringBuffer();
        result.append(this.gedcom.getName());
        for (Entity entity : this.entities) {
            result.append("|");
            result.append(entity.getId());
            for (Property prop : this.properties) {
                if (prop.getEntity() != entity) continue;
                result.append(",");
                result.append(prop.getPath());
            }
        }
        return result.toString();
    }

    public static Context fromString(Gedcom gedcom, String toString) throws GedcomException {
        ArrayList<Entity> entities = new ArrayList<Entity>();
        ArrayList<Property> properties = new ArrayList<Property>();
        String[] es = toString.split("\\|");
        if (!es[0].equals(gedcom.getName())) {
            throw new GedcomException(es[0] + " doesn't match " + gedcom.getName());
        }
        for (int e = 1; e < es.length; ++e) {
            String[] ps = es[e].split(",");
            Entity entity = gedcom.getEntity(ps[0]);
            if (entity == null) {
                throw new GedcomException(ps[0] + " not in " + gedcom);
            }
            entities.add(entity);
            for (int p = 1; p < ps.length; ++p) {
                try {
                    Property property = entity.getPropertyByPath(ps[p]);
                    if (property == null) {
                        throw new GedcomException(ps[p] + " not in " + ps[0] + " in " + gedcom);
                    }
                    properties.add(property);
                    continue;
                }
                catch (IllegalArgumentException iae) {
                    throw new GedcomException(ps[p] + " not valid for " + es[e]);
                }
            }
        }
        return new Context(gedcom, entities, properties);
    }
}

