/*
 * Decompiled with CFR 0.152.
 */
package ancestris.util;

import genj.gedcom.Entity;
import genj.gedcom.Gedcom;
import genj.gedcom.Property;
import genj.gedcom.TagPath;
import java.awt.Image;
import java.io.StringReader;
import java.util.Collection;
import java.util.Locale;
import javax.swing.text.Document;
import javax.swing.text.EditorKit;
import javax.swing.text.html.HTMLEditorKit;
import org.openide.util.Lookup;

public class Utilities {
    private static int margin = 10;
    private static String bit = "...";

    private Utilities() {
    }

    public static String getClassName(Object o) {
        return Utilities.getClassName(o.getClass());
    }

    public static String getClassName(Class c) {
        return c.getName().replace('.', '/');
    }

    public static boolean wordsMatch(String text, String pattern) {
        pattern = pattern.replaceAll(" +", ".+");
        return text.matches(".*" + pattern + ".*");
    }

    public static Locale getLocaleFromString(String str) {
        if (str == null || str.length() == 0) {
            return null;
        }
        str.replaceAll(":", "_");
        String[] locale = (str + "__").split("_", 3);
        return new Locale(locale[0], locale[1], locale[2]);
    }

    public static String ctxPropertiesDisplayName() {
        Collection properties = org.openide.util.Utilities.actionsGlobalContext().lookupAll(Property.class);
        String result = "";
        if (properties != null) {
            result = "'" + Property.getPropertyNames(properties, 5) + "' (" + properties.size() + ")";
        }
        return result;
    }

    public static String ctxPropertyDisplayName() {
        Property prop = (Property)org.openide.util.Utilities.actionsGlobalContext().lookup(Property.class);
        String result = "";
        if (prop != null) {
            result = Property.LABEL + " '" + TagPath.get(prop).getName() + '\'';
        }
        return result;
    }

    public static String ctxEntityDisplayName() {
        Entity entity = (Entity)org.openide.util.Utilities.actionsGlobalContext().lookup(Entity.class);
        String result = "";
        if (entity != null) {
            result = Gedcom.getName(entity.getTag(), false) + " '" + entity.getId() + '\'';
        }
        return result;
    }

    public static String ctxGedcomDisplayName() {
        Property prop;
        Gedcom gedcom = (Gedcom)org.openide.util.Utilities.actionsGlobalContext().lookup(Gedcom.class);
        if (gedcom == null && (prop = (Property)org.openide.util.Utilities.actionsGlobalContext().lookup(Property.class)) != null) {
            gedcom = prop.getGedcom();
        }
        String result = "";
        if (gedcom != null) {
            result = "Gedcom '" + gedcom.getName() + '\'';
        }
        return result;
    }

    public static Image getDN() {
        Property prop = (Property)org.openide.util.Utilities.actionsGlobalContext().lookup(Property.class);
        if (prop != null) {
            return prop.getImage(false).getImage();
        }
        return null;
    }

    public static Gedcom getGedcomFromContext(Lookup lookup) {
        Property prop;
        Gedcom gedcom = (Gedcom)lookup.lookup(Gedcom.class);
        if (gedcom == null && (prop = (Property)lookup.lookup(Property.class)) != null) {
            gedcom = prop.getGedcom();
        }
        return gedcom;
    }

    public static String html2text(String html) {
        HTMLEditorKit kit = new HTMLEditorKit();
        Document doc = ((EditorKit)kit).createDefaultDocument();
        doc.putProperty("IgnoreCharsetDirective", Boolean.TRUE);
        try {
            StringReader reader = new StringReader(html);
            ((EditorKit)kit).read(reader, doc, 0);
            return doc.getText(0, doc.getLength());
        }
        catch (Exception e) {
            return "";
        }
    }

    public static String getPhraseBit(String text, String find) {
        int i;
        String q;
        String str = (text = text.replaceAll("(?:\\n|\\r)", " ")).toLowerCase();
        int index = str.indexOf(q = find.toLowerCase());
        if (index == -1) {
            return null;
        }
        int start = Math.max(index - margin, 0);
        int end = Math.min(text.length(), index + q.length() + margin);
        for (i = start; i >= 0; --i) {
            if (str.charAt(i) != ' ') continue;
            start = i + 1;
            break;
        }
        for (i = end; i < text.length(); ++i) {
            if (str.charAt(i) != ' ') continue;
            end = i;
            break;
        }
        return bit + text.substring(start, end) + bit;
    }
}

