/*
 * Decompiled with CFR 0.152.
 */
package ancestris.swing.atable;

import ancestris.core.actions.AbstractAncestrisAction;
import ancestris.swing.atable.ATableFilterWidget;
import ancestris.swing.atable.ATableHeaderRenderer;
import ancestris.swing.atable.ATableRowSorter;
import genj.gedcom.Property;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.text.Collator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.RowSorter;
import javax.swing.SortOrder;
import javax.swing.event.RowSorterEvent;
import javax.swing.event.RowSorterListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;

public class ATable
extends JTable {
    private Collator cachedCollator = null;
    private Map<TableModel, ATableRowSorter<TableModel>> sorters;
    private ATableRowSorter<TableModel> currentSorter;
    private ATableFilterWidget filterText;
    private JPanel shortcuts;

    public ATable() {
        this.getTableHeader().setReorderingAllowed(false);
        this.getTableHeader().setDefaultRenderer(new ATableHeaderRenderer(this.getTableHeader().getDefaultRenderer()));
        this.getTableHeader().addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent aEvent) {
                if (ATable.this.currentSorter != null) {
                    int columnIdx = ATable.this.getColumnModel().getColumnIndexAtX(aEvent.getX());
                    if (!aEvent.isControlDown()) {
                        ATable.this.currentSorter.toggleSortOrder(columnIdx, true);
                    } else {
                        ATable.this.currentSorter.toggleSortOrder(columnIdx, false);
                    }
                }
            }
        });
    }

    @Override
    public void setModel(TableModel tableModel) {
        super.setModel(tableModel);
        if (tableModel instanceof DefaultTableModel) {
            return;
        }
        if (this.sorters == null) {
            this.sorters = new HashMap<TableModel, ATableRowSorter<TableModel>>();
        }
        this.currentSorter = this.sorters.get(tableModel);
        if (this.currentSorter == null) {
            this.currentSorter = new ATableRowSorter<TableModel>(tableModel);
            this.currentSorter.addRowSorterListener(new RowSorterListener(){

                @Override
                public void sorterChanged(RowSorterEvent e) {
                    ATable.this.createShortcuts();
                }
            });
            this.sorters.put(tableModel, this.currentSorter);
            tableModel.addTableModelListener(new TableModelListener(){

                @Override
                public void tableChanged(TableModelEvent e) {
                    if (e.getLastRow() == Integer.MAX_VALUE) {
                        ATable.this.createShortcuts();
                    }
                }
            });
        }
        this.setRowSorter(this.currentSorter);
        if (this.filterText != null) {
            this.filterText.setSorter(this.currentSorter);
        }
    }

    public void setFilterWidget(ATableFilterWidget filter) {
        this.filterText = filter;
        if (this.filterText != null) {
            this.filterText.setSorter(this.currentSorter);
        }
    }

    public void setShortCut(JPanel panelShortcuts) {
        this.shortcuts = panelShortcuts;
        this.shortcuts.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                ATable.this.createShortcuts();
            }
        });
    }

    public void tsvExport(File file) throws IOException {
        TableModel model = this.getModel();
        FileWriter writer = new FileWriter(file);
        for (int i = 0; i < model.getColumnCount(); ++i) {
            writer.write(model.getColumnName(i) + "\t");
        }
        writer.write("\n");
        for (int r = 0; r < this.currentSorter.getViewRowCount(); ++r) {
            for (int col = 0; col < model.getColumnCount(); ++col) {
                writer.write(this.exportCellValue(model.getValueAt(this.convertRowIndexToModel(r), col), r, col));
                writer.write("\t");
            }
            writer.write("\n");
        }
        writer.close();
    }

    public String exportCellValue(Object object, int row, int col) {
        if (object == null) {
            return "";
        }
        return object.toString();
    }

    AbstractAncestrisAction createShortcut(String txt, final int y) {
        return new AbstractAncestrisAction(txt.toUpperCase()){

            @Override
            public void actionPerformed(ActionEvent event) {
                int x = 0;
                try {
                    x = ((JViewport)ATable.this.getParent()).getViewPosition().x;
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                ATable.this.scrollRectToVisible(new Rectangle(x, y, 1, ATable.this.getParent().getHeight()));
            }
        };
    }

    private Collator getCollator() {
        if (this.cachedCollator == null) {
            this.cachedCollator = Collator.getInstance(this.getLocale());
            this.cachedCollator.setStrength(0);
        }
        return this.cachedCollator;
    }

    void createShortcuts(int col, SortOrder dir, JComponent container) {
        TableModel model = this.getModel();
        Collator collator = this.getCollator();
        ArrayList<AbstractAncestrisAction> actions = new ArrayList<AbstractAncestrisAction>(3);
        String cursor = "";
        for (int r = 0; r < this.currentSorter.getViewRowCount(); ++r) {
            String value;
            int vr = dir == SortOrder.ASCENDING ? r : this.currentSorter.getViewRowCount() - r - 1;
            Property prop = (Property)model.getValueAt(this.convertRowIndexToModel(vr), col);
            if (prop == null || (value = prop.getComparator().getSortGroup(prop)).length() == 0 || collator.compare(cursor, value) >= 0) continue;
            cursor = value;
            AbstractAncestrisAction action = this.createShortcut(value, this.getCellRect((int)vr, (int)col, (boolean)true).y);
            actions.add(action);
            InputMap imap = container.getInputMap(2);
            ActionMap amap = container.getActionMap();
            imap.put(KeyStroke.getKeyStroke(value.charAt(0)), action);
            amap.put(action, action);
        }
        if (actions.isEmpty()) {
            return;
        }
        int w = LinkWidget.sampleDimension((int)((AbstractAncestrisAction)actions.get((int)(actions.size() / 2))).getText().length()).width;
        int n = Math.min(actions.size(), container.getSize().width / w - 1);
        for (int i = 0; i < n; ++i) {
            LinkWidget link = new LinkWidget((Action)actions.get(i * actions.size() / n));
            container.add(link);
        }
        if (n < actions.size()) {
            LinkWidget link = new LinkWidget((Action)actions.get(actions.size() - 1));
            container.add(link);
        }
    }

    public void createShortcuts() {
        if (this.shortcuts == null) {
            return;
        }
        this.shortcuts.removeAll();
        this.shortcuts.getInputMap(2).clear();
        this.shortcuts.getActionMap().clear();
        this.shortcuts.revalidate();
        this.shortcuts.repaint();
        if (this.currentSorter != null && !this.currentSorter.getSortKeys().isEmpty()) {
            RowSorter.SortKey prim = this.currentSorter.getSortKeys().get(0);
            if (prim.getSortOrder() == SortOrder.UNSORTED) {
                return;
            }
            this.createShortcuts(prim.getColumn(), prim.getSortOrder(), this.shortcuts);
        }
    }

    public ATableRowSorter<TableModel> getSorter() {
        return this.currentSorter;
    }

    private static class LinkWidget
    extends JButton {
        private static Map<String, Dimension> sd = new HashMap<String, Dimension>(3);

        public LinkWidget(String text, Icon icon) {
            super(text, icon);
            this.init();
        }

        public LinkWidget(String text) {
            this(text, null);
        }

        public LinkWidget(Action a) {
            super(a);
            this.init();
        }

        private void init() {
            this.setBorderPainted(false);
            this.setAlignmentX(1.0f);
        }

        public static Dimension sampleDimension() {
            return LinkWidget.sampleDimension("W");
        }

        public static Dimension sampleDimension(int size) {
            StringBuilder outputBuffer = new StringBuilder(size);
            outputBuffer.append("W");
            for (int i = 1; i < size; ++i) {
                outputBuffer.append("0");
            }
            return LinkWidget.sampleDimension(outputBuffer.toString());
        }

        public static Dimension sampleDimension(String label) {
            if (!sd.containsKey(label)) {
                JButton sample = new JButton(label);
                sample.setBorderPainted(false);
                sd.put(label, sample.getPreferredSize());
            }
            return sd.get(label);
        }
    }
}

