/*
 * Decompiled with CFR 0.152.
 */
package ancestris.gedcom;

import ancestris.core.pluginservice.AncestrisPlugin;
import ancestris.core.pluginservice.PluginInterface;
import ancestris.gedcom.Bundle;
import ancestris.gedcom.GedcomDataObject;
import ancestris.gedcom.GedcomMgr;
import ancestris.gedcom.SaveOptionsWidget;
import ancestris.util.TimingUtility;
import ancestris.util.swing.DialogManager;
import ancestris.util.swing.FileChooserBuilder;
import ancestris.view.AncestrisViewInterface;
import ancestris.view.SelectionDispatcher;
import genj.gedcom.Context;
import genj.gedcom.Gedcom;
import genj.gedcom.GedcomException;
import genj.gedcom.GedcomOptions;
import genj.gedcom.Indi;
import genj.gedcom.Submitter;
import genj.io.Filter;
import genj.util.EnvironmentChecker;
import genj.util.Origin;
import genj.util.Registry;
import genj.util.Resources;
import java.beans.PropertyVetoException;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComponent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.Utilities;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

public abstract class GedcomDirectory {
    static final Logger LOG = Logger.getLogger("ancestris.app");
    static final Resources RES = Resources.get(GedcomDirectory.class);
    static final Registry REGISTRY = Registry.get(GedcomDirectory.class);
    protected List<GedcomRegistryListener> listeners = new ArrayList<GedcomRegistryListener>();
    private static GedcomDirectory defaultInstance;

    public abstract List<Context> getContexts();

    public abstract Context getContext(FileObject var1);

    public abstract GedcomDataObject getDataObject(Context var1) throws ContextNotFoundException;

    protected abstract boolean registerGedcomImpl(GedcomDataObject var1);

    protected abstract boolean unregisterGedcomImpl(Context var1);

    public Context newGedcom() {
        return this.newGedcom(null, null, null, true);
    }

    public Context newGedcom(Gedcom gedcomProvided, String title, String defaultFilename, boolean setDefaults) {
        File file = null;
        boolean fileOK = false;
        while (!fileOK) {
            file = this.chooseFile(title == null ? Bundle.create_title() : title, Bundle.create_action(), null, defaultFilename, true);
            if (file == null) {
                return null;
            }
            if (!file.getName().endsWith(".ged")) {
                file = new File(file.getAbsolutePath() + ".ged");
            }
            if (file.exists()) {
                if (DialogManager.YES_OPTION != DialogManager.createYesNo(title == null ? Bundle.create_title() : title, Bundle.file_exists(file.getName())).setMessageType(2).show()) continue;
                fileOK = true;
                continue;
            }
            fileOK = true;
        }
        Gedcom gedcom = gedcomProvided;
        try {
            if (gedcomProvided == null) {
                gedcom = new Gedcom(Origin.create(file.toURI().toURL()));
            } else {
                gedcom.setOrigin(Origin.create(file.toURI().toURL()));
            }
        }
        catch (MalformedURLException e) {
            LOG.log(Level.WARNING, "unexpected exception creating new gedcom", e);
            return null;
        }
        Context context = GedcomMgr.getDefault().setGedcom(gedcom);
        try {
            Indi firstIndi;
            if (setDefaults) {
                this.setDefault(gedcom);
            }
            if ((firstIndi = (Indi)context.getGedcom().getFirstEntity("INDI")) == null) {
                firstIndi = (Indi)context.getGedcom().createEntity("INDI");
                firstIndi.addDefaultProperties();
            }
            GedcomMgr.getDefault().saveGedcom(new Context(firstIndi), FileUtil.toFileObject((File)file));
            GedcomMgr.getDefault().gedcomClose(context);
            return this.openGedcom(FileUtil.toFileObject((File)file));
        }
        catch (Exception e) {
            Exceptions.printStackTrace((Throwable)e);
            return context;
        }
    }

    private void setDefault(Gedcom gedcom) {
        try {
            Registry submPref = Registry.get(GedcomOptions.class);
            Submitter submitter = (Submitter)gedcom.createEntity("SUBM");
            submitter.setName(submPref.get("submName", ""));
            submitter.setCity(submPref.get("submCity", ""));
            submitter.setPhone(submPref.get("submPhone", ""));
            submitter.setEmail(submPref.get("submEmail", ""));
            submitter.setCountry(submPref.get("submCountry", ""));
            submitter.setWeb(submPref.get("submWeb", ""));
            gedcom.createEntity("HEAD", "");
            gedcom.setPlaceFormat(GedcomOptions.getInstance().getPlaceFormat());
            gedcom.setShowJuridictions(GedcomOptions.getInstance().getShowJuridictions());
            gedcom.setPlaceSortOrder(GedcomOptions.getInstance().getPlaceSortOrder());
            gedcom.setPlaceDisplayFormat(GedcomOptions.getInstance().getPlaceDisplayFormat());
        }
        catch (GedcomException e) {
            Exceptions.printStackTrace((Throwable)e);
        }
    }

    public Context openGedcom() {
        File file = this.chooseFile(RES.getString("cc.open.title"), RES.getString("cc.open.action"), null, false);
        if (file == null) {
            return null;
        }
        REGISTRY.put("last.dir", file.getParentFile().getAbsolutePath());
        return this.openGedcom(FileUtil.toFileObject((File)file));
    }

    @Deprecated
    public Context openGedcom(File input) {
        if (input == null) {
            return null;
        }
        return this.openGedcom(FileUtil.toFileObject((File)input));
    }

    public Context openGedcom(FileObject input) {
        Context context = this.getContext(input);
        if (context != null) {
            return context;
        }
        try {
            DataObject dao = DataObject.find((FileObject)input);
            GedcomDataObject gdao = (GedcomDataObject)dao.getLookup().lookup(GedcomDataObject.class);
            if (gdao == null) {
                return null;
            }
            if (gdao.isCancelled()) {
                gdao.setCancelled(false);
                return null;
            }
            if (gdao.getContext() == null && !gdao.load()) {
                return null;
            }
            this.registerGedcom(gdao);
            context = gdao.getContext();
            GedcomDirectory.openDefaultViews(context);
            SelectionDispatcher.fireSelection(context);
            WindowManager.getDefault().invokeWhenUIReady(new Runnable(){

                @Override
                public void run() {
                    System.gc();
                }
            });
            return gdao.getContext();
        }
        catch (Exception e) {
            LOG.info(e.toString());
            return context;
        }
    }

    public boolean saveGedcom(Context context) {
        if (context == null || context.getGedcom() == null) {
            return false;
        }
        if (!(context == null || context.getGedcom().getOrigin() != null && context.getGedcom().getOrigin().getFile().exists())) {
            return this.saveAsGedcom(context);
        }
        try {
            return GedcomMgr.getDefault().saveGedcom(context, this.getDataObject(context).getPrimaryFile());
        }
        catch (ContextNotFoundException ex) {
            return false;
        }
    }

    public boolean saveAsGedcom(Context context) {
        Origin o;
        if (context == null || context.getGedcom() == null) {
            return false;
        }
        GedcomMgr.getDefault().commitRequested(context);
        ArrayList<Filter> theFilters = new ArrayList<Filter>(5);
        for (Filter f : AncestrisPlugin.lookupAll(Filter.class)) {
            if (!f.canApplyTo(context.getGedcom())) continue;
            theFilters.add(f);
        }
        for (Filter f : Lookup.getDefault().lookupAll(Filter.class)) {
            if (!f.canApplyTo(context.getGedcom())) continue;
            theFilters.add(f);
        }
        SaveOptionsWidget options = new SaveOptionsWidget(context.getGedcom(), theFilters.toArray(new Filter[0]));
        File file = this.chooseFile(RES.getString("cc.save.title", context.getGedcom().toString()), RES.getString("cc.save.action"), options, context.getGedcom().toString(), true);
        if (file == null) {
            return false;
        }
        if (!file.getName().endsWith(".ged")) {
            file = new File(file.getAbsolutePath() + ".ged");
        }
        if (file.exists()) {
            if (DialogManager.YES_OPTION != DialogManager.createYesNo(RES.getString("cc.save.title", context.getGedcom().toString()), Bundle.file_exists(file.getName())).setMessageType(2).show()) {
                return false;
            }
        } else {
            try {
                file.createNewFile();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if ((o = GedcomMgr.getDefault().saveGedcomAs(context, options, FileUtil.toFileObject((File)file))) == null) {
            return false;
        }
        if (context != null) {
            this.closeGedcom(context);
            this.openGedcom(FileUtil.toFileObject((File)o.getFile()));
        }
        return true;
    }

    public boolean closeGedcom(Context context) {
        if (context == null || context.getGedcom() == null) {
            return true;
        }
        try {
            this.getDataObject(context);
            GedcomMgr.getDefault().commitRequested(context);
            if (context.getGedcom().hasChanged() || !context.getGedcom().getOrigin().getFile().exists()) {
                Object rc = DialogManager.create(null, RES.getString("cc.savechanges?", context.getGedcom().getName())).setMessageType(2).setOptionType(1).show();
                if (rc == DialogManager.CANCEL_OPTION || rc == DialogManager.CLOSED_OPTION) {
                    return false;
                }
                if (rc == DialogManager.YES_OPTION && !this.saveGedcom(context)) {
                    return false;
                }
            }
            this.unregisterGedcom(context);
            GedcomMgr.getDefault().gedcomClose(context);
            return true;
        }
        catch (ContextNotFoundException contextNotFoundException) {
            return true;
        }
    }

    public void registerGedcom(GedcomDataObject gedcomObject) {
        if (gedcomObject == null) {
            return;
        }
        if (!this.registerGedcomImpl(gedcomObject)) {
            return;
        }
        ArrayList<GedcomRegistryListener> ls = new ArrayList<GedcomRegistryListener>(this.listeners);
        for (GedcomRegistryListener listener : ls) {
            listener.gedcomRegistered(gedcomObject.getContext());
        }
    }

    public void unregisterGedcom(Context context) {
        if (context == null) {
            return;
        }
        if (!this.unregisterGedcomImpl(context)) {
            return;
        }
        ArrayList<GedcomRegistryListener> ls = new ArrayList<GedcomRegistryListener>(this.listeners);
        for (GedcomRegistryListener listener : ls) {
            listener.gedcomUnregistered(context);
        }
    }

    @Deprecated
    public Context getSelectedContext(boolean firstIfNoneSelected) {
        Context c = (Context)Utilities.actionsGlobalContext().lookup(Context.class);
        return c;
    }

    @Deprecated
    public Context getLastContext() {
        throw new UnsupportedOperationException("GedcomDirectory does not provide last context anymore. use private cache or lookup");
    }

    public File chooseFile(String title, String action, JComponent accessory, boolean create) {
        return this.chooseFile(title, action, accessory, null, create);
    }

    public File chooseFile(String title, String action, JComponent accessory, String defaultFilename, boolean create) {
        FileChooserBuilder fbc = new FileChooserBuilder(GedcomDirectory.class).setDirectoriesOnly(false).setDefaultBadgeProvider().setAccessory(accessory).setTitle(title).setApproveText(action).setDefaultExtension(FileChooserBuilder.getGedcomFilter().getExtensions()[0]).setFileFilter(FileChooserBuilder.getGedcomFilter()).setAcceptAllFileFilterUsed(false).setDefaultWorkingDirectory(new File(EnvironmentChecker.getProperty(new String[]{"ancestris.gedcom.dir", "user.home"}, ".", "choose gedcom file")));
        if (defaultFilename != null) {
            fbc = fbc.setSelectedFile(new File(defaultFilename));
        }
        File file = create ? fbc.showSaveDialog(false) : fbc.showOpenDialog();
        return file;
    }

    public static void openDefaultViews(Context context) {
        Registry prefs = Registry.get(AncestrisViewInterface.class);
        ArrayList openedViews = new ArrayList();
        Registry gedcomSettings = context.getGedcom().getRegistry();
        String[] ovs = gedcomSettings.get("openViews", (String[])null);
        openedViews.addAll(AncestrisPlugin.lookupForName(AncestrisViewInterface.class, (String[])ovs));
        if (openedViews.isEmpty()) {
            openedViews.addAll(AncestrisPlugin.lookupForName(AncestrisViewInterface.class, (String[])prefs.get("openViews", (String[])null)));
        }
        if (openedViews.isEmpty()) {
            for (PluginInterface sInterface : Lookup.getDefault().lookupAll(PluginInterface.class)) {
                openedViews.addAll(sInterface.getDefaultOpenedViews());
            }
        }
        TopComponent tc = null;
        HashMap<String, TopComponent> name2tc = new HashMap<String, TopComponent>();
        for (Class clazz : openedViews) {
            LOG.log(Level.FINE, "{0}: {1} opened", new Object[]{TimingUtility.getInstance().getTime(), clazz.getCanonicalName()});
            try {
                tc = (TopComponent)clazz.newInstance();
                if (tc instanceof AncestrisViewInterface) {
                    tc = ((AncestrisViewInterface)tc).create(context);
                }
                tc.open();
                name2tc.put(clazz.getCanonicalName(), tc);
            }
            catch (Exception ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            if (tc == null) continue;
            tc.requestActive();
        }
        for (String name : gedcomSettings.get("focusViews", new String[0])) {
            TopComponent tcToFocus = (TopComponent)name2tc.get(name);
            if (tcToFocus == null) continue;
            tcToFocus.requestActive();
        }
    }

    public void addListener(GedcomRegistryListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(GedcomRegistryListener listener) {
        this.listeners.remove(listener);
    }

    public static GedcomDirectory getDefault() {
        GedcomDirectory gdInstance = (GedcomDirectory)Lookup.getDefault().lookup(GedcomDirectory.class);
        return gdInstance != null ? gdInstance : GedcomDirectory.getDefaultInstance();
    }

    private static synchronized GedcomDirectory getDefaultInstance() {
        if (defaultInstance == null) {
            defaultInstance = new DefaultGedcomDirectoryImpl();
        }
        return defaultInstance;
    }

    private static class DefaultGedcomDirectoryImpl
    extends GedcomDirectory {
        private Map<Gedcom, GedcomDataObject> gedcomsOpened = new HashMap<Gedcom, GedcomDataObject>(5);

        private DefaultGedcomDirectoryImpl() {
        }

        @Override
        protected boolean registerGedcomImpl(GedcomDataObject gedcomObject) {
            Gedcom gedcom = gedcomObject.getContext().getGedcom();
            if (!this.gedcomsOpened.containsKey(gedcom)) {
                this.gedcomsOpened.put(gedcom, gedcomObject);
            }
            return true;
        }

        @Override
        protected boolean unregisterGedcomImpl(Context context) {
            GedcomDataObject gdao = this.gedcomsOpened.get(context.getGedcom());
            if (gdao != null) {
                try {
                    gdao.setValid(false);
                }
                catch (PropertyVetoException ex) {
                    return false;
                }
            }
            this.gedcomsOpened.remove(context.getGedcom());
            return true;
        }

        @Override
        public Context getContext(FileObject file) {
            if (file == null) {
                return null;
            }
            for (Gedcom g : this.gedcomsOpened.keySet()) {
                if (!file.equals(this.gedcomsOpened.get(g).getPrimaryFile())) continue;
                return this.gedcomsOpened.get(g).getContext();
            }
            return null;
        }

        @Override
        public List<Context> getContexts() {
            ArrayList<Context> result = new ArrayList<Context>();
            for (Gedcom g : this.gedcomsOpened.keySet()) {
                result.add(this.gedcomsOpened.get(g).getContext());
            }
            return result;
        }

        @Override
        public GedcomDataObject getDataObject(Context context) throws ContextNotFoundException {
            if (context == null || context.getGedcom() == null) {
                throw new ContextNotFoundException("No GedcomDAO for context " + context);
            }
            GedcomDataObject dao = this.gedcomsOpened.get(context.getGedcom());
            if (dao == null) {
                throw new ContextNotFoundException("No GedcomDAO for context " + context);
            }
            return dao;
        }
    }

    public static interface GedcomRegistryListener {
        public void gedcomRegistered(Context var1);

        public void gedcomUnregistered(Context var1);
    }

    public static class ContextNotFoundException
    extends Exception {
        public ContextNotFoundException(String message) {
            super(message);
        }
    }
}

