/*
 * Decompiled with CFR 0.152.
 */
package ancestris.core.actions;

import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.UIManager;
import org.openide.awt.DynamicMenuContent;
import org.openide.util.actions.Presenter;

public class CommonActions {
    public static final Action NOOP = new NoOpAction();

    public static Action createSeparatorAction(String title) {
        SeparatorAction result = new SeparatorAction(title);
        return result;
    }

    private static class TitleMenuItem
    extends JMenuItem
    implements DynamicMenuContent {
        private JLabel title;

        public TitleMenuItem(String title) {
            this.title = new JLabel(title);
            this.title.setBackground(UIManager.getColor("MenuItem.selectionBackground"));
            this.title.setForeground(UIManager.getColor("MenuItem.selectionForeground"));
            this.title.setOpaque(true);
        }

        @Override
        public void setToolTipText(String text) {
            this.title.setToolTipText(text);
        }

        public JComponent[] getMenuPresenters() {
            return new JComponent[]{this.title};
        }

        public JComponent[] synchMenuPresenters(JComponent[] items) {
            return this.getMenuPresenters();
        }
    }

    private static class SeparatorAction
    extends AbstractAction
    implements Presenter.Popup {
        private String title;

        public SeparatorAction(String title) {
            this.title = title;
            this.setEnabled(true);
            this.putValue("Name", title);
            this.putValue("hideWhenDisabled", true);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
        }

        public JMenuItem getPopupPresenter() {
            TitleMenuItem item = new TitleMenuItem("<html><b>&nbsp;&nbsp;" + this.title + "</b></html>");
            String tt = (String)this.getValue("ShortDescription");
            if (tt != null) {
                ((JComponent)item).setToolTipText("<html><body width=\"500\">" + tt.replaceAll("\\n", "<br/>") + "</body></html>");
            }
            item.setEnabled(false);
            return item;
        }
    }

    private static class NoOpAction
    extends AbstractAction {
        public NoOpAction() {
            this.setEnabled(false);
            this.putValue("Name", "noop");
            this.putValue("hideWhenDisabled", true);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
        }
    }
}

