/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.editors.genealogyeditor.panels;

import ancestris.modules.editors.genealogyeditor.models.NoteCitationsTableModel;
import ancestris.modules.editors.genealogyeditor.panels.NoteCitationEditorPanel;
import ancestris.modules.editors.genealogyeditor.panels.NotesTablePanel;
import ancestris.modules.editors.genealogyeditor.renderer.TextPaneTableCellRenderer;
import ancestris.modules.editors.genealogyeditor.table.EditorTable;
import ancestris.util.swing.DialogManager;
import genj.gedcom.Gedcom;
import genj.gedcom.GedcomException;
import genj.gedcom.Note;
import genj.gedcom.Property;
import genj.gedcom.UnitOfWork;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.LayoutStyle;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.table.TableCellRenderer;
import org.openide.DialogDescriptor;
import org.openide.util.ChangeSupport;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class NoteCitationsTablePanel
extends JPanel {
    private Property mRoot;
    private final NoteCitationsTableModel mNoteCitationsTableModel = new NoteCitationsTableModel();
    private final ChangeListner changeListner = new ChangeListner();
    private final ChangeSupport changeSupport = new ChangeSupport(NoteCitationsTablePanel.class);
    private JButton addNoteButton;
    private JButton deleteNoteButton;
    private JButton editNoteButton;
    private JScrollPane jScrollPane1;
    private JButton linkToNoteButton;
    private EditorTable noteCitationsTable;
    private JToolBar notesToolBar;

    public NoteCitationsTablePanel() {
        this.initComponents();
        this.noteCitationsTable.setID(NoteCitationsTablePanel.class.getName());
    }

    private void initComponents() {
        this.notesToolBar = new JToolBar();
        this.addNoteButton = new JButton();
        this.linkToNoteButton = new JButton();
        this.editNoteButton = new JButton();
        this.deleteNoteButton = new JButton();
        this.jScrollPane1 = new JScrollPane();
        this.noteCitationsTable = new EditorTable(){

            @Override
            public TableCellRenderer getCellRenderer(int row, int column) {
                if (column == 1) {
                    return new TextPaneTableCellRenderer();
                }
                return super.getCellRenderer(row, column);
            }
        };
        this.setMinimumSize(new Dimension(453, 57));
        this.notesToolBar.setFloatable(false);
        this.notesToolBar.setRollover(true);
        this.addNoteButton.setIcon(new ImageIcon(this.getClass().getResource("/ancestris/modules/editors/genealogyeditor/resources/edit_add.png")));
        this.addNoteButton.setToolTipText(MessageFormat.format(ResourceBundle.getBundle("ancestris/modules/editors/genealogyeditor/panels/Bundle").getString("NoteCitationsTablePanel.addNoteButton.toolTipText"), new Object[0]));
        this.addNoteButton.setFocusable(false);
        this.addNoteButton.setHorizontalTextPosition(0);
        this.addNoteButton.setVerticalTextPosition(3);
        this.addNoteButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NoteCitationsTablePanel.this.addNoteButtonActionPerformed(evt);
            }
        });
        this.notesToolBar.add(this.addNoteButton);
        this.linkToNoteButton.setIcon(new ImageIcon(this.getClass().getResource("/ancestris/modules/editors/genealogyeditor/resources/link_add.png")));
        this.linkToNoteButton.setToolTipText(MessageFormat.format(ResourceBundle.getBundle("ancestris/modules/editors/genealogyeditor/panels/Bundle").getString("NoteCitationsTablePanel.linkToNoteButton.toolTipText"), new Object[0]));
        this.linkToNoteButton.setFocusable(false);
        this.linkToNoteButton.setHorizontalTextPosition(0);
        this.linkToNoteButton.setVerticalTextPosition(3);
        this.linkToNoteButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NoteCitationsTablePanel.this.linkToNoteButtonActionPerformed(evt);
            }
        });
        this.notesToolBar.add(this.linkToNoteButton);
        this.editNoteButton.setIcon(new ImageIcon(this.getClass().getResource("/ancestris/modules/editors/genealogyeditor/resources/edit.png")));
        this.editNoteButton.setToolTipText(MessageFormat.format(ResourceBundle.getBundle("ancestris/modules/editors/genealogyeditor/panels/Bundle").getString("NoteCitationsTablePanel.editNoteButton.toolTipText"), new Object[0]));
        this.editNoteButton.setFocusable(false);
        this.editNoteButton.setHorizontalTextPosition(0);
        this.editNoteButton.setVerticalTextPosition(3);
        this.editNoteButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NoteCitationsTablePanel.this.editNoteButtonActionPerformed(evt);
            }
        });
        this.notesToolBar.add(this.editNoteButton);
        this.deleteNoteButton.setIcon(new ImageIcon(this.getClass().getResource("/ancestris/modules/editors/genealogyeditor/resources/edit_delete.png")));
        this.deleteNoteButton.setToolTipText(MessageFormat.format(ResourceBundle.getBundle("ancestris/modules/editors/genealogyeditor/panels/Bundle").getString("NoteCitationsTablePanel.deleteNoteButton.toolTipText"), new Object[0]));
        this.deleteNoteButton.setFocusable(false);
        this.deleteNoteButton.setHorizontalTextPosition(0);
        this.deleteNoteButton.setVerticalTextPosition(3);
        this.deleteNoteButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NoteCitationsTablePanel.this.deleteNoteButtonActionPerformed(evt);
            }
        });
        this.notesToolBar.add(this.deleteNoteButton);
        this.noteCitationsTable.setModel(this.mNoteCitationsTableModel);
        this.noteCitationsTable.setSelectionBackground(new Color(89, 142, 195));
        this.noteCitationsTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                NoteCitationsTablePanel.this.noteCitationsTableMouseClicked(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.noteCitationsTable);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.notesToolBar, -1, -1, Short.MAX_VALUE).addComponent(this.jScrollPane1));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.notesToolBar, -2, 25, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane1, -1, 26, Short.MAX_VALUE)));
    }

    private void addNoteButtonActionPerformed(ActionEvent evt) {
        Gedcom gedcom = this.mRoot.getGedcom();
        int undoNb = gedcom.getUndoNb();
        final NoteCitationEditorPanel noteCitationEditorPanel = new NoteCitationEditorPanel();
        noteCitationEditorPanel.set(gedcom, this.mRoot, null);
        DialogManager.ADialog noteCitationEditorDialog = new DialogManager.ADialog(NbBundle.getMessage(NoteCitationEditorPanel.class, (String)"NoteCitationEditorPanel.create.title"), (JComponent)noteCitationEditorPanel);
        noteCitationEditorDialog.setDialogId(NoteCitationEditorPanel.class.getName());
        if (noteCitationEditorDialog.show() == DialogDescriptor.OK_OPTION) {
            try {
                gedcom.doUnitOfWork(new UnitOfWork(){

                    public void perform(Gedcom gedcom) throws GedcomException {
                        noteCitationEditorPanel.commit();
                        if (noteCitationEditorPanel.get() instanceof Note) {
                            NoteCitationsTablePanel.this.mRoot.addNote((Note)noteCitationEditorPanel.get());
                        }
                    }
                });
                this.mNoteCitationsTableModel.clear();
                this.mNoteCitationsTableModel.addAll(Arrays.asList(this.mRoot.getProperties("NOTE")));
                this.editNoteButton.setEnabled(true);
                this.deleteNoteButton.setEnabled(true);
                this.changeListner.stateChanged(null);
            }
            catch (GedcomException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        } else {
            while (gedcom.getUndoNb() > undoNb && gedcom.canUndo()) {
                gedcom.undoUnitOfWork(false);
            }
        }
    }

    private void editNoteButtonActionPerformed(ActionEvent evt) {
        int selectedRow = this.noteCitationsTable.getSelectedRow();
        if (selectedRow != -1) {
            int rowIndex = this.noteCitationsTable.convertRowIndexToModel(selectedRow);
            Property note = this.mNoteCitationsTableModel.getValueAt(rowIndex);
            this.editNote(note);
        }
    }

    private void deleteNoteButtonActionPerformed(ActionEvent evt) {
        int selectedRow = this.noteCitationsTable.getSelectedRow();
        if (selectedRow != -1) {
            final int rowIndex = this.noteCitationsTable.convertRowIndexToModel(selectedRow);
            DialogManager createYesNo = DialogManager.createYesNo((String)NbBundle.getMessage(NoteCitationsTablePanel.class, (String)"NoteCitationsTableDialog.deleteNote.title"), (String)NbBundle.getMessage(NoteCitationsTablePanel.class, (String)"NoteCitationsTableDialog.deleteNote.text", (Object)this.mRoot));
            if (createYesNo.show() == DialogManager.YES_OPTION) {
                try {
                    this.mRoot.getGedcom().doUnitOfWork(new UnitOfWork(){

                        public void perform(Gedcom gedcom) throws GedcomException {
                            NoteCitationsTablePanel.this.mRoot.delProperty(NoteCitationsTablePanel.this.mNoteCitationsTableModel.remove(rowIndex));
                        }
                    });
                    this.changeListner.stateChanged(null);
                    if (this.mNoteCitationsTableModel.getRowCount() <= 0) {
                        this.editNoteButton.setEnabled(false);
                        this.deleteNoteButton.setEnabled(false);
                    }
                }
                catch (GedcomException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
        }
    }

    private void linkToNoteButtonActionPerformed(ActionEvent evt) {
        ArrayList<Note> notesList = new ArrayList<Note>(this.mRoot.getGedcom().getEntities("NOTE"));
        NotesTablePanel notesTablePanel = new NotesTablePanel();
        notesTablePanel.set(this.mRoot, notesList);
        notesTablePanel.setToolBarVisible(false);
        DialogManager.ADialog notesTableDialog = new DialogManager.ADialog(NbBundle.getMessage(NotesTablePanel.class, (String)"NotesTableDialog.linkTo.title"), (JComponent)notesTablePanel);
        notesTableDialog.setDialogId(NotesTablePanel.class.getName());
        if (notesTableDialog.show() == DialogDescriptor.OK_OPTION) {
            final Note selectedNote = notesTablePanel.getSelectedNote();
            try {
                this.mRoot.getGedcom().doUnitOfWork(new UnitOfWork(){

                    public void perform(Gedcom gedcom) throws GedcomException {
                        NoteCitationsTablePanel.this.mRoot.addNote(selectedNote);
                    }
                });
                this.mNoteCitationsTableModel.clear();
                this.mNoteCitationsTableModel.addAll(Arrays.asList(this.mRoot.getProperties("NOTE")));
                this.editNoteButton.setEnabled(true);
                this.deleteNoteButton.setEnabled(true);
                this.changeListner.stateChanged(null);
            }
            catch (GedcomException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }

    private void noteCitationsTableMouseClicked(MouseEvent evt) {
        int selectedRow;
        if (evt.getClickCount() >= 2 && (selectedRow = this.noteCitationsTable.getSelectedRow()) != -1) {
            int rowIndex = this.noteCitationsTable.convertRowIndexToModel(selectedRow);
            Property note = this.mNoteCitationsTableModel.getValueAt(rowIndex);
            this.editNote(note);
        }
    }

    public void set(Property root, List<Property> notesList) {
        this.mRoot = root;
        this.mNoteCitationsTableModel.clear();
        this.mNoteCitationsTableModel.addAll(notesList);
        if (this.mNoteCitationsTableModel.getRowCount() > 0) {
            this.editNoteButton.setEnabled(true);
            this.deleteNoteButton.setEnabled(true);
        } else {
            this.editNoteButton.setEnabled(false);
            this.deleteNoteButton.setEnabled(false);
        }
    }

    public void setToolBarVisible(boolean visible) {
        this.notesToolBar.setVisible(visible);
    }

    private void editNote(Property note) {
        Gedcom gedcom = this.mRoot.getGedcom();
        int undoNb = gedcom.getUndoNb();
        final NoteCitationEditorPanel noteCitationEditorPanel = new NoteCitationEditorPanel();
        noteCitationEditorPanel.set(gedcom, this.mRoot, note);
        DialogManager.ADialog noteCitationEditorDialog = new DialogManager.ADialog(NbBundle.getMessage(NoteCitationEditorPanel.class, (String)"NoteCitationEditorPanel.edit.title"), (JComponent)noteCitationEditorPanel);
        noteCitationEditorDialog.setDialogId(NoteCitationEditorPanel.class.getName());
        if (noteCitationEditorDialog.show() == DialogDescriptor.OK_OPTION) {
            try {
                this.mRoot.getGedcom().doUnitOfWork(new UnitOfWork(){

                    public void perform(Gedcom gedcom) throws GedcomException {
                        noteCitationEditorPanel.commit();
                    }
                });
                this.changeListner.stateChanged(null);
            }
            catch (GedcomException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        } else {
            while (gedcom.getUndoNb() > undoNb && gedcom.canUndo()) {
                gedcom.undoUnitOfWork(false);
            }
        }
    }

    public void addChangeListener(ChangeListener l) {
        this.changeSupport.addChangeListener(l);
    }

    public void removeChangeListener(ChangeListener l) {
        this.changeSupport.removeChangeListener(l);
    }

    private class ChangeListner
    implements ChangeListener {
        private ChangeListner() {
        }

        @Override
        public void stateChanged(ChangeEvent ce) {
            NoteCitationsTablePanel.this.changeSupport.fireChange();
        }
    }
}

