/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.editors.genealogyeditor.panels;

import ancestris.modules.editors.genealogyeditor.models.NamesTableModel;
import ancestris.modules.editors.genealogyeditor.panels.NameEditorPanel;
import ancestris.modules.editors.genealogyeditor.panels.NotesTablePanel;
import ancestris.modules.editors.genealogyeditor.table.EditorTable;
import ancestris.util.swing.DialogManager;
import genj.gedcom.Gedcom;
import genj.gedcom.GedcomException;
import genj.gedcom.Indi;
import genj.gedcom.PropertyName;
import genj.gedcom.UnitOfWork;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.MessageFormat;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.LayoutStyle;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.openide.DialogDescriptor;
import org.openide.util.ChangeSupport;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class NamesTablePanel
extends JPanel {
    private final NamesTableModel mNamesTableModel = new NamesTableModel();
    private final ChangeListner changeListner = new ChangeListner();
    private final ChangeSupport changeSupport = new ChangeSupport(NamesTablePanel.class);
    private Indi root;
    private PropertyName addedName = null;
    private JButton addNameButton;
    private JButton deleteNameButton;
    private JButton editNameButton;
    private EditorTable namesTable;
    private JScrollPane namesTableScrollPane;
    private JToolBar namesToolBar;

    public NamesTablePanel() {
        this.initComponents();
    }

    private void initComponents() {
        this.namesToolBar = new JToolBar();
        this.addNameButton = new JButton();
        this.editNameButton = new JButton();
        this.deleteNameButton = new JButton();
        this.namesTableScrollPane = new JScrollPane();
        this.namesTable = new EditorTable();
        this.namesToolBar.setFloatable(false);
        this.namesToolBar.setRollover(true);
        this.addNameButton.setIcon(new ImageIcon(this.getClass().getResource("/ancestris/modules/editors/genealogyeditor/resources/edit_add.png")));
        this.addNameButton.setToolTipText(MessageFormat.format(ResourceBundle.getBundle("ancestris/modules/editors/genealogyeditor/panels/Bundle").getString("NamesTablePanel.addNameButton.toolTipText"), new Object[0]));
        this.addNameButton.setFocusable(false);
        this.addNameButton.setHorizontalTextPosition(0);
        this.addNameButton.setVerticalTextPosition(3);
        this.addNameButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NamesTablePanel.this.addNameButtonActionPerformed(evt);
            }
        });
        this.namesToolBar.add(this.addNameButton);
        this.editNameButton.setIcon(new ImageIcon(this.getClass().getResource("/ancestris/modules/editors/genealogyeditor/resources/edit.png")));
        this.editNameButton.setToolTipText(MessageFormat.format(ResourceBundle.getBundle("ancestris/modules/editors/genealogyeditor/panels/Bundle").getString("NamesTablePanel.editNameButton.toolTipText"), new Object[0]));
        this.editNameButton.setFocusable(false);
        this.editNameButton.setHorizontalTextPosition(0);
        this.editNameButton.setVerticalTextPosition(3);
        this.editNameButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NamesTablePanel.this.editNameButtonActionPerformed(evt);
            }
        });
        this.namesToolBar.add(this.editNameButton);
        this.deleteNameButton.setIcon(new ImageIcon(this.getClass().getResource("/ancestris/modules/editors/genealogyeditor/resources/edit_delete.png")));
        this.deleteNameButton.setToolTipText(MessageFormat.format(ResourceBundle.getBundle("ancestris/modules/editors/genealogyeditor/panels/Bundle").getString("NamesTablePanel.deleteNameButton.toolTipText"), new Object[0]));
        this.deleteNameButton.setFocusable(false);
        this.deleteNameButton.setHorizontalTextPosition(0);
        this.deleteNameButton.setVerticalTextPosition(3);
        this.deleteNameButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NamesTablePanel.this.deleteNameButtonActionPerformed(evt);
            }
        });
        this.namesToolBar.add(this.deleteNameButton);
        this.namesTable.setModel(this.mNamesTableModel);
        this.namesTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                NamesTablePanel.this.namesTableMouseClicked(evt);
            }
        });
        this.namesTableScrollPane.setViewportView(this.namesTable);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.namesToolBar, -1, 539, Short.MAX_VALUE).addComponent(this.namesTableScrollPane));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.namesToolBar, -2, 25, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.namesTableScrollPane, -1, 154, Short.MAX_VALUE)));
    }

    private void addNameButtonActionPerformed(ActionEvent evt) {
        final NameEditorPanel nameEditorPanel = new NameEditorPanel();
        Gedcom gedcom = this.root.getGedcom();
        int undoNb = gedcom.getUndoNb();
        try {
            gedcom.doUnitOfWork(new UnitOfWork(){

                public void perform(Gedcom gedcom) throws GedcomException {
                    NamesTablePanel.this.addedName = (PropertyName)NamesTablePanel.this.root.addProperty("NAME", "");
                }
            });
        }
        catch (GedcomException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        nameEditorPanel.set(this.root, this.addedName);
        DialogManager.ADialog nameEditorDialog = new DialogManager.ADialog(NbBundle.getMessage(NameEditorPanel.class, (String)"NameEditorPanel.title.create"), (JComponent)nameEditorPanel);
        nameEditorDialog.setDialogId(NameEditorPanel.class.getName());
        if (nameEditorDialog.show() == DialogDescriptor.OK_OPTION) {
            try {
                this.root.getGedcom().doUnitOfWork(new UnitOfWork(){

                    public void perform(Gedcom gedcom) throws GedcomException {
                        nameEditorPanel.commit();
                        NamesTablePanel.this.mNamesTableModel.add(nameEditorPanel.get());
                    }
                });
                this.editNameButton.setEnabled(true);
                this.deleteNameButton.setEnabled(true);
            }
            catch (GedcomException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        } else {
            while (gedcom.getUndoNb() > undoNb && gedcom.canUndo()) {
                gedcom.undoUnitOfWork(false);
            }
        }
    }

    private void editNameButtonActionPerformed(ActionEvent evt) {
        int selectedRow = this.namesTable.getSelectedRow();
        if (selectedRow != -1) {
            int rowIndex = this.namesTable.convertRowIndexToModel(selectedRow);
            final NameEditorPanel nameEditorPanel = new NameEditorPanel();
            nameEditorPanel.set(this.root, this.mNamesTableModel.getValueAt(rowIndex));
            DialogManager.ADialog nameEditorDialog = new DialogManager.ADialog(NbBundle.getMessage(NameEditorPanel.class, (String)"NameEditorPanel.title.edit"), (JComponent)nameEditorPanel);
            nameEditorDialog.setDialogId(NameEditorPanel.class.getName());
            if (nameEditorDialog.show() == DialogDescriptor.OK_OPTION) {
                try {
                    this.root.getGedcom().doUnitOfWork(new UnitOfWork(){

                        public void perform(Gedcom gedcom) throws GedcomException {
                            nameEditorPanel.commit();
                        }
                    });
                }
                catch (GedcomException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
        }
    }

    private void deleteNameButtonActionPerformed(ActionEvent evt) {
        int selectedRow = this.namesTable.getSelectedRow();
        if (selectedRow != -1) {
            final int rowIndex = this.namesTable.convertRowIndexToModel(selectedRow);
            DialogManager createYesNo = DialogManager.createYesNo((String)NbBundle.getMessage(NotesTablePanel.class, (String)"NamesTableDialog.deleteName.title"), (String)NbBundle.getMessage(NotesTablePanel.class, (String)"NamesTableDialog.deleteName.text", (Object)this.root));
            if (createYesNo.show() == DialogManager.YES_OPTION) {
                try {
                    this.root.getGedcom().doUnitOfWork(new UnitOfWork(){

                        public void perform(Gedcom gedcom) throws GedcomException {
                            NamesTablePanel.this.root.delProperty(NamesTablePanel.this.mNamesTableModel.remove(rowIndex));
                        }
                    });
                    if (this.mNamesTableModel.getRowCount() <= 0) {
                        this.editNameButton.setEnabled(false);
                        this.deleteNameButton.setEnabled(false);
                    }
                    this.changeListner.stateChanged(null);
                }
                catch (GedcomException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
        }
    }

    private void namesTableMouseClicked(MouseEvent evt) {
        int selectedRow;
        if (evt.getClickCount() >= 2 && (selectedRow = this.namesTable.getSelectedRow()) != -1) {
            int rowIndex = this.namesTable.convertRowIndexToModel(selectedRow);
            final NameEditorPanel nameEditorPanel = new NameEditorPanel();
            nameEditorPanel.set(this.root, this.mNamesTableModel.getValueAt(rowIndex));
            DialogManager.ADialog nameEditorDialog = new DialogManager.ADialog(NbBundle.getMessage(NameEditorPanel.class, (String)"NameEditorPanel.title.edit"), (JComponent)nameEditorPanel);
            nameEditorDialog.setDialogId(NameEditorPanel.class.getName());
            if (nameEditorDialog.show() == DialogDescriptor.OK_OPTION) {
                try {
                    this.root.getGedcom().doUnitOfWork(new UnitOfWork(){

                        public void perform(Gedcom gedcom) throws GedcomException {
                            nameEditorPanel.commit();
                        }
                    });
                }
                catch (GedcomException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
        }
    }

    public void set(Indi root, List<PropertyName> namesList) {
        this.root = root;
        this.mNamesTableModel.clear();
        this.mNamesTableModel.addAll(namesList);
        if (this.mNamesTableModel.getRowCount() > 0) {
            this.editNameButton.setEnabled(true);
            this.deleteNameButton.setEnabled(true);
        } else {
            this.editNameButton.setEnabled(false);
            this.deleteNameButton.setEnabled(false);
        }
    }

    public void addChangeListener(ChangeListener l) {
        this.changeSupport.addChangeListener(l);
    }

    public void removeChangeListener(ChangeListener l) {
        this.changeSupport.removeChangeListener(l);
    }

    private class ChangeListner
    implements ChangeListener {
        private ChangeListner() {
        }

        @Override
        public void stateChanged(ChangeEvent ce) {
            NamesTablePanel.this.changeSupport.fireChange();
        }
    }
}

