/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.editors.genealogyeditor.panels;

import ancestris.modules.editors.genealogyeditor.models.NameTypeComboBoxModel;
import ancestris.modules.editors.genealogyeditor.panels.NoteCitationsTablePanel;
import ancestris.modules.editors.genealogyeditor.panels.SourceCitationsTablePanel;
import genj.gedcom.Context;
import genj.gedcom.Gedcom;
import genj.gedcom.Indi;
import genj.gedcom.Property;
import genj.gedcom.PropertyName;
import genj.util.ChangeSupport;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public class NameEditorPanel
extends JPanel {
    private NameTypeComboBoxModel nameTypeComboBoxModelModel = new NameTypeComboBoxModel();
    private Indi mRoot;
    private PropertyName mName;
    private boolean nameTypeModified = false;
    private boolean familyNamePrefixModified = false;
    private boolean familyNameModified = false;
    private boolean firstNamePrefixModified = false;
    private boolean firstNameSuffixModified = false;
    private boolean firstNameModified = false;
    private boolean nicknameModified = false;
    private static final Logger logger = Logger.getLogger(NameEditorPanel.class.getName(), null);
    private final ChangeSupport changeSupport = new ChangeSupport((Object)this);
    private JLabel familyNameLabel;
    private JLabel familyNamePrefixLabel;
    private JTextField familyNamePrefixTextField;
    private JTextField familyNameTextField;
    private JLabel firstNamePrefixLabel;
    private JTextField firstNamePrefixTextField;
    private JLabel firstNameSuffixLabel;
    private JTextField firstNameSuffixTextField;
    private JTextField firstNameTextField;
    private JLabel firstnameLabel;
    private JCheckBox jCheckBox1;
    private JPanel nameEditorPanel;
    private JTabbedPane nameEditorTabbedPane;
    private JPanel namePanel;
    private JComboBox<String> nameTypeComboBox;
    private JLabel nameTypeLabel;
    private JLabel nicknameLabel;
    private JTextField nicknameTextField;
    private NoteCitationsTablePanel noteCitationsTablePanel;
    private SourceCitationsTablePanel sourceCitationsTablePanel;

    public NameEditorPanel() {
        this.initComponents();
        this.jCheckBox1.setSelected(false);
        this.firstNamePrefixLabel.setVisible(false);
        this.firstNamePrefixTextField.setVisible(false);
        this.familyNamePrefixLabel.setVisible(false);
        this.familyNamePrefixTextField.setVisible(false);
        this.firstNameSuffixLabel.setVisible(false);
        this.firstNameSuffixTextField.setVisible(false);
        this.firstNamePrefixTextField.getDocument().addDocumentListener((DocumentListener)this.changeSupport);
        this.familyNamePrefixTextField.getDocument().addDocumentListener((DocumentListener)this.changeSupport);
        this.firstNameTextField.getDocument().addDocumentListener((DocumentListener)this.changeSupport);
        this.familyNameTextField.getDocument().addDocumentListener((DocumentListener)this.changeSupport);
        this.nicknameTextField.getDocument().addDocumentListener((DocumentListener)this.changeSupport);
        this.firstNameSuffixTextField.getDocument().addDocumentListener((DocumentListener)this.changeSupport);
        Context contextToOpen = (Context)Utilities.actionsGlobalContext().lookup(Context.class);
        if (contextToOpen != null) {
            Gedcom gedcom = contextToOpen.getGedcom();
        }
    }

    private void initComponents() {
        this.nameEditorTabbedPane = new JTabbedPane();
        this.namePanel = new JPanel();
        this.nameEditorPanel = new JPanel();
        this.jCheckBox1 = new JCheckBox();
        this.nameTypeLabel = new JLabel();
        this.nameTypeComboBox = new JComboBox();
        this.firstNamePrefixLabel = new JLabel();
        this.firstNamePrefixTextField = new JTextField();
        this.firstNameTextField = new JTextField();
        this.familyNamePrefixLabel = new JLabel();
        this.familyNamePrefixTextField = new JTextField();
        this.familyNameTextField = new JTextField();
        this.firstNameSuffixTextField = new JTextField();
        this.nicknameLabel = new JLabel();
        this.nicknameTextField = new JTextField();
        this.firstnameLabel = new JLabel();
        this.familyNameLabel = new JLabel();
        this.firstNameSuffixLabel = new JLabel();
        this.noteCitationsTablePanel = new NoteCitationsTablePanel();
        this.sourceCitationsTablePanel = new SourceCitationsTablePanel();
        this.jCheckBox1.setText(NbBundle.getMessage(NameEditorPanel.class, (String)"NameEditorPanel.jCheckBox1.text"));
        this.jCheckBox1.setHorizontalAlignment(2);
        this.jCheckBox1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NameEditorPanel.this.jCheckBox1ActionPerformed(evt);
            }
        });
        this.nameTypeLabel.setText(MessageFormat.format(ResourceBundle.getBundle("ancestris/modules/editors/genealogyeditor/panels/Bundle").getString("NameEditorPanel.nameTypeLabel.text"), new Object[0]));
        this.nameTypeComboBox.setEditable(true);
        this.nameTypeComboBox.setModel(this.nameTypeComboBoxModelModel);
        this.nameTypeComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NameEditorPanel.this.nameTypeComboBoxActionPerformed(evt);
            }
        });
        this.firstNamePrefixLabel.setHorizontalAlignment(4);
        this.firstNamePrefixLabel.setText(MessageFormat.format(ResourceBundle.getBundle("ancestris/modules/editors/genealogyeditor/panels/Bundle").getString("NameEditorPanel.firstNamePrefixLabel.text"), new Object[0]));
        this.firstNamePrefixTextField.setColumns(8);
        this.firstNamePrefixTextField.setHorizontalAlignment(2);
        this.firstNamePrefixTextField.setToolTipText(MessageFormat.format(ResourceBundle.getBundle("ancestris/modules/editors/genealogyeditor/panels/Bundle").getString("NameEditorPanel.firstNamePrefixTextField.toolTipText"), new Object[0]));
        this.firstNamePrefixTextField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                NameEditorPanel.this.firstNamePrefixModified = true;
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                NameEditorPanel.this.firstNamePrefixModified = true;
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                NameEditorPanel.this.firstNamePrefixModified = true;
            }
        });
        this.firstNameTextField.setToolTipText(MessageFormat.format(ResourceBundle.getBundle("ancestris/modules/editors/genealogyeditor/panels/Bundle").getString("NameEditorPanel.firstNameTextField.toolTipText"), new Object[0]));
        this.firstNameTextField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                NameEditorPanel.this.firstNameModified = true;
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                NameEditorPanel.this.firstNameModified = true;
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                NameEditorPanel.this.firstNameModified = true;
            }
        });
        this.familyNamePrefixLabel.setHorizontalAlignment(4);
        this.familyNamePrefixLabel.setText(MessageFormat.format(ResourceBundle.getBundle("ancestris/modules/editors/genealogyeditor/panels/Bundle").getString("NameEditorPanel.familyNamePrefixLabel.text"), new Object[0]));
        this.familyNamePrefixTextField.setColumns(8);
        this.familyNamePrefixTextField.setToolTipText(MessageFormat.format(ResourceBundle.getBundle("ancestris/modules/editors/genealogyeditor/panels/Bundle").getString("NameEditorPanel.familyNamePrefixTextField.toolTipText"), new Object[0]));
        this.familyNamePrefixTextField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                NameEditorPanel.this.familyNamePrefixModified = true;
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                NameEditorPanel.this.familyNamePrefixModified = true;
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                NameEditorPanel.this.familyNamePrefixModified = true;
            }
        });
        this.familyNameTextField.setColumns(16);
        this.familyNameTextField.setToolTipText(MessageFormat.format(ResourceBundle.getBundle("ancestris/modules/editors/genealogyeditor/panels/Bundle").getString("NameEditorPanel.familyNameTextField.toolTipText"), new Object[0]));
        this.familyNameTextField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                NameEditorPanel.this.familyNameModified = true;
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                NameEditorPanel.this.familyNameModified = true;
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                NameEditorPanel.this.familyNameModified = true;
            }
        });
        this.firstNameSuffixTextField.setColumns(8);
        this.firstNameSuffixTextField.setText(MessageFormat.format(ResourceBundle.getBundle("ancestris/modules/editors/genealogyeditor/panels/Bundle").getString("NameEditorPanel.firstNameSuffixTextField.text"), new Object[0]));
        this.firstNameSuffixTextField.setToolTipText(MessageFormat.format(ResourceBundle.getBundle("ancestris/modules/editors/genealogyeditor/panels/Bundle").getString("NameEditorPanel.firstNameSuffixTextField.toolTipText"), new Object[0]));
        this.firstNameSuffixTextField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                NameEditorPanel.this.firstNameSuffixModified = true;
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                NameEditorPanel.this.firstNameSuffixModified = true;
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                NameEditorPanel.this.firstNameSuffixModified = true;
            }
        });
        this.nicknameLabel.setHorizontalAlignment(4);
        this.nicknameLabel.setText(MessageFormat.format(ResourceBundle.getBundle("ancestris/modules/editors/genealogyeditor/panels/Bundle").getString("NameEditorPanel.nicknameLabel.text"), new Object[0]));
        this.nicknameTextField.setColumns(8);
        this.nicknameTextField.setHorizontalAlignment(2);
        this.nicknameTextField.setToolTipText(MessageFormat.format(ResourceBundle.getBundle("ancestris/modules/editors/genealogyeditor/panels/Bundle").getString("NameEditorPanel.nicknameTextField.toolTipText"), new Object[0]));
        this.nicknameTextField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                NameEditorPanel.this.nicknameModified = true;
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                NameEditorPanel.this.nicknameModified = true;
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                NameEditorPanel.this.nicknameModified = true;
            }
        });
        this.firstnameLabel.setHorizontalAlignment(4);
        this.firstnameLabel.setText(MessageFormat.format(ResourceBundle.getBundle("ancestris/modules/editors/genealogyeditor/panels/Bundle").getString("NameEditorPanel.firstnameLabel.text"), new Object[0]));
        this.familyNameLabel.setHorizontalAlignment(4);
        this.familyNameLabel.setText(MessageFormat.format(ResourceBundle.getBundle("ancestris/modules/editors/genealogyeditor/panels/Bundle").getString("NameEditorPanel.familyNameLabel.text"), new Object[0]));
        this.firstNameSuffixLabel.setHorizontalAlignment(4);
        this.firstNameSuffixLabel.setText(MessageFormat.format(ResourceBundle.getBundle("ancestris/modules/editors/genealogyeditor/panels/Bundle").getString("NameEditorPanel.firstNameSuffixLabel.text"), new Object[0]));
        GroupLayout nameEditorPanelLayout = new GroupLayout(this.nameEditorPanel);
        this.nameEditorPanel.setLayout(nameEditorPanelLayout);
        nameEditorPanelLayout.setHorizontalGroup(nameEditorPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(nameEditorPanelLayout.createSequentialGroup().addComponent(this.jCheckBox1, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.nameTypeLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.nameTypeComboBox, 0, -1, Short.MAX_VALUE)).addGroup(nameEditorPanelLayout.createSequentialGroup().addGroup(nameEditorPanelLayout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.familyNamePrefixLabel, -1, -1, Short.MAX_VALUE).addComponent(this.firstNamePrefixLabel, -2, 133, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(nameEditorPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.firstNamePrefixTextField).addComponent(this.familyNamePrefixTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(nameEditorPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.nicknameLabel, -1, -1, Short.MAX_VALUE).addComponent(this.familyNameLabel, -1, -1, Short.MAX_VALUE).addComponent(this.firstnameLabel, -2, 101, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(nameEditorPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.firstNameTextField).addGroup(GroupLayout.Alignment.TRAILING, nameEditorPanelLayout.createSequentialGroup().addGroup(nameEditorPanelLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.nicknameTextField, GroupLayout.Alignment.LEADING).addComponent(this.familyNameTextField)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.firstNameSuffixLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.firstNameSuffixTextField, -2, -1, -2)))));
        nameEditorPanelLayout.setVerticalGroup(nameEditorPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(nameEditorPanelLayout.createSequentialGroup().addGroup(nameEditorPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.nameTypeComboBox, -2, -1, -2).addComponent(this.nameTypeLabel).addComponent(this.jCheckBox1)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(nameEditorPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.firstNamePrefixTextField, -2, -1, -2).addComponent(this.firstNameTextField, -2, -1, -2).addComponent(this.firstNamePrefixLabel).addComponent(this.firstnameLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(nameEditorPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.familyNamePrefixLabel).addComponent(this.familyNamePrefixTextField, -2, -1, -2).addComponent(this.familyNameTextField, -2, -1, -2).addComponent(this.firstNameSuffixTextField, -2, -1, -2).addComponent(this.familyNameLabel).addComponent(this.firstNameSuffixLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(nameEditorPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.nicknameLabel).addComponent(this.nicknameTextField, -2, -1, -2))));
        GroupLayout namePanelLayout = new GroupLayout(this.namePanel);
        this.namePanel.setLayout(namePanelLayout);
        namePanelLayout.setHorizontalGroup(namePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(namePanelLayout.createSequentialGroup().addContainerGap().addComponent(this.nameEditorPanel, -1, -1, Short.MAX_VALUE).addContainerGap()));
        namePanelLayout.setVerticalGroup(namePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(namePanelLayout.createSequentialGroup().addContainerGap().addComponent(this.nameEditorPanel, -1, -1, Short.MAX_VALUE).addContainerGap()));
        this.nameEditorTabbedPane.addTab(NbBundle.getMessage(NameEditorPanel.class, (String)"NameEditorPanel.namePanel.TabConstraints.tabTitle"), new ImageIcon(this.getClass().getResource("/ancestris/modules/editors/genealogyeditor/resources/Name.png")), this.namePanel);
        this.nameEditorTabbedPane.addTab(NbBundle.getMessage(NameEditorPanel.class, (String)"NameEditorPanel.noteCitationsTablePanel.TabConstraints.tabTitle"), new ImageIcon(this.getClass().getResource("/ancestris/modules/editors/genealogyeditor/resources/Note.png")), this.noteCitationsTablePanel);
        this.nameEditorTabbedPane.addTab(NbBundle.getMessage(NameEditorPanel.class, (String)"NameEditorPanel.sourceCitationsTablePanel.TabConstraints.tabTitle"), new ImageIcon(this.getClass().getResource("/ancestris/modules/editors/genealogyeditor/resources/Source.png")), this.sourceCitationsTablePanel);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.nameEditorTabbedPane));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.nameEditorTabbedPane));
    }

    private void jCheckBox1ActionPerformed(ActionEvent evt) {
        if (this.jCheckBox1.isSelected()) {
            this.firstNamePrefixLabel.setVisible(true);
            this.firstNamePrefixTextField.setVisible(true);
            this.familyNamePrefixLabel.setVisible(true);
            this.familyNamePrefixTextField.setVisible(true);
            this.firstNameSuffixLabel.setVisible(true);
            this.firstNameSuffixTextField.setVisible(true);
        } else {
            this.firstNamePrefixLabel.setVisible(false);
            this.firstNamePrefixTextField.setVisible(false);
            this.familyNamePrefixLabel.setVisible(false);
            this.familyNamePrefixTextField.setVisible(false);
            this.firstNameSuffixLabel.setVisible(false);
            this.firstNameSuffixTextField.setVisible(false);
        }
        this.revalidate();
    }

    private void nameTypeComboBoxActionPerformed(ActionEvent evt) {
        this.nameTypeModified = true;
        this.changeSupport.fireChangeEvent();
    }

    public void set(Indi mRoot, PropertyName mName) {
        this.mRoot = mRoot;
        this.mName = mName;
        this.changeSupport.mute();
        String version = mRoot.getGedcom().getGrammar().getVersion();
        if (version.equals("5.5")) {
            this.nameTypeLabel.setVisible(false);
            this.nameTypeComboBox.setVisible(false);
        }
        if (mName != null) {
            Property nameType = mName.getProperty("TYPE");
            if (nameType != null) {
                this.nameTypeComboBox.setSelectedItem(nameType.getValue());
            } else {
                this.nameTypeComboBox.setSelectedIndex(1);
            }
            this.nameTypeModified = false;
            Property firstnamePrefix = mName.getProperty("NPFX");
            this.firstNamePrefixTextField.setText(firstnamePrefix != null ? firstnamePrefix.getValue() : "");
            this.firstNamePrefixModified = false;
            Property givenName = mName.getProperty("GIVN");
            this.firstNameTextField.setText(givenName != null ? givenName.getValue() : mName.getFirstName());
            this.firstNameModified = false;
            Property firstNameSuffix = mName.getProperty("NSFX");
            this.firstNameSuffixTextField.setText(firstNameSuffix != null ? firstNameSuffix.getValue() : "");
            this.firstNameSuffixModified = false;
            Property familyNamePrefix = mName.getProperty("SPFX");
            this.familyNamePrefixTextField.setText(familyNamePrefix != null ? familyNamePrefix.getValue() : "");
            this.familyNamePrefixModified = false;
            Property familyName = mName.getProperty("SURN");
            if (familyName != null) {
                this.familyNameTextField.setText(familyName.getValue());
            } else {
                this.familyNameTextField.setText(mName.getLastName());
            }
            this.familyNameModified = false;
            Property nickName = mName.getProperty("NICK");
            this.nicknameTextField.setText(nickName != null ? nickName.getValue() : "");
            this.nicknameModified = false;
            if (firstnamePrefix != null || firstNameSuffix != null || familyNamePrefix != null) {
                this.jCheckBox1.setSelected(true);
                this.firstNamePrefixLabel.setVisible(true);
                this.firstNamePrefixTextField.setVisible(true);
                this.familyNamePrefixLabel.setVisible(true);
                this.familyNamePrefixTextField.setVisible(true);
                this.firstNameSuffixLabel.setVisible(true);
                this.firstNameSuffixTextField.setVisible(true);
            } else {
                this.jCheckBox1.setSelected(false);
                this.firstNamePrefixLabel.setVisible(false);
                this.firstNamePrefixTextField.setVisible(false);
                this.familyNamePrefixLabel.setVisible(false);
                this.familyNamePrefixTextField.setVisible(false);
                this.firstNameSuffixLabel.setVisible(false);
                this.firstNameSuffixTextField.setVisible(false);
            }
            this.noteCitationsTablePanel.set((Property)mName, Arrays.asList(mName.getProperties("NOTE")));
            this.sourceCitationsTablePanel.set((Property)mName, Arrays.asList(mName.getProperties("SOUR")));
        } else {
            this.nameTypeComboBox.setSelectedIndex(1);
            this.nameTypeModified = false;
            this.jCheckBox1.setSelected(false);
            this.firstNamePrefixLabel.setVisible(false);
            this.firstNamePrefixTextField.setVisible(false);
            this.familyNamePrefixLabel.setVisible(false);
            this.familyNamePrefixTextField.setVisible(false);
            this.firstNameSuffixLabel.setVisible(false);
            this.firstNameSuffixTextField.setVisible(false);
        }
        this.revalidate();
        this.changeSupport.setChanged(false);
        this.changeSupport.unmute();
    }

    public boolean hasChanged() {
        return this.changeSupport.hasChanged();
    }

    public void addChangeListener(ChangeListener l) {
        this.changeSupport.addChangeListener(l);
    }

    public void removeChangeListener(ChangeListener l) {
        this.changeSupport.removeChangeListener(l);
    }

    public void commit() {
        String version = this.mRoot.getGedcom().getGrammar().getVersion();
        if (this.hasChanged()) {
            Property familyName;
            Property givenName;
            logger.log(Level.INFO, "Commiting ...");
            if (this.mName == null) {
                logger.log(Level.INFO, "Add property mName");
                this.mName = (PropertyName)this.mRoot.addProperty("NAME", "");
            }
            if (version.equals("5.5.1") && this.nameTypeModified) {
                Property nameType = this.mName.getProperty("TYPE");
                if (nameType == null) {
                    logger.log(Level.INFO, "Add property TYPE");
                    this.mName.addProperty("TYPE", this.nameTypeComboBox.getSelectedItem().toString());
                } else {
                    logger.log(Level.INFO, "Update property TYPE");
                    nameType.setValue(this.nameTypeComboBox.getSelectedItem().toString());
                }
            }
            if (this.firstNamePrefixModified) {
                Property firstnamePrefix = this.mName.getProperty("NPFX");
                if (firstnamePrefix == null) {
                    logger.log(Level.INFO, "Add property NPFX");
                    this.mName.addProperty("NPFX", this.firstNamePrefixTextField.getText().trim());
                } else {
                    logger.log(Level.INFO, "Update property NPFX");
                    firstnamePrefix.setValue(this.firstNamePrefixTextField.getText().trim());
                }
            }
            if (this.firstNameModified && (givenName = this.mName.getProperty("GIVN")) != null) {
                logger.log(Level.INFO, "Update property GIVN");
                givenName.setValue(this.firstNameTextField.getText().trim());
            }
            if (this.firstNameSuffixModified) {
                Property firstNameSuffix = this.mName.getProperty("NSFX");
                if (firstNameSuffix == null) {
                    logger.log(Level.INFO, "Add property NSFX");
                    this.mName.addProperty("NSFX", this.firstNameSuffixTextField.getText().trim());
                } else {
                    logger.log(Level.INFO, "Update property NSFX");
                    firstNameSuffix.setValue(this.firstNameSuffixTextField.getText().trim());
                }
            }
            if (this.familyNamePrefixModified) {
                Property familyNamePrefix = this.mName.getProperty("SPFX");
                if (familyNamePrefix == null) {
                    logger.log(Level.INFO, "Add property SPFX");
                    this.mName.addProperty("SPFX", this.familyNamePrefixTextField.getText().trim());
                } else {
                    logger.log(Level.INFO, "Update property SPFX");
                    familyNamePrefix.setValue(this.familyNamePrefixTextField.getText().trim());
                }
            }
            if (this.familyNameModified && (familyName = this.mName.getProperty("SURN")) != null) {
                logger.log(Level.INFO, "Update property SURN");
                familyName.setValue(this.familyNameTextField.getText().trim());
            }
            if (this.nicknameModified) {
                Property nickname = this.mName.getProperty("NICK");
                if (nickname == null) {
                    logger.log(Level.INFO, "Update property NICK");
                    this.mName.addProperty("NICK", this.nicknameTextField.getText().trim());
                } else {
                    logger.log(Level.INFO, "Update property NICK");
                    nickname.setValue(this.nicknameTextField.getText().trim());
                }
            }
            this.mName.setName(this.firstNamePrefixTextField.getText().trim(), this.firstNameTextField.getText().trim(), this.familyNamePrefixTextField.getText().trim(), this.familyNameTextField.getText().trim(), this.firstNameSuffixTextField.getText().trim(), false);
            logger.log(Level.INFO, "... finished");
        }
        this.changeSupport.setChanged(false);
    }

    PropertyName get() {
        return this.mName;
    }

    public JTabbedPane getNameEditorTabbedPane() {
        return this.nameEditorTabbedPane;
    }
}

