/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.editors.genealogyeditor.panels;

import ancestris.modules.editors.genealogyeditor.editors.IndividualEditor;
import ancestris.modules.editors.genealogyeditor.models.ChildrenTreeTableModel;
import ancestris.modules.editors.genealogyeditor.panels.IndividualsTablePanel;
import ancestris.util.swing.DialogManager;
import genj.gedcom.Context;
import genj.gedcom.Entity;
import genj.gedcom.Fam;
import genj.gedcom.Gedcom;
import genj.gedcom.GedcomException;
import genj.gedcom.Indi;
import genj.gedcom.Property;
import genj.gedcom.PropertyChild;
import genj.gedcom.PropertyXRef;
import genj.gedcom.UnitOfWork;
import genj.util.Registry;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.LayoutStyle;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jdesktop.swingx.JXTreeTable;
import org.jdesktop.swingx.decorator.ColorHighlighter;
import org.jdesktop.swingx.decorator.ComponentAdapter;
import org.jdesktop.swingx.decorator.HighlightPredicate;
import org.jdesktop.swingx.decorator.Highlighter;
import org.jdesktop.swingx.decorator.IconHighlighter;
import org.jdesktop.swingx.treetable.TreeTableModel;
import org.openide.DialogDescriptor;
import org.openide.util.ChangeSupport;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class ChildrenTreeTablePanel
extends JPanel {
    private static final Logger logger = Logger.getLogger(ChildrenTreeTablePanel.class.getName(), null);
    private ChildrenTreeTableModel mChildrenTreeTableModel = new ChildrenTreeTableModel();
    private final ChangeListner changeListner = new ChangeListner();
    private final ChangeSupport changeSupport = new ChangeSupport(ChildrenTreeTablePanel.class);
    private Registry mRegistry = Registry.get(ChildrenTreeTablePanel.class);
    private Property mRoot;
    private String mTableId = ChildrenTreeTablePanel.class.getName();
    private Indi mIndividual;
    private PropertyChild mAddedChild = null;
    private JButton addChildrenButton;
    private JScrollPane childrenScrollPane;
    private JToolBar childrenToolBar;
    private JXTreeTable childrenTreeTable;
    private JButton deleteButton;
    private JButton editButton;
    private JButton linkToChildrenButton;

    public ChildrenTreeTablePanel() {
        this.initComponents();
        for (int index = 0; index < this.childrenTreeTable.getColumnModel().getColumnCount(); ++index) {
            int columnSize = this.mRegistry.get(this.mTableId + ".column" + index + ".size", 100);
            this.childrenTreeTable.getColumnModel().getColumn(index).setPreferredWidth(columnSize);
            logger.log(Level.FINE, "setID: table id {0} column index {1} size {2}", new Object[]{this.mTableId, index, columnSize});
        }
        HighlightPredicate MyHighlightPredicate = new HighlightPredicate(){

            public boolean isHighlighted(Component renderer, ComponentAdapter adapter) {
                int rowIndex = adapter.row;
                TreePath path = ChildrenTreeTablePanel.this.childrenTreeTable.getPathForRow(rowIndex);
                Object lastPathComponent = path.getLastPathComponent();
                if (lastPathComponent instanceof DefaultMutableTreeNode) {
                    DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
                    if (node.getUserObject() instanceof PropertyXRef) {
                        Entity entity = ((PropertyXRef)node.getUserObject()).getTargetEntity();
                        return entity.equals(ChildrenTreeTablePanel.this.mRoot);
                    }
                    return false;
                }
                return false;
            }
        };
        HighlightPredicate FamilyIconpredicate = new HighlightPredicate(){

            public boolean isHighlighted(Component renderer, ComponentAdapter adapter) {
                int rowIndex = adapter.row;
                TreePath path = ChildrenTreeTablePanel.this.childrenTreeTable.getPathForRow(rowIndex);
                Object lastPathComponent = path.getLastPathComponent();
                if (lastPathComponent instanceof DefaultMutableTreeNode) {
                    DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
                    if (node.getUserObject() instanceof PropertyXRef) {
                        Entity entity = ((PropertyXRef)node.getUserObject()).getTargetEntity();
                        return entity instanceof Fam;
                    }
                    return false;
                }
                return false;
            }
        };
        this.childrenTreeTable.addHighlighter((Highlighter)new ColorHighlighter(MyHighlightPredicate, this.childrenTreeTable.getBackground(), Color.blue));
        this.childrenTreeTable.addHighlighter((Highlighter)new IconHighlighter(FamilyIconpredicate, (Icon)new ImageIcon("ancestris/modules/editors/genealogyeditor/resources/indi_add.png")));
    }

    private void initComponents() {
        this.childrenScrollPane = new JScrollPane();
        this.childrenTreeTable = new JXTreeTable((TreeTableModel)this.mChildrenTreeTableModel);
        this.childrenToolBar = new JToolBar();
        this.addChildrenButton = new JButton();
        this.linkToChildrenButton = new JButton();
        this.editButton = new JButton();
        this.deleteButton = new JButton();
        this.childrenTreeTable.setEditable(false);
        this.childrenTreeTable.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                ChildrenTreeTablePanel.this.childrenTreeTableMouseClicked(evt);
            }
        });
        this.childrenScrollPane.setViewportView((Component)this.childrenTreeTable);
        this.childrenToolBar.setFloatable(false);
        this.childrenToolBar.setRollover(true);
        this.addChildrenButton.setIcon(new ImageIcon(this.getClass().getResource("/ancestris/modules/editors/genealogyeditor/resources/edit_add.png")));
        this.addChildrenButton.setToolTipText(MessageFormat.format(ResourceBundle.getBundle("ancestris/modules/editors/genealogyeditor/panels/Bundle").getString("ChildrenTreeTablePanel.addChildrenButton.toolTipText"), new Object[0]));
        this.addChildrenButton.setFocusable(false);
        this.addChildrenButton.setHorizontalTextPosition(0);
        this.addChildrenButton.setVerticalTextPosition(3);
        this.addChildrenButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ChildrenTreeTablePanel.this.addChildrenButtonActionPerformed(evt);
            }
        });
        this.childrenToolBar.add(this.addChildrenButton);
        this.linkToChildrenButton.setIcon(new ImageIcon(this.getClass().getResource("/ancestris/modules/editors/genealogyeditor/resources/link_add.png")));
        this.linkToChildrenButton.setText(MessageFormat.format(ResourceBundle.getBundle("ancestris/modules/editors/genealogyeditor/panels/Bundle").getString("ChildrenTreeTablePanel.linkToChildrenButton.text"), new Object[0]));
        this.linkToChildrenButton.setToolTipText(MessageFormat.format(ResourceBundle.getBundle("ancestris/modules/editors/genealogyeditor/panels/Bundle").getString("ChildrenTreeTablePanel.linkToChildrenButton.toolTipText"), new Object[0]));
        this.linkToChildrenButton.setFocusable(false);
        this.linkToChildrenButton.setHorizontalTextPosition(0);
        this.linkToChildrenButton.setVerticalTextPosition(3);
        this.linkToChildrenButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ChildrenTreeTablePanel.this.linkToChildrenButtonActionPerformed(evt);
            }
        });
        this.childrenToolBar.add(this.linkToChildrenButton);
        this.editButton.setIcon(new ImageIcon(this.getClass().getResource("/ancestris/modules/editors/genealogyeditor/resources/edit.png")));
        this.editButton.setToolTipText(NbBundle.getMessage(ChildrenTreeTablePanel.class, (String)"ChildrenTreeTablePanel.editButton.toolTipText"));
        this.editButton.setFocusable(false);
        this.editButton.setHorizontalTextPosition(0);
        this.editButton.setVerticalTextPosition(3);
        this.editButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ChildrenTreeTablePanel.this.editButtonActionPerformed(evt);
            }
        });
        this.childrenToolBar.add(this.editButton);
        this.deleteButton.setIcon(new ImageIcon(this.getClass().getResource("/ancestris/modules/editors/genealogyeditor/resources/edit_delete.png")));
        this.deleteButton.setToolTipText(NbBundle.getMessage(ChildrenTreeTablePanel.class, (String)"ChildrenTreeTablePanel.deleteButton.toolTipText"));
        this.deleteButton.setFocusable(false);
        this.deleteButton.setHorizontalTextPosition(0);
        this.deleteButton.setVerticalTextPosition(3);
        this.deleteButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ChildrenTreeTablePanel.this.deleteButtonActionPerformed(evt);
            }
        });
        this.childrenToolBar.add(this.deleteButton);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.childrenScrollPane, -1, 539, Short.MAX_VALUE).addComponent(this.childrenToolBar, -1, 539, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.childrenToolBar, -2, 25, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.childrenScrollPane, -1, 154, Short.MAX_VALUE)));
    }

    private void editButtonActionPerformed(ActionEvent evt) {
        Indi child;
        Property property;
        DefaultMutableTreeNode dataNode;
        TreeNode parent;
        TreePath path;
        Object node;
        int rowIndex = this.childrenTreeTable.convertRowIndexToModel(this.childrenTreeTable.getSelectedRow());
        Gedcom gedcom = this.mRoot.getGedcom();
        if (rowIndex != -1 && (node = (path = this.childrenTreeTable.getPathForRow(rowIndex)).getLastPathComponent()) instanceof DefaultMutableTreeNode && (parent = (dataNode = (DefaultMutableTreeNode)node).getParent()) instanceof DefaultMutableTreeNode && ((DefaultMutableTreeNode)parent).isRoot() && (property = (Property)dataNode.getUserObject()) instanceof PropertyChild && !(child = ((PropertyChild)property).getChild()).equals(this.mRoot)) {
            IndividualEditor individualEditor = new IndividualEditor();
            individualEditor.setContext(new Context((Entity)child));
            individualEditor.addChangeListener(this.changeListner);
            individualEditor.showPanel();
            individualEditor.removeChangeListener(this.changeListner);
        }
    }

    private void childrenTreeTableMouseClicked(MouseEvent evt) {
        if (evt.getClickCount() >= 2) {
            Indi child;
            Property property;
            DefaultMutableTreeNode dataNode;
            TreeNode parent;
            TreePath path;
            Object node;
            int rowIndex = this.childrenTreeTable.convertRowIndexToModel(this.childrenTreeTable.getSelectedRow());
            Gedcom gedcom = this.mRoot.getGedcom();
            if (rowIndex != -1 && (node = (path = this.childrenTreeTable.getPathForRow(rowIndex)).getLastPathComponent()) instanceof DefaultMutableTreeNode && (parent = (dataNode = (DefaultMutableTreeNode)node).getParent()) instanceof DefaultMutableTreeNode && ((DefaultMutableTreeNode)parent).isRoot() && (property = (Property)dataNode.getUserObject()) instanceof PropertyChild && !(child = ((PropertyChild)property).getChild()).equals(this.mRoot)) {
                IndividualEditor individualEditor = new IndividualEditor();
                individualEditor.setContext(new Context((Entity)child));
                individualEditor.addChangeListener(this.changeListner);
                individualEditor.showPanel();
                individualEditor.removeChangeListener(this.changeListner);
            }
        }
    }

    private void linkToChildrenButtonActionPerformed(ActionEvent evt) {
        Indi selectedIndividual;
        IndividualsTablePanel individualsTablePanel = new IndividualsTablePanel();
        ArrayList<Indi> individualsList = new ArrayList<Indi>(this.mRoot.getGedcom().getIndis());
        individualsTablePanel.setToolBarVisible(false);
        individualsTablePanel.set(this.mRoot, individualsList);
        DialogManager.ADialog individualsTableDialog = new DialogManager.ADialog(NbBundle.getMessage(IndividualsTablePanel.class, (String)"individualsTableDialog.title.select.child"), (JComponent)individualsTablePanel);
        individualsTableDialog.setDialogId(IndividualsTablePanel.class.getName());
        if (individualsTableDialog.show() == DialogDescriptor.OK_OPTION && (selectedIndividual = individualsTablePanel.getSelectedIndividual()) != null) {
            try {
                this.mRoot.getGedcom().doUnitOfWork(new UnitOfWork(){

                    public void perform(Gedcom gedcom) throws GedcomException {
                        PropertyXRef addChild = ((Fam)ChildrenTreeTablePanel.this.mRoot).addChild(selectedIndividual);
                        ChildrenTreeTablePanel.this.mChildrenTreeTableModel.add((PropertyChild)addChild);
                        ChildrenTreeTablePanel.this.childrenTreeTable.expandAll();
                    }
                });
                this.changeListner.stateChanged(null);
            }
            catch (GedcomException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }

    private void addChildrenButtonActionPerformed(ActionEvent evt) {
        Gedcom gedcom = this.mRoot.getGedcom();
        int undoNb = gedcom.getUndoNb();
        try {
            this.mRoot.getGedcom().doUnitOfWork(new UnitOfWork(){

                public void perform(Gedcom gedcom) throws GedcomException {
                    ChildrenTreeTablePanel.this.mIndividual = (Indi)gedcom.createEntity("INDI");
                    String lastName = "";
                    if (((Fam)ChildrenTreeTablePanel.this.mRoot).getHusband() != null) {
                        lastName = ((Fam)ChildrenTreeTablePanel.this.mRoot).getHusband().getLastName();
                    } else if (((Fam)ChildrenTreeTablePanel.this.mRoot).getWife() != null) {
                        lastName = ((Fam)ChildrenTreeTablePanel.this.mRoot).getWife().getLastName();
                    }
                    ChildrenTreeTablePanel.this.mIndividual.setName("", lastName);
                }
            });
            IndividualEditor individualEditor = new IndividualEditor();
            individualEditor.setContext(new Context((Entity)this.mIndividual));
            individualEditor.addChangeListener(this.changeListner);
            if (individualEditor.showPanel()) {
                this.mRoot.getGedcom().doUnitOfWork(new UnitOfWork(){

                    public void perform(Gedcom gedcom) throws GedcomException {
                        ChildrenTreeTablePanel.this.mAddedChild = (PropertyChild)((Fam)ChildrenTreeTablePanel.this.mRoot).addChild(ChildrenTreeTablePanel.this.mIndividual);
                        ChildrenTreeTablePanel.this.mChildrenTreeTableModel.add(ChildrenTreeTablePanel.this.mAddedChild);
                        ChildrenTreeTablePanel.this.childrenTreeTable.expandAll();
                    }
                });
            } else {
                while (gedcom.getUndoNb() > undoNb && gedcom.canUndo()) {
                    gedcom.undoUnitOfWork(false);
                }
            }
            individualEditor.removeChangeListener(this.changeListner);
        }
        catch (GedcomException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    private void deleteButtonActionPerformed(ActionEvent evt) {
        TreePath path;
        Object node;
        int rowIndex = this.childrenTreeTable.convertRowIndexToModel(this.childrenTreeTable.getSelectedRow());
        Gedcom gedcom = this.mRoot.getGedcom();
        if (rowIndex != -1 && (node = (path = this.childrenTreeTable.getPathForRow(rowIndex)).getLastPathComponent()) instanceof DefaultMutableTreeNode) {
            DialogManager createYesNo;
            final DefaultMutableTreeNode dataNode = (DefaultMutableTreeNode)node;
            TreeNode parent = dataNode.getParent();
            if (dataNode.getUserObject() instanceof PropertyChild && parent instanceof DefaultMutableTreeNode && ((DefaultMutableTreeNode)parent).isRoot() && (createYesNo = DialogManager.createYesNo((String)NbBundle.getMessage(ChildrenTreeTablePanel.class, (String)"ChildrenTreeTablePanel.deleteChildConfirmation.title", (Object)((PropertyChild)dataNode.getUserObject()).getChild()), (String)NbBundle.getMessage(ChildrenTreeTablePanel.class, (String)"ChildrenTreeTablePanel.deleteChildConfirmation.text", (Object)((PropertyChild)dataNode.getUserObject()).getChild(), (Object)this.mRoot))).show() == DialogManager.YES_OPTION) {
                try {
                    gedcom.doUnitOfWork(new UnitOfWork(){

                        public void perform(Gedcom gedcom) throws GedcomException {
                            ChildrenTreeTablePanel.this.mRoot.delProperty((Property)((PropertyXRef)dataNode.getUserObject()));
                        }
                    });
                    this.changeListner.stateChanged(null);
                    ((ChildrenTreeTableModel)this.childrenTreeTable.getTreeTableModel()).remove(dataNode);
                    this.childrenTreeTable.expandAll();
                }
                catch (GedcomException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
        }
    }

    public void set(Property root, List<PropertyChild> children) {
        this.mRoot = root;
        ((ChildrenTreeTableModel)this.childrenTreeTable.getTreeTableModel()).clear();
        ((ChildrenTreeTableModel)this.childrenTreeTable.getTreeTableModel()).addAll(children);
        this.childrenTreeTable.expandAll();
        this.childrenTreeTable.getColumnModel().addColumnModelListener(new FamiliesTreeTableTableColumnModelListener());
    }

    public void addChangeListener(ChangeListener l) {
        this.changeSupport.addChangeListener(l);
    }

    public void removeChangeListener(ChangeListener l) {
        this.changeSupport.removeChangeListener(l);
    }

    private class FamiliesTreeTableTableColumnModelListener
    implements TableColumnModelListener {
        private final Logger logger = Logger.getLogger(FamiliesTreeTableTableColumnModelListener.class.getName(), null);

        private FamiliesTreeTableTableColumnModelListener() {
        }

        @Override
        public void columnAdded(TableColumnModelEvent tcme) {
            this.logger.log(Level.FINE, "columnAdded: {0}", tcme.getFromIndex());
        }

        @Override
        public void columnRemoved(TableColumnModelEvent tcme) {
            this.logger.log(Level.FINE, "columnRemoved: {0}", tcme.getFromIndex());
        }

        @Override
        public void columnMoved(TableColumnModelEvent tcme) {
            this.logger.log(Level.FINE, "columnMoved: {0}", tcme.getFromIndex());
        }

        @Override
        public void columnMarginChanged(ChangeEvent ce) {
            this.logger.log(Level.FINE, "columnMarginChanged: {0}", ce.toString());
            for (int index = 0; index < ChildrenTreeTablePanel.this.childrenTreeTable.getColumnCount(); ++index) {
                int preferredWidth = ChildrenTreeTablePanel.this.childrenTreeTable.getColumn(index).getPreferredWidth();
                this.logger.log(Level.FINE, "columnMarginChanged: table id {0} column index {1} size {2}", new Object[]{ChildrenTreeTablePanel.this.mTableId, index, preferredWidth});
                ChildrenTreeTablePanel.this.mRegistry.put(ChildrenTreeTablePanel.this.mTableId + ".column" + index + ".size", preferredWidth);
            }
        }

        @Override
        public void columnSelectionChanged(ListSelectionEvent lse) {
        }
    }

    private class ChangeListner
    implements ChangeListener {
        private ChangeListner() {
        }

        @Override
        public void stateChanged(ChangeEvent ce) {
            ChildrenTreeTablePanel.this.changeSupport.fireChange();
        }
    }
}

