/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.editors.genealogyeditor.models;

import ancestris.modules.editors.genealogyeditor.models.SexComboBoxModel;
import genj.gedcom.Indi;
import java.util.ArrayList;
import java.util.List;
import javax.swing.table.AbstractTableModel;
import org.openide.util.NbBundle;

public class IndividualsTableModel
extends AbstractTableModel {
    private List<Indi> individualsList = new ArrayList<Indi>();
    private String[] columnsName = new String[]{NbBundle.getMessage(IndividualsTableModel.class, (String)"IndividualsTableModel.column.ID.title"), NbBundle.getMessage(IndividualsTableModel.class, (String)"IndividualsTableModel.column.Name.title"), NbBundle.getMessage(IndividualsTableModel.class, (String)"IndividualsTableModel.column.Sex.title"), NbBundle.getMessage(IndividualsTableModel.class, (String)"IndividualsTableModel.column.BirthDate.title"), NbBundle.getMessage(IndividualsTableModel.class, (String)"IndividualsTableModel.column.DeathDate.title")};
    private String[] sex = new String[]{NbBundle.getMessage(SexComboBoxModel.class, (String)"SexComboBoxModel.SexType.UNKNOWN"), NbBundle.getMessage(SexComboBoxModel.class, (String)"SexComboBoxModel.SexType.MALE"), NbBundle.getMessage(SexComboBoxModel.class, (String)"SexComboBoxModel.SexType.FEMALE")};

    @Override
    public int getRowCount() {
        return this.individualsList.size();
    }

    @Override
    public int getColumnCount() {
        return this.columnsName.length;
    }

    @Override
    public Object getValueAt(int row, int column) {
        if (row < this.individualsList.size()) {
            Indi individual = this.individualsList.get(row);
            if (column == 0) {
                return individual.getId();
            }
            if (column == 1) {
                return individual.getName();
            }
            if (column == 2) {
                return this.sex[individual.getSex()];
            }
            if (column == 3) {
                return individual.getBirthAsString();
            }
            if (column == 4) {
                return individual.getDeathAsString();
            }
            return "";
        }
        return "";
    }

    @Override
    public String getColumnName(int col) {
        return this.columnsName[col];
    }

    public void add(Indi individual) {
        this.individualsList.add(individual);
        this.fireTableDataChanged();
    }

    public void addAll(List<Indi> individualsList) {
        this.individualsList.addAll(individualsList);
        this.fireTableDataChanged();
    }

    public void clear(List<Indi> individualsList) {
        this.individualsList.clear();
    }

    public Indi getValueAt(int row) {
        return this.individualsList.get(row);
    }
}

