/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.editors.genealogyeditor.actions;

import ancestris.modules.editors.genealogyeditor.editors.FamilyEditor;
import ancestris.modules.editors.genealogyeditor.editors.IndividualEditor;
import ancestris.modules.editors.genealogyeditor.editors.MultiMediaObjectEditor;
import ancestris.modules.editors.genealogyeditor.editors.NoteEditor;
import ancestris.modules.editors.genealogyeditor.editors.RepositoryEditor;
import ancestris.modules.editors.genealogyeditor.editors.SourceEditor;
import ancestris.modules.editors.genealogyeditor.editors.SubmitterEditor;
import genj.gedcom.Context;
import genj.gedcom.Entity;
import genj.gedcom.Fam;
import genj.gedcom.Gedcom;
import genj.gedcom.Indi;
import genj.gedcom.Media;
import genj.gedcom.Note;
import genj.gedcom.Repository;
import genj.gedcom.Source;
import genj.gedcom.Submitter;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import org.openide.loaders.DataObject;
import org.openide.util.Utilities;

public final class GenealogyEditorEditAction
implements ActionListener {
    private final DataObject context;

    public GenealogyEditorEditAction(DataObject context) {
        this.context = context;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Context context = (Context)Utilities.actionsGlobalContext().lookup(Context.class);
        if (context != null) {
            Entity entity = context.getEntity();
            Gedcom gedcom = entity.getGedcom();
            if (entity instanceof Indi) {
                IndividualEditor individualEditor = new IndividualEditor();
                individualEditor.setContext(context);
                individualEditor.showPanel();
            } else if (entity instanceof Fam) {
                FamilyEditor familyEditor = new FamilyEditor();
                familyEditor.setContext(context);
                familyEditor.showPanel();
            } else if (entity instanceof Note) {
                NoteEditor noteEditor = new NoteEditor();
                noteEditor.setContext(context);
                noteEditor.showPanel();
            } else if (entity instanceof Media) {
                MultiMediaObjectEditor multiMediaObjectEditor = new MultiMediaObjectEditor();
                multiMediaObjectEditor.setContext(context);
                multiMediaObjectEditor.showPanel();
            } else if (entity instanceof Source) {
                SourceEditor sourceEditor = new SourceEditor();
                sourceEditor.setContext(context);
                sourceEditor.showPanel();
            } else if (entity instanceof Repository) {
                RepositoryEditor repositoryEditor = new RepositoryEditor();
                repositoryEditor.setContext(context);
                repositoryEditor.showPanel();
            } else if (entity instanceof Submitter) {
                SubmitterEditor submitterEditor = new SubmitterEditor();
                submitterEditor.setContext(context);
                submitterEditor.showPanel();
            }
        }
    }
}

