/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.editors.standard.tools;

import ancestris.modules.editors.standard.tools.SourceWrapper;
import ancestris.view.SelectionDispatcher;
import genj.gedcom.Context;
import genj.gedcom.Entity;
import genj.gedcom.Gedcom;
import genj.gedcom.GedcomException;
import genj.gedcom.Property;
import genj.gedcom.PropertyXRef;
import genj.gedcom.Repository;
import genj.gedcom.Source;
import genj.gedcom.UnitOfWork;
import genj.util.ReferenceSet;
import genj.util.Registry;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.TreeSet;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.LayoutStyle;
import javax.swing.ListCellRenderer;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.JTextComponent;
import org.openide.awt.Mnemonics;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.windows.WindowManager;

public class RepoChooser
extends JPanel
implements DocumentListener {
    private static int THUMB_WIDTH = 120;
    private static int THUMB_HEIGHT = 140;
    private Registry registry = null;
    private ThumbComparator thumbComparator = new ThumbComparator();
    private TreeSet<RepoThumb> allRepo = new TreeSet<RepoThumb>(this.thumbComparator);
    private DefaultListModel filteredModel = new DefaultListModel();
    private DefaultListModel sourceListModel = new DefaultListModel();
    private DefaultComboBoxModel mediaListModel = new DefaultComboBoxModel();
    private Gedcom gedcom = null;
    private SourceWrapper source = null;
    private Repository repo = null;
    private JButton okButton = null;
    private JButton cancelButton = null;
    private boolean isBusy = false;
    private JLabel filterLabel;
    private JButton jButtonCancel;
    private JButton jButtonDelete;
    private JButton jButtonSave;
    private JComboBox jComboBoxMedia;
    private JLabel jLabel1;
    private JLabel jLabelAddress;
    private JLabel jLabelCaln;
    private JLabel jLabelMedia;
    private JLabel jLabelName;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPaneRepo;
    private JSplitPane jSplitPane;
    private JTextField jTextAddress;
    private JTextField jTextCaln;
    private JTextField jTextCity;
    private JTextField jTextCountry;
    private JTextField jTextName;
    private JTextField jTextZip;
    private JScrollPane noteScrollPane;
    private JTextArea noteText;
    private JList repoList;
    private JList sourceList;
    private JLabel sourceListLabel;
    private JTextField textFilter;

    public RepoChooser(Gedcom gedcom, SourceWrapper source, JButton okButton, JButton cancelButton) {
        this.gedcom = gedcom;
        this.source = source;
        this.repo = source != null ? source.getRepo() : null;
        this.okButton = okButton;
        this.cancelButton = cancelButton;
        this.createRepoThumbs();
        this.registry = Registry.get(this.getClass());
        this.initComponents();
        this.setPreferredSize(new Dimension(this.registry.get("repoWindowWidth", this.getPreferredSize().width), this.registry.get("repoWindowHeight", this.getPreferredSize().height)));
        this.jSplitPane.setDividerLocation(this.registry.get("repoSplitDividerLocation", this.jSplitPane.getDividerLocation()));
        this.repoList.setCellRenderer(new ListEntryCellRenderer());
        this.textFilter.getDocument().addDocumentListener(new DocumentListener(){

            public void insertUpdate(DocumentEvent e) {
                this.filter();
            }

            public void removeUpdate(DocumentEvent e) {
                this.filter();
            }

            public void changedUpdate(DocumentEvent e) {
            }

            private void filter() {
                RepoChooser.this.filterModel(RepoChooser.this.textFilter.getText());
            }
        });
        this.addListeners();
        this.setHotKeys();
        Thread repoThread = new Thread(){

            public void run() {
                RepoChooser.this.displayRepoThumbs();
                RepoChooser.this.selectRepo(RepoChooser.this.repo);
            }
        };
        repoThread.setName("Repo reading thread");
        repoThread.start();
    }

    private void addListeners() {
        this.jTextName.getDocument().addDocumentListener(this);
        this.jTextAddress.getDocument().addDocumentListener(this);
        this.jTextZip.getDocument().addDocumentListener(this);
        this.jTextCity.getDocument().addDocumentListener(this);
        this.jTextCountry.getDocument().addDocumentListener(this);
        this.noteText.getDocument().addDocumentListener(this);
        this.jTextCaln.getDocument().addDocumentListener(this);
        ((JTextComponent)this.jComboBoxMedia.getEditor().getEditorComponent()).getDocument().addDocumentListener(this);
    }

    private void setHotKeys() {
        KeyStroke enterStroke = KeyStroke.getKeyStroke(10, 0);
        AbstractAction enterAction = new AbstractAction(){

            public void actionPerformed(ActionEvent evt) {
                if (RepoChooser.this.jButtonSave.isEnabled()) {
                    RepoChooser.this.jButtonSaveActionPerformed(evt);
                } else {
                    RepoChooser.this.okButton.doClick();
                }
            }
        };
        this.registerKeyboardAction(enterAction, enterStroke, 1);
        KeyStroke escStroke = KeyStroke.getKeyStroke(27, 0);
        AbstractAction escAction = new AbstractAction(){

            public void actionPerformed(ActionEvent evt) {
                if (RepoChooser.this.jButtonCancel.isEnabled()) {
                    RepoChooser.this.jButtonCancelActionPerformed(evt);
                } else {
                    RepoChooser.this.cancelButton.doClick();
                }
            }
        };
        this.registerKeyboardAction(escAction, escStroke, 1);
    }

    private void refreshAll(Repository selectedRepo) {
        this.createRepoThumbs();
        this.displayRepoThumbs();
        this.selectRepo(selectedRepo);
    }

    private void selectRepo(Repository selectedRepo) {
        RepoThumb selectedRepotb = null;
        for (RepoThumb repotb : this.allRepo) {
            if (repotb.entity == null && selectedRepo == null) {
                selectedRepotb = repotb;
                break;
            }
            if (repotb.entity == null || selectedRepo == null || !repotb.entity.getId().equals(selectedRepo.getId())) continue;
            selectedRepotb = repotb;
            break;
        }
        if (selectedRepotb != null) {
            final RepoThumb repotb = selectedRepotb;
            WindowManager.getDefault().invokeWhenUIReady(new Runnable(){

                public void run() {
                    RepoChooser.this.repoList.setSelectedValue(repotb, true);
                }
            });
        }
    }

    private void clearForm() {
        this.jTextName.setText("");
        this.jTextAddress.setText("");
        this.jTextZip.setText("");
        this.jTextCity.setText("");
        this.jTextCountry.setText("");
        this.noteText.setText("");
        this.sourceListModel.removeAllElements();
        this.sourceListLabel.setText(NbBundle.getMessage(this.getClass(), (String)"RepoChooser.sourceListLabel.text", (Object)this.sourceListModel.getSize()));
        this.jTextCaln.setText("");
        ((JTextComponent)this.jComboBoxMedia.getEditor().getEditorComponent()).setText("");
    }

    private void displayRepoDetails(Repository repo, SourceWrapper source) {
        this.isBusy = true;
        this.clearForm();
        if (repo == null) {
            this.isBusy = false;
            this.enableButtons(false);
            return;
        }
        this.jTextName.setText(repo.getRepositoryName());
        this.jTextName.setCaretPosition(0);
        Property pAddr = repo.getProperty("ADDR");
        this.jTextAddress.setText(pAddr != null ? pAddr.getDisplayValue() : "");
        this.jTextAddress.setCaretPosition(0);
        if (pAddr != null) {
            Property prop = pAddr.getProperty("POST");
            this.jTextZip.setText(prop != null ? prop.getDisplayValue() : "");
            prop = pAddr.getProperty("CITY");
            this.jTextCity.setText(prop != null ? prop.getDisplayValue() : "");
            prop = pAddr.getProperty("CTRY");
            this.jTextCountry.setText(prop != null ? prop.getDisplayValue() : "");
            this.jTextZip.setCaretPosition(0);
            this.jTextCity.setCaretPosition(0);
            this.jTextCountry.setCaretPosition(0);
        } else {
            this.jTextZip.setText("");
            this.jTextCity.setText("");
            this.jTextCountry.setText("");
        }
        Property pNote = repo.getProperty("NOTE");
        this.noteText.setText(pNote != null ? pNote.getDisplayValue() : "");
        this.noteText.setCaretPosition(0);
        this.getSourceList(repo);
        this.sourceListLabel.setText(NbBundle.getMessage(this.getClass(), (String)"RepoChooser.sourceListLabel.text", (Object)this.sourceListModel.getSize()));
        this.sourceList.setModel(this.sourceListModel);
        int selectedSource = 0;
        if (source != null && source.getRepo() == repo) {
            for (int i = 0; i < this.sourceListModel.getSize(); ++i) {
                Entity ent = (Entity)this.sourceListModel.getElementAt(i);
                if (ent != source.getTargetSource()) continue;
                selectedSource = i;
                break;
            }
        }
        this.getMediaList();
        this.jComboBoxMedia.setModel(this.mediaListModel);
        if (!this.sourceListModel.isEmpty()) {
            this.sourceList.setSelectedIndex(selectedSource);
        } else {
            ((JTextComponent)this.jComboBoxMedia.getEditor().getEditorComponent()).setText("");
        }
        this.isBusy = false;
        this.enableButtons(false);
    }

    private DefaultListModel getSourceList(Repository repo) {
        this.sourceListModel.removeAllElements();
        ArrayList<Entity> sources = new ArrayList<Entity>();
        Entity[] ents = PropertyXRef.getReferences((Entity)repo);
        for (Entity ent : ents) {
            sources.add(ent);
        }
        Collections.sort(sources, new Comparator<Entity>(){

            @Override
            public int compare(Entity e1, Entity e2) {
                return e1.toString(true).compareTo(e2.toString(true));
            }
        });
        for (Entity ent : sources) {
            this.sourceListModel.addElement(ent);
        }
        return this.sourceListModel;
    }

    private DefaultComboBoxModel getMediaList() {
        ReferenceSet refs = this.gedcom.getReferenceSet("MEDI");
        this.mediaListModel.removeAllElements();
        List keys = refs.getKeys();
        Collections.sort(keys, new Comparator<String>(){

            @Override
            public int compare(String s1, String s2) {
                return s1.toLowerCase().compareTo(s2.toLowerCase());
            }
        });
        for (String key : keys) {
            this.mediaListModel.addElement(key);
        }
        return this.mediaListModel;
    }

    private void initComponents() {
        this.jSplitPane = new JSplitPane();
        this.jPanel1 = new JPanel();
        this.jLabelName = new JLabel();
        this.jTextName = new JTextField();
        this.jLabelAddress = new JLabel();
        this.jTextAddress = new JTextField();
        this.jTextZip = new JTextField();
        this.jTextCity = new JTextField();
        this.jTextCountry = new JTextField();
        this.noteScrollPane = new JScrollPane();
        this.noteText = new JTextArea();
        this.sourceListLabel = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.sourceList = new JList();
        this.jLabelCaln = new JLabel();
        this.jTextCaln = new JTextField();
        this.jLabelMedia = new JLabel();
        this.jComboBoxMedia = new JComboBox();
        this.jButtonSave = new JButton();
        this.jButtonCancel = new JButton();
        this.jButtonDelete = new JButton();
        this.jPanel2 = new JPanel();
        this.filterLabel = new JLabel();
        this.textFilter = new JTextField();
        this.jScrollPaneRepo = new JScrollPane();
        this.repoList = new JList(this.filteredModel);
        this.jLabel1 = new JLabel();
        this.setToolTipText(NbBundle.getMessage(RepoChooser.class, (String)"RepoChooser.toolTipText"));
        this.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent evt) {
                RepoChooser.this.formComponentResized(evt);
            }
        });
        this.jSplitPane.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                RepoChooser.this.jSplitPanePropertyChange(evt);
            }
        });
        this.jPanel1.setBorder(null);
        this.jPanel1.setPreferredSize(new Dimension(250, 383));
        Mnemonics.setLocalizedText((JLabel)this.jLabelName, (String)NbBundle.getMessage(RepoChooser.class, (String)"RepoChooser.jLabelName.text"));
        this.jTextName.setText(NbBundle.getMessage(RepoChooser.class, (String)"RepoChooser.jTextName.text"));
        Mnemonics.setLocalizedText((JLabel)this.jLabelAddress, (String)NbBundle.getMessage(RepoChooser.class, (String)"RepoChooser.jLabelAddress.text"));
        this.jTextAddress.setText(NbBundle.getMessage(RepoChooser.class, (String)"RepoChooser.jTextAddress.text"));
        this.jTextAddress.setToolTipText(NbBundle.getMessage(RepoChooser.class, (String)"RepoChooser.jTextAddress.toolTipText"));
        this.jTextZip.setText(NbBundle.getMessage(RepoChooser.class, (String)"RepoChooser.jTextZip.text"));
        this.jTextZip.setToolTipText(NbBundle.getMessage(RepoChooser.class, (String)"RepoChooser.jTextZip.toolTipText"));
        this.jTextZip.setPreferredSize(new Dimension(50, 27));
        this.jTextCity.setText(NbBundle.getMessage(RepoChooser.class, (String)"RepoChooser.jTextCity.text"));
        this.jTextCity.setToolTipText(NbBundle.getMessage(RepoChooser.class, (String)"RepoChooser.jTextCity.toolTipText"));
        this.jTextCity.setPreferredSize(new Dimension(126, 27));
        this.jTextCountry.setText(NbBundle.getMessage(RepoChooser.class, (String)"RepoChooser.jTextCountry.text"));
        this.jTextCountry.setToolTipText(NbBundle.getMessage(RepoChooser.class, (String)"RepoChooser.jTextCountry.toolTipText"));
        this.noteScrollPane.setPreferredSize(new Dimension(188, 93));
        this.noteText.setColumns(20);
        this.noteText.setLineWrap(true);
        this.noteText.setRows(3);
        this.noteText.setText(NbBundle.getMessage(RepoChooser.class, (String)"RepoChooser.noteText.text"));
        this.noteText.setToolTipText(NbBundle.getMessage(RepoChooser.class, (String)"RepoChooser.noteText.toolTipText"));
        this.noteText.setWrapStyleWord(true);
        this.noteScrollPane.setViewportView(this.noteText);
        this.sourceListLabel.setFont(new Font("DejaVu Sans", 1, 12));
        this.sourceListLabel.setHorizontalAlignment(0);
        Mnemonics.setLocalizedText((JLabel)this.sourceListLabel, (String)NbBundle.getMessage(RepoChooser.class, (String)"RepoChooser.sourceListLabel.text"));
        this.sourceListLabel.setToolTipText(NbBundle.getMessage(RepoChooser.class, (String)"RepoChooser.sourceListLabel.toolTipText"));
        this.sourceListLabel.setVerticalAlignment(1);
        this.sourceListLabel.setBorder(null);
        this.sourceList.setModel(this.sourceListModel);
        this.sourceList.setSelectionMode(0);
        this.sourceList.setToolTipText(NbBundle.getMessage(RepoChooser.class, (String)"RepoChooser.sourceList.toolTipText"));
        this.sourceList.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent evt) {
                RepoChooser.this.sourceListMousePressed(evt);
            }
        });
        this.sourceList.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent evt) {
                RepoChooser.this.sourceListValueChanged(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.sourceList);
        Mnemonics.setLocalizedText((JLabel)this.jLabelCaln, (String)NbBundle.getMessage(RepoChooser.class, (String)"RepoChooser.jLabelCaln.text"));
        this.jTextCaln.setText(NbBundle.getMessage(RepoChooser.class, (String)"RepoChooser.jTextCaln.text"));
        Mnemonics.setLocalizedText((JLabel)this.jLabelMedia, (String)NbBundle.getMessage(RepoChooser.class, (String)"RepoChooser.jLabelMedia.text"));
        this.jComboBoxMedia.setEditable(true);
        this.jComboBoxMedia.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        Mnemonics.setLocalizedText((AbstractButton)this.jButtonSave, (String)NbBundle.getMessage(RepoChooser.class, (String)"RepoChooser.jButtonSave.text"));
        this.jButtonSave.setToolTipText(NbBundle.getMessage(RepoChooser.class, (String)"RepoChooser.jButtonSave.toolTipText"));
        this.jButtonSave.setEnabled(false);
        this.jButtonSave.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                RepoChooser.this.jButtonSaveActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.jButtonCancel, (String)NbBundle.getMessage(RepoChooser.class, (String)"RepoChooser.jButtonCancel.text"));
        this.jButtonCancel.setToolTipText(NbBundle.getMessage(RepoChooser.class, (String)"RepoChooser.jButtonCancel.toolTipText"));
        this.jButtonCancel.setEnabled(false);
        this.jButtonCancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                RepoChooser.this.jButtonCancelActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.jButtonDelete, (String)NbBundle.getMessage(RepoChooser.class, (String)"RepoChooser.jButtonDelete.text"));
        this.jButtonDelete.setToolTipText(NbBundle.getMessage(RepoChooser.class, (String)"RepoChooser.jButtonDelete.toolTipText"));
        this.jButtonDelete.setEnabled(false);
        this.jButtonDelete.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                RepoChooser.this.jButtonDeleteActionPerformed(evt);
            }
        });
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, GroupLayout.Alignment.TRAILING, -2, 0, Short.MAX_VALUE).addComponent(this.sourceListLabel, -1, -1, Short.MAX_VALUE).addComponent(this.noteScrollPane, -1, -1, Short.MAX_VALUE).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabelAddress).addComponent(this.jLabelName)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jTextZip, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTextCity, -2, 1, Short.MAX_VALUE)).addComponent(this.jTextName).addComponent(this.jTextAddress).addComponent(this.jTextCountry))).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabelCaln).addComponent(this.jLabelMedia)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jTextCaln).addComponent(this.jComboBoxMedia, 0, -1, Short.MAX_VALUE))).addGroup(GroupLayout.Alignment.TRAILING, jPanel1Layout.createSequentialGroup().addGap(30, 30, 30).addComponent(this.jButtonSave).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonCancel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonDelete))).addContainerGap()));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabelName).addComponent(this.jTextName, -2, -1, -2)).addGap(2, 2, 2).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabelAddress).addComponent(this.jTextAddress, -2, -1, -2)).addGap(2, 2, 2).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jTextZip, -2, -1, -2).addComponent(this.jTextCity, -2, -1, -2)).addGap(2, 2, 2).addComponent(this.jTextCountry, -2, -1, -2).addGap(2, 2, 2).addComponent(this.noteScrollPane, -2, 77, -2).addGap(18, 18, 18).addComponent(this.sourceListLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane1, -1, 129, Short.MAX_VALUE).addGap(2, 2, 2).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabelCaln).addComponent(this.jTextCaln, -2, -1, -2)).addGap(2, 2, 2).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabelMedia).addComponent(this.jComboBoxMedia, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButtonCancel).addComponent(this.jButtonSave).addComponent(this.jButtonDelete)).addContainerGap()));
        this.jSplitPane.setLeftComponent(this.jPanel1);
        this.jPanel2.setPreferredSize(new Dimension(200, 58));
        Mnemonics.setLocalizedText((JLabel)this.filterLabel, (String)NbBundle.getMessage(RepoChooser.class, (String)"RepoChooser.filterLabel.text"));
        this.textFilter.setText(NbBundle.getMessage(RepoChooser.class, (String)"RepoChooser.textFilter.text"));
        this.repoList.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
        this.repoList.setFont(new Font("DejaVu Sans Condensed", 0, 10));
        this.repoList.setSelectionMode(0);
        this.repoList.setLayoutOrientation(2);
        this.repoList.setVisibleRowCount(-1);
        this.repoList.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                RepoChooser.this.repoListMouseClicked(evt);
            }
        });
        this.repoList.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent evt) {
                RepoChooser.this.repoListValueChanged(evt);
            }
        });
        this.jScrollPaneRepo.setViewportView(this.repoList);
        this.jLabel1.setFont(new Font("DejaVu Sans", 0, 10));
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(RepoChooser.class, (String)"RepoChooser.jLabel1.text"));
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPaneRepo).addGroup(jPanel2Layout.createSequentialGroup().addComponent(this.filterLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.textFilter, -1, 295, Short.MAX_VALUE)))).addGroup(jPanel2Layout.createSequentialGroup().addGap(12, 12, 12).addComponent(this.jLabel1))).addContainerGap()));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addGap(6, 6, 6).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.filterLabel).addComponent(this.textFilter, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPaneRepo, -1, 410, Short.MAX_VALUE).addGap(0, 0, 0).addComponent(this.jLabel1, -2, -1, -2)));
        this.jSplitPane.setRightComponent(this.jPanel2);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jSplitPane, GroupLayout.Alignment.TRAILING, -1, 652, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jSplitPane, GroupLayout.Alignment.TRAILING, -1, 464, Short.MAX_VALUE));
    }

    private void repoListValueChanged(ListSelectionEvent evt) {
        this.displaySelection();
    }

    private void repoListMouseClicked(MouseEvent evt) {
        if (evt.getClickCount() == 2) {
            this.okButton.doClick();
        }
    }

    private void formComponentResized(ComponentEvent evt) {
        this.registry.put("repoWindowWidth", evt.getComponent().getWidth());
        this.registry.put("repoWindowHeight", evt.getComponent().getHeight());
    }

    private void jSplitPanePropertyChange(PropertyChangeEvent evt) {
        this.registry.put("repoSplitDividerLocation", this.jSplitPane.getDividerLocation());
    }

    private void sourceListValueChanged(ListSelectionEvent evt) {
        Property pRepo;
        if (this.sourceList.getSelectedIndex() == -1) {
            return;
        }
        this.isBusy = true;
        Source selectedSource = (Source)this.sourceListModel.getElementAt(this.sourceList.getSelectedIndex());
        if (selectedSource != null && (pRepo = selectedSource.getProperty("REPO")) != null) {
            Property pCaln = pRepo.getProperty("CALN");
            String strCaln = pCaln != null ? pCaln.getDisplayValue() : "";
            String strMedi = "";
            JTextComponent jTextMedia = (JTextComponent)this.jComboBoxMedia.getEditor().getEditorComponent();
            if (pCaln != null) {
                Property pMedi = pCaln.getProperty("MEDI");
                strMedi = pMedi != null ? pMedi.getDisplayValue() : "";
            }
            this.jTextCaln.setText(strCaln);
            jTextMedia.setText(strMedi);
        }
        this.isBusy = false;
    }

    private void sourceListMousePressed(MouseEvent evt) {
        if (evt.getButton() == 3 && this.sourceList.getSelectedIndex() != -1) {
            Source selectedSource = (Source)this.sourceListModel.getElementAt(this.sourceList.getSelectedIndex());
            JPopupMenu menu = new JPopupMenu();
            JMenuItem menuItem = new JMenuItem(NbBundle.getMessage(this.getClass(), (String)"EditEntity", (Object)selectedSource.toString(true)));
            menu.add(menuItem);
            Source finalEntity = selectedSource;
            menuItem.addActionListener(new ActionListener((Entity)finalEntity){
                final /* synthetic */ Entity val$finalEntity;
                {
                    this.val$finalEntity = entity;
                }

                public void actionPerformed(ActionEvent ae) {
                    RepoChooser.this.cancelButton.doClick();
                    SelectionDispatcher.fireSelection((Context)new Context(this.val$finalEntity));
                }
            });
            menu.show(this.sourceList, evt.getX(), evt.getY());
        }
    }

    private void jButtonSaveActionPerformed(ActionEvent evt) {
        if (this.gedcom.isWriteLocked()) {
            this.commit();
        } else {
            try {
                this.gedcom.doUnitOfWork(new UnitOfWork(){

                    public void perform(Gedcom gedcom) throws GedcomException {
                        RepoChooser.this.commit();
                    }
                });
            }
            catch (GedcomException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        this.displaySelection();
    }

    private void jButtonDeleteActionPerformed(ActionEvent evt) {
        if (this.gedcom.isWriteLocked()) {
            this.delete();
        } else {
            try {
                this.gedcom.doUnitOfWork(new UnitOfWork(){

                    public void perform(Gedcom gedcom) throws GedcomException {
                        RepoChooser.this.delete();
                    }
                });
            }
            catch (GedcomException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }

    private void createRepoThumbs() {
        this.allRepo.clear();
        this.allRepo.add(new RepoThumb());
        Collection entities = this.gedcom.getEntities("REPO");
        for (Repository entity : entities) {
            RepoThumb repotb = new RepoThumb(entity);
            Entity[] ents = PropertyXRef.getReferences((Entity)entity);
            repotb.setUnused(ents.length == 0);
            this.allRepo.add(repotb);
        }
    }

    private void displayRepoThumbs() {
        this.filteredModel.clear();
        for (RepoThumb item : this.allRepo) {
            this.filteredModel.addElement(item);
        }
    }

    private RepoThumb getSelectedThumb() {
        return (RepoThumb)this.filteredModel.get(this.repoList.getSelectedIndex());
    }

    public boolean isSelectedEntityRepo() {
        RepoThumb repotb = this.getSelectedThumb();
        return repotb == null ? false : repotb.isRepo;
    }

    public Entity getSelectedEntity() {
        RepoThumb repotb = this.getSelectedThumb();
        return repotb == null ? null : repotb.entity;
    }

    public String getSelectedText() {
        RepoThumb repotb = this.getSelectedThumb();
        return repotb == null ? "" : repotb.text;
    }

    public void filterModel(String filter) {
        this.repoList.clearSelection();
        this.repoList.setModel(new DefaultListModel());
        this.filteredModel.clear();
        for (RepoThumb item : this.allRepo) {
            if (!item.text.toLowerCase().contains(filter.toLowerCase())) continue;
            this.filteredModel.addElement(item);
        }
        this.repoList.setModel(this.filteredModel);
    }

    public int getNbRepos() {
        return this.allRepo.size();
    }

    public void insertUpdate(DocumentEvent e) {
        this.enableButtons(true);
    }

    public void removeUpdate(DocumentEvent e) {
        this.enableButtons(true);
    }

    public void changedUpdate(DocumentEvent e) {
        this.enableButtons(true);
    }

    private void enableButtons(boolean flag) {
        if (!this.isBusy) {
            this.jButtonSave.setEnabled(flag);
            this.jButtonCancel.setEnabled(flag);
            this.okButton.setEnabled(!flag && this.okButton.isEnabled());
            this.cancelButton.setEnabled(!flag);
        }
    }

    private void displaySelection() {
        if (!this.repoList.isSelectionEmpty()) {
            RepoThumb repotb = (RepoThumb)this.filteredModel.get(this.repoList.getSelectedIndex());
            this.displayRepoDetails(repotb.entity, this.source);
            this.okButton.setEnabled(true);
            this.jButtonDelete.setEnabled(repotb.entity != null);
        } else {
            this.displayRepoDetails(this.repo, this.source);
            this.okButton.setEnabled(false);
            this.jButtonDelete.setEnabled(false);
        }
    }

    private void commit() {
        Property pRepo;
        Repository repoToSave = null;
        if (!this.repoList.isSelectionEmpty()) {
            RepoThumb repotb = (RepoThumb)this.filteredModel.get(this.repoList.getSelectedIndex());
            repoToSave = repotb.entity;
        } else {
            repoToSave = this.repo;
        }
        if (repoToSave == null) {
            try {
                repoToSave = (Repository)this.gedcom.createEntity("REPO");
            }
            catch (GedcomException ex) {
                Exceptions.printStackTrace((Throwable)ex);
                return;
            }
        }
        String value = this.jTextName.getText().trim();
        Property prop = repoToSave.getProperty("NAME");
        if (prop != null) {
            prop.setValue(value);
        } else {
            repoToSave.addProperty("NAME", value);
        }
        value = this.jTextAddress.getText().trim();
        prop = repoToSave.getProperty("ADDR");
        if (prop != null) {
            prop.setValue(value);
        } else {
            prop = repoToSave.addProperty("ADDR", value);
        }
        value = this.jTextZip.getText().trim();
        Property p = prop.getProperty("POST");
        if (p != null) {
            p.setValue(value);
        } else if (!value.isEmpty()) {
            prop.addProperty("POST", value);
        }
        value = this.jTextCity.getText().trim();
        p = prop.getProperty("CITY");
        if (p != null) {
            p.setValue(value);
        } else if (!value.isEmpty()) {
            prop.addProperty("CITY", value);
        }
        value = this.jTextCountry.getText().trim();
        p = prop.getProperty("CTRY");
        if (p != null) {
            p.setValue(value);
        } else if (!value.isEmpty()) {
            prop.addProperty("CTRY", value);
        }
        value = this.noteText.getText().trim();
        prop = repoToSave.getProperty("NOTE");
        if (prop != null) {
            prop.setValue(value);
        } else if (!value.isEmpty()) {
            repoToSave.addProperty("NOTE", value);
        }
        Source sourceToSave = null;
        if (this.sourceList.getSelectedIndex() != -1) {
            sourceToSave = (Source)this.sourceListModel.getElementAt(this.sourceList.getSelectedIndex());
        } else {
            Source source = sourceToSave = this.source != null ? (Source)this.source.getTargetSource() : null;
        }
        if (sourceToSave != null && (pRepo = sourceToSave.getProperty("REPO")) != null) {
            String strCaln = this.jTextCaln.getText().trim();
            String strMedi = ((JTextComponent)this.jComboBoxMedia.getEditor().getEditorComponent()).getText().trim();
            Property pCaln = pRepo.getProperty("CALN");
            if (pCaln != null) {
                pCaln.setValue(strCaln);
            } else {
                pCaln = this.repo.addProperty("CALN", strCaln);
            }
            Property pMedi = pCaln.getProperty("MEDI");
            if (pMedi != null) {
                pMedi.setValue(strMedi);
            } else {
                pMedi = pCaln.addProperty("MEDI", strMedi);
            }
        }
        this.refreshAll(repoToSave);
    }

    private void delete() {
        Repository repoToDelete = null;
        if (!this.repoList.isSelectionEmpty()) {
            RepoThumb repotb = (RepoThumb)this.filteredModel.get(this.repoList.getSelectedIndex());
            repoToDelete = repotb.entity;
        } else {
            repoToDelete = this.repo;
        }
        if (repoToDelete != null) {
            this.gedcom.deleteEntity((Entity)repoToDelete);
            Repository firstEnt = (Repository)this.gedcom.getFirstEntity("REPO");
            this.refreshAll((Repository)(firstEnt != null ? firstEnt : null));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ThumbComparator
    implements Comparator<RepoThumb> {
        private ThumbComparator() {
        }

        @Override
        public int compare(RepoThumb o1, RepoThumb o2) {
            String ent1 = o1.entity == null ? "0" : "1";
            String ent2 = o2.entity == null ? "0" : "1";
            String id1 = o1.entity == null ? "" : o1.entity.getId();
            String id2 = o2.entity == null ? "" : o2.entity.getId();
            String total1 = ent1 + o1.title.toLowerCase() + id1;
            String total2 = ent2 + o2.title.toLowerCase() + id2;
            return total1.compareTo(total2);
        }
    }

    private class RepoThumb {
        public boolean isRepo = true;
        public Repository entity = null;
        public String title = "";
        public String text = "";
        public boolean isUnused = false;

        public RepoThumb() {
            this.entity = null;
            this.title = NbBundle.getMessage(this.getClass(), (String)"NewRepoTitle");
            this.text = NbBundle.getMessage(this.getClass(), (String)"NewRepoText");
        }

        public RepoThumb(Repository entity) {
            Property prop;
            this.entity = entity;
            this.title = entity.toString(true);
            this.text = "<center>" + entity.toString(true) + "</center>";
            Property pAddr = entity.getProperty("ADDR");
            if (pAddr != null) {
                String str;
                prop = pAddr.getProperty("CITY");
                if (prop != null && !prop.getDisplayValue().trim().isEmpty()) {
                    this.text = this.text + "<br>&bull;&nbsp;" + prop.getDisplayValue();
                }
                if ((prop = pAddr.getProperty("CTRY")) != null && !prop.getDisplayValue().trim().isEmpty()) {
                    this.text = this.text + ", " + prop.getDisplayValue();
                }
                if (!pAddr.getDisplayValue().trim().isEmpty() && (str = pAddr.getDisplayValue()).length() > 0) {
                    this.text = this.text + "<br>&bull;&nbsp;" + str.substring(0, Math.min(16, str.length() - 1)) + ".";
                }
            }
            if ((prop = entity.getProperty("NOTE")) != null) {
                this.text = this.text + "<br>&bull;&nbsp;" + prop.getDisplayValue();
            }
        }

        private void setUnused(boolean b) {
            this.isUnused = b;
        }
    }

    private static class ListEntryCellRenderer
    extends JLabel
    implements ListCellRenderer {
        private ListEntryCellRenderer() {
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            String color;
            RepoThumb entry = (RepoThumb)value;
            this.setHorizontalTextPosition(0);
            this.setVerticalTextPosition(1);
            this.setVerticalAlignment(1);
            this.setHorizontalAlignment(0);
            this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4), BorderFactory.createCompoundBorder(BorderFactory.createRaisedBevelBorder(), BorderFactory.createLoweredSoftBevelBorder())));
            int labelWidth = THUMB_WIDTH - 8;
            int labelHeight = THUMB_HEIGHT - 8;
            int nbLines = labelHeight / 18;
            int nbTotalLines = this.getFontMetrics(this.getFont()).stringWidth(entry.text) / labelWidth;
            int nbMaxCars = entry.text.length();
            String add = "";
            if (nbTotalLines > nbLines) {
                nbMaxCars = nbMaxCars * nbLines / nbTotalLines - 3;
                add = "...";
            }
            String text = entry.text.substring(0, Math.min(entry.text.length(), nbMaxCars)) + add;
            this.setPreferredSize(new Dimension(labelWidth, labelHeight));
            String string = entry.isRepo && !entry.isUnused ? "black" : (color = !entry.isRepo && !entry.isUnused ? "blue" : "red");
            if (entry.entity == null) {
                text = "<center><font size=+0><br><br><i><b>" + text + "</b></i></font></center>";
            }
            this.setText("<html><font color=" + color + ">" + text + "</font></html>");
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            this.setEnabled(list.isEnabled());
            this.setFont(list.getFont());
            this.setOpaque(true);
            return this;
        }
    }
}

