/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.editors.standard.tools;

import genj.gedcom.Entity;
import genj.gedcom.Fam;
import genj.gedcom.Gedcom;
import genj.gedcom.GedcomException;
import genj.gedcom.GedcomOptions;
import genj.gedcom.Indi;
import genj.gedcom.Property;
import genj.gedcom.PropertyFamilySpouse;
import genj.gedcom.UnitOfWork;
import org.openide.util.Exceptions;

public class IndiCreator {
    public static int CREATION = 0;
    public static int ATTACH = 1;
    public static int DETACH = 2;
    public static int DESTROY = 9;
    public static int REL_NONE = 0;
    public static int REL_FATHER = 1;
    public static int REL_MOTHER = 2;
    public static int REL_BROTHER = 3;
    public static int REL_SISTER = 4;
    public static int REL_PARTNER = 5;
    public static int REL_CHILD = 6;
    public static String[] RELATIONS = new String[]{"NONE", "FATHER", "MOTHER", "BROTHER", "SISTER", "PARTNER", "CHILD"};
    private Indi indiCreated;
    private boolean success;

    public IndiCreator(final int mode, final Indi sourceIndi, final int relation, final Fam currentFam, final Indi target) {
        Gedcom gedcom = sourceIndi.getGedcom();
        this.success = false;
        try {
            if (!gedcom.isWriteLocked()) {
                gedcom.doUnitOfWork(new UnitOfWork(){

                    public void perform(Gedcom gedcom) throws GedcomException {
                        if (mode == CREATION && target == null) {
                            IndiCreator.this.indiCreated = (Indi)gedcom.createEntity("INDI");
                            IndiCreator.this.indiCreated.addDefaultProperties();
                            if (relation == REL_FATHER) {
                                IndiCreator.this.linkParent(sourceIndi, IndiCreator.this.indiCreated, true);
                            } else if (relation == REL_MOTHER) {
                                IndiCreator.this.linkParent(sourceIndi, IndiCreator.this.indiCreated, false);
                            } else if (relation == REL_BROTHER) {
                                IndiCreator.this.linkSibling(sourceIndi, IndiCreator.this.indiCreated, true);
                            } else if (relation == REL_SISTER) {
                                IndiCreator.this.linkSibling(sourceIndi, IndiCreator.this.indiCreated, false);
                            } else if (relation == REL_PARTNER) {
                                IndiCreator.this.linkPartner(sourceIndi, IndiCreator.this.indiCreated);
                            } else if (relation == REL_CHILD) {
                                IndiCreator.this.linkChild(sourceIndi, IndiCreator.this.indiCreated, currentFam);
                            }
                            IndiCreator.this.success = true;
                            return;
                        }
                        if (mode == ATTACH && target != null) {
                            IndiCreator.this.indiCreated = target;
                            if (relation == REL_FATHER) {
                                IndiCreator.this.linkParentToTarget(sourceIndi, target, true);
                            } else if (relation == REL_MOTHER) {
                                IndiCreator.this.linkParentToTarget(sourceIndi, target, false);
                            } else if (relation == REL_BROTHER) {
                                IndiCreator.this.linkSiblingToTarget(sourceIndi, target);
                            } else if (relation == REL_SISTER) {
                                IndiCreator.this.linkSiblingToTarget(sourceIndi, target);
                            } else if (relation == REL_PARTNER) {
                                IndiCreator.this.linkPartnerToTarget(sourceIndi, target);
                            } else if (relation == REL_CHILD) {
                                IndiCreator.this.linkChildToTarget(sourceIndi, target, currentFam);
                            }
                            IndiCreator.this.success = true;
                            return;
                        }
                        if (mode == DETACH && target != null) {
                            IndiCreator.this.indiCreated = null;
                            if (relation == REL_FATHER) {
                                IndiCreator.this.unlinkParentFromTarget(sourceIndi, target, true);
                            } else if (relation == REL_MOTHER) {
                                IndiCreator.this.unlinkParentFromTarget(sourceIndi, target, false);
                            } else if (relation == REL_BROTHER) {
                                IndiCreator.this.unlinkSiblingFromTarget(sourceIndi, target);
                            } else if (relation == REL_SISTER) {
                                IndiCreator.this.unlinkSiblingFromTarget(sourceIndi, target);
                            } else if (relation == REL_PARTNER) {
                                IndiCreator.this.unlinkPartnerFromTarget(sourceIndi, target);
                            } else if (relation == REL_CHILD) {
                                IndiCreator.this.unlinkChildFromTarget(sourceIndi, target, currentFam);
                            }
                            IndiCreator.this.success = true;
                            return;
                        }
                        if (mode == DESTROY) {
                            gedcom.deleteEntity((Entity)sourceIndi);
                            IndiCreator.this.success = true;
                        }
                    }
                });
            }
        }
        catch (GedcomException ex) {
            this.success = false;
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    public Indi getIndi() {
        return this.indiCreated;
    }

    public boolean isSuccessful() {
        return this.success;
    }

    private void linkParent(Indi child, Indi parent, boolean isFather) throws GedcomException {
        Fam fam = child.getFamilyWhereBiologicalChild();
        if (fam == null) {
            fam = (Fam)child.getGedcom().createEntity("FAM");
            fam.addDefaultProperties();
            fam.addChild(child);
        }
        parent.addDefaultProperties();
        parent.setSex(isFather ? 1 : 2);
        if (isFather || GedcomOptions.getInstance().isSetWifeLastname()) {
            parent.setName("", child.getLastName());
        }
        if (isFather) {
            fam.setHusband(parent);
        } else {
            fam.setWife(parent);
        }
        if (GedcomOptions.getInstance().getCreateSpouse() && fam.getNoOfSpouses() < 2) {
            Indi spouse = (Indi)child.getGedcom().createEntity("INDI");
            spouse.addDefaultProperties();
            spouse.setSex(isFather ? 2 : 1);
            if (isFather) {
                if (GedcomOptions.getInstance().isSetWifeLastname()) {
                    spouse.setName("", child.getLastName());
                }
                fam.setWife(spouse);
            } else {
                spouse.setName("", child.getLastName());
                fam.setHusband(spouse);
            }
        }
    }

    private void linkSibling(Indi existingSibling, Indi newSibling, boolean isBrother) throws GedcomException {
        Fam fam = existingSibling.getFamilyWhereBiologicalChild();
        if (fam == null) {
            fam = (Fam)existingSibling.getGedcom().createEntity("FAM");
            fam.addDefaultProperties();
            fam.addChild(existingSibling);
        }
        newSibling.addDefaultProperties();
        newSibling.setSex(isBrother ? 1 : 2);
        newSibling.setName("", existingSibling.getLastName());
        fam.addChild(newSibling);
    }

    private void linkPartner(Indi spouse, Indi otherSpouse) throws GedcomException {
        boolean isHusband;
        Fam fam = (Fam)spouse.getGedcom().createEntity("FAM");
        fam.addDefaultProperties();
        otherSpouse.addDefaultProperties();
        boolean bl = isHusband = spouse.getSex() != 2;
        if (isHusband) {
            otherSpouse.setSex(2);
            fam.setHusband(spouse);
            fam.setWife(otherSpouse);
        } else {
            otherSpouse.setSex(1);
            fam.setHusband(otherSpouse);
            fam.setWife(spouse);
        }
    }

    private void linkChild(Indi parent, Indi child, Fam currentFam) throws GedcomException {
        Fam fam = null;
        Fam[] fams = parent.getFamiliesWhereSpouse();
        if (fams == null || fams.length == 0 || currentFam == null) {
            fam = (Fam)parent.getGedcom().createEntity("FAM");
            fam.addDefaultProperties();
            if (parent.getSex() != 2) {
                fam.setHusband(parent);
                if (currentFam != null) {
                    fam.setWife(currentFam.getOtherSpouse(parent));
                }
            } else {
                fam.setWife(parent);
                if (currentFam != null) {
                    fam.setHusband(currentFam.getOtherSpouse(parent));
                }
            }
            child.addDefaultProperties();
            fam.addChild(child);
        } else {
            for (Fam f : fams) {
                if (f != currentFam) continue;
                child.addDefaultProperties();
                f.addChild(child);
                return;
            }
        }
    }

    private void linkParentToTarget(Indi child, Indi parent, boolean isFather) throws GedcomException {
        Fam[] fams = parent.getFamiliesWhereSpouse();
        if (fams != null && fams.length > 0) {
            Fam fam = fams[0];
            fam.addChild(child);
            return;
        }
        Fam fam = child.getFamilyWhereBiologicalChild();
        if (fam == null) {
            fam = (Fam)parent.getGedcom().createEntity("FAM");
            fam.addDefaultProperties();
            fam.addChild(child);
        }
        if (isFather) {
            fam.setHusband(parent);
        } else {
            fam.setWife(parent);
        }
    }

    private void linkSiblingToTarget(Indi existingSibling, Indi otherSibling) throws GedcomException {
        Fam fam = existingSibling.getFamilyWhereBiologicalChild();
        if (fam != null) {
            fam.addChild(otherSibling);
            return;
        }
        Fam fam2 = otherSibling.getFamilyWhereBiologicalChild();
        if (fam2 == null) {
            fam = (Fam)existingSibling.getGedcom().createEntity("FAM");
            fam.addDefaultProperties();
            fam.addChild(existingSibling);
            fam.addChild(otherSibling);
            return;
        }
        fam2.addChild(existingSibling);
    }

    private void linkPartnerToTarget(Indi spouse, Indi otherSpouse) throws GedcomException {
        boolean isHusband;
        Fam fam = (Fam)spouse.getGedcom().createEntity("FAM");
        fam.addDefaultProperties();
        boolean bl = isHusband = spouse.getSex() != 2;
        if (isHusband) {
            fam.setHusband(spouse);
            fam.setWife(otherSpouse);
        } else {
            fam.setHusband(otherSpouse);
            fam.setWife(spouse);
        }
    }

    private void linkChildToTarget(Indi parent, Indi child, Fam currentFam) throws GedcomException {
        Fam fam = null;
        Fam[] fams = parent.getFamiliesWhereSpouse();
        if (fams == null || fams.length == 0) {
            fam = (Fam)parent.getGedcom().createEntity("FAM");
            fam.addDefaultProperties();
            if (parent.getSex() != 2) {
                fam.setHusband(parent);
            } else {
                fam.setWife(parent);
            }
            fam.addChild(child);
        } else {
            for (Fam f : fams) {
                if (f != currentFam) continue;
                f.addChild(child);
            }
        }
    }

    private void unlinkParentFromTarget(Indi child, Indi parent, boolean isFather) throws GedcomException {
        Property[] props;
        Fam fam = child.getFamilyWhereBiologicalChild();
        if (fam == null) {
            return;
        }
        if (isFather && fam.getHusband() != parent || !isFather && fam.getWife() != parent) {
            return;
        }
        Property propToDelete = null;
        for (Property prop : props = parent.getProperties("FAMS")) {
            PropertyFamilySpouse pfs = (PropertyFamilySpouse)prop;
            Fam fam2 = pfs.getFamily();
            if (fam != fam2) continue;
            propToDelete = prop;
            break;
        }
        if (propToDelete != null) {
            parent.delProperty(propToDelete);
        }
        this.cleanFamily(fam);
    }

    private void unlinkSiblingFromTarget(Indi existingSibling, Indi otherSibling) throws GedcomException {
        Fam fam1 = existingSibling.getFamilyWhereBiologicalChild();
        if (fam1 == null) {
            return;
        }
        Fam fam2 = otherSibling.getFamilyWhereBiologicalChild();
        if (fam2 == null || fam2 != fam1) {
            return;
        }
        Property prop = otherSibling.getProperty("FAMC");
        otherSibling.delProperty(prop);
        this.cleanFamily(fam1);
    }

    private void unlinkPartnerFromTarget(Indi spouse, Indi otherSpouse) throws GedcomException {
        Property[] props;
        Fam fam = null;
        Property propToDelete = null;
        for (Property prop : props = otherSpouse.getProperties("FAMS")) {
            PropertyFamilySpouse pfs = (PropertyFamilySpouse)prop;
            fam = pfs.getFamily();
            if (fam.getHusband() != spouse && fam.getHusband() != otherSpouse || fam.getWife() != spouse && fam.getWife() != otherSpouse) continue;
            propToDelete = prop;
            break;
        }
        if (propToDelete != null) {
            otherSpouse.delProperty(propToDelete);
        }
        this.cleanFamily(fam);
    }

    private void unlinkChildFromTarget(Indi parent, Indi child, Fam currentFam) throws GedcomException {
        Fam fam = child.getFamilyWhereBiologicalChild();
        if (fam.getHusband() == parent || fam.getWife() == parent) {
            Property prop = child.getProperty("FAMC");
            child.delProperty(prop);
        }
        this.cleanFamily(fam);
    }

    private void cleanFamily(Fam fam) {
        if (fam == null) {
            return;
        }
        Indi husband = fam.getHusband();
        Indi wife = fam.getWife();
        Indi[] children = fam.getChildren();
        if (husband == null && wife == null && (children == null || children.length == 0)) {
            Gedcom gedcom = fam.getGedcom();
            gedcom.deleteEntity((Entity)fam);
        }
    }
}

