/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.editors.standard.tools;

import ancestris.modules.editors.standard.tools.EventLabel;
import ancestris.modules.editors.standard.tools.MediaWrapper;
import ancestris.modules.editors.standard.tools.NoteWrapper;
import ancestris.modules.editors.standard.tools.SourceWrapper;
import genj.edit.beans.DateBean;
import genj.gedcom.Entity;
import genj.gedcom.Fam;
import genj.gedcom.Gedcom;
import genj.gedcom.GedcomException;
import genj.gedcom.Indi;
import genj.gedcom.Media;
import genj.gedcom.Note;
import genj.gedcom.Property;
import genj.gedcom.PropertyAge;
import genj.gedcom.PropertyDate;
import genj.gedcom.PropertyLatitude;
import genj.gedcom.PropertyLongitude;
import genj.gedcom.PropertyMedia;
import genj.gedcom.PropertyNote;
import genj.gedcom.PropertyPlace;
import genj.gedcom.Repository;
import genj.gedcom.Source;
import genj.gedcom.time.Delta;
import genj.gedcom.time.PointInTime;
import java.io.File;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EventWrapper {
    private static Set<String> ATTR_TAGS = new HashSet<String>(Arrays.asList("CAST", "DSCR", "EDUC", "IDNO", "NATI", "NCHI", "NMR", "OCCU", "PROP", "RELI", "SSN", "TITL"));
    public static String AGE_FORMAT = "#.###";
    public boolean isGeneral = true;
    private Entity hostingEntity = null;
    public Property eventProperty = null;
    private PropertyDate birthDate;
    private double ageAsDouble;
    public EventLabel eventLabel = null;
    public String eventYear = "-";
    public String eventAge = "-";
    public boolean showDesc = false;
    public String title = "";
    public String description = "";
    private boolean hasAttribute = false;
    private Property dummyProperty = null;
    public PropertyDate date = null;
    public PropertyPlace place = null;
    public String dayOfWeek = "";
    public String age = "";
    public List<MediaWrapper> eventMediaSet = null;
    public List<MediaWrapper> eventMediaRemovedSet = null;
    public int eventMediaIndex = 0;
    public List<NoteWrapper> eventNoteSet = null;
    public List<NoteWrapper> eventNoteRemovedSet = null;
    public int eventNoteIndex = 0;
    public List<SourceWrapper> eventSourceSet = null;
    public List<SourceWrapper> eventSourceRemovedSet = null;
    public int eventSourceIndex = 0;

    public EventWrapper(Property property, Indi indi) {
        this.eventProperty = property;
        this.hostingEntity = property != null ? property.getEntity() : null;
        this.createDummyProperty(indi.getGedcom());
        this.eventLabel = new EventLabel(property);
        this.eventLabel.setIcon((Icon)property.getImage());
        if (!property.equals(indi)) {
            this.isGeneral = false;
            this.description = this.getDescription();
            this.date = (PropertyDate)this.dummyProperty.addProperty("DATE", "");
            PropertyDate tmpDate = (PropertyDate)this.eventProperty.getProperty("DATE");
            if (tmpDate != null) {
                this.date.setValue(tmpDate.getValue());
            }
            try {
                this.dayOfWeek = this.date != null && this.date.getStart() != null ? this.date.getStart().getDayOfWeek(true) : "";
            }
            catch (GedcomException ex) {
                this.dayOfWeek = "";
            }
            if (tmpDate != null) {
                String string = this.eventYear = tmpDate.getStart() == null ? "-" : "" + tmpDate.getStart().getYear();
            }
            if (indi == null) {
                return;
            }
            this.calcAge(indi, property);
            this.place = (PropertyPlace)this.dummyProperty.addProperty("PLAC", "");
            PropertyPlace tmpPlace = (PropertyPlace)property.getProperty("PLAC");
            if (tmpPlace != null) {
                this.place.setValue(tmpPlace.getValue());
                this.setCoordinates(tmpPlace, this.place);
            }
        }
        String string = this.title = this.isGeneral ? this.eventLabel.getLongLabel() : this.eventLabel.getShortLabel();
        if (this.eventMediaSet != null) {
            this.eventMediaSet.clear();
            this.eventMediaSet = null;
        }
        if (this.eventMediaRemovedSet != null) {
            this.eventMediaRemovedSet.clear();
            this.eventMediaRemovedSet = null;
        }
        this.eventMediaSet = this.getEventMedia(this.eventProperty);
        this.eventMediaRemovedSet = new ArrayList<MediaWrapper>();
        this.eventMediaIndex = 0;
        if (this.eventNoteSet != null) {
            this.eventNoteSet.clear();
            this.eventNoteSet = null;
        }
        if (this.eventNoteRemovedSet != null) {
            this.eventNoteRemovedSet.clear();
            this.eventNoteRemovedSet = null;
        }
        this.eventNoteSet = this.getEventNotes(this.eventProperty);
        this.eventNoteRemovedSet = new ArrayList<NoteWrapper>();
        this.eventNoteIndex = 0;
        if (this.eventSourceSet != null) {
            this.eventSourceSet.clear();
            this.eventSourceSet = null;
        }
        if (this.eventSourceRemovedSet != null) {
            this.eventSourceRemovedSet.clear();
            this.eventSourceRemovedSet = null;
        }
        this.eventSourceSet = this.getEventSources(this.eventProperty);
        this.eventSourceRemovedSet = new ArrayList<SourceWrapper>();
        this.eventSourceIndex = 0;
    }

    public EventWrapper(Entity entity) {
        this.hostingEntity = entity;
        this.eventProperty = entity;
        this.eventLabel = new EventLabel((Property)entity);
        this.eventLabel.setIcon((Icon)entity.getImage());
        this.title = this.eventLabel.getShortLabel();
    }

    public void setDescription(String text) {
        this.description = text;
    }

    public void setPlace(String text) {
        this.place.setValue(text);
    }

    public void setDate(DateBean dateBean) {
        dateBean.setValueToProperty(this.date);
    }

    public void calcAge(Indi indi, Property property) {
        Property pReadAge = property.getProperty("AGE");
        String readAge = null;
        String foundAge = NbBundle.getMessage(this.getClass(), (String)"Found_Age");
        if (pReadAge != null) {
            PropertyAge pAge = (PropertyAge)pReadAge;
            readAge = pAge.getDisplayValue();
        }
        this.birthDate = indi.getBirthDate();
        if (!this.isValidBirthDate()) {
            this.ageAsDouble = 0.0;
            this.eventAge = "-";
            this.age = NbBundle.getMessage(this.getClass(), (String)"Undetermined_Age");
            return;
        }
        if (this.date == null || !this.date.isValid() || property.getTag().equals("BIRT")) {
            this.ageAsDouble = 0.0;
            this.eventAge = "-";
            this.age = "";
            return;
        }
        PointInTime start = this.birthDate.getStart();
        PointInTime end = this.date.getStart();
        Delta delta = Delta.get((PointInTime)start, (PointInTime)end);
        double d = delta.getYears();
        d += (double)delta.getMonths() / 12.0;
        d += (double)delta.getDays() / 365.0;
        if (start.compareTo(end) > 0) {
            d *= -1.0;
        }
        this.ageAsDouble = d;
        DecimalFormat df = new DecimalFormat(AGE_FORMAT);
        df.setRoundingMode(RoundingMode.FLOOR);
        this.eventAge = df.format(d);
        this.age = "(" + PropertyAge.getLabelForAge() + ": " + (d < 0.0 ? "-" : "") + delta.toString() + (readAge != null ? " - " + foundAge + ": " + readAge : "") + ")";
    }

    private boolean isValidBirthDate() {
        return this.birthDate != null && this.birthDate.isValid();
    }

    public boolean isAgeNegative() {
        return this.ageAsDouble < 0.0;
    }

    private List<MediaWrapper> getEventMedia(Property event) {
        Property[] mediaProps;
        ArrayList<MediaWrapper> ret = new ArrayList<MediaWrapper>();
        if (event == null) {
            return ret;
        }
        for (Property prop : mediaProps = event.getProperties("OBJE")) {
            if (prop == null) continue;
            MediaWrapper media = null;
            if (prop instanceof PropertyMedia) {
                media = new MediaWrapper((Media)((PropertyMedia)prop).getTargetEntity());
                media.setHostingProperty(prop);
                ret.add(media);
                continue;
            }
            media = new MediaWrapper(prop);
            ret.add(media);
        }
        return ret;
    }

    public boolean addMedia(String mediaTitle) {
        MediaWrapper media = new MediaWrapper(mediaTitle);
        this.eventMediaSet.add(media);
        this.eventMediaIndex = this.eventMediaSet.size() - 1;
        return true;
    }

    public boolean setMedia(String mediaTitle) {
        this.eventMediaSet.get(this.eventMediaIndex).setTitle(mediaTitle);
        return true;
    }

    private List<NoteWrapper> getEventNotes(Property event) {
        Property[] noteProps;
        ArrayList<NoteWrapper> ret = new ArrayList<NoteWrapper>();
        if (event == null) {
            return ret;
        }
        for (Property prop : noteProps = event.getProperties("NOTE")) {
            if (prop == null || prop.getDisplayValue().trim().isEmpty()) continue;
            NoteWrapper note = null;
            if (prop instanceof PropertyNote) {
                note = new NoteWrapper((Note)((PropertyNote)prop).getTargetEntity());
                if (note == null) continue;
                note.setHostingProperty(prop);
                ret.add(note);
                continue;
            }
            note = new NoteWrapper(prop);
            ret.add(note);
        }
        return ret;
    }

    public boolean addNote(Note entity, String noteText) {
        NoteWrapper note = new NoteWrapper(entity);
        note.setText(noteText);
        this.eventNoteSet.add(note);
        this.eventNoteIndex = this.eventNoteSet.size() - 1;
        return true;
    }

    public boolean addNote(String noteText) {
        NoteWrapper note = new NoteWrapper(noteText);
        this.eventNoteSet.add(note);
        this.eventNoteIndex = this.eventNoteSet.size() - 1;
        return true;
    }

    public boolean setNote(Note entity, String noteText, int index) {
        this.eventNoteSet.get(index).setTargetEntity(entity);
        this.eventNoteSet.get(index).setText(noteText);
        this.eventNoteIndex = index;
        return true;
    }

    public boolean setNote(String noteText, int index) {
        this.eventNoteSet.get(index).setText(noteText);
        this.eventNoteIndex = index;
        return true;
    }

    public boolean setNote(String noteText) {
        this.eventNoteSet.get(this.eventNoteIndex).setText(noteText);
        return true;
    }

    private List<SourceWrapper> getEventSources(Property event) {
        Property[] sourceProps;
        ArrayList<SourceWrapper> ret = new ArrayList<SourceWrapper>();
        if (event == null) {
            return ret;
        }
        for (Property prop : sourceProps = event.getProperties("SOUR")) {
            if (prop == null || prop.getDisplayValue().trim().isEmpty()) continue;
            SourceWrapper source = new SourceWrapper(prop);
            ret.add(source);
        }
        return ret;
    }

    public boolean addSource(Source entity) {
        SourceWrapper source = new SourceWrapper((Property)entity);
        this.eventSourceSet.add(source);
        this.eventSourceIndex = this.eventSourceSet.size() - 1;
        return true;
    }

    public boolean addSource(String title, String text, String mediaTitle) {
        SourceWrapper source = new SourceWrapper(title);
        source.setText(text);
        source.setMediaTitle(mediaTitle);
        this.eventSourceSet.add(source);
        this.eventSourceIndex = this.eventSourceSet.size() - 1;
        return true;
    }

    public boolean addSourceMedia(MediaWrapper media) {
        SourceWrapper source = new SourceWrapper(media);
        this.eventSourceSet.add(source);
        this.eventSourceIndex = this.eventSourceSet.size() - 1;
        return true;
    }

    public boolean addSourceFile(File file) {
        SourceWrapper source = new SourceWrapper(file);
        this.eventSourceSet.add(source);
        this.eventSourceIndex = this.eventSourceSet.size() - 1;
        return true;
    }

    public boolean addSourceRepository(Repository repo) {
        SourceWrapper source = new SourceWrapper(repo);
        this.eventSourceSet.add(source);
        this.eventSourceIndex = this.eventSourceSet.size() - 1;
        return true;
    }

    public boolean setSource(Source entity, int index) {
        this.eventSourceSet.get(index).setSourceFromEntity(entity);
        this.eventSourceIndex = index;
        return true;
    }

    public boolean setSource(String title, String text, String mediaTitle) {
        SourceWrapper source = this.eventSourceSet.get(this.eventSourceIndex);
        source.setTitle(title);
        source.setText(text);
        source.setMediaTitle(mediaTitle);
        return true;
    }

    public boolean setSourceMedia(MediaWrapper media, boolean addMedia) {
        this.eventSourceSet.get(this.eventSourceIndex).setMedia(media, addMedia);
        return true;
    }

    public boolean setSourceFile(File file) {
        this.eventSourceSet.get(this.eventSourceIndex).setMediaFile(file);
        return true;
    }

    public boolean setSourceRepository(Repository repo) {
        this.eventSourceSet.get(this.eventSourceIndex).setRepo(repo);
        return true;
    }

    public SourceWrapper getEventSource() {
        if (this.eventSourceSet != null && !this.eventSourceSet.isEmpty() && this.eventSourceIndex >= 0 && this.eventSourceIndex < this.eventSourceSet.size()) {
            return this.eventSourceSet.get(this.eventSourceIndex);
        }
        return null;
    }

    public void update(Indi indi) {
        if (this.eventProperty.getGedcom() == null || this.eventProperty.getGedcom().getOrigin() == null) {
            if (this.hostingEntity instanceof Indi) {
                this.eventProperty = indi.addProperty(this.eventProperty.getTag(), "");
            } else if (this.hostingEntity instanceof Fam) {
                Fam fam = this.createFamForIndi(indi);
                if (fam == null) {
                    return;
                }
                this.eventProperty = fam.addProperty(this.eventProperty.getTag(), "");
            }
        }
        if (!this.isGeneral) {
            this.description = this.description.trim();
            if (this.hasAttribute) {
                this.eventProperty.setValue(this.description);
            } else {
                Property type = this.eventProperty.getProperty("TYPE");
                if (type == null) {
                    if (!this.description.isEmpty()) {
                        this.eventProperty.addProperty("TYPE", this.description);
                    }
                } else {
                    type.setValue(this.description);
                }
            }
            PropertyDate tmpDate = (PropertyDate)this.eventProperty.getProperty("DATE", false);
            if (tmpDate == null) {
                String val = this.date.getValue().trim();
                if (!val.isEmpty()) {
                    this.eventProperty.addProperty("DATE", this.date.getValue());
                }
            } else {
                tmpDate.setValue(this.date.getValue());
            }
            PropertyPlace tmpPlace = (PropertyPlace)this.eventProperty.getProperty("PLAC");
            if (tmpPlace == null) {
                String val = this.place.getValue().trim();
                if (!val.isEmpty()) {
                    tmpPlace = (PropertyPlace)this.eventProperty.addProperty("PLAC", this.place.getValue());
                }
            } else {
                tmpPlace.setValue(this.place.getValue());
            }
            this.setCoordinates(this.place, tmpPlace);
        }
        for (MediaWrapper media : this.eventMediaSet) {
            media.update(this.eventProperty);
        }
        for (MediaWrapper media : this.eventMediaRemovedSet) {
            media.remove();
        }
        for (NoteWrapper note : this.eventNoteSet) {
            note.update(this.eventProperty);
        }
        for (NoteWrapper note : this.eventNoteRemovedSet) {
            note.remove();
        }
        for (SourceWrapper source : this.eventSourceSet) {
            source.update(this.eventProperty);
        }
        for (SourceWrapper source : this.eventSourceRemovedSet) {
            source.remove();
        }
    }

    public void remove(Indi indi) {
        if (this.hostingEntity == null) {
            return;
        }
        this.hostingEntity.delProperty(this.eventProperty);
    }

    private Fam createFamForIndi(Indi indi) {
        Fam fam = null;
        Gedcom gedcom = indi.getGedcom();
        try {
            fam = (Fam)gedcom.createEntity("FAM");
            int sex = indi.getSex();
            if (sex == 0) {
                sex = 1;
            }
            if (sex == 1) {
                fam.setHusband(indi);
            } else {
                fam.setWife(indi);
            }
        }
        catch (GedcomException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return fam;
    }

    public String getEventKey() {
        return this.getEventKey(false);
    }

    public String getEventKey(boolean force) {
        String ret = "";
        if (this.eventProperty == null) {
            return "-1";
        }
        ret = ret + this.eventProperty.getTag() + "|";
        if (force) {
            PropertyDate tmpDate = (PropertyDate)this.eventProperty.getProperty("DATE");
            ret = ret + (tmpDate == null || tmpDate.getValue().isEmpty() ? "" : tmpDate.getValue());
            ret = ret + this.getDescription();
        } else {
            ret = ret + (this.date == null || this.date.getValue().isEmpty() ? "" : this.date.getValue());
            ret = ret + this.description;
        }
        return ret;
    }

    public String getTag() {
        return this.hasAttribute ? this.eventProperty.getTag() : "TYPE";
    }

    private String getDescription() {
        String tag = this.eventProperty.getTag();
        this.hasAttribute = ATTR_TAGS.contains(tag);
        Property type = this.eventProperty.getProperty("TYPE");
        return this.hasAttribute ? this.eventProperty.getDisplayValue().trim() : (type != null ? type.getDisplayValue() : "");
    }

    private void createDummyProperty(Gedcom gedcom) {
        Gedcom tmpGedcom = new Gedcom();
        tmpGedcom.setGrammar(gedcom.getGrammar());
        try {
            Indi indi = (Indi)tmpGedcom.createEntity("INDI");
            this.dummyProperty = indi.addProperty("BIRT", "");
        }
        catch (GedcomException gedcomException) {
            // empty catch block
        }
    }

    private void setCoordinates(PropertyPlace fromPlace, PropertyPlace toPlace) {
        PropertyLatitude pLatitude = fromPlace.getLatitude(true);
        PropertyLongitude pLongitude = fromPlace.getLongitude(true);
        if (pLatitude != null && pLongitude != null) {
            String strLat = pLatitude.getValue();
            String strLong = pLongitude.getValue();
            toPlace.setCoordinates(strLat, strLong);
        }
    }
}

