/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.editors.standard.tools;

import genj.gedcom.Indi;
import genj.gedcom.Property;
import genj.gedcom.PropertyDate;
import genj.gedcom.PropertyPlace;
import genj.util.WordBuffer;
import javax.swing.JLabel;
import org.openide.util.NbBundle;

public class EventLabel
extends JLabel {
    private String tag = "";
    private String shortLabel = "";
    private String longLabel = "";

    public EventLabel(Property property) {
        this.tag = property.getTag();
        if (property instanceof Indi) {
            this.shortLabel = NbBundle.getMessage(this.getClass(), (String)"IndiEventNameShort");
            this.longLabel = NbBundle.getMessage(this.getClass(), (String)"IndiEventNameLong");
        } else {
            Property place;
            String str = property.getPropertyName();
            this.shortLabel = str.contains(" ") ? str.substring(0, str.indexOf(" ")) : str;
            WordBuffer buffer = new WordBuffer(" - ");
            buffer.append(this.shortLabel);
            Property date = property.getProperty("DATE");
            if (date != null) {
                PropertyDate pDate = (PropertyDate)date;
                buffer.append(pDate.getStart().getValue());
            }
            if ((place = property.getProperty("PLAC")) != null) {
                PropertyPlace pPlace = (PropertyPlace)place;
                buffer.append(pPlace.getCity());
            }
            this.longLabel = buffer.toString();
        }
        this.setText(this.shortLabel);
    }

    public String getTag() {
        return this.tag;
    }

    public String getShortLabel() {
        return this.shortLabel;
    }

    public String getLongLabel() {
        return this.longLabel;
    }
}

