/*
 * Decompiled with CFR 0.152.
 */
package ancestris.report.svgtree.graphics;

import ancestris.report.svgtree.graphics.GraphicsOutput;
import ancestris.report.svgtree.graphics.GraphicsRenderer;
import genj.report.Report;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import javax.swing.JComponent;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;

public class ScreenOutput
implements GraphicsOutput {
    private GraphicsRenderer renderer = null;
    private JComponent view;
    private JScrollPane pane = new JScrollPane();
    private Point lastPoint;

    public ScreenOutput() {
        this.view = new JComponent(){

            @Override
            public void paint(Graphics g) {
                Graphics2D g2 = (Graphics2D)g;
                g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                ScreenOutput.this.renderer.render(g2);
            }
        };
        this.pane.setViewportView(this.view);
        this.pane.setPreferredSize(new Dimension(300, 200));
        this.pane.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                ScreenOutput.this.lastPoint = e.getPoint();
                ScreenOutput.this.pane.setCursor(Cursor.getPredefinedCursor(12));
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                ScreenOutput.this.pane.setCursor(Cursor.getDefaultCursor());
            }
        });
        this.pane.addMouseMotionListener(new MouseMotionAdapter(){
            private JScrollBar hSb;
            private JScrollBar vSb;
            {
                this.hSb = ScreenOutput.this.pane.getHorizontalScrollBar();
                this.vSb = ScreenOutput.this.pane.getVerticalScrollBar();
            }

            @Override
            public void mouseDragged(MouseEvent e) {
                int dX = ((ScreenOutput)ScreenOutput.this).lastPoint.x - e.getX();
                int dY = ((ScreenOutput)ScreenOutput.this).lastPoint.y - e.getY();
                this.hSb.setValue(this.hSb.getValue() + dX);
                this.vSb.setValue(this.vSb.getValue() + dY);
                ScreenOutput.this.lastPoint = e.getPoint();
            }
        });
    }

    @Override
    public void output(GraphicsRenderer renderer) {
        this.renderer = renderer;
        this.view.setPreferredSize(new Dimension(renderer.getImageWidth(), renderer.getImageHeight()));
    }

    @Override
    public Object result(Report report) {
        return this.pane;
    }

    public String getFileExtension() {
        return null;
    }
}

