/*
 * Decompiled with CFR 0.152.
 */
package ancestris.report.svgtree.build;

import ancestris.report.svgtree.IndiBox;
import ancestris.report.svgtree.filter.TreeFilterBase;
import genj.gedcom.Indi;
import java.util.ArrayList;
import java.util.Arrays;

public class NoSpouseFilter
extends TreeFilterBase {
    @Override
    protected void preFilter(IndiBox indibox) {
        if (indibox.getDir() != IndiBox.Direction.PARENT && indibox.getDir() != IndiBox.Direction.SPOUSE) {
            indibox.children = this.getChildren(indibox, indibox.individual);
            if (indibox.children != null) {
                for (IndiBox c : indibox.children) {
                    c.prev = indibox;
                }
            }
            indibox.spouse = null;
        }
    }

    private IndiBox[] getChildren(IndiBox indibox, Indi parent) {
        IndiBox[] children = null;
        if (indibox.individual == parent || indibox.spouse != null && indibox.spouse.individual == parent) {
            children = indibox.children;
        }
        if (indibox.nextMarriage != null) {
            children = this.merge(children, this.getChildren(indibox.nextMarriage, parent));
        }
        if (indibox.spouse != null && indibox.spouse.nextMarriage != null) {
            children = this.merge(children, this.getChildren(indibox.spouse.nextMarriage, parent));
        }
        return children;
    }

    private IndiBox[] merge(IndiBox[] a, IndiBox[] b) {
        if (a == null) {
            return b;
        }
        if (b == null) {
            return a;
        }
        ArrayList<IndiBox> list = new ArrayList<IndiBox>(Arrays.asList(a));
        list.addAll(Arrays.asList(b));
        return list.toArray(new IndiBox[0]);
    }
}

