/*
 * Decompiled with CFR 0.152.
 */
package genj.entity;

import ancestris.core.actions.AncestrisActionProvider;
import ancestris.gedcom.PropertyNode;
import genj.gedcom.Context;
import genj.gedcom.Entity;
import genj.gedcom.Gedcom;
import genj.gedcom.GedcomListener;
import genj.gedcom.GedcomListenerAdapter;
import genj.gedcom.Property;
import genj.renderer.Blueprint;
import genj.renderer.BlueprintManager;
import genj.renderer.BlueprintRenderer;
import genj.renderer.ChooseBlueprintAction;
import genj.renderer.RenderOptions;
import genj.util.Registry;
import genj.util.Resources;
import genj.view.View;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Action;
import org.openide.nodes.Node;
import spin.Spin;

public class EntityView
extends View
implements AncestrisActionProvider {
    static final Resources resources = Resources.get(EntityView.class);
    private static final Blueprint BLUEPRINT_SELECT = new Blueprint(resources.getString("html.select"));
    private static final Registry REGISTRY = Registry.get(EntityView.class);
    private BlueprintRenderer renderer = null;
    Context context = new Context();
    private Map<String, Blueprint> type2blueprint = new HashMap<String, Blueprint>();
    private boolean isAntialiasing = true;
    private transient GedcomListener callback = new GedcomListenerAdapter(){

        public void gedcomEntityDeleted(Gedcom gedcom, Entity entity) {
            if (EntityView.this.context.getEntity() == entity) {
                EntityView.this.setContext(new Context(EntityView.this.context.getGedcom()));
            }
        }

        public void gedcomPropertyChanged(Gedcom gedcom, Property property) {
            if (EntityView.this.context.getEntity() == property.getEntity()) {
                EntityView.this.repaint();
            }
        }

        public void gedcomPropertyAdded(Gedcom gedcom, Property property, int pos, Property added) {
            this.gedcomPropertyChanged(gedcom, property);
        }

        public void gedcomPropertyDeleted(Gedcom gedcom, Property property, int pos, Property removed) {
            this.gedcomPropertyChanged(gedcom, property);
        }
    };

    public EntityView() {
        BlueprintManager bpm = BlueprintManager.getInstance();
        for (int t = 0; t < Gedcom.ENTITIES.length; ++t) {
            String tag = Gedcom.ENTITIES[t];
            this.type2blueprint.put(tag, bpm.getBlueprint(tag, REGISTRY.get("blueprint." + tag, "")));
        }
        this.isAntialiasing = REGISTRY.get("antial", false);
    }

    public List<Action> getActions(boolean hasFocus, Node[] nodes) {
        if (!hasFocus) {
            return new ArrayList<Action>();
        }
        ArrayList<Action> actions = new ArrayList<Action>();
        if (nodes.length == 1 && nodes[0] instanceof PropertyNode) {
            PropertyNode node = (PropertyNode)nodes[0];
            Entity entity = node.getProperty().getEntity();
            actions.add((Action)new ChooseBlueprintAction(entity, this.getBlueprint(entity.getTag())){

                protected void commit(Entity recipient, Blueprint blueprint) {
                    EntityView.this.type2blueprint.put(blueprint.getTag(), blueprint);
                    EntityView.this.setContext(EntityView.this.context);
                    REGISTRY.put("blueprint." + blueprint.getTag(), blueprint.getName());
                }
            });
        }
        return actions;
    }

    public void setContext(Context newContext) {
        if (this.context.getGedcom() != null) {
            this.context.getGedcom().removeGedcomListener((GedcomListener)Spin.over((Object)this.callback));
        }
        this.renderer = null;
        this.context = newContext;
        if (this.context.getGedcom() != null) {
            this.context.getGedcom().addGedcomListener((GedcomListener)Spin.over((Object)this.callback));
            Entity e = this.context.getEntity();
            Blueprint blueprint = e == null ? BLUEPRINT_SELECT : this.getBlueprint(e.getTag());
            this.renderer = new BlueprintRenderer(blueprint);
        }
        this.repaint();
    }

    public Dimension getPreferredSize() {
        return new Dimension(256, 160);
    }

    protected void paintComponent(Graphics g) {
        Rectangle bounds = this.getBounds();
        g.setColor(Color.white);
        g.fillRect(0, 0, bounds.width, bounds.height);
        g.setColor(Color.black);
        g.setFont(RenderOptions.getInstance().getDefaultFont());
        if (this.context == null || this.renderer == null) {
            return;
        }
        ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, this.isAntialiasing ? RenderingHints.VALUE_ANTIALIAS_ON : RenderingHints.VALUE_ANTIALIAS_OFF);
        this.renderer.render(g, (Property)this.context.getEntity(), new Rectangle(0, 0, bounds.width, bounds.height));
    }

    private Blueprint getBlueprint(String tag) {
        Blueprint result = this.type2blueprint.get(tag);
        if (result == null) {
            result = BlueprintManager.getInstance().getBlueprint(tag, "");
            this.type2blueprint.put(tag, result);
        }
        return result;
    }

    public void setAntialiasing(boolean set) {
        this.isAntialiasing = set;
        this.repaint();
    }

    public boolean isAntialiasing() {
        return this.isAntialiasing;
    }
}

