/*
 * Decompiled with CFR 0.152.
 */
package genj.edit.beans;

import ancestris.api.editor.AncestrisEditor;
import ancestris.core.CoreOptions;
import ancestris.util.swing.DialogManager;
import genj.edit.beans.CCPMenu;
import genj.edit.beans.PropertyBean;
import genj.gedcom.Gedcom;
import genj.gedcom.Property;
import genj.gedcom.PropertyPlace;
import genj.util.GridBagHelper;
import genj.util.swing.ChoiceWidget;
import genj.util.swing.Updateable;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPopupMenu;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class PlaceBean
extends PropertyBean {
    private final GridBagHelper gh = new GridBagHelper((Container)this);
    private int rows = 0;
    private JCheckBox global = new JCheckBox();
    private Property[] sameChoices = new Property[0];

    public PlaceBean() {
        this.changeSupport.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                PlaceBean.this.setupGlobal(true);
            }
        });
        this.global.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (PlaceBean.this.global.isSelected()) {
                    boolean yes = DialogManager.YES_OPTION == DialogManager.createYesNo((String)PropertyBean.RESOURCES.getString("choice.global.enable"), (String)PlaceBean.this.getGlobalConfirmMessage(false)).show();
                    PlaceBean.this.global.setSelected(yes);
                }
            }
        });
    }

    private String getCommitValue() {
        boolean hierarchy = CoreOptions.getInstance().isSplitJurisdictions() && ((PropertyPlace)this.getProperty()).getFormatAsString().length() > 0;
        StringBuilder result = new StringBuilder();
        int n = this.getComponentCount();
        int j = 0;
        for (int c = 0; c < n; ++c) {
            Component comp = this.getComponent(c);
            if (!(comp instanceof ChoiceWidget)) continue;
            String jurisdiction = ((ChoiceWidget)comp).getText().trim();
            if (hierarchy) {
                jurisdiction = jurisdiction.replaceAll(",", ";");
            }
            if (j++ > 0) {
                result.append(",");
            }
            result.append(jurisdiction);
        }
        return result.toString();
    }

    protected void commitImpl(Property property) {
        ((PropertyPlace)property).setValue(this.getCommitValue(), this.global.isSelected());
        this.setPropertyImpl(property);
    }

    public void setPropertyImpl(Property prop) {
        String formatAsString;
        String[] jurisdictions;
        String value;
        this.removeAll();
        this.rows = 0;
        this.defaultFocus = null;
        final Gedcom ged = this.getRoot().getGedcom();
        PropertyPlace place = (PropertyPlace)prop;
        Boolean[] showJuridictions = ged.getShowJuridictions();
        if (place == null) {
            this.sameChoices = new Property[0];
            value = "";
            jurisdictions = new String[]{};
            formatAsString = ged.getPlaceFormat();
        } else {
            this.sameChoices = place.getSameChoices();
            value = place.isSecret() ? "" : place.getValue();
            formatAsString = place.getFormatAsString();
            jurisdictions = place.getJurisdictions();
        }
        Updateable updater = new Updateable(){

            public Object[] getValues() {
                return PropertyPlace.getAllJurisdictions((Gedcom)ged, (int)-1, (boolean)true);
            }
        };
        if (!CoreOptions.getInstance().isSplitJurisdictions() || formatAsString.length() == 0) {
            this.createChoice(null, value, updater, formatAsString, true);
        } else {
            String[] format = PropertyPlace.getFormat((Gedcom)ged);
            for (int i = 0; i < Math.max(format.length, jurisdictions.length); ++i) {
                boolean showIt = showJuridictions == null || i >= showJuridictions.length || showJuridictions[i] != false;
                this.createChoice(i < format.length ? format[i] : "?", i < jurisdictions.length ? jurisdictions[i] : "", PropertyPlace.getAllJurisdictions((Gedcom)ged, (int)i, (boolean)true), null, showIt);
            }
        }
        this.setupGlobal(false);
        this.gh.setAnchor(21).add((Component)this.global, 1, ++this.rows, 1, 1);
        this.gh.setAnchor(-1);
        AncestrisEditor editor = AncestrisEditor.findEditor((Property)prop);
        this.gh.addFiller(1, ++this.rows);
    }

    private void createChoice(String label, String value, Object values, String tip, boolean showIt) {
        ++this.rows;
        if (label != null && showIt) {
            this.gh.add((Component)new JLabel(label, 4), 0, this.rows, 1, 1, 1);
        }
        ChoiceWidget choice = new ChoiceWidget();
        choice.setComponentPopupMenu((JPopupMenu)new CCPMenu(choice.getTextEditor()));
        choice.setIgnoreCase(true);
        choice.setEditable(true);
        if (values instanceof Updateable) {
            choice.setUpdater((Updateable)values);
        } else {
            choice.setValues((Object[])values);
        }
        choice.setText(value);
        choice.addChangeListener((ChangeListener)this.changeSupport);
        if (tip != null && tip.length() > 0) {
            choice.setToolTipText(tip);
        }
        this.gh.add((Component)choice, 1, this.rows, 1, 1, 17);
        if (this.defaultFocus == null) {
            this.defaultFocus = choice;
        }
        choice.setVisible(showIt);
    }

    private String getGlobalConfirmMessage(boolean isShort) {
        if (this.sameChoices.length < 2) {
            return null;
        }
        String messageId = isShort ? "choice.global.confirm.short" : "choice.global.confirm";
        return RESOURCES.getString(messageId, new Object[]{"" + this.sameChoices.length, this.sameChoices[0].getDisplayValue(), this.getCommitValue()});
    }

    private void setupGlobal(boolean enabled) {
        String confirm = this.getGlobalConfirmMessage(true);
        this.global.setEnabled(confirm != null && enabled);
        this.global.setText(confirm == null ? RESOURCES.getString("choice.global.hidden") : confirm);
    }
}

