/*
 * Decompiled with CFR 0.152.
 */
package genj.edit.beans;

import ancestris.core.actions.AncestrisActionProvider;
import ancestris.core.actions.RunExternal;
import genj.edit.beans.CCPMenu;
import genj.edit.beans.PropertyBean;
import genj.gedcom.Property;
import genj.gedcom.PropertyBlob;
import genj.gedcom.PropertyFile;
import genj.io.InputSource;
import genj.util.Origin;
import genj.util.swing.FileChooserWidget;
import genj.util.swing.ThumbnailWidget;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FilePermission;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Action;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.event.ChangeListener;
import org.openide.nodes.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileBean
extends PropertyBean
implements AncestrisActionProvider {
    private JCheckBox updateMeta = new JCheckBox(RESOURCES.getString("file.update"), true);
    private FileChooserWidget chooser = new FileChooserWidget();
    private ThumbnailWidget preview = new ThumbnailWidget(){

        protected void handleDrop(List<File> files) {
            if (files.size() == 1) {
                File file = files.get(0);
                FileBean.this.chooser.setFile(file);
                this.setSource(InputSource.get((File)file));
            }
        }
    };
    private transient ActionListener doPreview = new ActionListener(){

        public void actionPerformed(ActionEvent e) {
            PropertyBean.REGISTRY.put("bean.file.dir", FileBean.this.chooser.getDirectory());
            File file = FileBean.this.getProperty().getGedcom().getOrigin().getFile(FileBean.this.chooser.getFile().toString());
            if (file == null) {
                FileBean.this.preview.setSource(null);
                return;
            }
            FileBean.this.preview.setSource(InputSource.get((File)file));
            String relative = FileBean.this.getProperty().getGedcom().getOrigin().calcRelativeLocation(file.getAbsolutePath());
            if (relative != null) {
                FileBean.this.chooser.setFile(relative);
            }
        }
    };

    public FileBean() {
        this.setLayout(new BorderLayout());
        this.chooser.setComponentPopupMenu((JPopupMenu)new CCPMenu((JComponent)this.chooser));
        this.chooser.setAccessory((JComponent)this.updateMeta);
        this.chooser.addChangeListener((ChangeListener)this.changeSupport);
        this.chooser.addActionListener(this.doPreview);
        this.add((Component)this.chooser, "North");
        this.add((Component)this.preview, "Center");
        this.defaultFocus = this.chooser;
    }

    @Override
    public void setPropertyImpl(Property property) {
        String dir;
        Origin origin = this.getRoot().getGedcom().getOrigin();
        String string = dir = origin.getFile() != null ? origin.getFile().getParent() : null;
        if (dir != null) {
            try {
                SecurityManager sm = System.getSecurityManager();
                if (sm != null) {
                    sm.checkPermission(new FilePermission(dir, "read"));
                }
                this.chooser.setDirectory(REGISTRY.get("bean.file.dir", dir));
                this.chooser.setVisible(true);
                this.defaultFocus = this.chooser;
            }
            catch (SecurityException se) {
                this.chooser.setVisible(false);
                this.defaultFocus = null;
            }
        }
        this.preview.setSource(null);
        if (property instanceof PropertyFile) {
            PropertyFile file = (PropertyFile)property;
            this.chooser.setTemplate(false);
            this.chooser.setFile(file.getValue());
            if (property.getValue().length() > 0) {
                this.preview.setSource(InputSource.get((File)property.getGedcom().getOrigin().getFile(file.getValue())));
            }
        }
        if (property instanceof PropertyBlob) {
            PropertyBlob blob = (PropertyBlob)property;
            this.chooser.setFile(blob.getValue());
            this.chooser.setTemplate(true);
            this.preview.setSource(InputSource.get((String)blob.getPropertyName(), (byte[])((PropertyBlob)property).getBlobData()));
        }
    }

    @Override
    protected void commitImpl(Property property) {
        File file;
        String value = this.chooser.getFile().toString();
        if (property instanceof PropertyFile) {
            ((PropertyFile)property).setValue(value, this.updateMeta.isSelected());
        }
        if (property instanceof PropertyBlob) {
            ((PropertyBlob)property).load(value, this.updateMeta.isSelected());
        }
        this.preview.setSource((file = this.getProperty().getGedcom().getOrigin().getFile(value)) != null ? InputSource.get((File)file) : null);
    }

    public List<Action> getActions(boolean hasFocus, Node[] nodes) {
        PropertyFile file;
        if (!hasFocus) {
            return AncestrisActionProvider.EMPTY_ACTIONS;
        }
        ArrayList<Action> result = new ArrayList<Action>(1);
        if (nodes != null && (file = (PropertyFile)this.getProperty()) != null) {
            result.add((Action)new RunExternal(file.getFile()));
        }
        return result;
    }
}

