/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.views.tree;

import ancestris.core.pluginservice.AncestrisPlugin;
import ancestris.view.GenjViewTopComponent;
import genj.tree.TreeView;
import genj.tree.TreeViewFactory;
import genj.view.ViewFactory;
import java.util.Properties;
import javax.swing.JToolBar;
import org.openide.windows.RetainLocation;

@RetainLocation(value="ancestris-output")
public final class TreeTopComponent
extends GenjViewTopComponent {
    private static TreeTopComponent factory;
    private static final ViewFactory viewfactory;
    private static final String PREFERRED_ID = "TreeTopComponent";

    public ViewFactory getViewFactory() {
        return viewfactory;
    }

    public static synchronized TreeTopComponent getFactory() {
        if (factory == null) {
            factory = new TreeTopComponent();
        }
        return factory;
    }

    public void writeProperties(Properties p) {
        super.writeProperties(p);
    }

    public void readProperties(Properties p) {
        super.readProperties(p);
    }

    public boolean createPanel() {
        if (!super.createPanel()) {
            return false;
        }
        AncestrisPlugin.register((Object)((Object)this));
        String root = this.getContext().getGedcom().getRegistry().get("tree.root", (String)null);
        TreeView v = (TreeView)this.getView();
        if (root != null) {
            v.setRoot(this.getContext().getGedcom().getEntity(root));
        }
        if (v.getRoot() == null) {
            v.setRoot(this.getContext().getEntity());
        }
        return true;
    }

    protected Object getToolBarConstraints(JToolBar bar, Object constraints) {
        return "North";
    }

    public void componentClosed() {
        TreeView v = (TreeView)this.getView();
        v.writeProperties();
        super.componentClosed();
    }

    protected String preferredID() {
        return PREFERRED_ID;
    }

    static {
        viewfactory = new TreeViewFactory();
    }
}

