/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.rtf;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ListIterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.apps.FOPException;
import org.apache.fop.apps.FOUserAgent;
import org.apache.fop.datatypes.SimplePercentBaseContext;
import org.apache.fop.fo.FOEventHandler;
import org.apache.fop.fo.FONode;
import org.apache.fop.fo.FOText;
import org.apache.fop.fo.flow.BasicLink;
import org.apache.fop.fo.flow.Block;
import org.apache.fop.fo.flow.BlockContainer;
import org.apache.fop.fo.flow.Character;
import org.apache.fop.fo.flow.ExternalGraphic;
import org.apache.fop.fo.flow.Footnote;
import org.apache.fop.fo.flow.FootnoteBody;
import org.apache.fop.fo.flow.Inline;
import org.apache.fop.fo.flow.InstreamForeignObject;
import org.apache.fop.fo.flow.Leader;
import org.apache.fop.fo.flow.ListBlock;
import org.apache.fop.fo.flow.ListItem;
import org.apache.fop.fo.flow.ListItemBody;
import org.apache.fop.fo.flow.ListItemLabel;
import org.apache.fop.fo.flow.PageNumber;
import org.apache.fop.fo.flow.Table;
import org.apache.fop.fo.flow.TableBody;
import org.apache.fop.fo.flow.TableCell;
import org.apache.fop.fo.flow.TableColumn;
import org.apache.fop.fo.flow.TableHeader;
import org.apache.fop.fo.flow.TableRow;
import org.apache.fop.fo.pagination.Flow;
import org.apache.fop.fo.pagination.PageSequence;
import org.apache.fop.fo.pagination.PageSequenceMaster;
import org.apache.fop.fo.pagination.Region;
import org.apache.fop.fo.pagination.SimplePageMaster;
import org.apache.fop.fo.pagination.StaticContent;
import org.apache.fop.fo.properties.CommonBorderPaddingBackground;
import org.apache.fop.fonts.FontSetup;
import org.apache.fop.image.FopImage;
import org.apache.fop.image.ImageFactory;
import org.apache.fop.image.XMLImage;
import org.apache.fop.render.rtf.BorderAttributesConverter;
import org.apache.fop.render.rtf.FoUnitsConverter;
import org.apache.fop.render.rtf.ListAttributesConverter;
import org.apache.fop.render.rtf.PageAttributesConverter;
import org.apache.fop.render.rtf.SVGConverter;
import org.apache.fop.render.rtf.TableAttributesConverter;
import org.apache.fop.render.rtf.TextAttributesConverter;
import org.apache.fop.render.rtf.rtflib.rtfdoc.IRtfAfterContainer;
import org.apache.fop.render.rtf.rtflib.rtfdoc.IRtfBeforeContainer;
import org.apache.fop.render.rtf.rtflib.rtfdoc.IRtfListContainer;
import org.apache.fop.render.rtf.rtflib.rtfdoc.IRtfTableContainer;
import org.apache.fop.render.rtf.rtflib.rtfdoc.IRtfTextrunContainer;
import org.apache.fop.render.rtf.rtflib.rtfdoc.RtfAfter;
import org.apache.fop.render.rtf.rtflib.rtfdoc.RtfAttributes;
import org.apache.fop.render.rtf.rtflib.rtfdoc.RtfBefore;
import org.apache.fop.render.rtf.rtflib.rtfdoc.RtfDocumentArea;
import org.apache.fop.render.rtf.rtflib.rtfdoc.RtfElement;
import org.apache.fop.render.rtf.rtflib.rtfdoc.RtfExternalGraphic;
import org.apache.fop.render.rtf.rtflib.rtfdoc.RtfFile;
import org.apache.fop.render.rtf.rtflib.rtfdoc.RtfFootnote;
import org.apache.fop.render.rtf.rtflib.rtfdoc.RtfHyperLink;
import org.apache.fop.render.rtf.rtflib.rtfdoc.RtfList;
import org.apache.fop.render.rtf.rtflib.rtfdoc.RtfListItem;
import org.apache.fop.render.rtf.rtflib.rtfdoc.RtfSection;
import org.apache.fop.render.rtf.rtflib.rtfdoc.RtfTable;
import org.apache.fop.render.rtf.rtflib.rtfdoc.RtfTableCell;
import org.apache.fop.render.rtf.rtflib.rtfdoc.RtfTableRow;
import org.apache.fop.render.rtf.rtflib.rtfdoc.RtfTextrun;
import org.apache.fop.render.rtf.rtflib.tools.BuilderContext;
import org.apache.fop.render.rtf.rtflib.tools.TableContext;
import org.xml.sax.SAXException;

public class RTFHandler
extends FOEventHandler {
    private RtfFile rtfFile;
    private final OutputStream os;
    private static Log log = LogFactory.getLog((Class)(class$org$apache$fop$render$rtf$RTFHandler == null ? (class$org$apache$fop$render$rtf$RTFHandler = RTFHandler.class$("org.apache.fop.render.rtf.RTFHandler")) : class$org$apache$fop$render$rtf$RTFHandler));
    private RtfSection sect;
    private RtfDocumentArea docArea;
    private boolean bDefer;
    private boolean bPrevHeaderSpecified = false;
    private boolean bPrevFooterSpecified = false;
    private boolean bHeaderSpecified = false;
    private boolean bFooterSpecified = false;
    private BuilderContext builderContext = new BuilderContext(null);
    private SimplePageMaster pagemaster;
    static /* synthetic */ Class class$org$apache$fop$render$rtf$RTFHandler;
    static /* synthetic */ Class class$org$apache$fop$render$rtf$rtflib$rtfdoc$IRtfBeforeContainer;
    static /* synthetic */ Class class$org$apache$fop$render$rtf$rtflib$rtfdoc$IRtfAfterContainer;
    static /* synthetic */ Class class$org$apache$fop$render$rtf$rtflib$rtfdoc$IRtfTextrunContainer;
    static /* synthetic */ Class class$org$apache$fop$render$rtf$rtflib$rtfdoc$IRtfTableContainer;
    static /* synthetic */ Class class$org$apache$fop$render$rtf$rtflib$rtfdoc$RtfTable;
    static /* synthetic */ Class class$org$apache$fop$render$rtf$rtflib$rtfdoc$RtfTableRow;
    static /* synthetic */ Class class$org$apache$fop$render$rtf$rtflib$rtfdoc$IRtfListContainer;
    static /* synthetic */ Class class$org$apache$fop$render$rtf$rtflib$rtfdoc$RtfList;
    static /* synthetic */ Class class$org$apache$fop$render$rtf$rtflib$rtfdoc$RtfListItem;
    static /* synthetic */ Class class$org$apache$fop$render$rtf$rtflib$rtfdoc$RtfFootnote;

    public RTFHandler(FOUserAgent userAgent, OutputStream os) {
        super(userAgent);
        this.os = os;
        this.bDefer = true;
        FontSetup.setup(this.fontInfo, null, userAgent);
    }

    public void startDocument() throws SAXException {
        try {
            this.rtfFile = new RtfFile(new OutputStreamWriter(this.os));
            this.docArea = this.rtfFile.startDocumentArea();
        }
        catch (IOException ioe) {
            throw new SAXException(ioe);
        }
    }

    public void endDocument() throws SAXException {
        try {
            this.rtfFile.flush();
        }
        catch (IOException ioe) {
            throw new SAXException(ioe);
        }
    }

    public void startPageSequence(PageSequence pageSeq) {
        try {
            if (this.pagemaster == null) {
                String reference = pageSeq.getMasterReference();
                this.pagemaster = pageSeq.getRoot().getLayoutMasterSet().getSimplePageMaster(reference);
                if (this.pagemaster == null) {
                    log.warn((Object)("Only simple-page-masters are supported on page-sequences: " + reference));
                    log.warn((Object)"Using default simple-page-master from page-sequence-master...");
                    PageSequenceMaster master = pageSeq.getRoot().getLayoutMasterSet().getPageSequenceMaster(reference);
                    this.pagemaster = master.getNextSimplePageMaster(false, false, false);
                }
            }
            if (this.bDefer) {
                return;
            }
            this.sect = this.docArea.newSection();
            if (this.pagemaster != null) {
                this.sect.getRtfAttributes().set(PageAttributesConverter.convertPageAttributes(this.pagemaster));
            } else {
                log.warn((Object)"No simple-page-master could be determined!");
            }
            this.builderContext.pushContainer(this.sect);
            this.bHeaderSpecified = false;
            this.bFooterSpecified = false;
        }
        catch (IOException ioe) {
            log.error((Object)("startPageSequence: " + ioe.getMessage()), (Throwable)ioe);
        }
        catch (FOPException fope) {
            log.error((Object)("startPageSequence: " + fope.getMessage()), (Throwable)fope);
        }
    }

    public void endPageSequence(PageSequence pageSeq) {
        if (this.bDefer) {
            this.bDefer = false;
            this.recurseFONode(pageSeq);
            this.pagemaster = null;
            this.bDefer = true;
            return;
        }
        this.builderContext.popContainer();
        this.pagemaster = null;
    }

    public void startFlow(Flow fl) {
        if (this.bDefer) {
            return;
        }
        try {
            log.debug((Object)("starting flow: " + fl.getFlowName()));
            boolean handled = false;
            Region regionBody = this.pagemaster.getRegion(36);
            Region regionBefore = this.pagemaster.getRegion(35);
            Region regionAfter = this.pagemaster.getRegion(34);
            if (fl.getFlowName().equals(regionBody.getRegionName())) {
                RtfAttributes attr;
                if (this.bPrevHeaderSpecified && !this.bHeaderSpecified) {
                    attr = new RtfAttributes();
                    attr.set("header");
                    IRtfBeforeContainer contBefore = (IRtfBeforeContainer)((Object)this.builderContext.getContainer(class$org$apache$fop$render$rtf$rtflib$rtfdoc$IRtfBeforeContainer == null ? (class$org$apache$fop$render$rtf$rtflib$rtfdoc$IRtfBeforeContainer = RTFHandler.class$("org.apache.fop.render.rtf.rtflib.rtfdoc.IRtfBeforeContainer")) : class$org$apache$fop$render$rtf$rtflib$rtfdoc$IRtfBeforeContainer, true, this));
                    contBefore.newBefore(attr);
                }
                if (this.bPrevFooterSpecified && !this.bFooterSpecified) {
                    attr = new RtfAttributes();
                    attr.set("footer");
                    IRtfAfterContainer contAfter = (IRtfAfterContainer)((Object)this.builderContext.getContainer(class$org$apache$fop$render$rtf$rtflib$rtfdoc$IRtfAfterContainer == null ? (class$org$apache$fop$render$rtf$rtflib$rtfdoc$IRtfAfterContainer = RTFHandler.class$("org.apache.fop.render.rtf.rtflib.rtfdoc.IRtfAfterContainer")) : class$org$apache$fop$render$rtf$rtflib$rtfdoc$IRtfAfterContainer, true, this));
                    contAfter.newAfter(attr);
                }
                handled = true;
            } else if (regionBefore != null && fl.getFlowName().equals(regionBefore.getRegionName())) {
                this.bHeaderSpecified = true;
                this.bPrevHeaderSpecified = true;
                IRtfBeforeContainer c = (IRtfBeforeContainer)((Object)this.builderContext.getContainer(class$org$apache$fop$render$rtf$rtflib$rtfdoc$IRtfBeforeContainer == null ? (class$org$apache$fop$render$rtf$rtflib$rtfdoc$IRtfBeforeContainer = RTFHandler.class$("org.apache.fop.render.rtf.rtflib.rtfdoc.IRtfBeforeContainer")) : class$org$apache$fop$render$rtf$rtflib$rtfdoc$IRtfBeforeContainer, true, this));
                RtfAttributes beforeAttributes = ((RtfElement)((Object)c)).getRtfAttributes();
                if (beforeAttributes == null) {
                    beforeAttributes = new RtfAttributes();
                }
                beforeAttributes.set("header");
                RtfBefore before = c.newBefore(beforeAttributes);
                this.builderContext.pushContainer(before);
                handled = true;
            } else if (regionAfter != null && fl.getFlowName().equals(regionAfter.getRegionName())) {
                this.bFooterSpecified = true;
                this.bPrevFooterSpecified = true;
                IRtfAfterContainer c = (IRtfAfterContainer)((Object)this.builderContext.getContainer(class$org$apache$fop$render$rtf$rtflib$rtfdoc$IRtfAfterContainer == null ? (class$org$apache$fop$render$rtf$rtflib$rtfdoc$IRtfAfterContainer = RTFHandler.class$("org.apache.fop.render.rtf.rtflib.rtfdoc.IRtfAfterContainer")) : class$org$apache$fop$render$rtf$rtflib$rtfdoc$IRtfAfterContainer, true, this));
                RtfAttributes afterAttributes = ((RtfElement)((Object)c)).getRtfAttributes();
                if (afterAttributes == null) {
                    afterAttributes = new RtfAttributes();
                }
                afterAttributes.set("footer");
                RtfAfter after = c.newAfter(afterAttributes);
                this.builderContext.pushContainer(after);
                handled = true;
            }
            if (!handled) {
                log.warn((Object)("A " + fl.getLocalName() + " has been skipped: " + fl.getFlowName()));
            }
        }
        catch (IOException ioe) {
            log.error((Object)("startFlow: " + ioe.getMessage()));
            throw new RuntimeException(ioe.getMessage());
        }
        catch (Exception e) {
            log.error((Object)("startFlow: " + e.getMessage()));
            throw new RuntimeException(e.getMessage());
        }
    }

    public void endFlow(Flow fl) {
        if (this.bDefer) {
            return;
        }
        try {
            Region regionBody = this.pagemaster.getRegion(36);
            Region regionBefore = this.pagemaster.getRegion(35);
            Region regionAfter = this.pagemaster.getRegion(34);
            if (!fl.getFlowName().equals(regionBody.getRegionName())) {
                if (regionBefore != null && fl.getFlowName().equals(regionBefore.getRegionName())) {
                    this.builderContext.popContainer();
                } else if (regionAfter != null && fl.getFlowName().equals(regionAfter.getRegionName())) {
                    this.builderContext.popContainer();
                }
            }
        }
        catch (Exception e) {
            log.error((Object)("endFlow: " + e.getMessage()));
            throw new RuntimeException(e.getMessage());
        }
    }

    public void startBlock(Block bl) {
        if (this.bDefer) {
            return;
        }
        try {
            RtfAttributes rtfAttr = TextAttributesConverter.convertAttributes(bl);
            IRtfTextrunContainer container = (IRtfTextrunContainer)((Object)this.builderContext.getContainer(class$org$apache$fop$render$rtf$rtflib$rtfdoc$IRtfTextrunContainer == null ? (class$org$apache$fop$render$rtf$rtflib$rtfdoc$IRtfTextrunContainer = RTFHandler.class$("org.apache.fop.render.rtf.rtflib.rtfdoc.IRtfTextrunContainer")) : class$org$apache$fop$render$rtf$rtflib$rtfdoc$IRtfTextrunContainer, true, this));
            RtfTextrun textrun = container.getTextrun();
            textrun.addParagraphBreak();
            textrun.pushBlockAttributes(rtfAttr);
            textrun.addBookmark(bl.getId());
        }
        catch (IOException ioe) {
            log.error((Object)("startBlock: " + ioe.getMessage()));
            throw new RuntimeException("IOException: " + ioe);
        }
        catch (Exception e) {
            log.error((Object)("startBlock: " + e.getMessage()));
            throw new RuntimeException("Exception: " + e);
        }
    }

    public void endBlock(Block bl) {
        if (this.bDefer) {
            return;
        }
        try {
            IRtfTextrunContainer container = (IRtfTextrunContainer)((Object)this.builderContext.getContainer(class$org$apache$fop$render$rtf$rtflib$rtfdoc$IRtfTextrunContainer == null ? (class$org$apache$fop$render$rtf$rtflib$rtfdoc$IRtfTextrunContainer = RTFHandler.class$("org.apache.fop.render.rtf.rtflib.rtfdoc.IRtfTextrunContainer")) : class$org$apache$fop$render$rtf$rtflib$rtfdoc$IRtfTextrunContainer, true, this));
            RtfTextrun textrun = container.getTextrun();
            textrun.addParagraphBreak();
            textrun.popBlockAttributes();
        }
        catch (IOException ioe) {
            log.error((Object)("startBlock:" + ioe.getMessage()));
            throw new RuntimeException(ioe.getMessage());
        }
        catch (Exception e) {
            log.error((Object)("startBlock:" + e.getMessage()));
            throw new RuntimeException(e.getMessage());
        }
    }

    public void startBlockContainer(BlockContainer blc) {
        if (this.bDefer) {
            return;
        }
        try {
            RtfAttributes rtfAttr = TextAttributesConverter.convertBlockContainerAttributes(blc);
            IRtfTextrunContainer container = (IRtfTextrunContainer)((Object)this.builderContext.getContainer(class$org$apache$fop$render$rtf$rtflib$rtfdoc$IRtfTextrunContainer == null ? (class$org$apache$fop$render$rtf$rtflib$rtfdoc$IRtfTextrunContainer = RTFHandler.class$("org.apache.fop.render.rtf.rtflib.rtfdoc.IRtfTextrunContainer")) : class$org$apache$fop$render$rtf$rtflib$rtfdoc$IRtfTextrunContainer, true, this));
            RtfTextrun textrun = container.getTextrun();
            textrun.addParagraphBreak();
            textrun.pushBlockAttributes(rtfAttr);
        }
        catch (IOException ioe) {
            log.error((Object)("startBlock: " + ioe.getMessage()));
            throw new RuntimeException("IOException: " + ioe);
        }
        catch (Exception e) {
            log.error((Object)("startBlock: " + e.getMessage()));
            throw new RuntimeException("Exception: " + e);
        }
    }

    public void endBlockContainer(BlockContainer bl) {
        if (this.bDefer) {
            return;
        }
        try {
            IRtfTextrunContainer container = (IRtfTextrunContainer)((Object)this.builderContext.getContainer(class$org$apache$fop$render$rtf$rtflib$rtfdoc$IRtfTextrunContainer == null ? (class$org$apache$fop$render$rtf$rtflib$rtfdoc$IRtfTextrunContainer = RTFHandler.class$("org.apache.fop.render.rtf.rtflib.rtfdoc.IRtfTextrunContainer")) : class$org$apache$fop$render$rtf$rtflib$rtfdoc$IRtfTextrunContainer, true, this));
            RtfTextrun textrun = container.getTextrun();
            textrun.addParagraphBreak();
            textrun.popBlockAttributes();
        }
        catch (IOException ioe) {
            log.error((Object)("startBlock:" + ioe.getMessage()));
            throw new RuntimeException(ioe.getMessage());
        }
        catch (Exception e) {
            log.error((Object)("startBlock:" + e.getMessage()));
            throw new RuntimeException(e.getMessage());
        }
    }

    public void startTable(Table tbl) {
        if (this.bDefer) {
            return;
        }
        TableContext tableContext = new TableContext(this.builderContext);
        try {
            IRtfTableContainer tc = (IRtfTableContainer)((Object)this.builderContext.getContainer(class$org$apache$fop$render$rtf$rtflib$rtfdoc$IRtfTableContainer == null ? (class$org$apache$fop$render$rtf$rtflib$rtfdoc$IRtfTableContainer = RTFHandler.class$("org.apache.fop.render.rtf.rtflib.rtfdoc.IRtfTableContainer")) : class$org$apache$fop$render$rtf$rtflib$rtfdoc$IRtfTableContainer, true, null));
            RtfAttributes atts = TableAttributesConverter.convertTableAttributes(tbl);
            RtfTable table = tc.newTable(atts, tableContext);
            CommonBorderPaddingBackground border = tbl.getCommonBorderPaddingBackground();
            RtfAttributes borderAttributes = new RtfAttributes();
            BorderAttributesConverter.makeBorder(border, 0, borderAttributes, "clbrdrt");
            BorderAttributesConverter.makeBorder(border, 1, borderAttributes, "clbrdrb");
            BorderAttributesConverter.makeBorder(border, 2, borderAttributes, "clbrdrl");
            BorderAttributesConverter.makeBorder(border, 3, borderAttributes, "clbrdrr");
            table.setBorderAttributes(borderAttributes);
            this.builderContext.pushContainer(table);
        }
        catch (Exception e) {
            log.error((Object)("startTable:" + e.getMessage()));
            throw new RuntimeException(e.getMessage());
        }
        this.builderContext.pushTableContext(tableContext);
    }

    public void endTable(Table tbl) {
        if (this.bDefer) {
            return;
        }
        this.builderContext.popTableContext();
        this.builderContext.popContainer();
    }

    public void startColumn(TableColumn tc) {
        if (this.bDefer) {
            return;
        }
        try {
            SimplePercentBaseContext context = new SimplePercentBaseContext(null, 11, 100000);
            Integer iWidth = new Integer(tc.getColumnWidth().getValue(context) / 1000);
            String strWidth = iWidth.toString() + "pt";
            Float width = new Float(FoUnitsConverter.getInstance().convertToTwips(strWidth));
            this.builderContext.getTableContext().setNextColumnWidth(width);
            this.builderContext.getTableContext().setNextColumnRowSpanning(new Integer(0), null);
            this.builderContext.getTableContext().setNextFirstSpanningCol(false);
        }
        catch (Exception e) {
            log.error((Object)("startColumn: " + e.getMessage()));
            throw new RuntimeException(e.getMessage());
        }
    }

    public void endColumn(TableColumn tc) {
        if (this.bDefer) {
            return;
        }
    }

    public void startHeader(TableBody th) {
    }

    public void endHeader(TableBody th) {
    }

    public void startFooter(TableBody tf) {
    }

    public void endFooter(TableBody tf) {
    }

    public void startInline(Inline inl) {
        if (this.bDefer) {
            return;
        }
        try {
            RtfAttributes rtfAttr = TextAttributesConverter.convertCharacterAttributes(inl);
            IRtfTextrunContainer container = (IRtfTextrunContainer)((Object)this.builderContext.getContainer(class$org$apache$fop$render$rtf$rtflib$rtfdoc$IRtfTextrunContainer == null ? (class$org$apache$fop$render$rtf$rtflib$rtfdoc$IRtfTextrunContainer = RTFHandler.class$("org.apache.fop.render.rtf.rtflib.rtfdoc.IRtfTextrunContainer")) : class$org$apache$fop$render$rtf$rtflib$rtfdoc$IRtfTextrunContainer, true, this));
            RtfTextrun textrun = container.getTextrun();
            textrun.pushInlineAttributes(rtfAttr);
            textrun.addBookmark(inl.getId());
        }
        catch (IOException ioe) {
            log.error((Object)("startInline:" + ioe.getMessage()));
            throw new RuntimeException(ioe.getMessage());
        }
        catch (FOPException fe) {
            log.error((Object)("startInline:" + fe.getMessage()));
            throw new RuntimeException(fe.getMessage());
        }
        catch (Exception e) {
            log.error((Object)("startInline:" + e.getMessage()));
            throw new RuntimeException(e.getMessage());
        }
    }

    public void endInline(Inline inl) {
        if (this.bDefer) {
            return;
        }
        try {
            IRtfTextrunContainer container = (IRtfTextrunContainer)((Object)this.builderContext.getContainer(class$org$apache$fop$render$rtf$rtflib$rtfdoc$IRtfTextrunContainer == null ? (class$org$apache$fop$render$rtf$rtflib$rtfdoc$IRtfTextrunContainer = RTFHandler.class$("org.apache.fop.render.rtf.rtflib.rtfdoc.IRtfTextrunContainer")) : class$org$apache$fop$render$rtf$rtflib$rtfdoc$IRtfTextrunContainer, true, this));
            RtfTextrun textrun = container.getTextrun();
            textrun.popInlineAttributes();
        }
        catch (IOException ioe) {
            log.error((Object)("startInline:" + ioe.getMessage()));
            throw new RuntimeException(ioe.getMessage());
        }
        catch (Exception e) {
            log.error((Object)("startInline:" + e.getMessage()));
            throw new RuntimeException(e.getMessage());
        }
    }

    public void startBody(TableBody tb) {
        if (this.bDefer) {
            return;
        }
        try {
            RtfAttributes atts = TableAttributesConverter.convertTableBodyAttributes(tb);
            RtfTable tbl = (RtfTable)this.builderContext.getContainer(class$org$apache$fop$render$rtf$rtflib$rtfdoc$RtfTable == null ? (class$org$apache$fop$render$rtf$rtflib$rtfdoc$RtfTable = RTFHandler.class$("org.apache.fop.render.rtf.rtflib.rtfdoc.RtfTable")) : class$org$apache$fop$render$rtf$rtflib$rtfdoc$RtfTable, true, this);
            tbl.setHeaderAttribs(atts);
        }
        catch (Exception e) {
            log.error((Object)("startBody: " + e.getMessage()));
            throw new RuntimeException(e.getMessage());
        }
    }

    public void endBody(TableBody tb) {
        if (this.bDefer) {
            return;
        }
        try {
            RtfTable tbl = (RtfTable)this.builderContext.getContainer(class$org$apache$fop$render$rtf$rtflib$rtfdoc$RtfTable == null ? (class$org$apache$fop$render$rtf$rtflib$rtfdoc$RtfTable = RTFHandler.class$("org.apache.fop.render.rtf.rtflib.rtfdoc.RtfTable")) : class$org$apache$fop$render$rtf$rtflib$rtfdoc$RtfTable, true, this);
            tbl.setHeaderAttribs(null);
        }
        catch (Exception e) {
            log.error((Object)("endBody: " + e.getMessage()));
            throw new RuntimeException(e.getMessage());
        }
    }

    public void startRow(TableRow tr) {
        if (this.bDefer) {
            return;
        }
        try {
            RtfTable tbl = (RtfTable)this.builderContext.getContainer(class$org$apache$fop$render$rtf$rtflib$rtfdoc$RtfTable == null ? (class$org$apache$fop$render$rtf$rtflib$rtfdoc$RtfTable = RTFHandler.class$("org.apache.fop.render.rtf.rtflib.rtfdoc.RtfTable")) : class$org$apache$fop$render$rtf$rtflib$rtfdoc$RtfTable, true, null);
            RtfAttributes atts = TableAttributesConverter.convertRowAttributes(tr, tbl.getHeaderAttribs());
            if (tr.getParent() instanceof TableHeader) {
                atts.set("trhdr");
            }
            this.builderContext.pushContainer(tbl.newTableRow(atts));
            this.builderContext.getTableContext().selectFirstColumn();
        }
        catch (Exception e) {
            log.error((Object)("startRow: " + e.getMessage()));
            throw new RuntimeException(e.getMessage());
        }
    }

    public void endRow(TableRow tr) {
        if (this.bDefer) {
            return;
        }
        try {
            TableContext tctx = this.builderContext.getTableContext();
            RtfTableRow row = (RtfTableRow)this.builderContext.getContainer(class$org$apache$fop$render$rtf$rtflib$rtfdoc$RtfTableRow == null ? (class$org$apache$fop$render$rtf$rtflib$rtfdoc$RtfTableRow = RTFHandler.class$("org.apache.fop.render.rtf.rtflib.rtfdoc.RtfTableRow")) : class$org$apache$fop$render$rtf$rtflib$rtfdoc$RtfTableRow, true, null);
            while (tctx.getNumberOfColumns() > tctx.getColumnIndex() && tctx.getColumnRowSpanningNumber() > 0) {
                RtfTableCell vCell = row.newTableCellMergedVertically((int)tctx.getColumnWidth(), tctx.getColumnRowSpanningAttrs());
                if (!tctx.getFirstSpanningCol()) {
                    vCell.setHMerge(2);
                }
                tctx.selectNextColumn();
            }
        }
        catch (Exception e) {
            log.error((Object)("endRow: " + e.getMessage()));
            throw new RuntimeException(e.getMessage());
        }
        this.builderContext.popContainer();
        this.builderContext.getTableContext().decreaseRowSpannings();
    }

    public void startCell(TableCell tc) {
        if (this.bDefer) {
            return;
        }
        try {
            TableContext tctx = this.builderContext.getTableContext();
            RtfTableRow row = (RtfTableRow)this.builderContext.getContainer(class$org$apache$fop$render$rtf$rtflib$rtfdoc$RtfTableRow == null ? (class$org$apache$fop$render$rtf$rtflib$rtfdoc$RtfTableRow = RTFHandler.class$("org.apache.fop.render.rtf.rtflib.rtfdoc.RtfTableRow")) : class$org$apache$fop$render$rtf$rtflib$rtfdoc$RtfTableRow, true, null);
            int numberRowsSpanned = tc.getNumberRowsSpanned();
            int numberColumnsSpanned = tc.getNumberColumnsSpanned();
            while (tctx.getNumberOfColumns() > tctx.getColumnIndex() && tctx.getColumnRowSpanningNumber() > 0) {
                RtfTableCell vCell = row.newTableCellMergedVertically((int)tctx.getColumnWidth(), tctx.getColumnRowSpanningAttrs());
                if (!tctx.getFirstSpanningCol()) {
                    vCell.setHMerge(2);
                }
                tctx.selectNextColumn();
            }
            float width = tctx.getColumnWidth();
            RtfAttributes atts = TableAttributesConverter.convertCellAttributes(tc);
            RtfTableCell cell = row.newTableCell((int)width, atts);
            if (numberRowsSpanned > 1) {
                cell.setVMerge(1);
                tctx.setCurrentColumnRowSpanning(new Integer(numberRowsSpanned), cell.getRtfAttributes());
            } else {
                tctx.setCurrentColumnRowSpanning(new Integer(numberRowsSpanned), null);
            }
            if (numberColumnsSpanned > 0) {
                RtfTable table = row.getTable();
                tctx.setCurrentFirstSpanningCol(true);
                for (int i = 0; i < numberColumnsSpanned - 1; ++i) {
                    tctx.selectNextColumn();
                    tctx.setCurrentFirstSpanningCol(false);
                    RtfTableCell hCell = row.newTableCellMergedHorizontally(0, null);
                    if (numberRowsSpanned > 1) {
                        hCell.setVMerge(1);
                        tctx.setCurrentColumnRowSpanning(new Integer(numberRowsSpanned), cell.getRtfAttributes());
                        continue;
                    }
                    tctx.setCurrentColumnRowSpanning(new Integer(numberRowsSpanned), null);
                }
            }
            this.builderContext.pushContainer(cell);
        }
        catch (Exception e) {
            log.error((Object)("startCell: " + e.getMessage()));
            throw new RuntimeException(e.getMessage());
        }
    }

    public void endCell(TableCell tc) {
        if (this.bDefer) {
            return;
        }
        this.builderContext.popContainer();
        this.builderContext.getTableContext().selectNextColumn();
    }

    public void startList(ListBlock lb) {
        if (this.bDefer) {
            return;
        }
        try {
            IRtfListContainer c = (IRtfListContainer)((Object)this.builderContext.getContainer(class$org$apache$fop$render$rtf$rtflib$rtfdoc$IRtfListContainer == null ? (class$org$apache$fop$render$rtf$rtflib$rtfdoc$IRtfListContainer = RTFHandler.class$("org.apache.fop.render.rtf.rtflib.rtfdoc.IRtfListContainer")) : class$org$apache$fop$render$rtf$rtflib$rtfdoc$IRtfListContainer, true, this));
            RtfList newList = c.newList(ListAttributesConverter.convertAttributes(lb));
            this.builderContext.pushContainer(newList);
        }
        catch (IOException ioe) {
            log.error((Object)("startList: " + ioe.getMessage()));
            throw new RuntimeException(ioe.getMessage());
        }
        catch (FOPException fe) {
            log.error((Object)("startList: " + fe.getMessage()));
            throw new RuntimeException(fe.getMessage());
        }
        catch (Exception e) {
            log.error((Object)("startList: " + e.getMessage()));
            throw new RuntimeException(e.getMessage());
        }
    }

    public void endList(ListBlock lb) {
        if (this.bDefer) {
            return;
        }
        this.builderContext.popContainer();
    }

    public void startListItem(ListItem li) {
        if (this.bDefer) {
            return;
        }
        try {
            RtfList list = (RtfList)this.builderContext.getContainer(class$org$apache$fop$render$rtf$rtflib$rtfdoc$RtfList == null ? (class$org$apache$fop$render$rtf$rtflib$rtfdoc$RtfList = RTFHandler.class$("org.apache.fop.render.rtf.rtflib.rtfdoc.RtfList")) : class$org$apache$fop$render$rtf$rtflib$rtfdoc$RtfList, true, this);
            if (list.getChildCount() > 0) {
                this.endListBody();
                this.endList((ListBlock)li.getParent());
                this.startList((ListBlock)li.getParent());
                this.startListBody();
                list = (RtfList)this.builderContext.getContainer(class$org$apache$fop$render$rtf$rtflib$rtfdoc$RtfList == null ? (class$org$apache$fop$render$rtf$rtflib$rtfdoc$RtfList = RTFHandler.class$("org.apache.fop.render.rtf.rtflib.rtfdoc.RtfList")) : class$org$apache$fop$render$rtf$rtflib$rtfdoc$RtfList, true, this);
            }
            this.builderContext.pushContainer(list.newListItem());
        }
        catch (IOException ioe) {
            log.error((Object)("startList: " + ioe.getMessage()));
            throw new RuntimeException(ioe.getMessage());
        }
        catch (FOPException fe) {
            log.error((Object)("startList: " + fe.getMessage()));
            throw new RuntimeException(fe.getMessage());
        }
        catch (Exception e) {
            log.error((Object)("startList: " + e.getMessage()));
            throw new RuntimeException(e.getMessage());
        }
    }

    public void endListItem(ListItem li) {
        if (this.bDefer) {
            return;
        }
        this.builderContext.popContainer();
    }

    public void startListLabel() {
        if (this.bDefer) {
            return;
        }
        try {
            RtfListItem item;
            RtfListItem rtfListItem = item = (RtfListItem)this.builderContext.getContainer(class$org$apache$fop$render$rtf$rtflib$rtfdoc$RtfListItem == null ? (class$org$apache$fop$render$rtf$rtflib$rtfdoc$RtfListItem = RTFHandler.class$("org.apache.fop.render.rtf.rtflib.rtfdoc.RtfListItem")) : class$org$apache$fop$render$rtf$rtflib$rtfdoc$RtfListItem, true, this);
            rtfListItem.getClass();
            RtfListItem.RtfListItemLabel label = new RtfListItem.RtfListItemLabel(rtfListItem, item);
            this.builderContext.pushContainer(label);
        }
        catch (IOException ioe) {
            log.error((Object)("startPageNumber:" + ioe.getMessage()));
            throw new RuntimeException(ioe.getMessage());
        }
        catch (Exception e) {
            log.error((Object)("startPageNumber: " + e.getMessage()));
            throw new RuntimeException(e.getMessage());
        }
    }

    public void endListLabel() {
        if (this.bDefer) {
            return;
        }
        this.builderContext.popContainer();
    }

    public void startListBody() {
    }

    public void endListBody() {
    }

    public void startStatic() {
    }

    public void endStatic() {
    }

    public void startMarkup() {
    }

    public void endMarkup() {
    }

    public void startLink(BasicLink basicLink) {
        if (this.bDefer) {
            return;
        }
        try {
            IRtfTextrunContainer container = (IRtfTextrunContainer)((Object)this.builderContext.getContainer(class$org$apache$fop$render$rtf$rtflib$rtfdoc$IRtfTextrunContainer == null ? (class$org$apache$fop$render$rtf$rtflib$rtfdoc$IRtfTextrunContainer = RTFHandler.class$("org.apache.fop.render.rtf.rtflib.rtfdoc.IRtfTextrunContainer")) : class$org$apache$fop$render$rtf$rtflib$rtfdoc$IRtfTextrunContainer, true, this));
            RtfTextrun textrun = container.getTextrun();
            RtfHyperLink link = textrun.addHyperlink(new RtfAttributes());
            if (basicLink.getExternalDestination() != null) {
                link.setExternalURL(basicLink.getExternalDestination());
            } else {
                link.setInternalURL(basicLink.getInternalDestination());
            }
            this.builderContext.pushContainer(link);
        }
        catch (IOException ioe) {
            log.error((Object)("startLink:" + ioe.getMessage()));
            throw new RuntimeException(ioe.getMessage());
        }
        catch (Exception e) {
            log.error((Object)("startLink: " + e.getMessage()));
            throw new RuntimeException(e.getMessage());
        }
    }

    public void endLink() {
        if (this.bDefer) {
            return;
        }
        this.builderContext.popContainer();
    }

    public void image(ExternalGraphic eg) {
        if (this.bDefer) {
            return;
        }
        try {
            String url = eg.getURL();
            ImageFactory fact = ImageFactory.getInstance();
            FopImage fopimage = fact.getImage(url, eg.getUserAgent());
            if (fopimage == null) {
                log.error((Object)("Image could not be found: " + url));
                return;
            }
            fopimage.load(2);
            byte[] rawData = "image/svg+xml".equals(fopimage.getMimeType()) ? SVGConverter.convertToJPEG((XMLImage)fopimage) : fopimage.getRessourceBytes();
            if (rawData == null) {
                log.warn((Object)FONode.decorateWithContextInfo("Image could not be embedded: " + url, eg));
                return;
            }
            IRtfTextrunContainer c = (IRtfTextrunContainer)((Object)this.builderContext.getContainer(class$org$apache$fop$render$rtf$rtflib$rtfdoc$IRtfTextrunContainer == null ? (class$org$apache$fop$render$rtf$rtflib$rtfdoc$IRtfTextrunContainer = RTFHandler.class$("org.apache.fop.render.rtf.rtflib.rtfdoc.IRtfTextrunContainer")) : class$org$apache$fop$render$rtf$rtflib$rtfdoc$IRtfTextrunContainer, true, this));
            RtfExternalGraphic newGraphic = c.getTextrun().newImage();
            newGraphic.setURL(url);
            newGraphic.setImageData(rawData);
            if (eg.getScaling() == 154) {
                newGraphic.setScaling("uniform");
            }
            int width = 0;
            width = eg.getWidth().getEnum() == 9 ? fopimage.getIntrinsicWidth() : eg.getWidth().getValue();
            int height = 0;
            height = eg.getWidth().getEnum() == 9 ? fopimage.getIntrinsicHeight() : eg.getHeight().getValue();
            int contentwidth = 0;
            contentwidth = eg.getContentWidth().getEnum() == 9 ? fopimage.getIntrinsicWidth() : (eg.getContentWidth().getEnum() == 125 ? width : eg.getContentWidth().getValue());
            int contentheight = 0;
            contentheight = eg.getContentHeight().getEnum() == 9 ? fopimage.getIntrinsicHeight() : (eg.getContentHeight().getEnum() == 125 ? height : eg.getContentHeight().getValue());
            newGraphic.setWidth((long)((float)contentwidth / 50.0f) + "twips");
            newGraphic.setHeight((long)((float)contentheight / 50.0f) + "twips");
            int compression = 0;
            if (compression != 0 && !newGraphic.setCompressionRate(compression)) {
                log.warn((Object)("The compression rate " + compression + " is invalid. The value has to be between 1 and 100 %."));
            }
        }
        catch (Exception e) {
            log.error((Object)("Error while handling an external-graphic: " + e.getMessage()), (Throwable)e);
        }
    }

    public void pageRef() {
    }

    public void foreignObject(InstreamForeignObject ifo) {
    }

    public void startFootnote(Footnote footnote) {
        if (this.bDefer) {
            return;
        }
        try {
            IRtfTextrunContainer container = (IRtfTextrunContainer)((Object)this.builderContext.getContainer(class$org$apache$fop$render$rtf$rtflib$rtfdoc$IRtfTextrunContainer == null ? (class$org$apache$fop$render$rtf$rtflib$rtfdoc$IRtfTextrunContainer = RTFHandler.class$("org.apache.fop.render.rtf.rtflib.rtfdoc.IRtfTextrunContainer")) : class$org$apache$fop$render$rtf$rtflib$rtfdoc$IRtfTextrunContainer, true, this));
            RtfTextrun textrun = container.getTextrun();
            RtfFootnote rtfFootnote = textrun.addFootnote();
            this.builderContext.pushContainer(rtfFootnote);
        }
        catch (IOException ioe) {
            log.error((Object)("startFootnote: " + ioe.getMessage()));
            throw new RuntimeException("IOException: " + ioe);
        }
        catch (Exception e) {
            log.error((Object)("startFootnote: " + e.getMessage()));
            throw new RuntimeException("Exception: " + e);
        }
    }

    public void endFootnote(Footnote footnote) {
        if (this.bDefer) {
            return;
        }
        this.builderContext.popContainer();
    }

    public void startFootnoteBody(FootnoteBody body) {
        if (this.bDefer) {
            return;
        }
        try {
            RtfFootnote rtfFootnote = (RtfFootnote)this.builderContext.getContainer(class$org$apache$fop$render$rtf$rtflib$rtfdoc$RtfFootnote == null ? (class$org$apache$fop$render$rtf$rtflib$rtfdoc$RtfFootnote = RTFHandler.class$("org.apache.fop.render.rtf.rtflib.rtfdoc.RtfFootnote")) : class$org$apache$fop$render$rtf$rtflib$rtfdoc$RtfFootnote, true, this);
            rtfFootnote.startBody();
        }
        catch (IOException ioe) {
            log.error((Object)("startFootnoteBody: " + ioe.getMessage()));
            throw new RuntimeException("IOException: " + ioe);
        }
        catch (Exception e) {
            log.error((Object)("startFootnoteBody: " + e.getMessage()));
            throw new RuntimeException("Exception: " + e);
        }
    }

    public void endFootnoteBody(FootnoteBody body) {
        if (this.bDefer) {
            return;
        }
        try {
            RtfFootnote rtfFootnote = (RtfFootnote)this.builderContext.getContainer(class$org$apache$fop$render$rtf$rtflib$rtfdoc$RtfFootnote == null ? (class$org$apache$fop$render$rtf$rtflib$rtfdoc$RtfFootnote = RTFHandler.class$("org.apache.fop.render.rtf.rtflib.rtfdoc.RtfFootnote")) : class$org$apache$fop$render$rtf$rtflib$rtfdoc$RtfFootnote, true, this);
            rtfFootnote.endBody();
        }
        catch (IOException ioe) {
            log.error((Object)("endFootnoteBody: " + ioe.getMessage()));
            throw new RuntimeException("IOException: " + ioe);
        }
        catch (Exception e) {
            log.error((Object)("endFootnoteBody: " + e.getMessage()));
            throw new RuntimeException("Exception: " + e);
        }
    }

    public void leader(Leader l) {
    }

    public void text(FOText text, char[] data, int start, int length) {
        if (this.bDefer) {
            return;
        }
        try {
            IRtfTextrunContainer container = (IRtfTextrunContainer)((Object)this.builderContext.getContainer(class$org$apache$fop$render$rtf$rtflib$rtfdoc$IRtfTextrunContainer == null ? (class$org$apache$fop$render$rtf$rtflib$rtfdoc$IRtfTextrunContainer = RTFHandler.class$("org.apache.fop.render.rtf.rtflib.rtfdoc.IRtfTextrunContainer")) : class$org$apache$fop$render$rtf$rtflib$rtfdoc$IRtfTextrunContainer, true, this));
            RtfTextrun textrun = container.getTextrun();
            RtfAttributes rtfAttr = TextAttributesConverter.convertCharacterAttributes(text);
            textrun.pushInlineAttributes(rtfAttr);
            textrun.addString(new String(data, start, length - start));
            textrun.popInlineAttributes();
        }
        catch (IOException ioe) {
            log.error((Object)("characters: " + ioe.getMessage()));
            throw new RuntimeException(ioe.getMessage());
        }
        catch (Exception e) {
            log.error((Object)("characters:" + e.getMessage()));
            throw new RuntimeException(e.getMessage());
        }
    }

    public void startPageNumber(PageNumber pagenum) {
        if (this.bDefer) {
            return;
        }
        try {
            RtfAttributes rtfAttr = TextAttributesConverter.convertCharacterAttributes(pagenum);
            IRtfTextrunContainer container = (IRtfTextrunContainer)((Object)this.builderContext.getContainer(class$org$apache$fop$render$rtf$rtflib$rtfdoc$IRtfTextrunContainer == null ? (class$org$apache$fop$render$rtf$rtflib$rtfdoc$IRtfTextrunContainer = RTFHandler.class$("org.apache.fop.render.rtf.rtflib.rtfdoc.IRtfTextrunContainer")) : class$org$apache$fop$render$rtf$rtflib$rtfdoc$IRtfTextrunContainer, true, this));
            RtfTextrun textrun = container.getTextrun();
            textrun.addPageNumber(rtfAttr);
        }
        catch (IOException ioe) {
            log.error((Object)("startPageNumber:" + ioe.getMessage()));
            throw new RuntimeException(ioe.getMessage());
        }
        catch (Exception e) {
            log.error((Object)("startPageNumber: " + e.getMessage()));
            throw new RuntimeException(e.getMessage());
        }
    }

    public void endPageNumber(PageNumber pagenum) {
        if (this.bDefer) {
            return;
        }
    }

    private void invokeDeferredEvent(FONode foNode, boolean bStart) {
        if (foNode instanceof PageSequence) {
            if (bStart) {
                this.startPageSequence((PageSequence)foNode);
            } else {
                this.endPageSequence((PageSequence)foNode);
            }
        } else if (foNode instanceof Flow) {
            if (bStart) {
                this.startFlow((Flow)foNode);
            } else {
                this.endFlow((Flow)foNode);
            }
        } else if (foNode instanceof StaticContent) {
            if (bStart) {
                this.startStatic();
            } else {
                this.endStatic();
            }
        } else if (foNode instanceof ExternalGraphic) {
            if (bStart) {
                this.image((ExternalGraphic)foNode);
            }
        } else if (foNode instanceof Block) {
            if (bStart) {
                this.startBlock((Block)foNode);
            } else {
                this.endBlock((Block)foNode);
            }
        } else if (foNode instanceof BlockContainer) {
            if (bStart) {
                this.startBlockContainer((BlockContainer)foNode);
            } else {
                this.endBlockContainer((BlockContainer)foNode);
            }
        } else if (foNode instanceof BasicLink) {
            if (bStart) {
                this.startLink((BasicLink)foNode);
            } else {
                this.endLink();
            }
        } else if (foNode instanceof Inline) {
            if (bStart) {
                this.startInline((Inline)foNode);
            } else {
                this.endInline((Inline)foNode);
            }
        } else if (foNode instanceof FOText) {
            if (bStart) {
                FOText text = (FOText)foNode;
                this.text(text, text.ca, text.startIndex, text.endIndex);
            }
        } else if (foNode instanceof Character) {
            if (bStart) {
                Character c = (Character)foNode;
                this.character(c);
            }
        } else if (foNode instanceof PageNumber) {
            if (bStart) {
                this.startPageNumber((PageNumber)foNode);
            } else {
                this.endPageNumber((PageNumber)foNode);
            }
        } else if (foNode instanceof Footnote) {
            if (bStart) {
                this.startFootnote((Footnote)foNode);
            } else {
                this.endFootnote((Footnote)foNode);
            }
        } else if (foNode instanceof FootnoteBody) {
            if (bStart) {
                this.startFootnoteBody((FootnoteBody)foNode);
            } else {
                this.endFootnoteBody((FootnoteBody)foNode);
            }
        } else if (foNode instanceof ListBlock) {
            if (bStart) {
                this.startList((ListBlock)foNode);
            } else {
                this.endList((ListBlock)foNode);
            }
        } else if (foNode instanceof ListItemBody) {
            if (bStart) {
                this.startListBody();
            } else {
                this.endListBody();
            }
        } else if (foNode instanceof ListItem) {
            if (bStart) {
                this.startListItem((ListItem)foNode);
            } else {
                this.endListItem((ListItem)foNode);
            }
        } else if (foNode instanceof ListItemLabel) {
            if (bStart) {
                this.startListLabel();
            } else {
                this.endListLabel();
            }
        } else if (foNode instanceof Table) {
            if (bStart) {
                this.startTable((Table)foNode);
            } else {
                this.endTable((Table)foNode);
            }
        } else if (foNode instanceof TableBody) {
            if (bStart) {
                this.startBody((TableBody)foNode);
            } else {
                this.endBody((TableBody)foNode);
            }
        } else if (foNode instanceof TableColumn) {
            if (bStart) {
                this.startColumn((TableColumn)foNode);
            } else {
                this.endColumn((TableColumn)foNode);
            }
        } else if (foNode instanceof TableRow) {
            if (bStart) {
                this.startRow((TableRow)foNode);
            } else {
                this.endRow((TableRow)foNode);
            }
        } else if (foNode instanceof TableCell) {
            if (bStart) {
                this.startCell((TableCell)foNode);
            } else {
                this.endCell((TableCell)foNode);
            }
        } else {
            log.warn((Object)("Ignored deferred event for " + foNode));
        }
    }

    private void recurseFONode(FONode foNode) {
        this.invokeDeferredEvent(foNode, true);
        if (foNode instanceof PageSequence) {
            FONode staticAfter;
            Region regionAfter;
            FONode staticBefore;
            PageSequence pageSequence = (PageSequence)foNode;
            Region regionBefore = this.pagemaster.getRegion(35);
            if (regionBefore != null && (staticBefore = (FONode)pageSequence.flowMap.get(regionBefore.getRegionName())) != null) {
                this.recurseFONode(staticBefore);
            }
            if ((regionAfter = this.pagemaster.getRegion(34)) != null && (staticAfter = (FONode)pageSequence.flowMap.get(regionAfter.getRegionName())) != null) {
                this.recurseFONode(staticAfter);
            }
            this.recurseFONode(pageSequence.getMainFlow());
        } else if (foNode instanceof Table) {
            Table table = (Table)foNode;
            ListIterator it = table.getColumns().iterator();
            while (it.hasNext()) {
                this.recurseFONode((FONode)it.next());
            }
            if (table.getTableHeader() != null) {
                this.recurseFONode(table.getTableHeader());
            }
            if (table.getTableFooter() != null) {
                this.recurseFONode(table.getTableFooter());
            }
            if (foNode.getChildNodes() != null) {
                it = foNode.getChildNodes();
                while (it.hasNext()) {
                    this.recurseFONode((FONode)it.next());
                }
            }
        } else if (foNode instanceof ListItem) {
            ListItem item = (ListItem)foNode;
            this.recurseFONode(item.getLabel());
            this.recurseFONode(item.getBody());
        } else if (foNode instanceof Footnote) {
            Footnote fn = (Footnote)foNode;
            this.recurseFONode(fn.getFootnoteCitation());
            this.recurseFONode(fn.getFootnoteBody());
        } else if (foNode.getChildNodes() != null) {
            ListIterator it = foNode.getChildNodes();
            while (it.hasNext()) {
                FONode fn = (FONode)it.next();
                if (log.isTraceEnabled()) {
                    log.trace((Object)("  ChildNode for " + fn + " (" + fn.getName() + ")"));
                }
                this.recurseFONode(fn);
            }
        }
        this.invokeDeferredEvent(foNode, false);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

