/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.layoutmgr.inline;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import org.apache.fop.area.Area;
import org.apache.fop.area.LineArea;
import org.apache.fop.area.Trait;
import org.apache.fop.area.inline.InlineArea;
import org.apache.fop.datatypes.Length;
import org.apache.fop.datatypes.Numeric;
import org.apache.fop.fo.FONode;
import org.apache.fop.fo.flow.Block;
import org.apache.fop.fo.properties.CommonHyphenation;
import org.apache.fop.fonts.Font;
import org.apache.fop.hyphenation.Hyphenation;
import org.apache.fop.hyphenation.Hyphenator;
import org.apache.fop.layoutmgr.BlockLevelLayoutManager;
import org.apache.fop.layoutmgr.BreakElement;
import org.apache.fop.layoutmgr.BreakingAlgorithm;
import org.apache.fop.layoutmgr.ElementListObserver;
import org.apache.fop.layoutmgr.FootnoteBodyLayoutManager;
import org.apache.fop.layoutmgr.InlineKnuthSequence;
import org.apache.fop.layoutmgr.KnuthBlockBox;
import org.apache.fop.layoutmgr.KnuthBox;
import org.apache.fop.layoutmgr.KnuthElement;
import org.apache.fop.layoutmgr.KnuthGlue;
import org.apache.fop.layoutmgr.KnuthPenalty;
import org.apache.fop.layoutmgr.KnuthPossPosIter;
import org.apache.fop.layoutmgr.KnuthSequence;
import org.apache.fop.layoutmgr.LayoutContext;
import org.apache.fop.layoutmgr.LayoutManager;
import org.apache.fop.layoutmgr.LeafPosition;
import org.apache.fop.layoutmgr.ListElement;
import org.apache.fop.layoutmgr.NonLeafPosition;
import org.apache.fop.layoutmgr.Position;
import org.apache.fop.layoutmgr.PositionIterator;
import org.apache.fop.layoutmgr.SpaceSpecifier;
import org.apache.fop.layoutmgr.inline.AlignmentContext;
import org.apache.fop.layoutmgr.inline.HyphContext;
import org.apache.fop.layoutmgr.inline.InlineLevelLayoutManager;
import org.apache.fop.layoutmgr.inline.InlineStackingLayoutManager;
import org.apache.fop.layoutmgr.inline.KnuthInlineBox;
import org.apache.fop.layoutmgr.inline.LineLayoutPossibilities;
import org.apache.fop.traits.MinOptMax;

public class LineLayoutManager
extends InlineStackingLayoutManager
implements BlockLevelLayoutManager {
    private Block fobj;
    private int textAlignment = 70;
    private int textAlignmentLast;
    private int effectiveAlignment;
    private Length textIndent;
    private Length lastLineEndIndent;
    private CommonHyphenation hyphenationProperties;
    private Numeric hyphenationLadderCount;
    private int wrapOption = 161;
    private Length lineHeight;
    private int lead;
    private int follow;
    private AlignmentContext alignmentContext = null;
    private List knuthParagraphs = null;
    private int iReturnedLBP = 0;
    private int flaggedPenalty = 50;
    private LineLayoutPossibilities lineLayouts;
    private List lineLayoutsList;
    private int iLineWidth = 0;
    public static final int DEFAULT_SPACE_WIDTH = 3336;
    private int constantLineHeight = 12000;

    public void initialize() {
        this.textAlignment = this.fobj.getTextAlign();
        this.textAlignmentLast = this.fobj.getTextAlignLast();
        this.textIndent = this.fobj.getTextIndent();
        this.lastLineEndIndent = this.fobj.getLastLineEndIndent();
        this.hyphenationProperties = this.fobj.getCommonHyphenation();
        this.hyphenationLadderCount = this.fobj.getHyphenationLadderCount();
        this.wrapOption = this.fobj.getWrapOption();
        this.effectiveAlignment = this.getEffectiveAlignment(this.textAlignment, this.textAlignmentLast);
    }

    private int getEffectiveAlignment(int alignment, int alignmentLast) {
        if (this.textAlignment != 70 && this.textAlignmentLast == 70) {
            return 0;
        }
        return this.textAlignment;
    }

    public LineLayoutManager(Block block, Length lh, int l, int f) {
        super(block);
        this.fobj = block;
        this.fobjIter = null;
        this.lineHeight = lh;
        this.lead = l;
        this.follow = f;
    }

    public LinkedList getNextKnuthElements(LayoutContext context, int alignment) {
        Font fs = this.fobj.getCommonFont().getFontState(this.fobj.getFOEventHandler().getFontInfo(), this);
        this.alignmentContext = new AlignmentContext(fs, this.lineHeight.getValue(this), context.getWritingMode());
        context.setAlignmentContext(this.alignmentContext);
        MinOptMax availIPD = context.getStackLimit();
        this.clearPrevIPD();
        if (this.knuthParagraphs == null) {
            this.knuthParagraphs = new ArrayList();
            this.collectInlineKnuthElements(context, availIPD);
        }
        if (this.knuthParagraphs.size() == 0) {
            this.setFinished(true);
            return null;
        }
        return this.createLineBreaks(context.getBPAlignment(), context);
    }

    private void collectInlineKnuthElements(LayoutContext context, MinOptMax availIPD) {
        InlineLevelLayoutManager curLM;
        LayoutContext inlineLC = new LayoutContext(context);
        LinkedList returnedList = null;
        this.iLineWidth = context.getStackLimit().opt;
        boolean bPrevWasKnuthBox = false;
        StringBuffer trace = new StringBuffer("LineLM:");
        Paragraph lastPar = null;
        while ((curLM = (InlineLevelLayoutManager)this.getChildLM()) != null) {
            returnedList = curLM.getNextKnuthElements(inlineLC, this.effectiveAlignment);
            if (returnedList == null || returnedList.size() == 0) continue;
            if (lastPar != null) {
                KnuthElement thisElement;
                KnuthSequence firstSeq = (KnuthSequence)returnedList.getFirst();
                if (!firstSeq.isInlineSequence()) {
                    lastPar.endParagraph();
                    ElementListObserver.observe(lastPar, "line", null);
                    lastPar = null;
                    if (log.isTraceEnabled()) {
                        trace.append(" ]");
                    }
                    bPrevWasKnuthBox = false;
                }
                if (lastPar != null && (thisElement = (KnuthElement)firstSeq.get(0)).isBox() && !thisElement.isAuxiliary() && bPrevWasKnuthBox) {
                    lastPar.addALetterSpace();
                }
            }
            ListIterator iter = returnedList.listIterator();
            while (iter.hasNext()) {
                KnuthSequence sequence = (KnuthSequence)iter.next();
                if (sequence.isInlineSequence()) {
                    ListElement lastElement = sequence.getLast();
                    if (lastElement == null) {
                        throw new NullPointerException("Sequence was empty! lastElement is null");
                    }
                    boolean bl = bPrevWasKnuthBox = lastElement.isBox() && ((KnuthElement)lastElement).getW() != 0;
                    if (lastPar == null) {
                        lastPar = new Paragraph(this, this.textAlignment, this.textAlignmentLast, this.textIndent.getValue(this), this.lastLineEndIndent.getValue(this));
                        lastPar.startParagraph(availIPD.opt);
                        if (log.isTraceEnabled()) {
                            trace.append(" [");
                        }
                    } else if (log.isTraceEnabled()) {
                        trace.append(" +");
                    }
                    lastPar.addAll(sequence);
                    if (log.isTraceEnabled()) {
                        trace.append(" I");
                    }
                    if (!lastElement.isPenalty() || ((KnuthPenalty)lastElement).getP() != -1000) continue;
                    lastPar.removeLast();
                    if (!lastPar.containsBox()) {
                        lastPar.add(new KnuthInlineBox(0, null, null, false));
                    }
                    lastPar.endParagraph();
                    ElementListObserver.observe(lastPar, "line", null);
                    lastPar = null;
                    if (log.isTraceEnabled()) {
                        trace.append(" ]");
                    }
                    bPrevWasKnuthBox = false;
                    continue;
                }
                this.knuthParagraphs.add(sequence);
                if (!log.isTraceEnabled()) continue;
                trace.append(" B");
            }
        }
        if (lastPar != null) {
            lastPar.endParagraph();
            ElementListObserver.observe(lastPar, "line", null);
            if (log.isTraceEnabled()) {
                trace.append(" ]");
            }
        }
        log.trace((Object)trace);
    }

    private LinkedList createLineBreaks(int alignment, LayoutContext context) {
        ListIterator paragraphsIterator = this.knuthParagraphs.listIterator(this.knuthParagraphs.size());
        this.lineLayoutsList = new ArrayList(this.knuthParagraphs.size());
        while (paragraphsIterator.hasPrevious()) {
            KnuthSequence seq = (KnuthSequence)paragraphsIterator.previous();
            LineLayoutPossibilities llPoss = !seq.isInlineSequence() ? new LineLayoutPossibilities() : this.findOptimalBreakingPoints(alignment, (Paragraph)seq);
            this.lineLayoutsList.add(0, llPoss);
        }
        this.setFinished(true);
        return this.postProcessLineBreaks(alignment, context);
    }

    private LineLayoutPossibilities findOptimalBreakingPoints(int alignment, Paragraph currPar) {
        this.lineLayouts = new LineLayoutPossibilities();
        double maxAdjustment = 1.0;
        int iBPcount = 0;
        LineBreakingAlgorithm alg = new LineBreakingAlgorithm(alignment, this.textAlignment, this.textAlignmentLast, this.textIndent.getValue(this), ((Paragraph)currPar).lineFiller.opt, this.lineHeight.getValue(this), this.lead, this.follow, this.knuthParagraphs.indexOf(currPar) == 0, this.hyphenationLadderCount.getEnum() == 89 ? 0 : this.hyphenationLadderCount.getValue(), this);
        if (this.hyphenationProperties.hyphenate == 149 && this.fobj.getWrapOption() != 93) {
            this.findHyphenationPoints(currPar);
        }
        int allowedBreaks = this.wrapOption == 93 ? 2 : 1;
        alg.setConstantLineWidth(this.iLineWidth);
        iBPcount = alg.findBreakingPoints(currPar, maxAdjustment, false, allowedBreaks);
        if (iBPcount == 0 || alignment == 70) {
            if (iBPcount > 0) {
                alg.resetAlgorithm();
                this.lineLayouts.savePossibilities(false);
            } else {
                log.debug((Object)("No set of breaking points found with maxAdjustment = " + maxAdjustment));
            }
            log.debug((Object)("Hyphenation possible? " + (this.hyphenationProperties.hyphenate == 149)));
            if (this.hyphenationProperties.hyphenate == 149 && allowedBreaks != 2) {
                allowedBreaks = 0;
            } else {
                maxAdjustment = 5.0;
            }
            iBPcount = alg.findBreakingPoints(currPar, maxAdjustment, false, allowedBreaks);
            if (iBPcount == 0) {
                log.debug((Object)("No set of breaking points found with maxAdjustment = " + maxAdjustment + (this.hyphenationProperties.hyphenate == 149 ? " and hyphenation" : "")));
                maxAdjustment = 20.0;
                iBPcount = alg.findBreakingPoints(currPar, maxAdjustment, true, allowedBreaks);
            }
            this.lineLayouts.restorePossibilities();
        }
        return this.lineLayouts;
    }

    private LinkedList postProcessLineBreaks(int alignment, LayoutContext context) {
        LinkedList<ListElement> returnList = new LinkedList<ListElement>();
        for (int p = 0; p < this.knuthParagraphs.size(); ++p) {
            LeafPosition returnPosition;
            if (p > 0 && !((BlockLevelLayoutManager)this.parentLM).mustKeepTogether()) {
                returnList.add(new BreakElement(new Position(this), 0, context));
            }
            LineLayoutPossibilities llPoss = (LineLayoutPossibilities)this.lineLayoutsList.get(p);
            KnuthSequence seq = (KnuthSequence)this.knuthParagraphs.get(p);
            if (!seq.isInlineSequence()) {
                LinkedList<ListElement> targetList = new LinkedList<ListElement>();
                ListIterator listIter = seq.listIterator();
                while (listIter.hasNext()) {
                    ListElement tempElement = (ListElement)listIter.next();
                    if (tempElement.getLayoutManager() != this) {
                        tempElement.setPosition(this.notifyPos(new NonLeafPosition(this, tempElement.getPosition())));
                    }
                    targetList.add(tempElement);
                }
                returnList.addAll(targetList);
                continue;
            }
            if (seq.isInlineSequence() && alignment == 70) {
                returnPosition = new LeafPosition(this, p);
                this.createElements(returnList, llPoss, returnPosition);
                continue;
            }
            returnPosition = new LeafPosition(this, p);
            int startIndex = 0;
            for (int i = 0; i < llPoss.getChosenLineCount(); ++i) {
                if (!((BlockLevelLayoutManager)this.parentLM).mustKeepTogether() && i >= this.fobj.getOrphans() && i <= llPoss.getChosenLineCount() - this.fobj.getWidows() && returnList.size() > 0) {
                    returnList.add(new BreakElement(returnPosition, 0, context));
                }
                int endIndex = ((LineBreakPosition)llPoss.getChosenPosition(i)).getLeafPos();
                LinkedList<FootnoteBodyLayoutManager> footnoteList = new LinkedList<FootnoteBodyLayoutManager>();
                ListIterator elementIterator = seq.listIterator(startIndex);
                while (elementIterator.nextIndex() <= endIndex) {
                    KnuthElement element = (KnuthElement)elementIterator.next();
                    if (element instanceof KnuthInlineBox && ((KnuthInlineBox)element).isAnchor()) {
                        footnoteList.add(((KnuthInlineBox)element).getFootnoteBodyLM());
                        continue;
                    }
                    if (!(element instanceof KnuthBlockBox)) continue;
                    footnoteList.addAll(((KnuthBlockBox)element).getFootnoteBodyLMs());
                }
                startIndex = endIndex + 1;
                LineBreakPosition lbp = (LineBreakPosition)llPoss.getChosenPosition(i);
                returnList.add(new KnuthBlockBox(lbp.lineHeight + lbp.spaceBefore + lbp.spaceAfter, footnoteList, lbp, false));
            }
        }
        return returnList;
    }

    private void createElements(List list, LineLayoutPossibilities llPoss, Position elementPosition) {
        int i;
        int nInnerLines = 0;
        int nOptionalLines = 0;
        int nConditionalOptionalLines = 0;
        int nEliminableLines = 0;
        int nConditionalEliminableLines = 0;
        int nFirstLines = this.fobj.getOrphans();
        int nLastLines = this.fobj.getWidows();
        LinkedList<KnuthElement> breaker = new LinkedList<KnuthElement>();
        if (this.fobj.getOrphans() + this.fobj.getWidows() <= llPoss.getMinLineCount()) {
            nInnerLines = llPoss.getMinLineCount() - (this.fobj.getOrphans() + this.fobj.getWidows());
            nOptionalLines = llPoss.getMaxLineCount() - llPoss.getOptLineCount();
            nEliminableLines = llPoss.getOptLineCount() - llPoss.getMinLineCount();
        } else if (this.fobj.getOrphans() + this.fobj.getWidows() <= llPoss.getOptLineCount()) {
            nOptionalLines = llPoss.getMaxLineCount() - llPoss.getOptLineCount();
            nEliminableLines = llPoss.getOptLineCount() - (this.fobj.getOrphans() + this.fobj.getWidows());
            nConditionalEliminableLines = this.fobj.getOrphans() + this.fobj.getWidows() - llPoss.getMinLineCount();
        } else if (this.fobj.getOrphans() + this.fobj.getWidows() <= llPoss.getMaxLineCount()) {
            nOptionalLines = llPoss.getMaxLineCount() - (this.fobj.getOrphans() + this.fobj.getWidows());
            nConditionalOptionalLines = this.fobj.getOrphans() + this.fobj.getWidows() - llPoss.getOptLineCount();
            nConditionalEliminableLines = llPoss.getOptLineCount() - llPoss.getMinLineCount();
            nFirstLines -= nConditionalOptionalLines;
        } else {
            nConditionalOptionalLines = llPoss.getMaxLineCount() - llPoss.getOptLineCount();
            nConditionalEliminableLines = llPoss.getOptLineCount() - llPoss.getMinLineCount();
            nFirstLines = llPoss.getOptLineCount();
            nLastLines = 0;
        }
        if (nLastLines != 0 && (nConditionalOptionalLines > 0 || nConditionalEliminableLines > 0)) {
            breaker.add(new KnuthPenalty(0, 1000, false, elementPosition, false));
            breaker.add(new KnuthGlue(0, -nConditionalOptionalLines * this.constantLineHeight, -nConditionalEliminableLines * this.constantLineHeight, 2, elementPosition, false));
            breaker.add(new KnuthPenalty(nConditionalOptionalLines * this.constantLineHeight, 0, false, elementPosition, false));
            breaker.add(new KnuthGlue(0, nConditionalOptionalLines * this.constantLineHeight, nConditionalEliminableLines * this.constantLineHeight, 2, elementPosition, false));
        } else if (nLastLines != 0) {
            breaker.add(new KnuthPenalty(0, 0, false, elementPosition, false));
        }
        list.add(new KnuthBox(nFirstLines * this.constantLineHeight, elementPosition, nLastLines == 0 && nConditionalOptionalLines == 0 && nConditionalEliminableLines == 0));
        if (nConditionalOptionalLines > 0 || nConditionalEliminableLines > 0) {
            list.add(new KnuthPenalty(0, 1000, false, elementPosition, false));
            list.add(new KnuthGlue(0, nConditionalOptionalLines * this.constantLineHeight, nConditionalEliminableLines * this.constantLineHeight, 2, elementPosition, false));
            list.add(new KnuthBox(0, elementPosition, nLastLines == 0));
        }
        for (i = 0; i < nOptionalLines; ++i) {
            list.addAll(breaker);
            list.add(new KnuthBox(0, elementPosition, false));
            list.add(new KnuthPenalty(0, 1000, false, elementPosition, false));
            list.add(new KnuthGlue(0, 1 * this.constantLineHeight, 0, 2, elementPosition, false));
            list.add(new KnuthBox(0, elementPosition, false));
        }
        for (i = 0; i < nEliminableLines; ++i) {
            list.addAll(breaker);
            list.add(new KnuthBox(1 * this.constantLineHeight, elementPosition, false));
            list.add(new KnuthPenalty(0, 1000, false, elementPosition, false));
            list.add(new KnuthGlue(0, 0, 1 * this.constantLineHeight, 2, elementPosition, false));
            list.add(new KnuthBox(0, elementPosition, false));
        }
        for (i = 0; i < nInnerLines; ++i) {
            list.addAll(breaker);
            list.add(new KnuthBox(1 * this.constantLineHeight, elementPosition, false));
        }
        if (nLastLines > 0) {
            list.addAll(breaker);
            list.add(new KnuthBox(nLastLines * this.constantLineHeight, elementPosition, true));
        }
    }

    public boolean mustKeepTogether() {
        return ((BlockLevelLayoutManager)this.getParent()).mustKeepTogether();
    }

    public boolean mustKeepWithPrevious() {
        return false;
    }

    public boolean mustKeepWithNext() {
        return false;
    }

    public int negotiateBPDAdjustment(int adj, KnuthElement lastElement) {
        LeafPosition pos = (LeafPosition)lastElement.getPosition();
        int totalAdj = adj;
        int lineNumberDifference = (int)Math.round((double)totalAdj / (double)this.constantLineHeight + (adj > 0 ? -0.4 : 0.4));
        LineLayoutPossibilities llPoss = (LineLayoutPossibilities)this.lineLayoutsList.get(pos.getLeafPos());
        lineNumberDifference = llPoss.applyLineCountAdjustment(lineNumberDifference);
        return lineNumberDifference * this.constantLineHeight;
    }

    public void discardSpace(KnuthGlue spaceGlue) {
    }

    public LinkedList getChangedKnuthElements(List oldList, int alignment) {
        LinkedList<KnuthElement> returnList = new LinkedList<KnuthElement>();
        for (int p = 0; p < this.knuthParagraphs.size(); ++p) {
            LineLayoutPossibilities llPoss = (LineLayoutPossibilities)this.lineLayoutsList.get(p);
            for (int i = 0; i < llPoss.getChosenLineCount(); ++i) {
                if (!((BlockLevelLayoutManager)this.parentLM).mustKeepTogether() && i >= this.fobj.getOrphans() && i <= llPoss.getChosenLineCount() - this.fobj.getWidows()) {
                    returnList.add(new KnuthPenalty(0, 0, false, new Position(this), false));
                }
                LineBreakPosition lbp = (LineBreakPosition)llPoss.getChosenPosition(i);
                MinOptMax contentIPD = alignment == 70 ? new MinOptMax(lbp.lineWidth - lbp.difference - lbp.availableShrink, lbp.lineWidth - lbp.difference, lbp.lineWidth - lbp.difference + lbp.availableStretch) : (alignment == 23 ? new MinOptMax(lbp.lineWidth - 2 * lbp.startIndent) : (alignment == 39 ? new MinOptMax(lbp.lineWidth - lbp.startIndent) : new MinOptMax(lbp.lineWidth - lbp.difference + lbp.startIndent)));
                returnList.add(new KnuthBlockBox(lbp.lineHeight, contentIPD, lbp.ipdAdjust != 0.0 ? lbp.lineWidth - lbp.difference : 0, lbp, false));
            }
        }
        return returnList;
    }

    private void findHyphenationPoints(Paragraph currPar) {
        ListIterator currParIterator = currPar.listIterator(currPar.ignoreAtStart);
        LinkedList<Update> updateList = new LinkedList<Update>();
        KnuthElement firstElement = null;
        KnuthElement nextElement = null;
        InlineLevelLayoutManager currLM = null;
        StringBuffer sbChars = null;
        while (currParIterator.hasNext()) {
            int i;
            firstElement = (KnuthElement)currParIterator.next();
            if (firstElement.getLayoutManager() != currLM) {
                currLM = (InlineLevelLayoutManager)firstElement.getLayoutManager();
                if (currLM == null) break;
                updateList.add(new Update(currLM, currParIterator.previousIndex()));
            } else if (currLM == null) break;
            if (!firstElement.isBox() || firstElement.isAuxiliary()) continue;
            int boxCount = 1;
            int auxCount = 0;
            sbChars = new StringBuffer();
            currLM.getWordChars(sbChars, firstElement.getPosition());
            while (currParIterator.hasNext()) {
                nextElement = (KnuthElement)currParIterator.next();
                if (nextElement.isBox() && !nextElement.isAuxiliary()) {
                    if (currLM != nextElement.getLayoutManager()) {
                        currLM = (InlineLevelLayoutManager)nextElement.getLayoutManager();
                        updateList.add(new Update(currLM, currParIterator.previousIndex()));
                    }
                    ++boxCount;
                    currLM.getWordChars(sbChars, nextElement.getPosition());
                    continue;
                }
                if (!nextElement.isAuxiliary()) {
                    currParIterator.previous();
                    break;
                }
                if (currLM != nextElement.getLayoutManager()) {
                    currLM = (InlineLevelLayoutManager)nextElement.getLayoutManager();
                    updateList.add(new Update(currLM, currParIterator.previousIndex()));
                }
                ++auxCount;
            }
            log.trace((Object)(" Word to hyphenate: " + sbChars.toString()));
            HyphContext hc = this.getHyphenContext(sbChars);
            if (hc == null) continue;
            KnuthElement element = null;
            for (i = 0; i < boxCount + auxCount; ++i) {
                currParIterator.previous();
            }
            for (i = 0; i < boxCount + auxCount; ++i) {
                element = (KnuthElement)currParIterator.next();
                if (!element.isBox() || element.isAuxiliary()) continue;
                ((InlineLevelLayoutManager)element.getLayoutManager()).hyphenate(element.getPosition(), hc);
            }
        }
        ListIterator updateListIterator = updateList.listIterator();
        Update currUpdate = null;
        int iAddedElements = 0;
        while (updateListIterator.hasNext()) {
            int toIndex;
            currUpdate = (Update)updateListIterator.next();
            int fromIndex = currUpdate.iFirstIndex;
            if (updateListIterator.hasNext()) {
                Update nextUpdate = (Update)updateListIterator.next();
                toIndex = nextUpdate.iFirstIndex;
                updateListIterator.previous();
            } else {
                toIndex = currPar.size() - currPar.ignoreAtEnd - iAddedElements;
            }
            if (!currUpdate.inlineLM.applyChanges(currPar.subList(fromIndex + iAddedElements, toIndex + iAddedElements))) continue;
            LinkedList newElements = null;
            newElements = currUpdate.inlineLM.getChangedKnuthElements(currPar.subList(fromIndex + iAddedElements, toIndex + iAddedElements), this.effectiveAlignment);
            currPar.subList(fromIndex + iAddedElements, toIndex + iAddedElements).clear();
            currPar.addAll(fromIndex + iAddedElements, newElements);
            iAddedElements += newElements.size() - (toIndex - fromIndex);
        }
        updateListIterator = null;
        updateList.clear();
    }

    protected boolean hasLeadingFence(boolean isNotFirst) {
        return true;
    }

    protected boolean hasTrailingFence(boolean isNotLast) {
        return true;
    }

    private HyphContext getHyphenContext(StringBuffer sbChars) {
        Hyphenation hyph = Hyphenator.hyphenate(this.hyphenationProperties.language, this.hyphenationProperties.country, sbChars.toString(), this.hyphenationProperties.hyphenationRemainCharacterCount, this.hyphenationProperties.hyphenationPushCharacterCount);
        if (hyph != null) {
            return new HyphContext(hyph.getHyphenationPoints());
        }
        return null;
    }

    public void resetPosition(Position resetPos) {
        if (resetPos == null) {
            this.setFinished(false);
            this.iReturnedLBP = 0;
        } else {
            if (this.isFinished()) {
                this.setFinished(false);
                --this.iReturnedLBP;
            }
            while ((LineBreakPosition)this.lineLayouts.getChosenPosition(this.iReturnedLBP) != (LineBreakPosition)resetPos) {
                --this.iReturnedLBP;
            }
            ++this.iReturnedLBP;
        }
    }

    public void addAreas(PositionIterator parentIter, LayoutContext context) {
        while (parentIter.hasNext()) {
            boolean isLastPosition;
            Position pos = (Position)parentIter.next();
            boolean bl = isLastPosition = !parentIter.hasNext();
            if (pos instanceof LineBreakPosition) {
                this.addInlineArea(context, pos, isLastPosition);
                continue;
            }
            if (!(pos instanceof NonLeafPosition) || !pos.generatesAreas()) continue;
            this.addBlockArea(context, pos, isLastPosition);
        }
        this.setCurrentArea(null);
    }

    private void addInlineArea(LayoutContext context, Position pos, boolean isLastPosition) {
        LayoutManager childLM;
        ListIterator seqIterator = null;
        KnuthElement tempElement = null;
        LayoutManager lastLM = null;
        LineBreakPosition lbp = (LineBreakPosition)pos;
        int iCurrParIndex = lbp.iParIndex;
        KnuthSequence seq = (KnuthSequence)this.knuthParagraphs.get(iCurrParIndex);
        int iStartElement = lbp.iStartIndex;
        int iEndElement = lbp.getLeafPos();
        LineArea lineArea = new LineArea(lbp.getLeafPos() < seq.size() - 1 ? this.textAlignment : this.textAlignmentLast, lbp.difference, lbp.availableStretch, lbp.availableShrink);
        if (lbp.startIndent != 0) {
            lineArea.addTrait(Trait.START_INDENT, new Integer(lbp.startIndent));
        }
        lineArea.setBPD(lbp.lineHeight);
        lineArea.setIPD(lbp.lineWidth);
        lineArea.addTrait(Trait.SPACE_BEFORE, new Integer(lbp.spaceBefore));
        lineArea.addTrait(Trait.SPACE_AFTER, new Integer(lbp.spaceAfter));
        this.alignmentContext.resizeLine(lbp.lineHeight, lbp.baseline);
        if (seq instanceof Paragraph) {
            Paragraph currPar = (Paragraph)seq;
            iStartElement += iStartElement == 0 ? currPar.ignoreAtStart : 0;
            if (iEndElement == currPar.size() - 1) {
                iEndElement -= currPar.ignoreAtEnd;
                lineArea.setIPD(lineArea.getIPD() - this.lastLineEndIndent.getValue(this));
            }
        }
        if ((tempElement = (KnuthElement)(seqIterator = seq.listIterator(iEndElement)).next()).isGlue()) {
            --iEndElement;
            seqIterator.previous();
            tempElement = (KnuthElement)seqIterator.previous();
        }
        lastLM = tempElement.getLayoutManager();
        seqIterator = seq.listIterator(iStartElement);
        tempElement = (KnuthElement)seqIterator.next();
        while (!tempElement.isBox() && seqIterator.hasNext()) {
            tempElement = (KnuthElement)seqIterator.next();
            ++iStartElement;
        }
        KnuthPossPosIter inlinePosIter = new KnuthPossPosIter(seq, iStartElement, iEndElement + 1);
        iStartElement = lbp.getLeafPos() + 1;
        if (iStartElement == seq.size()) {
            iStartElement = 0;
        }
        LayoutContext lc = new LayoutContext(0);
        lc.setAlignmentContext(this.alignmentContext);
        lc.setSpaceAdjust(lbp.dAdjust);
        lc.setIPDAdjust(lbp.ipdAdjust);
        lc.setLeadingSpace(new SpaceSpecifier(true));
        lc.setTrailingSpace(new SpaceSpecifier(false));
        lc.setFlags(256, true);
        this.setCurrentArea(lineArea);
        this.setChildContext(lc);
        while ((childLM = inlinePosIter.getNextChildLM()) != null) {
            lc.setFlags(128, childLM == lastLM);
            childLM.addAreas(inlinePosIter, lc);
            lc.setLeadingSpace(lc.getTrailingSpace());
            lc.setTrailingSpace(new SpaceSpecifier(false));
        }
        if (!(context.getSpaceAfter() <= 0 || context.isLastArea() && isLastPosition)) {
            lineArea.setBPD(lineArea.getBPD() + context.getSpaceAfter());
        }
        lineArea.finalise();
        this.parentLM.addChildArea(lineArea);
    }

    private void addBlockArea(LayoutContext context, Position pos, boolean isLastPosition) {
        LayoutManager childLM;
        ArrayList<Position> positionList = new ArrayList<Position>(1);
        Position innerPosition = ((NonLeafPosition)pos).getPosition();
        positionList.add(innerPosition);
        LayoutManager lastLM = null;
        if (isLastPosition) {
            lastLM = innerPosition.getLM();
        }
        LineArea lineArea = new LineArea();
        this.setCurrentArea(lineArea);
        LayoutContext lc = new LayoutContext(0);
        lc.setAlignmentContext(this.alignmentContext);
        this.setChildContext(lc);
        InlineStackingLayoutManager.StackingIter childPosIter = new InlineStackingLayoutManager.StackingIter(positionList.listIterator());
        LayoutContext blocklc = new LayoutContext(0);
        blocklc.setLeadingSpace(new SpaceSpecifier(true));
        blocklc.setTrailingSpace(new SpaceSpecifier(false));
        blocklc.setFlags(256, true);
        while ((childLM = childPosIter.getNextChildLM()) != null) {
            blocklc.setFlags(128, context.isLastArea() && childLM == lastLM);
            blocklc.setStackLimit(context.getStackLimit());
            childLM.addAreas(childPosIter, blocklc);
            blocklc.setLeadingSpace(blocklc.getTrailingSpace());
            blocklc.setTrailingSpace(new SpaceSpecifier(false));
        }
        lineArea.updateExtentsFromChildren();
        this.parentLM.addChildArea(lineArea);
    }

    public void addChildArea(Area childArea) {
        if (childArea instanceof InlineArea) {
            Area parent = this.getCurrentArea();
            if (this.getContext().resolveLeadingSpace()) {
                this.addSpace(parent, this.getContext().getLeadingSpace().resolve(false), this.getContext().getSpaceAdjust());
            }
            parent.addChildArea(childArea);
        }
    }

    public boolean getGeneratesBlockArea() {
        return true;
    }

    public boolean getGeneratesLineArea() {
        return true;
    }

    private class LineBreakingAlgorithm
    extends BreakingAlgorithm {
        private LineLayoutManager thisLLM;
        private int pageAlignment;
        private int activePossibility;
        private int addedPositions;
        private int textIndent;
        private int fillerMinWidth;
        private int lineHeight;
        private int lead;
        private int follow;
        private int maxDiff;
        private static final double MAX_DEMERITS = 1.0E7;

        public LineBreakingAlgorithm(int pageAlign, int textAlign, int textAlignLast, int indent, int fillerWidth, int lh, int ld, int fl, boolean first, int maxFlagCount, LineLayoutManager llm) {
            super(textAlign, textAlignLast, first, false, maxFlagCount);
            this.pageAlignment = pageAlign;
            this.textIndent = indent;
            this.fillerMinWidth = fillerWidth;
            this.lineHeight = lh;
            this.lead = ld;
            this.follow = fl;
            this.thisLLM = llm;
            this.activePossibility = -1;
            this.maxDiff = LineLayoutManager.this.fobj.getWidows() >= LineLayoutManager.this.fobj.getOrphans() ? LineLayoutManager.this.fobj.getWidows() : LineLayoutManager.this.fobj.getOrphans();
        }

        public void updateData1(int lineCount, double demerits) {
            LineLayoutManager.this.lineLayouts.addPossibility(lineCount, demerits);
            log.trace((Object)("Layout possibility in " + lineCount + " lines; break at position:"));
        }

        public void updateData2(BreakingAlgorithm.KnuthNode bestActiveNode, KnuthSequence par, int total) {
            double ratio;
            int textAlign;
            int indent = 0;
            int difference = bestActiveNode.difference;
            int n = textAlign = bestActiveNode.line < total ? this.alignment : this.alignmentLast;
            indent += textAlign == 23 ? difference / 2 : (textAlign == 39 ? difference : 0);
            indent += bestActiveNode.line == 1 && this.bFirst ? this.textIndent : 0;
            double d = ratio = textAlign == 70 || difference < 0 && -difference <= bestActiveNode.availableShrink ? bestActiveNode.adjustRatio : 0.0;
            if (this.activePossibility == -1) {
                this.activePossibility = 0;
                this.addedPositions = 0;
            }
            if (this.addedPositions == LineLayoutManager.this.lineLayouts.getLineCount(this.activePossibility)) {
                ++this.activePossibility;
                this.addedPositions = 0;
            }
            if (difference + bestActiveNode.availableShrink < 0 && log.isWarnEnabled()) {
                log.warn((Object)FONode.decorateWithContextInfo("Line " + (this.addedPositions + 1) + " of a paragraph overflows the available area.", LineLayoutManager.this.getFObj()));
            }
            LineLayoutManager.this.lineLayouts.addBreakPosition(this.makeLineBreakPosition(par, bestActiveNode.line > 1 ? bestActiveNode.previous.position + 1 : 0, bestActiveNode.position, bestActiveNode.availableShrink - (this.addedPositions > 0 ? 0 : ((Paragraph)((Paragraph)par)).lineFiller.opt - ((Paragraph)((Paragraph)par)).lineFiller.min), bestActiveNode.availableStretch, difference, ratio, indent), this.activePossibility);
            ++this.addedPositions;
        }

        public void resetAlgorithm() {
            this.activePossibility = -1;
        }

        private LineBreakPosition makeLineBreakPosition(KnuthSequence par, int firstElementIndex, int lastElementIndex, int availableShrink, int availableStretch, int difference, double ratio, int indent) {
            boolean bZeroHeightLine;
            int spaceBefore = (this.lineHeight - this.lead - this.follow) / 2;
            int spaceAfter = this.lineHeight - this.lead - this.follow - spaceBefore;
            int lineLead = this.lead;
            int lineFollow = this.follow;
            boolean bl = bZeroHeightLine = difference == LineLayoutManager.this.iLineWidth;
            if (LineLayoutManager.this.fobj.getLineStackingStrategy() != 52) {
                ListIterator inlineIterator = par.listIterator(firstElementIndex);
                AlignmentContext lastAC = null;
                int maxIgnoredHeight = 0;
                for (int j = firstElementIndex; j <= lastElementIndex; ++j) {
                    KnuthElement element = (KnuthElement)inlineIterator.next();
                    if (!(element instanceof KnuthInlineBox)) continue;
                    AlignmentContext ac = ((KnuthInlineBox)element).getAlignmentContext();
                    if (ac != null && lastAC != ac) {
                        if (!ac.usesInitialBaselineTable() || ac.getAlignmentBaselineIdentifier() != 14 && ac.getAlignmentBaselineIdentifier() != 4) {
                            int alignmentOffset = ac.getTotalAlignmentBaselineOffset();
                            if (alignmentOffset + ac.getAltitude() > lineLead) {
                                lineLead = alignmentOffset + ac.getAltitude();
                            }
                            if (ac.getDepth() - alignmentOffset > lineFollow) {
                                lineFollow = ac.getDepth() - alignmentOffset;
                            }
                        } else if (ac.getHeight() > maxIgnoredHeight) {
                            maxIgnoredHeight = ac.getHeight();
                        }
                        lastAC = ac;
                    }
                    if (!bZeroHeightLine || element.isAuxiliary() && (ac == null || ac.getHeight() <= 0)) continue;
                    bZeroHeightLine = false;
                }
                if (lineFollow < maxIgnoredHeight - lineLead) {
                    lineFollow = maxIgnoredHeight - lineLead;
                }
            }
            LineLayoutManager.this.constantLineHeight = lineLead + lineFollow;
            if (bZeroHeightLine) {
                return new LineBreakPosition(this.thisLLM, LineLayoutManager.this.knuthParagraphs.indexOf(par), firstElementIndex, lastElementIndex, availableShrink, availableStretch, difference, ratio, 0.0, indent, 0, LineLayoutManager.this.iLineWidth, 0, 0, 0);
            }
            return new LineBreakPosition(this.thisLLM, LineLayoutManager.this.knuthParagraphs.indexOf(par), firstElementIndex, lastElementIndex, availableShrink, availableStretch, difference, ratio, 0.0, indent, lineLead + lineFollow, LineLayoutManager.this.iLineWidth, spaceBefore, spaceAfter, lineLead);
        }

        public int findBreakingPoints(Paragraph par, double threshold, boolean force, int allowedBreaks) {
            return super.findBreakingPoints(par, threshold, force, allowedBreaks);
        }

        protected int filterActiveNodes() {
            BreakingAlgorithm.KnuthNode bestActiveNode = null;
            if (this.pageAlignment == 70) {
                BreakingAlgorithm.KnuthNode node;
                int i;
                for (i = this.startLine; i < this.endLine; ++i) {
                    node = this.getNode(i);
                    while (node != null) {
                        bestActiveNode = this.compareNodes(bestActiveNode, node);
                        node = node.next;
                    }
                }
                for (i = this.startLine; i < this.endLine; ++i) {
                    node = this.getNode(i);
                    while (node != null) {
                        if (node.line != bestActiveNode.line && node.totalDemerits > 1.0E7) {
                            this.removeNode(i, node);
                        }
                        node = node.next;
                    }
                }
            } else {
                for (int i = this.startLine; i < this.endLine; ++i) {
                    BreakingAlgorithm.KnuthNode node = this.getNode(i);
                    while (node != null) {
                        if (node != (bestActiveNode = this.compareNodes(bestActiveNode, node))) {
                            this.removeNode(i, node);
                        }
                        node = node.next;
                    }
                }
            }
            return bestActiveNode.line;
        }
    }

    private class Paragraph
    extends InlineKnuthSequence {
        private int ignoreAtStart = 0;
        private int ignoreAtEnd = 0;
        private MinOptMax lineFiller;
        private int textAlignment;
        private int textAlignmentLast;
        private int textIndent;
        private int lastLineEndIndent;
        private int lineWidth;
        private LineLayoutManager layoutManager;

        public Paragraph(LineLayoutManager llm, int alignment, int alignmentLast, int indent, int endIndent) {
            this.layoutManager = llm;
            this.textAlignment = alignment;
            this.textAlignmentLast = alignmentLast;
            this.textIndent = indent;
            this.lastLineEndIndent = endIndent;
        }

        public void startParagraph(int lw) {
            this.lineWidth = lw;
            this.startSequence();
        }

        public void startSequence() {
            this.lineFiller = this.textAlignment == 23 ? new MinOptMax(this.lastLineEndIndent) : new MinOptMax(this.lastLineEndIndent, this.lastLineEndIndent, this.lineWidth);
            if (this.textAlignment == 23 && this.textAlignmentLast != 70) {
                this.add(new KnuthGlue(0, 10008, 0, null, false));
                ++this.ignoreAtStart;
            }
            if (LineLayoutManager.this.knuthParagraphs.size() == 0 && LineLayoutManager.this.fobj.getTextIndent().getValue(this.layoutManager) != 0) {
                this.add(new KnuthInlineBox(LineLayoutManager.this.fobj.getTextIndent().getValue(this.layoutManager), null, null, false));
                ++this.ignoreAtStart;
            }
        }

        public void endParagraph() {
            KnuthSequence finishedPar = this.endSequence();
            if (finishedPar != null) {
                LineLayoutManager.this.knuthParagraphs.add(finishedPar);
            }
        }

        public KnuthSequence endSequence() {
            if (this.size() > this.ignoreAtStart) {
                if (this.textAlignment == 23 && this.textAlignmentLast != 70) {
                    this.add(new KnuthGlue(0, 10008, 0, null, false));
                    this.add(new KnuthPenalty(this.lineFiller.opt, -1000, false, null, false));
                    this.ignoreAtEnd = 2;
                } else if (this.textAlignmentLast != 70) {
                    this.add(new KnuthPenalty(0, 1000, false, null, false));
                    this.add(new KnuthGlue(0, this.lineFiller.max - this.lineFiller.opt, this.lineFiller.opt - this.lineFiller.min, null, false));
                    this.add(new KnuthPenalty(this.lineFiller.opt, -1000, false, null, false));
                    this.ignoreAtEnd = 3;
                } else {
                    this.add(new KnuthPenalty(this.lineFiller.opt, -1000, false, null, false));
                    this.ignoreAtEnd = 1;
                }
                return this;
            }
            this.clear();
            return null;
        }

        public boolean containsBox() {
            for (int i = 0; i < this.size(); ++i) {
                KnuthElement el = (KnuthElement)this.get(i);
                if (!el.isBox()) continue;
                return true;
            }
            return false;
        }
    }

    private class Update {
        private InlineLevelLayoutManager inlineLM;
        private int iFirstIndex;

        public Update(InlineLevelLayoutManager lm, int index) {
            this.inlineLM = lm;
            this.iFirstIndex = index;
        }
    }

    private static class LineBreakPosition
    extends LeafPosition {
        private int iParIndex;
        private int iStartIndex;
        private int availableShrink;
        private int availableStretch;
        private int difference;
        private double dAdjust;
        private double ipdAdjust;
        private int startIndent;
        private int lineHeight;
        private int lineWidth;
        private int spaceBefore;
        private int spaceAfter;
        private int baseline;

        LineBreakPosition(LayoutManager lm, int index, int iStartIndex, int iBreakIndex, int shrink, int stretch, int diff, double ipdA, double adjust, int ind, int lh, int lw, int sb, int sa, int bl) {
            super(lm, iBreakIndex);
            this.availableShrink = shrink;
            this.availableStretch = stretch;
            this.difference = diff;
            this.iParIndex = index;
            this.iStartIndex = iStartIndex;
            this.ipdAdjust = ipdA;
            this.dAdjust = adjust;
            this.startIndent = ind;
            this.lineHeight = lh;
            this.lineWidth = lw;
            this.spaceBefore = sb;
            this.spaceAfter = sa;
            this.baseline = bl;
        }
    }
}

