/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fo.properties;

import org.apache.fop.fo.FObj;
import org.apache.fop.fo.PropertyList;
import org.apache.fop.fo.expr.PropertyException;
import org.apache.fop.fo.flow.TableBody;
import org.apache.fop.fo.flow.TableFObj;
import org.apache.fop.fo.properties.NumberProperty;
import org.apache.fop.fo.properties.Property;

public class ColumnNumberPropertyMaker
extends NumberProperty.Maker {
    public ColumnNumberPropertyMaker(int propId) {
        super(propId);
    }

    public Property make(PropertyList propertyList) throws PropertyException {
        FObj fo = propertyList.getFObj();
        if (fo.getNameId() == 50 || fo.getNameId() == 51) {
            TableFObj parent = (TableFObj)propertyList.getParentFObj();
            int columnIndex = parent.getCurrentColumnIndex();
            if (fo.getNameId() == 50 && parent.getNameId() == 48) {
                boolean startsRow;
                boolean bl = startsRow = propertyList.get(213).getEnum() == 149;
                if (startsRow && !((TableBody)parent).lastCellEndedRow()) {
                    ((TableBody)parent).resetColumnIndex();
                    columnIndex = parent.getCurrentColumnIndex();
                }
            }
            return new NumberProperty(columnIndex);
        }
        throw new PropertyException("column-number property is only allowed on fo:table-cell or fo:table-column, not on " + fo.getName());
    }

    public Property get(int subpropId, PropertyList propertyList, boolean tryInherit, boolean tryDefault) throws PropertyException {
        Property p = super.get(0, propertyList, tryInherit, tryDefault);
        TableFObj fo = (TableFObj)propertyList.getFObj();
        TableFObj parent = (TableFObj)propertyList.getParentFObj();
        int columnIndex = p.getNumeric().getValue();
        if (columnIndex <= 0) {
            fo.getLogger().warn((Object)("Specified negative or zero value for column-number on " + fo.getName() + ": " + columnIndex + " forced to " + parent.getCurrentColumnIndex()));
            return new NumberProperty(parent.getCurrentColumnIndex());
        }
        if (fo.getNameId() == 50) {
            int i = -1;
            int colspan = propertyList.get(149).getNumeric().getValue();
            while (++i < colspan) {
                if (fo.getTable().getColumns() != null) {
                    while (columnIndex <= fo.getTable().getColumns().size() && !fo.getTable().isColumnNumberUsed(columnIndex)) {
                        ++columnIndex;
                    }
                }
                if (!parent.isColumnNumberUsed(columnIndex + i)) continue;
                throw new PropertyException("fo:table-cell overlaps in column " + (columnIndex + i));
            }
        }
        if (propertyList.getExplicit(70) != null) {
            parent.setCurrentColumnIndex(p.getNumeric().getValue());
        }
        return p;
    }
}

