/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fo;

import java.util.ArrayList;
import java.util.List;
import org.apache.fop.fo.CharIterator;
import org.apache.fop.fo.FONode;
import org.apache.fop.fo.FObj;
import org.apache.fop.fo.FObjMixed;
import org.apache.fop.fo.RecursiveCharIterator;
import org.apache.fop.fo.flow.Block;
import org.apache.fop.fo.flow.Character;
import org.apache.fop.util.CharUtilities;

public class XMLWhiteSpaceHandler {
    private boolean inWhiteSpace = false;
    private boolean afterLinefeed = true;
    private int nonWhiteSpaceCount;
    private Block currentBlock;
    private FObj currentFO;
    private int linefeedTreatment;
    private int whiteSpaceTreatment;
    private int whiteSpaceCollapse;
    private FONode nextChild;
    private boolean endOfBlock;
    private boolean nextChildIsBlock;
    private RecursiveCharIterator charIter;
    private List discardableFOCharacters;
    private List pendingInlines;
    private CharIterator firstWhiteSpaceInSeq;

    public void addDiscardableFOChar(Character foChar) {
        if (this.discardableFOCharacters == null) {
            this.discardableFOCharacters = new ArrayList();
        }
        this.discardableFOCharacters.add(foChar);
    }

    public void handleWhiteSpace(FObjMixed fo, FONode firstTextNode) {
        if (fo.getNameId() == 3) {
            this.currentBlock = (Block)fo;
            this.linefeedTreatment = this.currentBlock.getLinefeedTreatment();
            this.whiteSpaceCollapse = this.currentBlock.getWhitespaceCollapse();
            this.whiteSpaceTreatment = this.currentBlock.getWhitespaceTreatment();
        }
        this.currentFO = fo;
        if (firstTextNode == null) {
            return;
        }
        this.charIter = new RecursiveCharIterator(fo, firstTextNode);
        this.inWhiteSpace = false;
        int textNodeIndex = -1;
        if (this.currentFO == this.currentBlock) {
            textNodeIndex = fo.childNodes.indexOf(firstTextNode);
            this.afterLinefeed = textNodeIndex == 0 || textNodeIndex > 0 && ((FONode)fo.childNodes.get(textNodeIndex - 1)).getNameId() == 3;
        }
        this.endOfBlock = this.nextChild == null && this.currentFO == this.currentBlock;
        this.nextChildIsBlock = this.nextChild != null && this.nextChild.getNameId() == 3;
        this.handleWhiteSpace();
        if (this.currentFO == this.currentBlock && this.pendingInlines != null && !this.pendingInlines.isEmpty() && (this.endOfBlock || this.nextChildIsBlock)) {
            if (this.nonWhiteSpaceCount == 0) {
                int i = this.pendingInlines.size();
                while (--i >= 0) {
                    PendingInline p = (PendingInline)this.pendingInlines.get(i);
                    this.charIter = (RecursiveCharIterator)p.firstTrailingWhiteSpace;
                    this.handleWhiteSpace();
                    this.pendingInlines.remove(p);
                }
            } else {
                this.pendingInlines.clear();
            }
        }
        if (this.currentFO != this.currentBlock && this.nextChild == null) {
            if (this.nonWhiteSpaceCount > 0 && this.pendingInlines != null) {
                this.pendingInlines.clear();
            }
            if (this.inWhiteSpace) {
                this.addPendingInline(fo);
            }
        }
    }

    public void handleWhiteSpace(FObjMixed fo, FONode firstTextNode, FONode nextChild) {
        this.nextChild = nextChild;
        this.handleWhiteSpace(fo, firstTextNode);
        this.nextChild = null;
    }

    private void handleWhiteSpace() {
        EOLchecker lfCheck = new EOLchecker(this.charIter);
        this.nonWhiteSpaceCount = 0;
        block16: while (this.charIter.hasNext()) {
            char currentChar;
            int currentCharClass;
            if (!this.inWhiteSpace) {
                this.firstWhiteSpaceInSeq = this.charIter.mark();
            }
            if ((currentCharClass = CharUtilities.classOf(currentChar = this.charIter.nextChar())) == 1 && this.linefeedTreatment == 147) {
                currentChar = ' ';
                this.charIter.replaceChar(' ');
                currentCharClass = CharUtilities.classOf(currentChar);
            }
            block0 : switch (CharUtilities.classOf(currentChar)) {
                case 4: {
                    if (this.inWhiteSpace && this.whiteSpaceCollapse == 149) {
                        this.charIter.remove();
                        break;
                    }
                    boolean bIgnore = false;
                    switch (this.whiteSpaceTreatment) {
                        case 60: {
                            bIgnore = true;
                            break;
                        }
                        case 62: {
                            bIgnore = lfCheck.beforeLinefeed();
                            break;
                        }
                        case 63: {
                            bIgnore = this.afterLinefeed || lfCheck.beforeLinefeed();
                            break;
                        }
                        case 61: {
                            bIgnore = this.afterLinefeed;
                            break;
                        }
                        case 108: {
                            break;
                        }
                    }
                    if (bIgnore) {
                        this.charIter.remove();
                        break;
                    }
                    this.inWhiteSpace = true;
                    if (currentChar == 32 || this.whiteSpaceTreatment != 108) continue block16;
                    this.charIter.replaceChar(' ');
                    break;
                }
                case 1: {
                    switch (this.linefeedTreatment) {
                        case 60: {
                            this.charIter.remove();
                            break block0;
                        }
                        case 148: {
                            this.charIter.replaceChar('\u200b');
                            this.inWhiteSpace = false;
                            break block0;
                        }
                        case 108: {
                            lfCheck.reset();
                            this.inWhiteSpace = false;
                            this.afterLinefeed = true;
                            break block0;
                        }
                    }
                    break;
                }
                default: {
                    this.inWhiteSpace = false;
                    this.afterLinefeed = false;
                    ++this.nonWhiteSpaceCount;
                    lfCheck.reset();
                }
            }
        }
        if (this.discardableFOCharacters != null && !this.discardableFOCharacters.isEmpty()) {
            this.currentFO.childNodes.removeAll(this.discardableFOCharacters);
            this.discardableFOCharacters.clear();
        }
    }

    private void addPendingInline(FObjMixed fo) {
        if (this.pendingInlines == null) {
            this.pendingInlines = new ArrayList(5);
        }
        this.pendingInlines.add(new PendingInline(fo, this.firstWhiteSpaceInSeq));
    }

    private class PendingInline {
        protected FObjMixed fo;
        protected CharIterator firstTrailingWhiteSpace;

        PendingInline(FObjMixed fo, CharIterator firstTrailingWhiteSpace) {
            this.fo = fo;
            this.firstTrailingWhiteSpace = firstTrailingWhiteSpace;
        }
    }

    private class EOLchecker {
        private boolean nextIsEOL = false;
        private RecursiveCharIterator charIter;

        EOLchecker(CharIterator charIter) {
            this.charIter = (RecursiveCharIterator)charIter;
        }

        boolean beforeLinefeed() {
            if (!this.nextIsEOL) {
                CharIterator lfIter = this.charIter.mark();
                while (lfIter.hasNext()) {
                    int charClass = CharUtilities.classOf(lfIter.nextChar());
                    if (charClass == 1) {
                        if (XMLWhiteSpaceHandler.this.linefeedTreatment != 108) continue;
                        this.nextIsEOL = true;
                        return this.nextIsEOL;
                    }
                    if (charClass == 4) continue;
                    return this.nextIsEOL;
                }
                this.nextIsEOL = XMLWhiteSpaceHandler.this.nextChildIsBlock || XMLWhiteSpaceHandler.this.endOfBlock;
            }
            return this.nextIsEOL;
        }

        void reset() {
            this.nextIsEOL = false;
        }
    }
}

