/* -*- Mode: C++; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */

#include "OfflineAudioCompletionEvent.h"
#include "mozilla/dom/OfflineAudioCompletionEventBinding.h"
#include "AudioContext.h"

namespace mozilla {
namespace dom {

NS_IMPL_CYCLE_COLLECTION_INHERITED(OfflineAudioCompletionEvent, Event,
                                   mRenderedBuffer)

NS_INTERFACE_MAP_BEGIN_CYCLE_COLLECTION_INHERITED(OfflineAudioCompletionEvent)
NS_INTERFACE_MAP_END_INHERITING(Event)

NS_IMPL_ADDREF_INHERITED(OfflineAudioCompletionEvent, Event)
NS_IMPL_RELEASE_INHERITED(OfflineAudioCompletionEvent, Event)

OfflineAudioCompletionEvent::OfflineAudioCompletionEvent(AudioContext* aOwner,
                                                         nsPresContext* aPresContext,
                                                         WidgetEvent* aEvent)
  : Event(aOwner, aPresContext, aEvent)
{
}

OfflineAudioCompletionEvent::~OfflineAudioCompletionEvent()
{
}

JSObject*
OfflineAudioCompletionEvent::WrapObjectInternal(JSContext* aCx, JS::Handle<JSObject*> aGivenProto)
{
  return OfflineAudioCompletionEventBinding::Wrap(aCx, this, aGivenProto);
}

} // namespace dom
} // namespace mozilla

