#!/usr/bin/sh

export PATH=$PATH:/usr/sbin:/usr/lib/execline/bin:/usr/libexec

## Start 66 user services if s6-66 is detected
if [ $(ps -p1 | grep -ic "s6-svscan") -eq 1 ] && [ -e /run/66 ]; then
    [ -d "/run/66/scandir/$(id -u)" ] || bash -c "coproc 66 scandir start &"
	sh -c "66 tree start"
fi

## Start s6-rc user services if s6-rc is detected
if [ $(ps -p1 | grep -ic "s6-svscan") -eq 1 ] && [ -e /run/s6-rc ]; then
	mkdir -p "/tmp/$(id -u)/service"
	bash -c "coproc s6-svscan /tmp/$(id -u)/service"
	s6-rc-init -c "$(/usr/lib/execline/bin/homeof $(whoami))/.s6-rc/compiled" -l "/tmp/$(id -u)/s6-rc" "/tmp/$(id -u)/service"
	s6-rc -l "/tmp/$(id -u)/s6-rc" start default
fi

## Start dinit user services if dinit is detected
if [ $(ps -p1 | grep -ic "dinit") -eq 1 ] || [ $(cat /proc/cmdline | grep -ic "init=/") -eq 0 ] && [ $(/sbin/init --version | grep -ic "Dinit") -eq 1 ]; then
	dinit -q -l /var/tmp/log/dinit.log &
fi

## Start runit user services if runit is detected
if [ $(ps -p1 | grep -ic "runit") -eq 1 ]; then
	if [ -d "${HOME}/.runit/service" ]; then
		runsvdir -P "${HOME}/.runit/service"
	else 
		[ -d "${HOME}/.config/service" ] && runsvdir -P "${HOME}/.config/service"
	fi
fi
